/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io;

import edu.sdsc.grid.io.MetaDataCondition;
import java.lang.reflect.Array;
import java.util.Vector;

public class MetaDataTable {
    private Vector values;
    private Vector operators;

    public MetaDataTable(int[] nArray, String[][] stringArray) {
        if (stringArray == null || nArray == null) {
            throw new NullPointerException("Values and operators cannot be null.");
        }
        if (nArray.length != stringArray.length) {
            throw new IllegalArgumentException("Values and operators must have equal length");
        }
        if (stringArray.length <= 0) {
            throw new IllegalArgumentException("No values were given.");
        }
        this.values = new Vector(stringArray.length);
        this.operators = new Vector(nArray.length);
        int n = 0;
        while (n < stringArray.length) {
            this.addRow(stringArray[n], nArray[n]);
            ++n;
        }
    }

    public void setStringValue(int n, int n2, String string) {
        Object e = this.values.get(n);
        Array.set(e, n2, string);
        this.values.set(n, e);
    }

    public int[] getOperators() {
        int[] nArray = new int[this.operators.size()];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = (Integer)this.operators.get(n);
            ++n;
        }
        return nArray;
    }

    public int getOperator(int n) {
        return (Integer)this.operators.get(n);
    }

    public int getIntValue(int n, int n2) {
        String[] stringArray = (String[])this.values.get(n);
        String string = stringArray[n2];
        if (n >= this.getRowCount() || n2 >= this.getColumnCount()) {
            throw new IllegalArgumentException();
        }
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException();
        }
        return Integer.parseInt(string.toString());
    }

    public float getFloatValue(int n, int n2) {
        String[] stringArray = (String[])this.values.get(n);
        String string = stringArray[n2];
        if (n >= this.getRowCount() || n2 >= this.getColumnCount()) {
            throw new IllegalArgumentException();
        }
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException();
        }
        return Float.parseFloat(string.toString());
    }

    public String getStringValue(int n, int n2) {
        String[] stringArray = (String[])this.values.get(n);
        String string = stringArray[n2];
        if (n >= this.getRowCount() || n2 >= this.getColumnCount()) {
            throw new IllegalArgumentException();
        }
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException();
        }
        return string;
    }

    public String getStringValue(String string) {
        int n = 0;
        while (n < this.values.size()) {
            if (this.getStringValue(n, 0).equals(string)) {
                return this.getStringValue(n, 1);
            }
            ++n;
        }
        return null;
    }

    public String getStringValue(String string, int n) {
        int n2 = 0;
        while (n2 < this.values.size()) {
            if (this.getStringValue(n2, 0).equals(string)) {
                return this.getStringValue(n2, n);
            }
            ++n2;
        }
        return null;
    }

    public int getRowCount() {
        return this.values.size();
    }

    public int getColumnCount() {
        return ((String[])this.values.get(0)).length;
    }

    private void setOperator(int n, String[] stringArray) {
        if (n < 0 || n > 13) {
            throw new IllegalArgumentException("Invalid operator.");
        }
        this.operators.add(new Integer(n));
    }

    public void addRow(String[] stringArray, int n) {
        if (stringArray != null) {
            boolean bl = false;
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray[n2] != null) {
                    bl = true;
                    break;
                }
                stringArray[n2] = "";
                ++n2;
            }
            if (bl) {
                this.setOperator(n, stringArray);
                this.values.add(stringArray);
            }
        } else {
            throw new NullPointerException("Values array cannot be null");
        }
    }

    public void removeRow(int n) {
        this.values.remove(n);
        this.operators.remove(n);
    }

    public String toString() {
        String string = "";
        int n = 0;
        while (n < this.getRowCount()) {
            string = string + "\n";
            string = string + this.getStringValue(n, 0) + " " + MetaDataCondition.getOperatorString(this.getOperator(n)) + " ";
            int n2 = 1;
            while (n2 < this.getColumnCount()) {
                string = string + this.getStringValue(n, n2) + "\t";
                ++n2;
            }
            ++n;
        }
        return string;
    }

    public boolean equals(Object object) {
        MetaDataTable metaDataTable = null;
        if (object == null) {
            return false;
        }
        try {
            metaDataTable = (MetaDataTable)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (metaDataTable.getRowCount() == this.getRowCount() && metaDataTable.getColumnCount() == this.getColumnCount()) {
            int n = 0;
            while (n < this.getRowCount()) {
                int n2 = 0;
                while (n2 < this.getColumnCount()) {
                    if (!this.getStringValue(n, n2).equals(metaDataTable.getStringValue(n, n2))) {
                        return false;
                    }
                    ++n2;
                }
                ++n;
            }
            return true;
        }
        return false;
    }
}

