/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io.srb;

import edu.sdsc.grid.io.srb.SRBFile;
import edu.sdsc.grid.io.srb.SRBFileSystem;
import java.io.IOException;

public class SRBDatascope {
    SRBFileSystem fileSystem;
    SRBFile file;
    int fd;

    public SRBDatascope(SRBFile sRBFile) throws IOException {
        if (sRBFile == null) {
            throw new NullPointerException("File cannot be null");
        }
        this.file = sRBFile;
        this.fileSystem = (SRBFileSystem)sRBFile.getFileSystem();
        this.fd = this.fileSystem.srbObjOpen(sRBFile.getName(), 2, sRBFile.getParent());
    }

    protected void finalize() throws Throwable {
        if (this.file != null) {
            this.fileSystem.srbObjClose(this.fd);
            this.file = null;
        }
        super.finalize();
    }

    public String runProcedure(String string) throws IOException {
        if (this.file != null) {
            return this.fileSystem.srbObjProc(this.fd, string, null, 200);
        }
        throw new NullPointerException("SRBDatascope file is null. Was this file closed?");
    }

    public String runProcedure(String string, int n) throws IOException {
        if (this.file != null) {
            return this.fileSystem.srbObjProc(this.fd, string, null, n);
        }
        throw new NullPointerException("SRBDatascope file is null. Was this file closed?");
    }

    public String runProcedure(String string, String string2) throws IOException {
        if (this.file != null) {
            return this.fileSystem.srbObjProc(this.fd, string, string2, 200);
        }
        throw new NullPointerException("SRBDatascope file is null. Was this file closed?");
    }

    public String runProcedure(String string, String string2, int n) throws IOException {
        if (this.file != null) {
            return this.fileSystem.srbObjProc(this.fd, string, string2, n);
        }
        throw new NullPointerException("SRBDatascope file is null. Was this file closed?");
    }

    public void close() throws IOException {
        if (this.file != null) {
            this.fileSystem.srbObjClose(this.fd);
            this.file = null;
        }
    }
}

