/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io.srb;

import edu.sdsc.grid.io.DublinCoreMetaData;
import edu.sdsc.grid.io.GeneralFileSystem;
import edu.sdsc.grid.io.MetaDataCondition;
import edu.sdsc.grid.io.MetaDataField;
import edu.sdsc.grid.io.MetaDataGroup;
import edu.sdsc.grid.io.MetaDataRecordList;
import edu.sdsc.grid.io.MetaDataSelect;
import edu.sdsc.grid.io.MetaDataSet;
import edu.sdsc.grid.io.UserMetaData;
import edu.sdsc.grid.io.srb.SRBFileSystem;
import edu.sdsc.grid.io.srb.SRBProtocol;
import java.io.IOException;
import java.util.HashMap;

public final class SRBMetaDataSet
extends MetaDataSet
implements DublinCoreMetaData,
UserMetaData {
    private static final int TOTAL_METADATA_FIELDS = 500;
    private static HashMap jargonToSRBID = new HashMap(500);
    private static final int EXTENSIBLE_START_NUM = 420;
    private static HashMap srbToJargon = new HashMap(500);
    private static HashMap jargonToSRB = new HashMap(500);
    static final char nll = '\u0000';
    static SRBProtocol protocol;
    static final String ORDERBY = "order by";
    static final String NONDISTINCT = "nondistinct";
    public static final String GROUP_DIRECTORY = "Directory";
    public static final String GROUP_DATA = "Data";
    public static final String GROUP_USER = "User";
    public static final String GROUP_PHYSICAL_RESOURCE = "Physical resource";
    public static final String GROUP_LOGICAL_RESOURCE = "Logical resource";
    public static final String GROUP_SERVER = "Server";
    public static final String GROUP_USER_GROUP = "User group";
    public static final String GROUP_AUTHENTICATION = "Authentication";
    public static final String GROUP_AUTHORIZATION = "Authorization";
    public static final String GROUP_AUDIT = "Audit";
    public static final String GROUP_TICKET = "Ticket";
    public static final String GROUP_CONTAINER = "Container";
    public static final String GROUP_ANNOTATIONS = "Annotations";
    public static final String GROUP_COMPOUND_RESOURCE = "Compound resource";
    public static final String GROUP_DUBLIN_CORE = "Dublin Core";
    public static final String GROUP_ZONE = "Zone";
    public static final String GROUP_DEFINABLE_METADATA = "Definable Metadata";
    static final String GROUP_UDMD = "User-defined metadata";
    public static final String GROUP_INDEX = "Index";
    public static final String GROUP_STRUCTURED_METADATA = "Structured Metadata";
    public static final String GROUP_METHOD = "Method";
    public static final String GROUP_GUID = "GUID";
    public static final String GROUP_UNDEFINED = "Undefined";
    public static final String GROUP_EXTENSIBLE = "Extensible";
    public static final String CURRENT_ZONE = "current zone";
    static final String FILE_ID = "file id";
    public static final String FILE_REPLICATION_ENUM = "file replication enum";
    public static final String USER_GROUP_NAME = "user group name";
    public static final String FILE_TYPE_NAME = "data type name";
    public static final String DATA_TYPE_NAME = "data type name";
    public static final String USER_TYPE_NAME = "user type name";
    public static final String USER_DOMAIN = "user domain";
    public static final String PATH_NAME = "path name";
    public static final String RESOURCE_NAME = "resource name";
    public static final String RESOURCE_ADDRESS_NETPREFIX = "resource address netprefix";
    public static final String RESOURCE_TYPE_NAME = "resource type name";
    public static final String MODIFICATION_DATE = "modification date";
    public static final String USER_AUDIT_TIME_STAMP = "user audit time stamp";
    public static final String USER_AUDIT_COMMENTS = "user audit comments";
    public static final String FILE_COMMENTS = "file comments";
    public static final String AUDIT_ACTION_DESCRIPTION = "audit action description";
    public static final String AUDIT_TIMESTAMP = "audit timestamp";
    public static final String AUDIT_COMMENTS = "audit comments";
    public static final String DIRECTORY_ACCESS_CONSTRAINT = "directory access constraint";
    public static final String ACCESS_DIRECTORY_NAME = "access directory name";
    public static final String RESOURCE_DEFAULT_PATH = "resource default path";
    public static final String PHYSICAL_RESOURCE_DEFAULT_PATH = "physical resource default path";
    public static final String PHYSICAL_RESOURCE_NAME = "physical resource name";
    public static final String PHYSICAL_RESOURCE_TYPE_NAME = "physical resource type name";
    public static final String RESOURCE_REPLICATION_ENUM = "resource replication enum";
    public static final String FILE_ACCESS_LIST = "file access list";
    public static final String RESOURCE_ACCESS_LIST = "resource access list";
    public static final String FILE_IS_DELETED = "file is deleted";
    public static final String TICKET_D = "ticket data";
    public static final String TICKET_BEGIN_TIME_D = "ticket begin time data";
    public static final String TICKET_END_TIME_D = "ticket end time data";
    public static final String TICKET_ACC_COUNT_D = "ticket acc count data";
    public static final String TICKET_ACC_LIST_D = "ticket acc list data";
    public static final String TICKET_OWNER_D = "ticket owner data";
    public static final String TICKET_USER_D = "ticket user data";
    public static final String TICKET_C = "ticket collection";
    public static final String TICKET_BEGIN_TIME_C = "ticket begin time collection";
    public static final String TICKET_END_TIME_C = "ticket end time collection";
    public static final String TICKET_ACC_COUNT_C = "ticket acc count collection";
    public static final String TICKET_ACC_LIST_C = "ticket acc list collection";
    public static final String TICKET_OWNER_C = "ticket owner collection";
    public static final String TICKET_USER_C = "ticket user collection";
    public static final String TICKET_USER_DOMAIN_C = "ticket user domain collection";
    public static final String TICKET_USER_DOMAIN_D = "ticket user domain data";
    public static final String TICKET_OWNER_DOMAIN_C = "ticket owner domain collection";
    public static final String TICKET_OWNER_DOMAIN_D = "ticket owner domain data";
    public static final String PARENT_DIRECTORY_NAME = "parent directory name";
    public static final String LOCATION_NAME = "location name";
    public static final String IS_DIRTY = "is dirty";
    public static final String CONTAINER_MAX_SIZE = "container max size";
    public static final String CONTAINER_NAME = "container name";
    public static final String RESOURCE_CLASS = "resource class";
    public static final String MAX_OBJ_SIZE = "max object size";
    public static final String OFFSET = "offset";
    public static final String CONTAINER_RESOURCE_NAME = "container resource name";
    public static final String CONTAINER_RESOURCE_CLASS = "container resource class";
    public static final String CONTAINER_SIZE = "container size";
    public static final String CONTAINER_LOG_RESOURCE_NAME = "container log resource name";
    public static final String OWNER_DOMAIN = "owner domain";
    public static final String USER_DISTINGUISHED_NAME = "user distinguished name";
    public static final String USER_AUTHENTICATION_SCHEME = "user authentication scheme";
    public static final String SERVER_LOCATION = "server location";
    public static final String SERVER_NETPREFIX = "server netprefix";
    public static final String CONTAINER_REPLICATION_ENUM = "container replication enum";
    public static final String FILE_ANNOTATION_USERNAME = "file annotation username";
    public static final String FILE_ANNOTATION_USERDOMAIN = "file annotation userdomain";
    public static final String FILE_ANNOTATION = "file annotation";
    public static final String FILE_ANNOTATION_TIMESTAMP = "file annotation timestamp";
    public static final String FILE_COMMENTS_TIMESTAMP = "file comments timestamp";
    public static final String FILE_ANNOTATION_POSITION = "file annotation position";
    public static final String FILE_ACCESS_PRIVILEGE = "file access privilege";
    public static final String RESOURCE_MAX_LATENCY = "resource max latency";
    public static final String RESOURCE_MIN_LATENCY = "resource min latency";
    public static final String RESOURCE_BANDWIDTH = "resource bandwidth";
    public static final String RESOURCE_MAX_CONCURRENCY = "resource max concurrency";
    public static final String RESOURCE_NUM_OF_HIERARCHIES = "resource num of hierarchies";
    public static final String RESOURCE_NUM_OF_STRIPES = "resource num of stripes";
    public static final String RESOURCE_CAPACITY = "resource capacity";
    public static final String RESOURCE_DESCRIPTION = "resource description";
    public static final String FILE_CLASS_NAME = "file class name";
    public static final String FILE_CLASS_TYPE = "file class type";
    public static final String STRUCTURED_METADATA_TYPE = "structured metadata type";
    public static final String STRUCTURED_METADATA_COMMENTS = "structured metadata comments";
    public static final String STRUCTURED_METADATA_FILE_NAME = "structured metadata file name";
    public static final String INTERNAL_STRUCTURED_METADATA = "internal structured metadata";
    public static final String INDEX_NAME_FOR_FILE = "index name for file";
    public static final String INDEX_NAME_FOR_DATATYPE = "index name for datatype";
    public static final String INDEX_NAME_FOR_DIRECTORY = "index name for directory";
    public static final String METHOD_NAME_FOR_FILE = "method name for file";
    public static final String METHOD_NAME_FOR_DATATYPE = "method name for datatype";
    public static final String METHOD_NAME_FOR_DIRECTORY = "method name for directory";
    public static final String IX_DIRECTORY_NAME_FOR_FILE = "ix directory name for file";
    public static final String IX_DIRECTORY_NAME_FOR_DATATYPE = "ix directory name for datatype";
    public static final String IX_DIRECTORY_NAME_FOR_DIRECTORY = "ix directory name for directory";
    public static final String METHOD_DIRECTORY_NAME_FOR_FILE = "method directory name for file";
    public static final String METHOD_DIRECTORY_NAME_FOR_DATATYPE = "method directory name for datatype";
    public static final String METHOD_DIRECTORY_NAME_FOR_DIRECTORY = "method directory name for directory";
    public static final String IX_DATATYPE_FOR_FILE = "ix datatype for file";
    public static final String IX_DATATYPE_FOR_DATATYPE = "ix datatype for datatype";
    public static final String IX_DATATYPE_FOR_DIRECTORY = "ix datatype for directory";
    public static final String METHOD_DATATYPE_FOR_FILE = "method datatype for file";
    public static final String METHOD_DATATYPE_FOR_DATATYPE = "method datatype for datatype";
    public static final String METHOD_DATATYPE_FOR_DIRECTORY = "method datatype for directory";
    public static final String STRUCTURED_METADATA_DIRECTORY_NAME = "structured metadata directory name";
    public static final String IX_LOCATION_FOR_FILE = "ix location for file";
    public static final String IX_LOCATION_FOR_DATATYPE = "ix location for datatype";
    public static final String IX_LOCATION_FOR_DIRECTORY = "ix location for directory";
    public static final String DEFINABLE_METADATA_FOR_FILES = "definable metadata for files";
    public static final String METADATA_NUM = "metadata number";
    public static final String DEFINABLE_METADATA_FOR_FILES0 = "definable metadata file0";
    static final String DEFINABLE_METADATA_FOR_FILES1 = "definable metadata file1";
    static final String DEFINABLE_METADATA_FOR_FILES2 = "definable metadata file2";
    static final String DEFINABLE_METADATA_FOR_FILES3 = "definable metadata file3";
    static final String DEFINABLE_METADATA_FOR_FILES4 = "definable metadata file4";
    static final String DEFINABLE_METADATA_FOR_FILES5 = "definable metadata file5";
    static final String DEFINABLE_METADATA_FOR_FILES6 = "definable metadata file6";
    static final String DEFINABLE_METADATA_FOR_FILES7 = "definable metadata file7";
    static final String DEFINABLE_METADATA_FOR_FILES8 = "definable metadata file8";
    static final String DEFINABLE_METADATA_FOR_FILES9 = "definable metadata file9";
    static final String INTEGER_DEFINABLE_METADATA0 = "integer definable metadata file0";
    static final String INTEGER_DEFINABLE_METADATA1 = "integer definable metadata file1";
    static final String DEFINABLE_METADATA_FOR_FILES0_0 = "definable metadata for files0_0";
    static final String DEFINABLE_METADATA_FOR_FILES0_1 = "definable metadata for files0_1";
    static final String DEFINABLE_METADATA_FOR_FILES0_2 = "definable metadata for files0_2";
    static final String DEFINABLE_METADATA_FOR_FILES0_3 = "definable metadata for files0_3";
    static final String DEFINABLE_METADATA_FOR_FILES0_4 = "definable metadata for files0_4";
    static final String DEFINABLE_METADATA_FOR_FILES1_0 = "definable metadata for files1_0";
    static final String DEFINABLE_METADATA_FOR_FILES1_1 = "definable metadata for files1_1";
    static final String DEFINABLE_METADATA_FOR_FILES1_2 = "definable metadata for files1_2";
    static final String DEFINABLE_METADATA_FOR_FILES1_3 = "definable metadata for files1_3";
    static final String DEFINABLE_METADATA_FOR_FILES1_4 = "definable metadata for files1_4";
    public static final String OWNER_EMAIL = "owner email";
    public static final String AUDIT_USER = "audit user";
    public static final String AUDIT_USER_DOMAIN = "audit user domain";
    public static final String CONTAINER_FOR_DIRECTORY = "container for directory";
    public static final String DEFINABLE_METADATA_FOR_DIRECTORIES = "definable metadata for directories";
    public static final String METADATA_NUM_DIRECTORY = "metadata number directory";
    public static final String DEFINABLE_METADATA_FOR_DIRECTORIES0 = "definable metadata directory0";
    static final String DEFINABLE_METADATA_FOR_DIRECTORIES1 = "definable metadata directory1";
    static final String DEFINABLE_METADATA_FOR_DIRECTORIES2 = "definable metadata directory2";
    static final String DEFINABLE_METADATA_FOR_DIRECTORIES3 = "definable metadata directory3";
    static final String DEFINABLE_METADATA_FOR_DIRECTORIES4 = "definable metadata directory4";
    static final String DEFINABLE_METADATA_FOR_DIRECTORIES5 = "definable metadata directory5";
    static final String DEFINABLE_METADATA_FOR_DIRECTORIES6 = "definable metadata directory6";
    static final String DEFINABLE_METADATA_FOR_DIRECTORIES7 = "definable metadata directory7";
    static final String DEFINABLE_METADATA_FOR_DIRECTORIES8 = "definable metadata directory8";
    static final String DEFINABLE_METADATA_FOR_DIRECTORIES9 = "definable metadata directory9";
    static final String INTEGER_DEFINABLE_METADATA_FOR_DIRECTORIES0 = "integer definable metadata directory0";
    static final String INTEGER_DEFINABLE_METADATA_FOR_DIRECTORIES1 = "integer definable metadata directory1";
    static final String DEFINABLE_METADATA_FOR_DIRECTORIES0_0 = "definable metadata for directories0_0";
    static final String DEFINABLE_METADATA_FOR_DIRECTORIES0_1 = "definable metadata for directories0_1";
    static final String DEFINABLE_METADATA_FOR_DIRECTORIES0_2 = "definable metadata for directories0_2";
    static final String DEFINABLE_METADATA_FOR_DIRECTORIES0_3 = "definable metadata for directories0_3";
    static final String DEFINABLE_METADATA_FOR_DIRECTORIES0_4 = "definable metadata for directories0_4";
    static final String DEFINABLE_METADATA_FOR_DIRECTORIES1_0 = "definable metadata for directories1_0";
    static final String DEFINABLE_METADATA_FOR_DIRECTORIES1_1 = "definable metadata for directories1_1";
    static final String DEFINABLE_METADATA_FOR_DIRECTORIES1_2 = "definable metadata for directories1_2";
    static final String DEFINABLE_METADATA_FOR_DIRECTORIES1_3 = "definable metadata for directories1_3";
    static final String DEFINABLE_METADATA_FOR_DIRECTORIES1_4 = "definable metadata for directories1_4";
    public static final String FILE_ACCESS_ID = "file access id";
    static final String USER_ID = "user id";
    public static final String FILE_LAST_ACCESS_TIMESTAMP = "file last access timestamp";
    public static final String DIRECTORY_OWNER_NAME = "collection owner name";
    public static final String DIRECTORY_CREATE_TIMESTAMP = "collection creation timestamp";
    public static final String DIRECTORY_COMMENTS = "collection comments";
    public static final String COLL_ACCS_ID = "directory access id";
    public static final String COLL_ACCS_USER_ID = "directory access user id";
    public static final String DATA_ACCS_ID = "data access id";
    public static final String DATA_ACCS_USER_ID = "data access user id";
    public static final String TICKET_RECURSIVE = "c ticket recursive";
    public static final String TAPE_NUMBER = "tape number";
    public static final String TAPE_OWNER = "tape owner";
    public static final String TAPE_TYPE_VAL = "tape type val";
    public static final String TAPE_LIBINX = "tape libinx";
    public static final String TAPE_FULLFLAG = "tape fullflag";
    public static final String TAPE_CURRENT_FILE_SEQNUM = "tape current file seqnum";
    public static final String TAPE_CURRENT_ABS_POSITION = "tape current abs position";
    public static final String TAPE_BYTES_WRITTEN = "tape bytes written";
    public static final String FILE_VER_NUM = "file ver num";
    public static final String FILE_LOCK_NUM = "file lock num";
    public static final String FILE_LOCK_DESCRIPTION = "file lock description";
    public static final String FILE_LOCK_OWNER_NAME = "file lock owner name";
    public static final String FILE_LOCK_OWNER_DOMAIN = "file lock owner domain";
    public static final String DIRECTORY_OWNER_DOMAIN = "directory owner domain";
    public static final String TICKET_DIRECTORY_NAME = "ticket directory name";
    public static final String TICKET_DIRECTORY_CREATE_TIMESTAMP = "ticket directory create timestamp";
    public static final String TICKET_DIRECTORY_COMMENTS = "ticket directory comments";
    public static final String DIRECTORY_ANNOTATION_USERNAME = "directory annotation username";
    public static final String DIRECTORY_ANNOTATION_USERDOMAIN = "directory annotation userdomain";
    public static final String DIRECTORY_ANNOTATION = "directory annotation";
    public static final String DIRECTORY_ANNOTATION_TIMESTAMP = "directory annotation timestamp";
    public static final String DIRECTORY_ANNOTATION_TYPE = "directory annotation type";
    public static final String FILE_GROUP_ID = "file group id";
    public static final String FILE_HIDE = "file hide";
    public static final String FILE_CHECKSUM = "file checksum";
    public static final String FILE_AUDITFLAG = "file auditflag";
    public static final String FILE_LOCK_EXPIRY = "file lock expiry";
    public static final String FILE_PIN_VAL = "file pin val";
    public static final String FILE_PIN_OWNER_NAME = "file pin owner name";
    public static final String FILE_PIN_OWNER_DOMAIN = "file pin owner domain";
    public static final String FILE_PIN_EXPIRY = "file pin expiry";
    public static final String FILE_EXPIRY_DATE = "file expiry date";
    public static final String FILE_IS_COMPRESSED = "file is compressed";
    public static final String FILE_IS_ENCRYPTED = "file is encrypted";
    public static final String FILE_EXPIRE_DATE_2 = "file expire date 2";
    public static final String NEW_AUDIT_ACTION_DESCRIPTION = "new audit action description";
    public static final String NEW_AUDIT_TIMESTAMP = "new audit timestamp";
    public static final String NEW_AUDIT_COMMENTS = "new audit comments";
    public static final String DEFINABLE_METADATA_FOR_RESOURCES = "definable metadata for resources";
    public static final String METADATA_NUM_RESOURCE = "metadata number for resources";
    public static final String DEFINABLE_METADATA_FOR_RESOURCES0 = "definable metadata resource0";
    static final String DEFINABLE_METADATA_FOR_RESOURCES1 = "definable metadata resource1";
    static final String DEFINABLE_METADATA_FOR_RESOURCES2 = "definable metadata resource2";
    static final String DEFINABLE_METADATA_FOR_RESOURCES3 = "definable metadata resource3";
    static final String DEFINABLE_METADATA_FOR_RESOURCES4 = "definable metadata resource4";
    static final String DEFINABLE_METADATA_FOR_RESOURCES5 = "definable metadata resource5";
    static final String DEFINABLE_METADATA_FOR_RESOURCES6 = "definable metadata resource6";
    static final String DEFINABLE_METADATA_FOR_RESOURCES7 = "definable metadata resource7";
    static final String DEFINABLE_METADATA_FOR_RESOURCES8 = "definable metadata resource8";
    static final String DEFINABLE_METADATA_FOR_RESOURCES9 = "definable metadata resource9";
    static final String DEFINABLE_INTEGER_METADATA_RESOURCE0 = "definable integer metadata resource0";
    static final String DEFINABLE_METADATA_FOR_RESOURCES0_0 = "definable metadata for resources0_0";
    static final String DEFINABLE_METADATA_FOR_RESOURCES0_1 = "definable metadata for resources0_1";
    static final String DEFINABLE_METADATA_FOR_RESOURCES0_2 = "definable metadata for resources0_2";
    static final String DEFINABLE_METADATA_FOR_RESOURCES0_3 = "definable metadata for resources0_3";
    static final String DEFINABLE_METADATA_FOR_RESOURCES1_0 = "definable metadata for resources1_0";
    static final String DEFINABLE_METADATA_FOR_RESOURCES1_1 = "definable metadata for resources1_1";
    static final String DEFINABLE_METADATA_FOR_RESOURCES1_2 = "definable metadata for resources1_2";
    static final String DEFINABLE_METADATA_FOR_RESOURCES1_3 = "definable metadata for resources1_3";
    public static final String COMPOUND_RESOURCE_NAME = "compound resource name";
    public static final String FILE_SEG_NUM = "file seg num";
    public static final String INT_REPLICATION_ENUM = "int replication enum";
    public static final String INT_SEG_NUM = "int seg num";
    public static final String INT_PATH_NAME = "int path name";
    public static final String INT_RESOURCE_NAME = "int resource name";
    public static final String INT_RESOURCE_ADDRESS_NETPREFIX = "int resource address netprefix";
    public static final String INT_RESOURCE_TYPE_NAME = "int resource type name";
    public static final String INT_IS_DIRTY = "int is dirty";
    public static final String INT_RESOURCE_CLASS = "int resource class";
    public static final String INT_OFFSET = "int offset";
    public static final String INT_SIZE = "int size";
    public static final String COMP_OBJ_USER_NAME = "comp obj user name";
    public static final String COMP_OBJ_USER_DOMAIN = "comp obj user domain";
    public static final String INT_PATH_NAME_FOR_REPL = "int path name for repl";
    public static final String DIRECTORY_LINK_NUMBER = "directory link number";
    public static final String REAL_DIRECTORY_NAME = "real directory name";
    public static final String FILE_CONTAINER_NAME = "file container name";
    public static final String DIRECTORY_CONTAINER_NAME = "directory container name";
    public static final String DEFINABLE_METADATA_FOR_USERS = "definable metadata for users";
    public static final String METADATA_NUM_USER = "metadata number for users";
    public static final String DEFINABLE_METADATA_FOR_USERS0 = "definable metadata user0";
    static final String DEFINABLE_METADATA_FOR_USERS1 = "definable metadata user1";
    static final String DEFINABLE_METADATA_FOR_USERS2 = "definable metadata user2";
    static final String DEFINABLE_METADATA_FOR_USERS3 = "definable metadata user3";
    static final String DEFINABLE_METADATA_FOR_USERS4 = "definable metadata user4";
    static final String DEFINABLE_METADATA_FOR_USERS5 = "definable metadata user5";
    static final String DEFINABLE_METADATA_FOR_USERS6 = "definable metadata user6";
    static final String DEFINABLE_METADATA_FOR_USERS7 = "definable metadata user7";
    static final String DEFINABLE_METADATA_FOR_USERS8 = "definable metadata user8";
    static final String DEFINABLE_METADATA_FOR_USERS9 = "definable metadata user9";
    static final String UDIMD_USER0 = "definable user integer metadata 0";
    static final String DEFINABLE_METADATA_FOR_USERS0_0 = "definable metadata for users0_0";
    static final String DEFINABLE_METADATA_FOR_USERS0_1 = "definable metadata for users0_1";
    static final String DEFINABLE_METADATA_FOR_USERS0_2 = "definable metadata for users0_2";
    static final String DEFINABLE_METADATA_FOR_USERS0_3 = "definable metadata for users0_3";
    static final String DEFINABLE_METADATA_FOR_USERS1_0 = "definable metadata for users1_0";
    static final String DEFINABLE_METADATA_FOR_USERS1_1 = "definable metadata for users1_1";
    static final String DEFINABLE_METADATA_FOR_USERS1_2 = "definable metadata for users1_2";
    static final String DEFINABLE_METADATA_FOR_USERS1_3 = "definable metadata for users1_3";
    static final String USERDEFFUNC01 = "definable function metadata 01";
    static final String USERDEFFUNC02 = "definable function metadata 02";
    static final String USERDEFFUNC03 = "definable function metadata 03";
    static final String USERDEFFUNC04 = "definable function metadata 04";
    static final String USERDEFFUNC05 = "definable function metadata 05";
    public static final String ZONE_NAME = "zone name";
    public static final String ZONE_LOCALITY = "zone locality";
    public static final String ZONE_NETPREFIX = "zone net prefix";
    public static final String ZONE_PORT_NUM = "zone port number";
    public static final String ZONE_ADMIN_AUTH_SCHEME_NAME = "zone admin's auth scheme";
    public static final String ZONE_ADMIN_DISTIN_NAME = "zone admin distinguish name";
    public static final String ZONE_STATUS = "zone status";
    public static final String ZONE_CREATE_DATE = "zone creation date";
    public static final String ZONE_MODIFY_DATE = "zone modification date";
    public static final String ZONE_COMMENTS = "zone comments";
    public static final String ZONE_CONTACT = "zone contact";
    public static final String ZONE_ADMIN_NAME = "zone admin's username";
    public static final String ZONE_ADMIN_DOMAIN_NAME = "zone admin's user domain name";
    public static final String RESOURCE_ACCESS_PRIVILEGE = "resource access privilege";
    public static final String RSRC_ACCESS_PRIVILEGE = "resource access privilege";
    public static final String RESOURCE_ACCESS_CONSTRAINT = "resource access constraint name";
    public static final String RSRC_ACCESS_CONSTRAINT = "resource access constraint name";
    public static final String UDIMD_USER1 = "change MAX_USER_INTEGER_METADATA";
    public static final String UDIMD_RESOURCE1 = "change MAX_RSRC_INTEGER_METADATA";
    public static final String UDIMD_RSRC1 = "change MAX_RSRC_INTEGER_METADATA";
    public static final String USER_GROUP_MODIFY_DATE = "group user info modify date";
    public static final String USER_GROUP_ZONE_NAME = "group user zone name";
    public static final String USER_GROUP_DOMAIN_DESC = "group user domain name";
    public static final String DATA_UDEF_MDATA_MODIFY_DATE = "user-def metadata for data mod";
    public static final String COLL_UDEF_MDATA_MODIFY_DATE = "user-def metadata for coll mod";
    public static final String USER_UDEF_MDATA_MODIFY_DATE = "user-def metadata for user mod";
    public static final String RESOURCE_UDEF_MDATA_MODIFY_DATE = "user-def metadata for resource mod";
    public static final String RSRC_UDEF_MDATA_MODIFY_DATE = "user-def metadata for resource mod";
    public static final String DATA_TYPE_MIME_STRING = "mime string for data type";
    public static final String DATA_TYPE_EXTENDERS = "extender list for data type";
    public static final String RESOURCE_COMMENTS = "comments on log resource";
    public static final String RSRC_COMMENTS = "comments on log resource";
    public static final String RESOURCE_CREATE_DATE = "log resource creation timestamp";
    public static final String RSRC_CREATE_DATE = "log resource creation timestamp";
    public static final String RESOURCE_MODIFY_DATE = "log resource modify timestamp";
    public static final String RSRC_MODIFY_DATE = "log resource modify timestamp";
    public static final String USER_CREATE_DATE = "user creation timestamp";
    public static final String USER_MODIFY_DATE = "user modify timestamp";
    public static final String RSRC_MAX_OBJ_SIZE = "log resource max obj size";
    public static final String RESOURCE_OWNER_NAME = "owner of the log resource";
    public static final String RSRC_OWNER_NAME = "owner of the log resource";
    public static final String RESOURCE_OWNER_DOMAIN = "domain of the log resource";
    public static final String RSRC_OWNER_DOMAIN = "domain of the log resource";
    public static final String RSRC_MLSEC_LATENCY_MAX = "max latency of resource in millisec";
    public static final String RSRC_MLSEC_LATENCY_MIN = "min latency of resource in millisec";
    public static final String RSRC_MBPS_BANDWIDTH = "bandwidth of resource in mega bps";
    public static final String RSRC_CONCURRENCY_MAX = "max concurrency allowed in resource";
    public static final String RSRC_NUM_OF_HIERARCHIES = "num of staging levels in resource";
    public static final String RSRC_NUM_OF_STRIPES = "num of striping done in resource";
    public static final String RSRC_MEGAB_CAPACITY = "capacity of resource in megabytes";
    public static final String RSRC_ACCS_USER_NAME = "user name used for resource access";
    public static final String RSRC_ACCS_USER_DOMAIN = "user domn used for resource access";
    public static final String RSRC_ACCS_USER_ZONE = "user zone used for resource access";
    public static final String RSRC_OWNER_ZONE = "zone for resource owner";
    public static final String DATA_OWNER_ZONE = "zone for data owner";
    public static final String TICKET_OWNER_ZONE_D = "zone for data ticket owner";
    public static final String TICKET_USER_ZONE_D = "zone for data ticket user";
    public static final String TICKET_OWNER_ZONE_C = "zone for coll ticket owner";
    public static final String TICKET_USER_ZONE_C = "zone for coll ticket user";
    public static final String DATA_ANNOTATION_USER_ZONE = "zone for data annotator";
    public static final String AUDIT_USER_ZONE = "zone for audited suer";
    public static final String COLL_OWNER_ZONE = "zone for collection owner";
    public static final String DATA_LOCK_OWNER_ZONE = "zone for data lock owner";
    public static final String COLL_ANNOTATION_USER_ZONE = "zone for coll annotator";
    public static final String DATA_PIN_OWNER_ZONE = "zone for data pin owner ";
    public static final String COMP_OBJ_USER_ZONE = "zone for composite obj owner";
    public static final String PARENT_SERVER_LOCATION = "parent of a location";
    public static final String RSRC_ACCESS_ID = "access id number for resource access";
    public static final String PARENT_DATA_TYPE = "parent of a data type";
    public static final String ZONE_LOCN_DESC = "location desc for zone";
    public static final String PARENT_DOMAIN_DESC = "parent of a domain";
    public static final String PARENT_USER_TYPE = "parent of a user type";
    public static final String PARENT_RSRC_TYPE = "parent of a resource type ";
    public static final String RSRC_ACCS_GRPUSER_NAME = "group user who has access to resource";
    public static final String RSRC_ACCS_GRPUSER_DOMAIN = "resource group user domain";
    public static final String RSRC_ACCS_GRPUSER_ZONE = "resource group user zone";
    public static final String COLL_MODIFY_TIMESTAMP = "collection modify_timestamp";
    public static final String DATA_ACCS_GRPUSER_NAME = "group user who has access to data";
    public static final String DATA_ACCS_GRPUSER_DOMAIN = "data group user domain";
    public static final String DATA_ACCS_GRPUSER_ZONE = "data group user zone";
    public static final String COLL_ACCS_GRPUSER_NAME = "group user who has access to coll";
    public static final String COLL_ACCS_GRPUSER_DOMAIN = "coll group user domain";
    public static final String COLL_ACCS_GRPUSER_ZONE = "coll group user zone";
    public static final String COLL_ACCS_COLLECTION_NAME = "coll name for finding coll access";
    public static final String COLL_ACCS_ACCESS_CONSTRAINT = "accs cons for finding coll access";
    public static final String DATA_TYPE_FOR_CONTAINER_FOR_COLLECTION = "data type for container associated with collection";
    public static final String DATA_UDEF_MDATA_CREATE_DATE = "DATA_UDEF_MDATA_CREATE_DATE";
    public static final String COLL_UDEF_MDATA_CREATE_DATE = "COLL_UDEF_MDATA_CREATE_DATE";
    public static final String RSRC_UDEF_MDATA_CREATE_DATE = "RSRC_UDEF_MDATA_CREATE_DATE";
    public static final String USER_UDEF_MDATA_CREATE_DATE = "USER_UDEF_MDATA_CREATE_DATE";
    public static final String CONTAINER_ID = "container id";
    public static final String GUID = "guid";
    public static final String GUID_FLAG = "guid flag";
    public static final String GUID_TIME_STAMP = "guid timestamp";
    public static final String DELETE_FILE_ID = "delete file id";
    public static final String DELETE_FILE_REPLICATION_ENUM = "delete file replication enum";
    public static final String DELETE_FILE_NAME = "delete file name";
    public static final String DELETE_MODIFICATION_DATE = "delete modification date";
    public static final String DELETE_DIRECTORY_NAME = "delete directory name";
    public static final String DEL_COLLECTION_ID = "collection_id of deleted data object";
    public static final String DEL_DATA_COMMENT = "comments on deleted data object";
    public static final String FREE_SPACE = "free space";
    public static final String FS_TIMESTAMP = "fs timestamp";
    public static final String EXTENSIBLE_SCHEMA_NAME = "extensible schema name";
    public static final String EXTENSIBLE_TABLE_NAME = "extensible table name";
    public static final String EXTENSIBLE_ATTR_NAME = "extensible attribute name";
    public static final String EXTENSIBLE_ATTR_OUTSIDE_NAME = "extensible attribute outside name";
    public static final String EXTENSIBLE_ATTR_COMMENTS = "extensible attribute comments";
    public static final String RESOURCE_STATUS = "resource status";
    public static final int D_DELETE_ONE = 1;
    public static final int D_DELETE_DOMN = 2;
    public static final int D_INSERT_DOMN = 3;
    public static final int D_CHANGE_SIZE = 4;
    public static final int D_CHANGE_TYPE = 5;
    public static final int D_CHANGE_GROUP = 6;
    public static final int D_CHANGE_SCHEMA = 7;
    public static final int D_INSERT_ACCS = 8;
    public static final int D_DELETE_ACCS = 9;
    public static final int D_DELETE_ALIAS = 10;
    public static final int D_INSERT_ALIAS = 11;
    public static final int D_DELETE_COMMENTS = 12;
    public static final int D_INSERT_COMMENTS = 13;
    public static final int D_INSERT_AUDIT = 14;
    public static final int D_CHANGE_OWNER = 15;
    public static final int U_CHANGE_PASSWORD = 16;
    public static final int U_DELETE = 17;
    public static final int U_DELETE_DOMN = 18;
    public static final int U_INSERT_DOMN = 19;
    public static final int U_DELETE_GROUP = 20;
    public static final int U_INSERT_GROUP = 21;
    public static final int U_CHANGE_TYPE = 22;
    public static final int U_DELETE_ALIAS = 23;
    public static final int U_INSERT_ALIAS = 24;
    public static final int U_CHANGE_VERKEY = 25;
    public static final int U_CHANGE_ENCKEY = 26;
    public static final int D_INSERT_COLL_ACCS = 27;
    public static final int D_DELETE_COLL_ACCS = 28;
    public static final int D_CHANGE_DNAME = 29;
    public static final int D_CHANGE_COLL_NAME = 30;
    public static final int D_DELETE_COLL = 31;
    public static final int D_UPDATE_COMMENTS = 32;
    public static final int D_APPEND_COMMENTS = 33;
    public static final int SU_CHANGE_PASSWORD = 34;
    public static final int D_CHANGE_OFFSET = 35;
    public static final int D_CHANGE_DIRTY = 36;
    public static final int U_DELETE_AUTH_MAP = 37;
    public static final int U_INSERT_AUTH_MAP = 38;
    public static final int D_DELETE_ANNOTATIONS = 39;
    public static final int D_INSERT_ANNOTATIONS = 40;
    public static final int D_UPDATE_ANNOTATIONS = 41;
    public static final int D_CHANGE_MODIFY_TIMESTAMP = 42;
    public static final int D_DELETE_CLASS = 43;
    public static final int D_INSERT_CLASS = 44;
    public static final int D_DELETE_INDEX_FOR_DATA = 45;
    public static final int D_INSERT_INDEX_FOR_DATA = 46;
    public static final int D_DELETE_INDEX_FOR_DATATYPE = 47;
    public static final int D_INSERT_INDEX_FOR_DATATYPE = 48;
    public static final int D_DELETE_INDEX_FOR_COLLECTION = 49;
    public static final int D_INSERT_INDEX_FOR_COLLECTION = 50;
    public static final int D_DELETE_METHOD_FOR_DATA = 51;
    public static final int D_INSERT_METHOD_FOR_DATA = 52;
    public static final int D_DELETE_METHOD_FOR_DATATYPE = 53;
    public static final int D_INSERT_METHOD_FOR_DATATYPE = 54;
    public static final int D_DELETE_METHOD_FOR_COLLECTION = 55;
    public static final int D_INSERT_METHOD_FOR_COLLECTION = 56;
    public static final int D_DELETE_STRUCT_METADATA = 57;
    public static final int D_INSERT_EXTERNAL_STRUCT_METADATA = 58;
    public static final int D_INSERT_INTERNAL_STRUCT_METADATA = 59;
    public static final int D_CHANGE_USER_DEFINED_STRING_META_DATA = 60;
    public static final int D_CHANGE_USER_DEFINED_INTEGER_META_DATA = 61;
    public static final int D_INSERT_USER_DEFINED_STRING_META_DATA = 62;
    public static final int D_DELETE_USER_DEFINED_STRING_META_DATA = 63;
    public static final int D_INSERT_USER_DEFINED_INTEGER_META_DATA = 64;
    public static final int D_DELETE_USER_DEFINED_INTEGER_META_DATA = 65;
    public static final int C_INSERT_CONTAINER_FOR_COLLECTION = 66;
    public static final int C_DELETE_CONTAINER_FOR_COLLECTION = 67;
    public static final int C_CHANGE_USER_DEFINED_COLL_STRING_META_DATA = 68;
    public static final int C_CHANGE_USER_DEFINED_COLL_INTEGER_META_DATA = 69;
    public static final int C_INSERT_USER_DEFINED_COLL_STRING_META_DATA = 70;
    public static final int C_INSERT_USER_DEFINED_COLL_INTEGER_META_DATA = 71;
    public static final int C_DELETE_USER_DEFINED_COLL_STRING_META_DATA = 72;
    public static final int C_DELETE_USER_DEFINED_COLL_INTEGER_META_DATA = 73;
    public static final int R_DELETE_ACCS = 74;
    public static final int R_INSERT_ACCS = 75;
    public static final int D_CHANGE_LAST_ACCS_TIME = 76;
    public static final int D_DELETE_ATTR = 77;
    public static final int D_INSERT_ATTR = 78;
    public static final int D_MODIFY_ATTR = 79;
    public static final int D_DELETE_MULTI_ATTR = 80;
    public static final int D_INSERT_MULTI_ATTR = 81;
    public static final int D_MODIFY_MULTI_ATTR = 82;
    public static final int D_INSERT_LINK = 83;
    public static final int D_UPDATE_COLL_COMMENTS = 84;
    public static final int D_INSERT_LOCK = 85;
    public static final int D_UPGRADE_LOCK = 86;
    public static final int D_DELETE_LOCK = 87;
    public static final int D_CHANGE_VERSION = 88;
    public static final int D_DELETE_ALL_FROM_CONTAINER = 89;
    public static final int D_EXTRACT_TEMPLATE_METADATA = 90;
    public static final int C_COPY_META_DATA_FROM_COLL_TO_COLL = 91;
    public static final int D_COPY_META_DATA_FROM_COLL_TO_DATA = 92;
    public static final int C_COPY_META_DATA_FROM_DATA_TO_COLL = 93;
    public static final int D_COPY_META_DATA_FROM_DATA_TO_DATA = 94;
    public static final int D_COPY_ANNOTATIONS_FROM_DATA_TO_DATA = 95;
    public static final int D_READ = 96;
    public static final int D_WRITE = 97;
    public static final int D_CREATE = 98;
    public static final int D_REPLICATE = 99;
    public static final int D_MOVE = 100;
    public static final int C_CREATE = 101;
    public static final int D_TICKET = 102;
    public static final int C_TICKET = 103;
    public static final int D_LINK = 104;
    public static final int D_BULKINGEST = 105;
    public static final int D_DELETECONT = 106;
    public static final int D_AUDIT_SUCCESS = 107;
    public static final int D_AUDIT_FAILURE = 108;
    public static final int D_CONTAINER = 109;
    public static final int C_DELETE_ANNOTATIONS = 110;
    public static final int C_INSERT_ANNOTATIONS = 111;
    public static final int C_UPDATE_ANNOTATIONS = 112;
    public static final int C_COPY_ANNOTATIONS_FROM_COLL_TO_COLL = 113;
    public static final int D_COMPOUND_CREATE = 114;
    public static final int D_DELETE_COMPOUND = 115;
    public static final int D_DELETE_SUBCOMPOUND = 116;
    public static final int D_COMPOUND_MODIFY_CMPD_PATH_NAME = 117;
    public static final int D_COMPOUND_MODIFY_MODIFY_TIMESTAMP = 118;
    public static final int D_COMPOUND_MODIFY_LAST_ACCS_TIME = 119;
    public static final int D_COMPOUND_MODIFY_SIZE = 120;
    public static final int D_COMPOUND_MODIFY_OFFSET = 121;
    public static final int D_COMPOUND_MODIFY_IS_DIRTY = 122;
    public static final int D_COMPOUND_SET_MODIFY_TIMESTAMP = 123;
    public static final int D_COMPOUND_SET_LAST_ACCS_TIME = 124;
    public static final int D_COMPOUND_MODIFY_SIZE_AND_DIRTY = 125;
    public static final int D_CHANGE_DPATH = 126;
    public static final int D_INSERT_INCOLL_ACCS = 127;
    public static final int D_INSERT_INCOLL_ACCS_RECUR = 128;
    public static final int D_DELETE_INCOLL_ACCS = 129;
    public static final int D_DELETE_INCOLL_ACCS_RECUR = 130;
    public static final int C_INSERT_LINK = 131;
    public static final int D_CHANGE_REPLNUM_VERNUM = 132;
    public static final int T_INSERT_TAPE_INFO = 133;
    public static final int T_UPDATE_TAPE_INFO = 134;
    public static final int T_UPDATE_TAPE_INFO_2 = 135;
    public static final int T_DELETE_TAPE_INFO = 136;
    public static final int D_INSERT_DCHECKSUM = 137;
    public static final int D_INSERT_DHIDE = 138;
    public static final int D_INSERT_AUDITFLAG = 139;
    public static final int D_UPDATE_PIN = 140;
    public static final int D_UPDATE_DEXPIRE_DATE = 141;
    public static final int D_UPDATE_DEXPIRE_DATE_2 = 142;
    public static final int D_UPDATE_DCOMPRESSED = 143;
    public static final int D_UPDATE_DENCRYPTED = 144;
    public static final int D_COPY_META_DATA_FROM_CONTAINER_TO_NEW_CONTAINER = 145;
    public static final int D_UPDATE_CONTAINER_FOR_COLLECTION = 146;
    public static final int D_BULK_INSERT_UDEF_META_DATA_FOR_DATA = 147;
    public static final int C_BULK_INSERT_UDEF_META_DATA_FOR_COLL = 148;
    public static final int U_BULK_INSERT_UDEF_META_DATA_FOR_USER = 149;
    public static final int R_BULK_INSERT_UDEF_META_DATA_FOR_RSRC = 150;
    public static final int Z_INSERT_NEW_LOCAL_ZONE = 151;
    public static final int Z_INSERT_NEW_ALIEN_ZONE = 152;
    public static final int Z_MODIFY_ZONE_INFO = 153;
    public static final int Z_MODIFY_ZONE_FOR_USER = 154;
    public static final int Z_CHANGE_ZONE_NAME = 155;
    public static final int Z_MODIFY_ZONE_LOCAL_FLAG = 156;
    public static final int Z_MODIFY_ZONE_STATUS = 157;
    public static final int C_DELETE_MULTI_ATTR = 158;
    public static final int C_INSERT_MULTI_ATTR = 159;
    public static final int C_MODIFY_MULTI_ATTR = 160;
    public static final int C_DELETE_ATTR = 161;
    public static final int C_INSERT_ATTR = 162;
    public static final int C_MODIFY_ATTR = 163;
    public static final int D_BULK_INSERT_UDEF_META_DATA_FOR_MANY_DATA = 164;
    public static final int R_CHANGE_OWNER = 165;
    public static final int C_CHANGE_MODIFY_TIMESTAMP = 166;
    public static final int C_CHANGE_COLL_OWNER = 167;
    public static final int D_INSERT_GUID = 168;
    public static final int D_DELETE_GUID = 169;
    public static final int D_DELETE_FROM_EXTMD_TABLE = 170;
    public static final int D_INSERT_INTO_EXTMD_TABLE = 171;
    public static final int D_MODIFY_IN_EXTMD_TABLE = 172;
    public static final int D_MOVE_DATA_TO_NEWCOLL = 173;
    public static final int D_MOVE_DATA_TO_TRASH = 174;
    public static final int C_MOVE_COLL_TO_NEWCOLL = 175;
    public static final int C_MOVE_COLL_TO_TRASH = 176;
    public static final int D_CHANGE_INCOLL_OWNER = 177;
    public static final int D_CHANGE_INCOLL_OWNER_RECUR = 178;
    public static final int R_CHANGE_USER_DEFINED_STRING_META_DATA = 179;
    public static final int R_INSERT_USER_DEFINED_STRING_META_DATA = 180;
    public static final int R_DELETE_USER_DEFINED_STRING_META_DATA = 181;
    public static final int U_INSERT_USER_DEFINED_STRING_META_DATA = 182;
    public static final int U_DELETE_USER_DEFINED_STRING_META_DATA = 183;
    public static final int U_CHANGE_USER_DEFINED_STRING_META_DATA = 184;
    public static final int R_ADJUST_LATENCY_MAX_IN_MILLISEC = 185;
    public static final int R_ADJUST_LATENCY_MIN_IN_MILLISEC = 186;
    public static final int R_ADJUST_BANDWIDTH_IN_MBITSPS = 187;
    public static final int R_ADJUST_MAXIMUM_CONCURRENCY = 188;
    public static final int R_ADJUST_NUM_OF_STRIPES = 189;
    public static final int R_ADJUST_NUM_OF_HIERARCHIES = 190;
    public static final int R_ADJUST_CAPACITY_IN_GIGABYTES = 191;
    public static final int R_ADJUST_DESCRIPTION = 192;
    public static final int R_INSERT_RSRC_USAGE_TOTAL_BY_DATE = 193;
    public static final int R_INSERT_RSRC_USAGE_AND_QUOTA = 194;
    public static final int R_DELETE_PHY_RSRC_FROM_LOG_RSRC = 195;
    public static final int D_DELETE_USER_DEFINED_ATTR_VAL_META_DATA = 196;
    public static final int R_DELETE_USER_DEFINED_ATTR_VAL_META_DATA = 197;
    public static final int U_DELETE_USER_DEFINED_ATTR_VAL_META_DATA = 198;
    public static final int C_DELETE_USER_DEFINED_ATTR_VAL_META_DATA = 199;
    public static final int R_INSERT_PHY_RSRC_INTO_LOG_RSRC = 200;
    public static final int R_INSERT_FREE_SPACE = 201;
    public static final int R_ADJUST_RSRC_COMMENT = 202;
    public static final int U_CHANGE_INFO = 203;
    public static final int U_ADD_GROUP_OWNER = 204;
    public static final int U_REMOVE_GROUP_OWNER = 205;
    public static final int U_UPDATE_EMAIL = 206;
    public static final int U_UPDATE_PHONE = 207;
    public static final int U_UPDATE_ADDRESS = 208;
    public static final int BULK_PHY_MOVE = 209;
    public static final int BULK_PHY_MOVE_INTO_CONTAINER = 210;
    public static final int BULK_REGISTER_REPLICATE = 211;
    public static final int C_CHANGE_ACL_INHERITANCE_BIT = 212;
    public static final int C_CHANGE_ACL_INHERITANCE_BIT_RECUR = 213;
    public static final int R_RENAME = 214;
    public static final int R_ADJUST_LOCK = 215;
    public static final int R_CHANGE_LOCATION = 216;
    public static final int CURATOR_ACTION_TYPE_MIN = 3000;
    public static final int D_INSERT_ACCS_BY_CURATOR = 3008;
    public static final int D_DELETE_ACCS_BY_CURATOR = 3009;
    public static final int D_CHANGE_OWNER_BY_CURATOR = 3015;
    public static final int D_INSERT_COLL_ACCS_BY_CURATOR = 3027;
    public static final int D_DELETE_COLL_ACCS_BY_CURATOR = 3028;
    public static final int D_INSERT_INCOLL_ACCS_BY_CURATOR = 3127;
    public static final int D_INSERT_INCOLL_ACCS_RECUR_BY_CURATOR = 3128;
    public static final int D_DELETE_INCOLL_ACCS_BY_CURATOR = 3129;
    public static final int D_DELETE_INCOLL_ACCS_RECUR_BY_CURATOR = 3130;
    public static final int C_CHANGE_COLL_OWNER_BY_CURATOR = 3167;
    public static final int D_CHANGE_INCOLL_OWNER_BY_CURATOR = 3177;
    public static final int D_CHANGE_INCOLL_OWNER_RECUR_BY_CURATOR = 3178;
    public static final int C_CHANGE_ACL_INHERITANCE_BIT_BY_CURATOR = 3212;
    public static final int C_CHANGE_ACL_INHERITANCE_BIT_RECUR_BY_CURATOR = 3213;
    public static final int CURATOR_ACTION_TYPE_MAX = 4000;
    static final int SYS_ACTION_TYPE_MIN = 1000;
    static final int D_SU_INSERT_ACCS = 1001;
    static final int D_SU_DELETE_ACCS = 1002;
    static final int C_SU_INSERT_COLL_ACCS = 1003;
    static final int C_SU_DELETE_COLL_ACCS = 1004;
    static final int C_SU_CHANGE_COLL_NAME = 1005;
    static final int D_SU_DELETE_TRASH_ONE = 1006;
    static final int C_SU_DELETE_TRASH_COLL = 1007;
    static final int SYS_ACTION_TYPE_MAX = 2000;
    private static String[] catalogNames;
    private static String[] srbCatalogNames;

    SRBMetaDataSet(SRBProtocol sRBProtocol) {
        protocol = sRBProtocol;
    }

    static final int getSRBID(String string) {
        Integer n = (Integer)jargonToSRBID.get(string);
        if (n == null) {
            return -5;
        }
        return n;
    }

    static final String getSRBName(String string) {
        int n = SRBMetaDataSet.getSRBID(string);
        return srbCatalogNames[n];
    }

    static final MetaDataField getGeneralMetaData(String string, String string2) {
        MetaDataField metaDataField;
        String string3 = (String)srbToJargon.get(string.substring(string.lastIndexOf(".") + 1) + '\u0000' + string2 + '\u0000');
        if (string3 == null) {
            string3 = (String)srbToJargon.get(string + '\u0000' + string2 + '\u0000');
        }
        if ((metaDataField = MetaDataSet.getField(string3)) == null) {
            throw new NullPointerException("This srb return value: " + string + " : " + string2 + ", is not supported in this version.");
        }
        return metaDataField;
    }

    static final String getSRBDatabaseName(String string) {
        String string2 = (String)jargonToSRB.get(string);
        if (string2 == null) {
            throw new NullPointerException("Programming error, was this metadata value: " + string + ", given an integer value in SRBMetaDataSet.jargonNameToSRBID?");
        }
        return string2;
    }

    public static MetaDataGroup[] getMetaDataGroups(GeneralFileSystem generalFileSystem) throws IOException {
        return SRBMetaDataSet.getMetaDataGroups(generalFileSystem, null);
    }

    public static MetaDataGroup[] getMetaDataGroups(GeneralFileSystem generalFileSystem, String string) throws IOException {
        if (!(generalFileSystem instanceof SRBFileSystem)) {
            return MetaDataSet.getMetaDataGroups();
        }
        String[] stringArray = new String[]{EXTENSIBLE_SCHEMA_NAME, EXTENSIBLE_TABLE_NAME, EXTENSIBLE_ATTR_NAME, EXTENSIBLE_ATTR_OUTSIDE_NAME};
        MetaDataSelect[] metaDataSelectArray = MetaDataSet.newSelection(stringArray);
        SRBMetaDataSet.setExtensibleSchema(generalFileSystem.query(null, metaDataSelectArray));
        return MetaDataSet.getMetaDataGroups();
    }

    public static void setExtensibleSchema(GeneralFileSystem generalFileSystem, String string) throws IOException {
        SRBMetaDataSet.setExtensibleSchema(generalFileSystem, new String[]{string});
    }

    public static void setExtensibleSchema(GeneralFileSystem generalFileSystem, String[] stringArray) throws IOException {
        if (stringArray == null) {
            return;
        }
        String string = stringArray[0];
        int n = 1;
        while (n < stringArray.length) {
            string = string + "," + stringArray[n];
            ++n;
        }
        MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{MetaDataSet.newCondition(EXTENSIBLE_SCHEMA_NAME, 6, string), MetaDataSet.newCondition(EXTENSIBLE_ATTR_OUTSIDE_NAME, 10, "")};
        String[] stringArray2 = new String[]{EXTENSIBLE_SCHEMA_NAME, EXTENSIBLE_TABLE_NAME, EXTENSIBLE_ATTR_NAME, EXTENSIBLE_ATTR_OUTSIDE_NAME};
        MetaDataSelect[] metaDataSelectArray = MetaDataSet.newSelection(stringArray2);
        SRBMetaDataSet.setExtensibleSchema(generalFileSystem.query(metaDataConditionArray, metaDataSelectArray));
    }

    private static void setExtensibleSchema(MetaDataRecordList[] metaDataRecordListArray) {
        if (metaDataRecordListArray == null) {
            return;
        }
        String string = metaDataRecordListArray[0].getStringValue(0);
        MetaDataGroup metaDataGroup = new MetaDataGroup(string, "SRB Extensible Schema");
        int n = 0;
        while (n < metaDataRecordListArray.length) {
            if (!string.equals(metaDataRecordListArray[n].getStringValue(0))) {
                MetaDataSet.add(metaDataGroup);
                string = metaDataRecordListArray[n].getStringValue(0);
                metaDataGroup = new MetaDataGroup(string, "SRB Extensible Schema");
            }
            metaDataGroup.add(new MetaDataField(metaDataRecordListArray[n].getStringValue(3), "", 3, protocol, metaDataRecordListArray[n].getStringValue(1)));
            Integer n2 = new Integer(420 + n);
            srbToJargon.put(metaDataRecordListArray[n].getStringValue(1) + '\u0000' + metaDataRecordListArray[n].getStringValue(2) + '\u0000', metaDataRecordListArray[n].getStringValue(3));
            jargonToSRBID.put(metaDataRecordListArray[n].getStringValue(3), n2);
            ++n;
        }
        if (metaDataGroup != null) {
            MetaDataSet.add(metaDataGroup);
        }
    }

    static MetaDataField getField(GeneralFileSystem generalFileSystem, String string) {
        return null;
    }

    static {
        catalogNames = new String[]{FILE_ID, FILE_REPLICATION_ENUM, "file name", USER_GROUP_NAME, "data type name", USER_TYPE_NAME, "user address", "user name", "access constraint", USER_DOMAIN, PATH_NAME, RESOURCE_NAME, RESOURCE_ADDRESS_NETPREFIX, RESOURCE_TYPE_NAME, MODIFICATION_DATE, "directory name", "user phone", "user email", "size", USER_AUDIT_TIME_STAMP, USER_AUDIT_COMMENTS, FILE_COMMENTS, AUDIT_ACTION_DESCRIPTION, AUDIT_TIMESTAMP, AUDIT_COMMENTS, DIRECTORY_ACCESS_CONSTRAINT, ACCESS_DIRECTORY_NAME, RESOURCE_DEFAULT_PATH, PHYSICAL_RESOURCE_DEFAULT_PATH, PHYSICAL_RESOURCE_NAME, PHYSICAL_RESOURCE_TYPE_NAME, RESOURCE_REPLICATION_ENUM, FILE_ACCESS_LIST, RESOURCE_ACCESS_LIST, FILE_IS_DELETED, "owner", TICKET_D, TICKET_BEGIN_TIME_D, TICKET_END_TIME_D, TICKET_ACC_COUNT_D, TICKET_ACC_LIST_D, TICKET_OWNER_D, TICKET_USER_D, TICKET_C, TICKET_BEGIN_TIME_C, TICKET_END_TIME_C, TICKET_ACC_COUNT_C, TICKET_ACC_LIST_C, TICKET_OWNER_C, TICKET_USER_C, TICKET_USER_DOMAIN_C, TICKET_USER_DOMAIN_D, TICKET_OWNER_DOMAIN_C, TICKET_OWNER_DOMAIN_D, PARENT_DIRECTORY_NAME, LOCATION_NAME, IS_DIRTY, CONTAINER_MAX_SIZE, CONTAINER_NAME, RESOURCE_CLASS, MAX_OBJ_SIZE, OFFSET, CONTAINER_RESOURCE_NAME, CONTAINER_RESOURCE_CLASS, CONTAINER_SIZE, CONTAINER_LOG_RESOURCE_NAME, OWNER_DOMAIN, USER_DISTINGUISHED_NAME, USER_AUTHENTICATION_SCHEME, SERVER_LOCATION, SERVER_NETPREFIX, CONTAINER_REPLICATION_ENUM, FILE_ANNOTATION_USERNAME, FILE_ANNOTATION_USERDOMAIN, FILE_ANNOTATION, FILE_ANNOTATION_TIMESTAMP, "creation date", FILE_COMMENTS_TIMESTAMP, FILE_ANNOTATION_POSITION, FILE_ACCESS_PRIVILEGE, RESOURCE_MAX_LATENCY, RESOURCE_MIN_LATENCY, RESOURCE_BANDWIDTH, RESOURCE_MAX_CONCURRENCY, RESOURCE_NUM_OF_HIERARCHIES, RESOURCE_NUM_OF_STRIPES, RESOURCE_CAPACITY, RESOURCE_DESCRIPTION, FILE_CLASS_NAME, FILE_CLASS_TYPE, STRUCTURED_METADATA_TYPE, STRUCTURED_METADATA_COMMENTS, STRUCTURED_METADATA_FILE_NAME, INTERNAL_STRUCTURED_METADATA, INDEX_NAME_FOR_FILE, INDEX_NAME_FOR_DATATYPE, INDEX_NAME_FOR_DIRECTORY, METHOD_NAME_FOR_FILE, METHOD_NAME_FOR_DATATYPE, METHOD_NAME_FOR_DIRECTORY, IX_DIRECTORY_NAME_FOR_FILE, IX_DIRECTORY_NAME_FOR_DATATYPE, IX_DIRECTORY_NAME_FOR_DIRECTORY, METHOD_DIRECTORY_NAME_FOR_FILE, METHOD_DIRECTORY_NAME_FOR_DATATYPE, METHOD_DIRECTORY_NAME_FOR_DIRECTORY, IX_DATATYPE_FOR_FILE, IX_DATATYPE_FOR_DATATYPE, IX_DATATYPE_FOR_DIRECTORY, METHOD_DATATYPE_FOR_FILE, METHOD_DATATYPE_FOR_DATATYPE, METHOD_DATATYPE_FOR_DIRECTORY, STRUCTURED_METADATA_DIRECTORY_NAME, IX_LOCATION_FOR_FILE, IX_LOCATION_FOR_DATATYPE, IX_LOCATION_FOR_DIRECTORY, METADATA_NUM, DEFINABLE_METADATA_FOR_FILES0, DEFINABLE_METADATA_FOR_FILES1, DEFINABLE_METADATA_FOR_FILES2, DEFINABLE_METADATA_FOR_FILES3, DEFINABLE_METADATA_FOR_FILES4, DEFINABLE_METADATA_FOR_FILES5, DEFINABLE_METADATA_FOR_FILES6, DEFINABLE_METADATA_FOR_FILES7, DEFINABLE_METADATA_FOR_FILES8, DEFINABLE_METADATA_FOR_FILES9, INTEGER_DEFINABLE_METADATA0, INTEGER_DEFINABLE_METADATA1, OWNER_EMAIL, AUDIT_USER, AUDIT_USER_DOMAIN, CONTAINER_FOR_DIRECTORY, METADATA_NUM_DIRECTORY, DEFINABLE_METADATA_FOR_DIRECTORIES0, DEFINABLE_METADATA_FOR_DIRECTORIES1, DEFINABLE_METADATA_FOR_DIRECTORIES2, DEFINABLE_METADATA_FOR_DIRECTORIES3, DEFINABLE_METADATA_FOR_DIRECTORIES4, DEFINABLE_METADATA_FOR_DIRECTORIES5, DEFINABLE_METADATA_FOR_DIRECTORIES6, DEFINABLE_METADATA_FOR_DIRECTORIES7, DEFINABLE_METADATA_FOR_DIRECTORIES8, DEFINABLE_METADATA_FOR_DIRECTORIES9, INTEGER_DEFINABLE_METADATA_FOR_DIRECTORIES0, INTEGER_DEFINABLE_METADATA_FOR_DIRECTORIES1, FILE_ACCESS_ID, USER_ID, FILE_LAST_ACCESS_TIMESTAMP, DIRECTORY_OWNER_NAME, DIRECTORY_CREATE_TIMESTAMP, DIRECTORY_COMMENTS, "Dublin Core: dataset", "Dublin Core: collection", "Dublin Core: contributor type", "Dublin Core: subject class", "Dublin Core: description type", "Dublin Core: type", "Dublin Core: source type", "Dublin Core: language", "Dublin Core: relation type", "Dublin Core: coverage type", "Dublin Core: rights type", "Dublin Core: title", "Dublin Core: contributor name", "Dublin Core: subject name", "Dublin Core: description", "Dublin Core: publisher", "Dublin Core: source", "Dublin Core: related data descriptionr", "Dublin Core: related data", "Dublin Core: related directory", "Dublin Core: coverage", "Dublin Core: rights", "Dublin Core: publisher addr", "Dublin Core: contributor addr", "Dublin Core: contributor email", "Dublin Core: contributor phone", "Dublin Core: contributor web", "Dublin Core: contributor affiliation", COLL_ACCS_ID, COLL_ACCS_USER_ID, DATA_ACCS_ID, DATA_ACCS_USER_ID, DEFINABLE_METADATA_FOR_FILES0_1, DEFINABLE_METADATA_FOR_FILES0_2, DEFINABLE_METADATA_FOR_FILES0_3, DEFINABLE_METADATA_FOR_FILES0_4, DEFINABLE_METADATA_FOR_FILES1_1, DEFINABLE_METADATA_FOR_FILES1_2, DEFINABLE_METADATA_FOR_FILES1_3, DEFINABLE_METADATA_FOR_FILES1_4, DEFINABLE_METADATA_FOR_DIRECTORIES0_1, DEFINABLE_METADATA_FOR_DIRECTORIES0_2, DEFINABLE_METADATA_FOR_DIRECTORIES0_3, DEFINABLE_METADATA_FOR_DIRECTORIES0_4, DEFINABLE_METADATA_FOR_DIRECTORIES1_1, DEFINABLE_METADATA_FOR_DIRECTORIES1_2, DEFINABLE_METADATA_FOR_DIRECTORIES1_3, DEFINABLE_METADATA_FOR_DIRECTORIES1_4, TICKET_RECURSIVE, DEFINABLE_METADATA_FOR_RESOURCES0_1, DEFINABLE_METADATA_FOR_RESOURCES0_2, DEFINABLE_METADATA_FOR_RESOURCES0_3, DEFINABLE_METADATA_FOR_RESOURCES1_1, DEFINABLE_METADATA_FOR_RESOURCES1_2, DEFINABLE_METADATA_FOR_RESOURCES1_3, DEFINABLE_METADATA_FOR_USERS0_1, DEFINABLE_METADATA_FOR_USERS0_2, DEFINABLE_METADATA_FOR_USERS0_3, DEFINABLE_METADATA_FOR_USERS1_1, DEFINABLE_METADATA_FOR_USERS1_2, DEFINABLE_METADATA_FOR_USERS1_3, TAPE_NUMBER, TAPE_OWNER, TAPE_TYPE_VAL, TAPE_LIBINX, TAPE_FULLFLAG, TAPE_CURRENT_FILE_SEQNUM, TAPE_CURRENT_ABS_POSITION, TAPE_BYTES_WRITTEN, FILE_VER_NUM, FILE_LOCK_NUM, FILE_LOCK_DESCRIPTION, FILE_LOCK_OWNER_NAME, FILE_LOCK_OWNER_DOMAIN, DIRECTORY_OWNER_DOMAIN, TICKET_DIRECTORY_NAME, TICKET_DIRECTORY_CREATE_TIMESTAMP, TICKET_DIRECTORY_COMMENTS, DIRECTORY_ANNOTATION_USERNAME, DIRECTORY_ANNOTATION_USERDOMAIN, DIRECTORY_ANNOTATION, DIRECTORY_ANNOTATION_TIMESTAMP, DIRECTORY_ANNOTATION_TYPE, FILE_GROUP_ID, FILE_HIDE, FILE_CHECKSUM, FILE_AUDITFLAG, FILE_LOCK_EXPIRY, FILE_PIN_VAL, FILE_PIN_OWNER_NAME, FILE_PIN_OWNER_DOMAIN, FILE_PIN_EXPIRY, FILE_EXPIRY_DATE, FILE_IS_COMPRESSED, FILE_IS_ENCRYPTED, FILE_EXPIRE_DATE_2, NEW_AUDIT_ACTION_DESCRIPTION, NEW_AUDIT_TIMESTAMP, NEW_AUDIT_COMMENTS, DEFINABLE_METADATA_FOR_RESOURCES0, DEFINABLE_METADATA_FOR_RESOURCES1, DEFINABLE_METADATA_FOR_RESOURCES2, DEFINABLE_METADATA_FOR_RESOURCES3, DEFINABLE_METADATA_FOR_RESOURCES4, DEFINABLE_METADATA_FOR_RESOURCES5, DEFINABLE_METADATA_FOR_RESOURCES6, DEFINABLE_METADATA_FOR_RESOURCES7, DEFINABLE_METADATA_FOR_RESOURCES8, DEFINABLE_METADATA_FOR_RESOURCES9, DEFINABLE_INTEGER_METADATA_RESOURCE0, METADATA_NUM_RESOURCE, METADATA_NUM_USER, COMPOUND_RESOURCE_NAME, FILE_SEG_NUM, INT_REPLICATION_ENUM, INT_SEG_NUM, INT_PATH_NAME, INT_RESOURCE_NAME, INT_RESOURCE_ADDRESS_NETPREFIX, INT_RESOURCE_TYPE_NAME, INT_IS_DIRTY, INT_RESOURCE_CLASS, INT_OFFSET, INT_SIZE, COMP_OBJ_USER_NAME, COMP_OBJ_USER_DOMAIN, INT_PATH_NAME_FOR_REPL, DIRECTORY_LINK_NUMBER, REAL_DIRECTORY_NAME, FILE_CONTAINER_NAME, DIRECTORY_CONTAINER_NAME, DEFINABLE_METADATA_FOR_USERS0, DEFINABLE_METADATA_FOR_USERS1, DEFINABLE_METADATA_FOR_USERS2, DEFINABLE_METADATA_FOR_USERS3, DEFINABLE_METADATA_FOR_USERS4, DEFINABLE_METADATA_FOR_USERS5, DEFINABLE_METADATA_FOR_USERS6, DEFINABLE_METADATA_FOR_USERS7, DEFINABLE_METADATA_FOR_USERS8, DEFINABLE_METADATA_FOR_USERS9, UDIMD_USER0, NONDISTINCT, USERDEFFUNC01, USERDEFFUNC02, USERDEFFUNC03, USERDEFFUNC04, USERDEFFUNC05, ZONE_NAME, ZONE_LOCALITY, ZONE_NETPREFIX, ZONE_PORT_NUM, ZONE_ADMIN_AUTH_SCHEME_NAME, ZONE_ADMIN_DISTIN_NAME, ZONE_STATUS, ZONE_CREATE_DATE, ZONE_MODIFY_DATE, ZONE_COMMENTS, ZONE_CONTACT, ZONE_ADMIN_NAME, ZONE_ADMIN_DOMAIN_NAME, "resource access privilege", "resource access constraint name", UDIMD_USER1, "change MAX_RSRC_INTEGER_METADATA", USER_GROUP_MODIFY_DATE, USER_GROUP_ZONE_NAME, USER_GROUP_DOMAIN_DESC, DATA_UDEF_MDATA_MODIFY_DATE, COLL_UDEF_MDATA_MODIFY_DATE, USER_UDEF_MDATA_MODIFY_DATE, "user-def metadata for resource mod", DATA_TYPE_MIME_STRING, DATA_TYPE_EXTENDERS, "comments on log resource", "log resource creation timestamp", "log resource modify timestamp", USER_CREATE_DATE, USER_MODIFY_DATE, RSRC_MAX_OBJ_SIZE, "owner of the log resource", "domain of the log resource", RSRC_MLSEC_LATENCY_MAX, RSRC_MLSEC_LATENCY_MIN, RSRC_MBPS_BANDWIDTH, RSRC_CONCURRENCY_MAX, RSRC_NUM_OF_HIERARCHIES, RSRC_NUM_OF_STRIPES, RSRC_MEGAB_CAPACITY, RSRC_ACCS_USER_NAME, RSRC_ACCS_USER_DOMAIN, RSRC_ACCS_USER_ZONE, RSRC_OWNER_ZONE, DATA_OWNER_ZONE, TICKET_OWNER_ZONE_D, TICKET_USER_ZONE_D, TICKET_OWNER_ZONE_C, TICKET_USER_ZONE_C, DATA_ANNOTATION_USER_ZONE, AUDIT_USER_ZONE, COLL_OWNER_ZONE, DATA_LOCK_OWNER_ZONE, COLL_ANNOTATION_USER_ZONE, DATA_PIN_OWNER_ZONE, COMP_OBJ_USER_ZONE, PARENT_SERVER_LOCATION, RSRC_ACCESS_ID, PARENT_DATA_TYPE, ZONE_LOCN_DESC, PARENT_DOMAIN_DESC, PARENT_USER_TYPE, PARENT_RSRC_TYPE, RSRC_ACCS_GRPUSER_NAME, RSRC_ACCS_GRPUSER_DOMAIN, RSRC_ACCS_GRPUSER_ZONE, COLL_MODIFY_TIMESTAMP, DATA_ACCS_GRPUSER_NAME, DATA_ACCS_GRPUSER_DOMAIN, DATA_ACCS_GRPUSER_ZONE, COLL_ACCS_GRPUSER_NAME, COLL_ACCS_GRPUSER_DOMAIN, COLL_ACCS_GRPUSER_ZONE, COLL_ACCS_COLLECTION_NAME, COLL_ACCS_ACCESS_CONSTRAINT, DATA_TYPE_FOR_CONTAINER_FOR_COLLECTION, DATA_UDEF_MDATA_CREATE_DATE, COLL_UDEF_MDATA_CREATE_DATE, RSRC_UDEF_MDATA_CREATE_DATE, USER_UDEF_MDATA_CREATE_DATE, CONTAINER_ID, GUID, GUID_FLAG, GUID_TIME_STAMP, ORDERBY, DELETE_FILE_ID, DELETE_FILE_REPLICATION_ENUM, DELETE_FILE_NAME, DELETE_MODIFICATION_DATE, DELETE_DIRECTORY_NAME, DEL_COLLECTION_ID, DEL_DATA_COMMENT, FREE_SPACE, FS_TIMESTAMP, EXTENSIBLE_SCHEMA_NAME, EXTENSIBLE_TABLE_NAME, EXTENSIBLE_ATTR_NAME, EXTENSIBLE_ATTR_OUTSIDE_NAME, EXTENSIBLE_ATTR_COMMENTS, RESOURCE_STATUS};
        srbCatalogNames = new String[]{"DATA_ID", "DATA_REPL_ENUM", "DATA_NAME", "USER_GROUP_NAME", "DATA_TYP_NAME", "USER_TYP_NAME", "USER_ADDRESS", "USER_NAME", "ACCESS_CONSTRAINT", "DOMAIN_DESC", "PATH_NAME", "RSRC_NAME", "RSRC_ADDR_NETPREFIX", "RSRC_TYP_NAME", "REPL_TIMESTAMP", "DATA_GRP_NAME", "USER_PHONE", "USER_EMAIL", "SIZE", "USER_AUDIT_TIME_STAMP", "USER_AUDIT_COMMENTS", "DATA_COMMENTS", "AUDIT_ACTION_DESC", "AUDIT_TIMESTAMP", "AUDIT_COMMENTS", "COLLECTION_ACCESS_CONSTRAINT", "ACCESS_COLLECTION_NAME", "RSRC_DEFAULT_PATH", "PHY_RSRC_DEFAULT_PATH", "PHY_RSRC_NAME", "PHY_RSRC_TYP_NAME", "RSRC_REPL_ENUM", "DATA_ACCESS_LIST", "RSRC_ACCESS_LIST", "DATA_IS_DELETED", "DATA_OWNER", "TICKET_D", "TICKET_BEGIN_TIME_D", "TICKET_END_TIME_D", "TICKET_ACC_COUNT_D", "TICKET_ACC_LIST_D", "TICKET_OWNER_D", "TICKET_USER_D", "TICKET_C", "TICKET_BEGIN_TIME_C", "TICKET_END_TIME_C", "TICKET_ACC_COUNT_C", "TICKET_ACC_LIST_C", "TICKET_OWNER_C", "TICKET_USER_C", "TICKET_USER_DOMAIN_C", "TICKET_USER_DOMAIN_D", "TICKET_OWNER_DOMAIN_C", "TICKET_OWNER_DOMAIN_D", "PARENT_COLLECTION_NAME", "LOCATION_NAME", "IS_DIRTY", "CONTAINER_MAX_SIZE", "CONTAINER_NAME", "RSRC_CLASS", "MAX_OBJ_SIZE", "OFFSET", "CONTAINER_RSRC_NAME", "CONTAINER_RSRC_CLASS", "CONTAINER_SIZE", "CONTAINER_LOG_RSRC_NAME", "DATA_OWNER_DOMAIN", "USER_DISTIN_NAME", "USER_AUTH_SCHEME", "SERVER_LOCATION", "SERVER_NETPREFIX", "CONTAINER_REPL_ENUM", "DATA_ANNOTATION_USERNAME", "DATA_ANNOTATION_USERDOMAIN", "DATA_ANNOTATION", "DATA_ANNOTATION_TIMESTAMP", "DATA_CREATE_TIMESTAMP", "DATA_COMMENTS_TIMESTAMP", "DATA_ANNOTATION_POSITION", "DATA_ACCESS_PRIVILEGE", "RESOURCE_MAX_LATENCY", "RESOURCE_MIN_LATENCY", "RESOURCE_BANDWIDTH", "RESOURCE_MAX_CONCURRENCY", "RESOURCE_NUM_OF_HIERARCHIES", "RESOURCE_NUM_OF_STRIPES", "RESOURCE_CAPACITY", "RESOURCE_DESCRIPTION", "DATA_CLASS_NAME", "DATA_CLASS_TYPE", "STRUCTURED_METADATA_TYPE", "STRUCTURED_METADATA_COMMENTS", "STRUCTURED_METADATA_DATA_NAME", "INTERNAL_STRUCTURED_METADATA", "INDEX_NAME_FOR_DATASET", "INDEX_NAME_FOR_DATATYPE", "INDEX_NAME_FOR_COLLECTION", "METHOD_NAME_FOR_DATASET", "METHOD_NAME_FOR_DATATYPE", "METHOD_NAME_FOR_COLLECTION", "IX_COLL_NAME_FOR_DATASET", "IX_COLLNAME_FOR_DATATYPE", "IX_COLLNAME_FOR_COLLECTION", "MTH_COLLNAME_FOR_DATASET", "MTH_COLLNAME_FOR_DATATYPE", "MTH_COLLNAME_FOR_COLLECTION", "IX_DATATYPE_FOR_DATASET", "IX_DATATYPE_FOR_DATATYPE", "IX_DATATYPE_FOR_COLLECTION", "MTH_DATATYPE_FOR_DATASET", "MTH_DATATYPE_FOR_DATATYPE", "MTH_DATATYPE_FOR_COLLECTION", "STRUCTURED_METADATA_COLLNAME", "IX_LOCATION_FOR_DATASET", "IX_LOCATION_FOR_DATATYPE", "IX_LOCATION_FOR_COLLECTION", "METADATA_NUM", "UDSMD0", "UDSMD1", "UDSMD2", "UDSMD3", "UDSMD4", "UDSMD5", "UDSMD6", "UDSMD7", "UDSMD8", "UDSMD9", "UDIMD0", "UDIMD1", "DATA_OWNER_EMAIL", "AUDIT_USER", "AUDIT_USER_DOMAIN", "CONTAINER_FOR_COLLECTION", "METADATA_NUM_COLL", "UDSMD_COLL0", "UDSMD_COLL1", "UDSMD_COLL2", "UDSMD_COLL3", "UDSMD_COLL4", "UDSMD_COLL5", "UDSMD_COLL6", "UDSMD_COLL7", "UDSMD_COLL8", "UDSMD_COLL9", "UDIMD_COLL0", "UDIMD_COLL1", "DATA_ACCESS_ID", "USER_ID", "DATA_LAST_ACCESS_TIMESTAMP", "COLL_OWNER_NAME", "COLL_CREATE_TIMESTAMP", "COLL_COMMENTS", "DC_DATA_NAME", "DC_COLLECTION", "DC_CONTRIBUTOR_TYPE", "DC_SUBJECT_CLASS", "DC_DESCRIPTION_TYPE", "DC_TYPE", "DC_SOURCE_TYPE", "DC_LANGUAGE", "DC_RELATION_TYPE", "DC_COVERAGE_TYPE", "DC_RIGHTS_TYPE", "DC_TITLE", "DC_CONTRIBUTOR_NAME", "DC_SUBJECT_NAME", "DC_DESCRIPTION", "DC_PUBLISHER", "DC_SOURCE", "DC_RELATED_DATA_DESCR", "DC_RELATED_DATA", "DC_RELATED_COLL", "DC_COVERAGE", "DC_RIGHTS", "DC_PUBLISHER_ADDR", "DC_CONTRIBUTOR_ADDR", "DC_CONTRIBUTOR_EMAIL", "DC_CONTRIBUTOR_PHONE", "DC_CONTRIBUTOR_WEB", "DC_CONTRIBUTOR_CORPNAME", "COLL_ACCS_ID", "COLL_ACCS_USER_ID", "DATA_ACCS_ID", "DATA_ACCS_USER_ID", "UDSMD0_1", "UDSMD0_2", "UDSMD0_3", "UDSMD0_4", "UDSMD1_1", "UDSMD1_2", "UDSMD1_3", "UDSMD1_4", "UDSMD_COLL0_1", "UDSMD_COLL0_2", "UDSMD_COLL0_3", "UDSMD_COLL0_4", "UDSMD_COLL1_1", "UDSMD_COLL1_2", "UDSMD_COLL1_3", "UDSMD_COLL1_4", "C_TICKET_RECURSIVE", "UDSMD_RSRC1_0", "UDSMD_RSRC1_1", "UDSMD_RSRC1_2", "UDSMD_RSRC2_0", "UDSMD_RSRC2_1", "UDSMD_RSRC2_2", "UDSMD_USER1_0", "UDSMD_USER1_1", "UDSMD_USER1_2", "UDSMD_USER2_0", "UDSMD_USER2_1", "UDSMD_USER2_2", "TAPE_NUMBER", "TAPE_OWNER", "TAPE_TYPE_VAL", "TAPE_LIBINX", "TAPE_FULLFLAG", "TAPE_CURRENT_FILE_SEQNUM", "TAPE_CURRENT_ABS_POSITION", "TAPE_BYTES_WRITTEN", "DATA_VER_NUM", "DATA_LOCK_NUM", "DATA_LOCK_DESC", "DATA_LOCK_OWNER_NAME", "DATA_LOCK_OWNER_DOMAIN", "COLL_OWNER_DOMAIN", "C_TICKET_COLL_NAME", "C_TICKET_COLL_CREATE_TIMESTAMP", "C_TICKET_COLL_COMMENTS", "COLL_ANNOTATION_USERNAME", "COLL_ANNOTATION_USERDOMAIN", "COLL_ANNOTATION", "COLL_ANNOTATION_TIMESTAMP", "COLL_ANNOTATION_TYPE", "DATA_GRP_ID", "DATA_HIDE", "DATA_CHECKSUM", "DATA_AUDITFLAG", "DATA_LOCK_EXPIRY", "DATA_PIN_VAL", "DATA_PIN_OWNER_NAME", "DATA_PIN_OWNER_DOMAIN", "DATA_PIN_EXPIRY", "DATA_EXPIRY_DATE", "DATA_IS_COMPRESSED", "DATA_IS_ENCRYPTED", "DATA_EXPIRE_DATE_2", "NEW_AUDIT_ACTION_DESC", "NEW_AUDIT_TIMESTAMP", "NEW_AUDIT_COMMENTS", "UDSMD_RSRC0", "UDSMD_RSRC1", "UDSMD_RSRC2", "UDSMD_RSRC3", "UDSMD_RSRC4", "UDSMD_RSRC5", "UDSMD_RSRC6", "UDSMD_RSRC7", "UDSMD_RSRC8", "UDSMD_RSRC9", "UDIMD_RSRC0", "METADATA_NUM_RSRC", "METADATA_NUM_USER", "COMPOUND_RSRC_NAME", "DATA_SEG_NUM", "INT_REPL_ENUM", "INT_SEG_NUM", "INT_PATH_NAME", "INT_RSRC_NAME", "INT_RSRC_ADDR_NETPREFIX", "INT_RSRC_TYP_NAME", "INT_IS_DIRTY", "INT_RSRC_CLASS", "INT_OFFSET", "INT_SIZE", "COMP_OBJ_USER_NAME", "COMP_OBJ_USER_DOMAIN", "INT_PATH_NAME_FOR_REPL", "COLLECTION_LINK_NUM", "REAL_COLLECTION_NAME", "DATA_CONT_NAME", "COLLECTION_CONT_NAME", "UDSMD_USER0", "UDSMD_USER1", "UDSMD_USER2", "UDSMD_USER3", "UDSMD_USER4", "UDSMD_USER5", "UDSMD_USER6", "UDSMD_USER7", "UDSMD_USER8", "UDSMD_USER9", "UDIMD_USER0", "NONDISTINCT", "USERDEFFUNC01", "USERDEFFUNC02", "USERDEFFUNC03", "USERDEFFUNC04", "USERDEFFUNC05", "ZONE_NAME", "ZONE_LOCALITY", "ZONE_NETPREFIX", "ZONE_PORT_NUM", "ZONE_ADMIN_AUTH_SCHEME_NAME", "ZONE_ADMIN_DISTIN_NAME", "ZONE_STATUS", "ZONE_CREATE_DATE", "ZONE_MODIFY_DATE", "ZONE_COMMENTS", "ZONE_CONTACT", "ZONE_ADMIN_NAME", "ZONE_ADMIN_DOMAIN_NAME", "RSRC_ACCESS_PRIVILEGE", "RSRC_ACCESS_CONSTRAINT", "UDIMD_USER1", "UDIMD_RSRC1", "USER_GROUP_MODIFY_DATE", "USER_GROUP_ZONE_NAME", "USER_GROUP_DOMAIN_DESC", "DATA_UDEF_MDATA_MODIFY_DATE", "COLl_UDEF_MDATA_MODIFY_DATE", "USER_UDEF_MDATA_MODIFY_DATE", "RSRC_UDEF_MDATA_MODIFY_DATE", "DATA_TYPE_MIME_STRING", "DATA_TYPE_EXTENDERS", "RSRC_COMMENTS", "RSRC_CREATE_DATE", "RSRC_MODIFY_DATE", "USER_CREATE_DATE", "USER_MODIFY_DATE", "RSRC_MAX_OBJ_SIZE", "RSRC_OWNER_NAME", "RSRC_OWNER_DOMAIN", "RSRC_MLSEC_LATENCY_MAX", "RSRC_MLSEC_LATENCY_MIN", "RSRC_MBPS_BANDWIDTH", "RSRC_CONCURRENCY_MAX", "RSRC_NUM_OF_HIERARCHIES", "RSRC_NUM_OF_STRIPES", "RSRC_MEGAB_CAPACITY", "RSRC_ACCS_USER_NAME", "RSRC_ACCS_USER_DOMAIN", "RSRC_ACCS_USER_ZONE", "RSRC_OWNER_ZONE", "DATA_OWNER_ZONE", "TICKET_OWNER_ZONE_D", "TICKET_USER_ZONE_D", "TICKET_OWNER_ZONE_C", "TICKET_USER_ZONE_C", "DATA_ANNOTATION_USER_ZONE", "AUDIT_USER_ZONE", "COLL_OWNER_ZONE", "DATA_LOCK_OWNER_ZONE", "COLL_ANNOTATION_USER_ZONE", "DATA_PIN_OWNER_ZONE", "COMP_OBJ_USER_ZONE", "PARENT_SERVER_LOCATION", "RSRC_ACCESS_ID", "PARENT_DATA_TYPE", "ZONE_LOCN_DESC", "PARENT_DOMAIN_DESC", "PARENT_USER_TYPE", "PARENT_RSRC_TYPE", "RSRC_ACCS_GRPUSER_NAME", "RSRC_ACCS_GRPUSER_DOMAIN", "RSRC_ACCS_GRPUSER_ZONE", "COLL_MODIFY_TIMESTAMP", "DATA_ACCS_GRPUSER_NAME", "DATA_ACCS_GRPUSER_DOMAIN", "DATA_ACCS_GRPUSER_ZONE", "COLL_ACCS_GRPUSER_NAME", "COLL_ACCS_GRPUSER_DOMAIN", "COLL_ACCS_GRPUSER_ZONE", "COLL_ACCS_COLLECTION_NAME", "COLL_ACCS_ACCESS_CONSTRAINT", "DATA_TYPE_FOR_CONTAINER_FOR_COLLECTION", DATA_UDEF_MDATA_CREATE_DATE, COLL_UDEF_MDATA_CREATE_DATE, RSRC_UDEF_MDATA_CREATE_DATE, USER_UDEF_MDATA_CREATE_DATE, "CONTAINER_ID", GROUP_GUID, "GUID_FLAG", "GUID_TIME_STAMP", "ORDERBY", "DEL_DATA_ID", "DEL_DATA_REPL_ENUM", "DEL_DATA_NAME", "DEL_REPL_TIMESTAMP", "DEL_COLLECTION_NAME", "DEL_COLLECTION_ID", "DEL_DATA_COMMENT", "FREE_SPACE", "FS_TIMESTAMP", "EXTENSIBLE_SCHEMA_NAME", "EXTENSIBLE_TABLE_NAME", "EXTENSIBLE_ATTR_NAME", "EXTENSIBLE_ATTR_OUTSIDE_NAME", "EXTENSIBLE_ATTR_COMMENTS", "RESOURCE_STATUS"};
        MetaDataGroup metaDataGroup = new MetaDataGroup(GROUP_DIRECTORY, "Core meta-information about directories");
        metaDataGroup.add(new MetaDataField(PARENT_DIRECTORY_NAME, "name of parent directory (directory name)", 3, protocol));
        metaDataGroup.add(new MetaDataField("directory name", "directory name", 3, protocol));
        metaDataGroup.add(new MetaDataField(FILE_GROUP_ID, "internal directory id", 0, protocol));
        metaDataGroup.add(new MetaDataField(DIRECTORY_OWNER_NAME, "directory owner", 3, protocol));
        metaDataGroup.add(new MetaDataField(DIRECTORY_OWNER_DOMAIN, DIRECTORY_OWNER_DOMAIN, 3, protocol));
        metaDataGroup.add(new MetaDataField(DIRECTORY_CREATE_TIMESTAMP, "directory create timestamp", 3, protocol));
        metaDataGroup.add(new MetaDataField(CONTAINER_FOR_DIRECTORY, "default container for coll", 3, protocol));
        metaDataGroup.add(new MetaDataField(DIRECTORY_COMMENTS, "comments on directory", 3, protocol));
        metaDataGroup.add(new MetaDataField(COLL_ACCS_ID, COLL_ACCS_ID, 3, protocol));
        metaDataGroup.add(new MetaDataField(COLL_ACCS_USER_ID, COLL_ACCS_USER_ID, 3, protocol));
        MetaDataSet.add(metaDataGroup);
        metaDataGroup = new MetaDataGroup(GROUP_DATA, "Core meta-information about datasets.");
        metaDataGroup.add(new MetaDataField("directory name", "collection name", 3, protocol));
        metaDataGroup.add(new MetaDataField(CONTAINER_NAME, "name of container", 3, protocol));
        metaDataGroup.add(new MetaDataField("file name", "file name", 3, protocol));
        metaDataGroup.add(new MetaDataField(FILE_ID, "internal data id", 3, protocol));
        metaDataGroup.add(new MetaDataField(FILE_REPLICATION_ENUM, "replica copy number", 3, protocol));
        metaDataGroup.add(new MetaDataField(FILE_VER_NUM, "dataset version number", 3, protocol));
        metaDataGroup.add(new MetaDataField(FILE_SEG_NUM, "dataset segment number", 3, protocol));
        metaDataGroup.add(new MetaDataField(PHYSICAL_RESOURCE_NAME, PHYSICAL_RESOURCE_NAME, 3, protocol));
        metaDataGroup.add(new MetaDataField(PATH_NAME, "physical path name of data object", 3, protocol));
        metaDataGroup.add(new MetaDataField("size", "size of data", 0, protocol));
        metaDataGroup.add(new MetaDataField(OFFSET, "position of data in container", 0, protocol));
        metaDataGroup.add(new MetaDataField("data type name", "data type", 3, protocol));
        metaDataGroup.add(new MetaDataField(FILE_CLASS_NAME, "classifcation name for data", 3, protocol));
        metaDataGroup.add(new MetaDataField(FILE_CLASS_TYPE, "classification type", 3, protocol));
        metaDataGroup.add(new MetaDataField("creation date", "data creation time stamp", 3, protocol));
        metaDataGroup.add(new MetaDataField(MODIFICATION_DATE, "data modification time stamp", 3, protocol));
        metaDataGroup.add(new MetaDataField(FILE_LAST_ACCESS_TIMESTAMP, "last access time stamp", 3, protocol));
        metaDataGroup.add(new MetaDataField("owner", "data creator name", 3, protocol));
        metaDataGroup.add(new MetaDataField(OWNER_DOMAIN, "domain of data creator", 3, protocol));
        metaDataGroup.add(new MetaDataField(FILE_COMMENTS, "comments on data", 3, protocol));
        metaDataGroup.add(new MetaDataField(FILE_IS_DELETED, "data liveness", 3, protocol));
        metaDataGroup.add(new MetaDataField(IS_DIRTY, "data has changed compared to other copies", 3, protocol));
        metaDataGroup.add(new MetaDataField(FILE_LOCK_NUM, "dataset lock type in numeric form", 0, protocol));
        metaDataGroup.add(new MetaDataField(FILE_LOCK_DESCRIPTION, "lock type description", 3, protocol));
        metaDataGroup.add(new MetaDataField(FILE_LOCK_OWNER_NAME, "dataset lock owner name", 3, protocol));
        metaDataGroup.add(new MetaDataField(FILE_LOCK_OWNER_DOMAIN, "dataset lock owner domain", 3, protocol));
        metaDataGroup.add(new MetaDataField(FILE_HIDE, "setting it more than 0 hides the data", 0, protocol));
        metaDataGroup.add(new MetaDataField(FILE_CHECKSUM, "check sum for data string", 0, protocol));
        metaDataGroup.add(new MetaDataField(FILE_AUDITFLAG, "flag set if data has to be audited", 3, protocol));
        metaDataGroup.add(new MetaDataField(FILE_LOCK_EXPIRY, "lock expory data timestamp", 3, protocol));
        metaDataGroup.add(new MetaDataField(FILE_PIN_VAL, "data replica pinned from moved if>=0", 0, protocol));
        metaDataGroup.add(new MetaDataField(FILE_PIN_OWNER_NAME, "owner of the pin", 3, protocol));
        metaDataGroup.add(new MetaDataField(FILE_PIN_OWNER_DOMAIN, "domain of the pin owner", 3, protocol));
        metaDataGroup.add(new MetaDataField(FILE_PIN_EXPIRY, "expiry timestamp for the pin", 3, protocol));
        metaDataGroup.add(new MetaDataField(FILE_EXPIRY_DATE, "expiry time for the data replica", 3, protocol));
        metaDataGroup.add(new MetaDataField(FILE_IS_COMPRESSED, "data compressed or not and how", 3, protocol));
        metaDataGroup.add(new MetaDataField(FILE_IS_ENCRYPTED, "data encrypted or not and how", 3, protocol));
        metaDataGroup.add(new MetaDataField(FILE_EXPIRE_DATE_2, "another expiry timestamp", 3, protocol));
        metaDataGroup.add(new MetaDataField(DATA_ACCS_ID, FILE_ACCESS_ID, 3, protocol));
        metaDataGroup.add(new MetaDataField(DATA_ACCS_USER_ID, "file access user id", 3, protocol));
        MetaDataSet.add(metaDataGroup);
        metaDataGroup = new MetaDataGroup(GROUP_USER, "Core information about SRB-registered users.");
        metaDataGroup.add(new MetaDataField("user name", "user name", 3, protocol));
        metaDataGroup.add(new MetaDataField(USER_DOMAIN, "user domain name", 3, protocol));
        metaDataGroup.add(new MetaDataField(USER_ID, "MCAT's internal Id for the User", 0, protocol));
        metaDataGroup.add(new MetaDataField(USER_TYPE_NAME, "user type", 3, protocol));
        metaDataGroup.add(new MetaDataField("user address", "user address", 3, protocol));
        metaDataGroup.add(new MetaDataField("user phone", "user phone number", 3, protocol));
        metaDataGroup.add(new MetaDataField("user email", "user email", 3, protocol));
        MetaDataSet.add(metaDataGroup);
        metaDataGroup = new MetaDataGroup(GROUP_PHYSICAL_RESOURCE, "Core meta-information about physical resources including SRB servers.");
        metaDataGroup.add(new MetaDataField(PHYSICAL_RESOURCE_NAME, PHYSICAL_RESOURCE_NAME, 3, protocol));
        metaDataGroup.add(new MetaDataField(PHYSICAL_RESOURCE_TYPE_NAME, "physical resource type", 3, protocol));
        metaDataGroup.add(new MetaDataField(PHYSICAL_RESOURCE_DEFAULT_PATH, "default path in physical resource", 3, protocol));
        metaDataGroup.add(new MetaDataField(LOCATION_NAME, "location of physical resource name", 3, protocol));
        metaDataGroup.add(new MetaDataField(RESOURCE_ADDRESS_NETPREFIX, "net address of physical resource", 3, protocol));
        metaDataGroup.add(new MetaDataField(RESOURCE_DESCRIPTION, "comments on the resource", 3, protocol));
        metaDataGroup.add(new MetaDataField(MAX_OBJ_SIZE, "max size of data allowed in resource", 0, protocol));
        metaDataGroup.add(new MetaDataField(RESOURCE_MAX_LATENCY, "physical resource estimated latency (max)", 0, protocol));
        metaDataGroup.add(new MetaDataField(RESOURCE_MIN_LATENCY, "physical resource estimated latency (min)", 0, protocol));
        metaDataGroup.add(new MetaDataField(RESOURCE_BANDWIDTH, "physical resource estimated bandwidth", 0, protocol));
        metaDataGroup.add(new MetaDataField(RESOURCE_MAX_CONCURRENCY, "physical resource max concurrent reqs", 0, protocol));
        metaDataGroup.add(new MetaDataField(RESOURCE_NUM_OF_HIERARCHIES, "depth of hierarchy in resource", 0, protocol));
        metaDataGroup.add(new MetaDataField(RESOURCE_NUM_OF_STRIPES, "number of striping in resource", 0, protocol));
        metaDataGroup.add(new MetaDataField(RESOURCE_CAPACITY, "capacity of the physical resource", 0, protocol));
        MetaDataSet.add(metaDataGroup);
        metaDataGroup = new MetaDataGroup(GROUP_LOGICAL_RESOURCE, "Core meta-information about logical resources.");
        metaDataGroup.add(new MetaDataField(RESOURCE_NAME, "name of logical resource", 3, protocol));
        metaDataGroup.add(new MetaDataField(RESOURCE_TYPE_NAME, "logical resource type", 3, protocol));
        metaDataGroup.add(new MetaDataField(PHYSICAL_RESOURCE_NAME, PHYSICAL_RESOURCE_NAME, 3, protocol));
        metaDataGroup.add(new MetaDataField(RESOURCE_REPLICATION_ENUM, "index of physical resource in logical resource", 3, protocol));
        metaDataGroup.add(new MetaDataField(RESOURCE_DEFAULT_PATH, "default path in logical resource", 3, protocol));
        metaDataGroup.add(new MetaDataField(RESOURCE_CLASS, "classification of resource", 3, protocol));
        metaDataGroup.add(new MetaDataField("resource access privilege", "resource access privilege", 3, protocol));
        metaDataGroup.add(new MetaDataField("resource access constraint name", "resource access constraint namw", 3, protocol));
        metaDataGroup.add(new MetaDataField("comments on log resource", "comments on log resource", 3, protocol));
        metaDataGroup.add(new MetaDataField("log resource creation timestamp", "log rsource creation timestamp", 3, protocol));
        metaDataGroup.add(new MetaDataField("log resource modify timestamp", "log resource modify timestamp", 3, protocol));
        metaDataGroup.add(new MetaDataField(RSRC_MAX_OBJ_SIZE, RSRC_MAX_OBJ_SIZE, 3, protocol));
        metaDataGroup.add(new MetaDataField("owner of the log resource", "owner of the log resource", 3, protocol));
        metaDataGroup.add(new MetaDataField("domain of the log resource", "domain of the log resource", 3, protocol));
        metaDataGroup.add(new MetaDataField(RSRC_MLSEC_LATENCY_MAX, RSRC_MLSEC_LATENCY_MAX, 3, protocol));
        metaDataGroup.add(new MetaDataField(RSRC_MLSEC_LATENCY_MIN, RSRC_MLSEC_LATENCY_MIN, 3, protocol));
        metaDataGroup.add(new MetaDataField(RSRC_MBPS_BANDWIDTH, RSRC_MBPS_BANDWIDTH, 3, protocol));
        metaDataGroup.add(new MetaDataField(RSRC_CONCURRENCY_MAX, RSRC_CONCURRENCY_MAX, 3, protocol));
        metaDataGroup.add(new MetaDataField(RSRC_NUM_OF_HIERARCHIES, RSRC_NUM_OF_HIERARCHIES, 3, protocol));
        metaDataGroup.add(new MetaDataField(RSRC_NUM_OF_STRIPES, RSRC_NUM_OF_STRIPES, 3, protocol));
        metaDataGroup.add(new MetaDataField(RSRC_MEGAB_CAPACITY, RSRC_MEGAB_CAPACITY, 3, protocol));
        metaDataGroup.add(new MetaDataField(RSRC_ACCS_USER_NAME, RSRC_ACCS_USER_NAME, 3, protocol));
        metaDataGroup.add(new MetaDataField(RSRC_ACCS_USER_DOMAIN, RSRC_ACCS_USER_DOMAIN, 3, protocol));
        metaDataGroup.add(new MetaDataField(RSRC_ACCS_USER_ZONE, RSRC_ACCS_USER_ZONE, 3, protocol));
        metaDataGroup.add(new MetaDataField(RSRC_OWNER_ZONE, RSRC_OWNER_ZONE, 3, protocol));
        metaDataGroup.add(new MetaDataField(RSRC_ACCS_GRPUSER_NAME, RSRC_ACCS_GRPUSER_NAME, 3, protocol));
        metaDataGroup.add(new MetaDataField(RSRC_ACCS_GRPUSER_DOMAIN, RSRC_ACCS_GRPUSER_DOMAIN, 3, protocol));
        metaDataGroup.add(new MetaDataField(RSRC_ACCS_GRPUSER_ZONE, RSRC_ACCS_GRPUSER_ZONE, 3, protocol));
        metaDataGroup.add(new MetaDataField(RSRC_ACCESS_ID, RSRC_ACCESS_ID, 3, protocol));
        MetaDataSet.add(metaDataGroup);
        metaDataGroup = new MetaDataGroup(GROUP_SERVER, "");
        metaDataGroup.add(new MetaDataField(SERVER_LOCATION, "location of SRB server", 3, protocol));
        metaDataGroup.add(new MetaDataField(SERVER_NETPREFIX, "net address of SRB server", 3, protocol));
        MetaDataSet.add(metaDataGroup);
        metaDataGroup = new MetaDataGroup(GROUP_USER_GROUP, "");
        metaDataGroup.add(new MetaDataField(USER_GROUP_NAME, "name of user group", 3, protocol));
        metaDataGroup.add(new MetaDataField("user name", "user name", 3, protocol));
        metaDataGroup.add(new MetaDataField(USER_DOMAIN, "user domain name", 3, protocol));
        MetaDataSet.add(metaDataGroup);
        metaDataGroup = new MetaDataGroup(GROUP_AUTHENTICATION, "");
        metaDataGroup.add(new MetaDataField("user name", "user name", 3, protocol));
        metaDataGroup.add(new MetaDataField(USER_DOMAIN, "user domain name", 3, protocol));
        metaDataGroup.add(new MetaDataField(USER_DISTINGUISHED_NAME, "distinguished name of user", 3, protocol));
        metaDataGroup.add(new MetaDataField(USER_AUTHENTICATION_SCHEME, "user authentication scheme (user distinguished name)", 3, protocol));
        MetaDataSet.add(metaDataGroup);
        metaDataGroup = new MetaDataGroup(GROUP_AUTHORIZATION, "");
        metaDataGroup.add(new MetaDataField("user name", "user name", 3, protocol));
        metaDataGroup.add(new MetaDataField(USER_DOMAIN, "user domain name", 3, protocol));
        metaDataGroup.add(new MetaDataField(TICKET_D, "identifier for ticket given for data", 3, protocol));
        metaDataGroup.add(new MetaDataField(TICKET_C, "identifier for ticket given for coll", 3, protocol));
        metaDataGroup.add(new MetaDataField("directory name", "collection name", 3, protocol));
        metaDataGroup.add(new MetaDataField("file name", "data name", 3, protocol));
        metaDataGroup.add(new MetaDataField(PHYSICAL_RESOURCE_NAME, PHYSICAL_RESOURCE_NAME, 3, protocol));
        metaDataGroup.add(new MetaDataField("access constraint", "access restriction on data", 3, protocol));
        metaDataGroup.add(new MetaDataField(DIRECTORY_ACCESS_CONSTRAINT, "access on directory (access directory name)", 3, protocol));
        metaDataGroup.add(new MetaDataField(ACCESS_DIRECTORY_NAME, "directory name for access in (directory access constraint)", 3, protocol));
        MetaDataSet.add(metaDataGroup);
        metaDataGroup = new MetaDataGroup(GROUP_AUDIT, "Audit information on users and on datasets.");
        metaDataGroup.add(new MetaDataField(AUDIT_USER, "audited user name", 3, protocol));
        metaDataGroup.add(new MetaDataField(AUDIT_USER_DOMAIN, "audited user domain", 3, protocol));
        metaDataGroup.add(new MetaDataField(AUDIT_ACTION_DESCRIPTION, AUDIT_ACTION_DESCRIPTION, 3, protocol));
        metaDataGroup.add(new MetaDataField(NEW_AUDIT_ACTION_DESCRIPTION, NEW_AUDIT_ACTION_DESCRIPTION, 3, protocol));
        metaDataGroup.add(new MetaDataField(NEW_AUDIT_TIMESTAMP, AUDIT_TIMESTAMP, 3, protocol));
        metaDataGroup.add(new MetaDataField(NEW_AUDIT_COMMENTS, AUDIT_COMMENTS, 3, protocol));
        MetaDataSet.add(metaDataGroup);
        metaDataGroup = new MetaDataGroup(GROUP_TICKET, "Information about ticket-based access control for datasets, collections as well as recursively under a collection.");
        metaDataGroup.add(new MetaDataField(TICKET_D, "identifier for ticket given for data", 3, protocol));
        metaDataGroup.add(new MetaDataField("directory name", "collection name", 3, protocol));
        metaDataGroup.add(new MetaDataField("file name", "data name", 3, protocol));
        metaDataGroup.add(new MetaDataField(TICKET_USER_D, "allowed ticket user or user group", 3, protocol));
        metaDataGroup.add(new MetaDataField(TICKET_USER_DOMAIN_D, "data ticket user domain", 3, protocol));
        metaDataGroup.add(new MetaDataField(TICKET_OWNER_D, "data ticket creator", 3, protocol));
        metaDataGroup.add(new MetaDataField(TICKET_OWNER_DOMAIN_D, "data ticket creator domain", 3, protocol));
        metaDataGroup.add(new MetaDataField(TICKET_BEGIN_TIME_D, "data ticket validity start time", 3, protocol));
        metaDataGroup.add(new MetaDataField(TICKET_END_TIME_D, "data ticket validity endtime", 3, protocol));
        metaDataGroup.add(new MetaDataField(TICKET_ACC_COUNT_D, "number of opens allowed on data ticket", 0, protocol));
        metaDataGroup.add(new MetaDataField(TICKET_ACC_LIST_D, "access allowed on data ticket", 3, protocol));
        metaDataGroup.add(new MetaDataField(TICKET_C, "identifier for ticket given for collection", 3, protocol));
        metaDataGroup.add(new MetaDataField(TICKET_DIRECTORY_NAME, "collection for ticket", 3, protocol));
        metaDataGroup.add(new MetaDataField(TICKET_RECURSIVE, "recursive flag for C_TICKET", 3, protocol));
        metaDataGroup.add(new MetaDataField(TICKET_USER_C, "allowed collection ticket user", 3, protocol));
        metaDataGroup.add(new MetaDataField(TICKET_USER_DOMAIN_C, "collection ticket user domain", 3, protocol));
        metaDataGroup.add(new MetaDataField(TICKET_OWNER_C, "collection ticket creator", 3, protocol));
        metaDataGroup.add(new MetaDataField(TICKET_OWNER_DOMAIN_C, "collection ticket creator domain", 3, protocol));
        metaDataGroup.add(new MetaDataField(TICKET_BEGIN_TIME_C, "collection ticket validity start time", 3, protocol));
        metaDataGroup.add(new MetaDataField(TICKET_END_TIME_C, "collection ticket validity end time", 3, protocol));
        metaDataGroup.add(new MetaDataField(TICKET_ACC_COUNT_C, "number of opens allowed on collection ticket", 0, protocol));
        metaDataGroup.add(new MetaDataField(TICKET_ACC_LIST_C, "access allowed on collection ticket", 3, protocol));
        metaDataGroup.add(new MetaDataField(TICKET_OWNER_ZONE_D, TICKET_OWNER_ZONE_D, 3, protocol));
        metaDataGroup.add(new MetaDataField(TICKET_USER_ZONE_D, TICKET_USER_ZONE_D, 3, protocol));
        metaDataGroup.add(new MetaDataField(TICKET_OWNER_ZONE_C, TICKET_OWNER_ZONE_C, 3, protocol));
        metaDataGroup.add(new MetaDataField(TICKET_USER_ZONE_C, TICKET_USER_ZONE_C, 3, protocol));
        MetaDataSet.add(metaDataGroup);
        metaDataGroup = new MetaDataGroup(GROUP_CONTAINER, "Core meta-information about containers");
        metaDataGroup.add(new MetaDataField(CONTAINER_NAME, "name of container is a dataname", 3, protocol));
        metaDataGroup.add(new MetaDataField(CONTAINER_REPLICATION_ENUM, "container copy number", 3, protocol));
        metaDataGroup.add(new MetaDataField(CONTAINER_MAX_SIZE, "maximum size of container", 0, protocol));
        metaDataGroup.add(new MetaDataField(CONTAINER_SIZE, "current size of container", 0, protocol));
        metaDataGroup.add(new MetaDataField(CONTAINER_LOG_RESOURCE_NAME, "logical resource associated with container", 3, protocol));
        metaDataGroup.add(new MetaDataField(CONTAINER_RESOURCE_NAME, CONTAINER_RESOURCE_NAME, 3, protocol));
        metaDataGroup.add(new MetaDataField(CONTAINER_RESOURCE_CLASS, "class of physical resource of container", 3, protocol));
        MetaDataSet.add(metaDataGroup);
        metaDataGroup = new MetaDataGroup(GROUP_ANNOTATIONS, "core meta-information on annotating datasets. see also access constraint attribute for access control");
        metaDataGroup.add(new MetaDataField("directory name", "collection name", 3, protocol));
        metaDataGroup.add(new MetaDataField("file name", "data name", 3, protocol));
        metaDataGroup.add(new MetaDataField(FILE_ANNOTATION_USERNAME, "name of annotator", 3, protocol));
        metaDataGroup.add(new MetaDataField(FILE_ANNOTATION_USERDOMAIN, "domain of annotator", 3, protocol));
        metaDataGroup.add(new MetaDataField(FILE_ANNOTATION, "annotation on data", 3, protocol));
        metaDataGroup.add(new MetaDataField(FILE_ANNOTATION_TIMESTAMP, "time of annotation", 3, protocol));
        metaDataGroup.add(new MetaDataField(FILE_ANNOTATION_POSITION, "location of the annotation", 3, protocol));
        metaDataGroup.add(new MetaDataField(DIRECTORY_ANNOTATION_USERNAME, "name of annotator", 3, protocol));
        metaDataGroup.add(new MetaDataField(DIRECTORY_ANNOTATION_USERDOMAIN, "domain of annotator", 3, protocol));
        metaDataGroup.add(new MetaDataField(DIRECTORY_ANNOTATION, "annotation on data", 3, protocol));
        metaDataGroup.add(new MetaDataField(DIRECTORY_ANNOTATION_TIMESTAMP, "time of annotation", 3, protocol));
        metaDataGroup.add(new MetaDataField(DIRECTORY_ANNOTATION_TYPE, "type for the annotation", 3, protocol));
        MetaDataSet.add(metaDataGroup);
        metaDataGroup = new MetaDataGroup(GROUP_COMPOUND_RESOURCE, "");
        metaDataGroup.add(new MetaDataField(COMPOUND_RESOURCE_NAME, COMPOUND_RESOURCE_NAME, 3, protocol));
        metaDataGroup.add(new MetaDataField(TAPE_NUMBER, "compound resource tape id", 0, protocol));
        metaDataGroup.add(new MetaDataField(TAPE_OWNER, "compound resource tape owner id", 3, protocol));
        metaDataGroup.add(new MetaDataField(TAPE_TYPE_VAL, "compound resource tape type", 3, protocol));
        metaDataGroup.add(new MetaDataField(TAPE_LIBINX, "compound resource libinx", 3, protocol));
        metaDataGroup.add(new MetaDataField(TAPE_FULLFLAG, "compound resource tape full flag", 3, protocol));
        metaDataGroup.add(new MetaDataField(TAPE_CURRENT_FILE_SEQNUM, "file index in tape", 0, protocol));
        metaDataGroup.add(new MetaDataField(TAPE_CURRENT_ABS_POSITION, "file position in tape", 0, protocol));
        metaDataGroup.add(new MetaDataField(TAPE_BYTES_WRITTEN, "tape used space", 0, protocol));
        metaDataGroup.add(new MetaDataField(INT_REPLICATION_ENUM, "replica number of file in compound resource", 3, protocol));
        metaDataGroup.add(new MetaDataField(INT_SEG_NUM, "segment number of file in compound resource", 3, protocol));
        metaDataGroup.add(new MetaDataField(INT_PATH_NAME, "path name of file in compound resource", 3, protocol));
        metaDataGroup.add(new MetaDataField(INT_IS_DIRTY, "dirty flag of file in compound resource", 0, protocol));
        metaDataGroup.add(new MetaDataField(INT_OFFSET, "offset of file in compound resource container", 0, protocol));
        metaDataGroup.add(new MetaDataField(INT_SIZE, "size of file in compound resource", 0, protocol));
        metaDataGroup.add(new MetaDataField(INT_PATH_NAME_FOR_REPL, "path of file in compound resource", 3, protocol));
        metaDataGroup.add(new MetaDataField(INT_RESOURCE_NAME, "resource name of file in compound resource", 3, protocol));
        metaDataGroup.add(new MetaDataField(INT_RESOURCE_ADDRESS_NETPREFIX, "net address of compound resource", 3, protocol));
        metaDataGroup.add(new MetaDataField(INT_RESOURCE_TYPE_NAME, "type of resource in compound resource", 3, protocol));
        metaDataGroup.add(new MetaDataField(INT_RESOURCE_CLASS, "class of resource in compound resource", 3, protocol));
        metaDataGroup.add(new MetaDataField(COMP_OBJ_USER_NAME, "user name of compound object", 3, protocol));
        metaDataGroup.add(new MetaDataField(COMP_OBJ_USER_DOMAIN, "user domn of compound object", 3, protocol));
        MetaDataSet.add(metaDataGroup);
        metaDataGroup = new MetaDataGroup(GROUP_DUBLIN_CORE, "This set of metadata, even though part of MCAT core, is normally turned off in order to speed up processing. patches ned to be applied if this option needs to be used. For more information please check http://www.dublincore.org/");
        metaDataGroup.add(new MetaDataField("Dublin Core: dataset", "DC: Data Name same as data name", 3, protocol));
        metaDataGroup.add(new MetaDataField("Dublin Core: collection", "DC: Collection Name same as collection name", 3, protocol));
        metaDataGroup.add(new MetaDataField("Dublin Core: contributor type", "DC: Contributor Type:eg.Author", 3, protocol));
        metaDataGroup.add(new MetaDataField("Dublin Core: subject class", "DC: Subject Classification", 3, protocol));
        metaDataGroup.add(new MetaDataField("Dublin Core: description type", "DC: Type of Description", 3, protocol));
        metaDataGroup.add(new MetaDataField("Dublin Core: type", "DC: Type of the Object", 3, protocol));
        metaDataGroup.add(new MetaDataField("Dublin Core: source type", "DC: Type of the Source", 3, protocol));
        metaDataGroup.add(new MetaDataField("Dublin Core: language", "DC: Language of the Object", 3, protocol));
        metaDataGroup.add(new MetaDataField("Dublin Core: relation type", "DC: Relation with another Object", 3, protocol));
        metaDataGroup.add(new MetaDataField("Dublin Core: coverage type", "DC: Coverage Type", 3, protocol));
        metaDataGroup.add(new MetaDataField("Dublin Core: rights type", "DC: Rights Type", 3, protocol));
        metaDataGroup.add(new MetaDataField("Dublin Core: title", "DC: Title of the Object", 3, protocol));
        metaDataGroup.add(new MetaDataField("Dublin Core: contributor name", "DC: Contributor Name", 3, protocol));
        metaDataGroup.add(new MetaDataField("Dublin Core: subject name", "DC: Subject", 3, protocol));
        metaDataGroup.add(new MetaDataField("Dublin Core: description", "DC: Description", 3, protocol));
        metaDataGroup.add(new MetaDataField("Dublin Core: publisher", "DC: Publisher Name", 3, protocol));
        metaDataGroup.add(new MetaDataField("Dublin Core: source", "DC: Source Name", 3, protocol));
        metaDataGroup.add(new MetaDataField("Dublin Core: related data descriptionr", "DC: Related Data Description", 3, protocol));
        metaDataGroup.add(new MetaDataField("Dublin Core: related data", "DC: Date Related to (Dublin Core: dataset,Dublin Core: collection)", 3, protocol));
        metaDataGroup.add(new MetaDataField("Dublin Core: related directory", "DC: Collection related to (Dublin Core: dataset,Dublin Core: collection)", 3, protocol));
        metaDataGroup.add(new MetaDataField("Dublin Core: coverage", "DC: Coverage Information", 3, protocol));
        metaDataGroup.add(new MetaDataField("Dublin Core: rights", "DC: Rights Information", 3, protocol));
        metaDataGroup.add(new MetaDataField("Dublin Core: publisher addr", "DC: Publisher Address", 3, protocol));
        metaDataGroup.add(new MetaDataField("Dublin Core: contributor addr", "DC: Contributor Address", 3, protocol));
        metaDataGroup.add(new MetaDataField("Dublin Core: contributor email", "DC: Contributor Email", 3, protocol));
        metaDataGroup.add(new MetaDataField("Dublin Core: contributor phone", "DC: Contributor Phone", 3, protocol));
        metaDataGroup.add(new MetaDataField("Dublin Core: contributor web", "DC: Contributor Web Address", 3, protocol));
        metaDataGroup.add(new MetaDataField("Dublin Core: contributor affiliation", "DC: Contributor Affiliation", 3, protocol));
        MetaDataSet.add(metaDataGroup);
        metaDataGroup = new MetaDataGroup(GROUP_ZONE, "Name of MCAT Zone");
        metaDataGroup.add(new MetaDataField(ZONE_NAME, "Name of MCAT Zone (String)", 3, protocol));
        metaDataGroup.add(new MetaDataField(ZONE_LOCALITY, "set to 1 for local zone, 0 otherwise", 3, protocol));
        metaDataGroup.add(new MetaDataField(ZONE_NETPREFIX, "address where (remote) MCAT is", 3, protocol));
        metaDataGroup.add(new MetaDataField(ZONE_PORT_NUM, "port num to reach (remote) MCAT", 3, protocol));
        metaDataGroup.add(new MetaDataField(ZONE_ADMIN_AUTH_SCHEME_NAME, "admin's auth scheme of rem MCAT", 3, protocol));
        metaDataGroup.add(new MetaDataField(ZONE_ADMIN_DISTIN_NAME, "DN str  of rem MCAT", 3, protocol));
        metaDataGroup.add(new MetaDataField(ZONE_STATUS, "1 for a valid zone", 3, protocol));
        metaDataGroup.add(new MetaDataField(ZONE_CREATE_DATE, "when the zone was created", 3, protocol));
        metaDataGroup.add(new MetaDataField(ZONE_MODIFY_DATE, "when the zone was modified", 3, protocol));
        metaDataGroup.add(new MetaDataField(ZONE_COMMENTS, "any comments about the zone", 3, protocol));
        metaDataGroup.add(new MetaDataField(ZONE_CONTACT, "who is in charge of the zone", 3, protocol));
        metaDataGroup.add(new MetaDataField(ZONE_ADMIN_NAME, ZONE_ADMIN_NAME, 3, protocol));
        metaDataGroup.add(new MetaDataField(ZONE_ADMIN_DOMAIN_NAME, ZONE_ADMIN_DOMAIN_NAME, 3, protocol));
        metaDataGroup.add(new MetaDataField(ZONE_LOCN_DESC, ZONE_LOCN_DESC, 3, protocol));
        metaDataGroup.add(new MetaDataField(CURRENT_ZONE, "current/working zone", 3, protocol));
        MetaDataSet.add(metaDataGroup);
        metaDataGroup = new MetaDataGroup(GROUP_UDMD, "The special catagory of metadata known as user definable metadata. By using the MetaDataTable, the user can define their own key-pair relationships. Creating in some sense their own new metadata attributes. These definable metadata can be attached to the various kinds of system objects, eg. files/datasets, directories/collections, user, resources.");
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_FILES, "definable metadata table for files", 14, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_DIRECTORIES, "definable metadata table for directories", 14, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_USERS, "definable metadata table for users", 14, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_RESOURCES, "definable metadata table for resources", 14, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_FILES0, "The first column of the definable metadata table for files. The standard usage keeps attribute names of the user defined metadata in this column. This field can be used in conjuction with the metadata number, which specifies a row in the table, to refer to a specific cell of the definable metadata table for files.", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_FILES1, "The  column of the definable metadata table for users.", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_FILES2, "The third column of the definable metadata table for users.", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_FILES3, "The fourth column of the definable metadata table for users.", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_FILES4, "The fifth column of the definable metadata table for users.", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_FILES5, "The sixth column of the definable metadata table for users.", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_FILES6, "The seventh column of the definable metadata table for users.", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_FILES7, "The eigth column of the definable metadata table for users.", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_FILES8, "The ninth column of the definable metadata table for users.", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_FILES9, "The tenth column of the definable metadata table for users.", 3, protocol));
        metaDataGroup.add(new MetaDataField(INTEGER_DEFINABLE_METADATA0, "The first column of the user-defined integer metadata", 0, protocol));
        metaDataGroup.add(new MetaDataField(INTEGER_DEFINABLE_METADATA1, "The second column of the user-defined integer metadata", 0, protocol));
        metaDataGroup.add(new MetaDataField(METADATA_NUM, "Used to specify a certain row in the definable metadata table for files.", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_FILES0_0, "Used for comparator queuries of the metadata, user attribute", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_FILES0_1, "Used for comparator queuries of the metadata, user attribute", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_FILES0_2, "Used for comparator queuries of the metadata, user attribute", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_FILES0_3, "Used for comparator queuries of the metadata, user attribute", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_FILES0_4, "Used for comparator queuries of the metadata, user attribute", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_FILES1_0, "Used for comparator queuries of the metadata, user value", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_FILES1_1, "Used for comparator queuries of the metadata, user value", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_FILES1_2, "Used for comparator queuries of the metadata, user value", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_FILES1_3, "Used for comparator queuries of the metadata, user value", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_FILES1_4, "Used for comparator queuries of the metadata, user value", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_DIRECTORIES0, "The first column of the definable metadata table for directories.", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_DIRECTORIES1, "The second column of the definable metadata table for directories.", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_DIRECTORIES2, "The third column of the definable metadata table for directories.", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_DIRECTORIES3, "The fourth column of the definable metadata table for directories.", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_DIRECTORIES4, "The fifth column of the definable metadata table for directories.", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_DIRECTORIES5, "The sixth column of the definable metadata table for directories.", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_DIRECTORIES6, "The seventh column of the definable metadata table for directories.", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_DIRECTORIES7, "The eigth column of the definable metadata table for directories.", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_DIRECTORIES8, "The ninth column of the definable metadata table for directories.", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_DIRECTORIES9, "The tenth column of the definable metadata table for directories.", 3, protocol));
        metaDataGroup.add(new MetaDataField(METADATA_NUM_DIRECTORY, "Used to specify a certain row in the definable metadata table for directories.", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_DIRECTORIES0_0, "Used for comparator queuries of the metadata, user attribute", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_DIRECTORIES0_1, "Used for comparator queuries of the metadata, user attribute", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_DIRECTORIES0_2, "Used for comparator queuries of the metadata, user attribute", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_DIRECTORIES0_3, "Used for comparator queuries of the metadata, user attribute", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_DIRECTORIES0_4, "Used for comparator queuries of the metadata, user attribute", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_DIRECTORIES1_0, "Used for comparator queuries of the metadata, user value", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_DIRECTORIES1_1, "Used for comparator queuries of the metadata, user value", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_DIRECTORIES1_2, "Used for comparator queuries of the metadata, user value", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_DIRECTORIES1_3, "Used for comparator queuries of the metadata, user value", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_DIRECTORIES1_4, "Used for comparator queuries of the metadata, user value", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_RESOURCES0, "The first column of the definable metadata table for resources.", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_RESOURCES1, "The second column of the definable metadata table for resources.", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_RESOURCES2, "The third column of the definable metadata table for resources.", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_RESOURCES3, "The fourth column of the definable metadata table for resources.", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_RESOURCES4, "The fifth column of the definable metadata table for resources.", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_RESOURCES5, "The sixth column of the definable metadata table for resources.", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_RESOURCES6, "The seventh column of the definable metadata table for resources.", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_RESOURCES7, "The eigth column of the definable metadata table for resources.", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_RESOURCES8, "The ninth column of the definable metadata table for resources.", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_RESOURCES9, "The tenth column of the definable metadata table for resources.", 3, protocol));
        metaDataGroup.add(new MetaDataField(METADATA_NUM_RESOURCE, "Used to specify a certain row in the definable metadata table for resources.", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_RESOURCES0_0, "Used for comparator queuries of the metadata, user attribute", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_RESOURCES0_1, "Used for comparator queuries of the metadata, user attribute", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_RESOURCES0_2, "Used for comparator queuries of the metadata, user attribute", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_RESOURCES0_3, "Used for comparator queuries of the metadata, user attribute", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_RESOURCES1_0, "Used for comparator queuries of the metadata, user value", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_RESOURCES1_1, "Used for comparator queuries of the metadata, user value", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_RESOURCES1_2, "Used for comparator queuries of the metadata, user value", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_RESOURCES1_3, "Used for comparator queuries of the metadata, user value", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_USERS0, "The first column of the definable metadata table for users.", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_USERS1, "The second column of the definable metadata table for users.", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_USERS2, "The third column of the definable metadata table for users.", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_USERS3, "The fourth column of the definable metadata table for users.", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_USERS4, "The fifth column of the definable metadata table for users.", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_USERS5, "The sixth column of the definable metadata table for users.", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_USERS6, "The seventh column of the definable metadata table for users.", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_USERS7, "The eigth column of the definable metadata table for users.", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_USERS8, "The ninth column of the definable metadata table for users.", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_USERS9, "The tenth column of the definable metadata table for users.", 3, protocol));
        metaDataGroup.add(new MetaDataField(METADATA_NUM_USER, "Used to specify a certain row in the definable metadata table for users.", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_USERS0_0, "Used for comparator queuries of the metadata, user attribute", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_USERS0_1, "Used for comparator queuries of the metadata, user attribute", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_USERS0_2, "Used for comparator queuries of the metadata, user attribute", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_USERS0_3, "Used for comparator queuries of the metadata, user attribute", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_USERS1_0, "Used for comparator queuries of the metadata, user value", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_USERS1_1, "Used for comparator queuries of the metadata, user value", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_USERS1_2, "Used for comparator queuries of the metadata, user value", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEFINABLE_METADATA_FOR_USERS1_3, "Used for comparator queuries of the metadata, user value", 3, protocol));
        MetaDataSet.add(metaDataGroup);
        metaDataGroup = new MetaDataGroup(GROUP_INDEX, "The user can index a dataset , datasets of given type or datasets in a collection. the index is treated as a SRB registered dataset. The user can download the index and search on it. The location can be collection-information (i.e., index is stored as several datasets inside a collection, or can be a URL!. Note that index is treated as a SRB registered dataset and hence inherits all meta information about datasets including structured metadata which can be used to store information about the index. see datacutter proxy for more information");
        metaDataGroup.add(new MetaDataField(INDEX_NAME_FOR_FILE, "data name of index on data", 3, protocol));
        metaDataGroup.add(new MetaDataField(IX_DIRECTORY_NAME_FOR_FILE, "collection name of index on data (FILE_TYPE_NAME)", 3, protocol));
        metaDataGroup.add(new MetaDataField(IX_DATATYPE_FOR_FILE, "index type for index name for file", 3, protocol));
        metaDataGroup.add(new MetaDataField(IX_LOCATION_FOR_FILE, "path name of index in index name for file", 3, protocol));
        metaDataGroup.add(new MetaDataField(INDEX_NAME_FOR_DATATYPE, "data name of index on data type", 3, protocol));
        metaDataGroup.add(new MetaDataField(IX_DIRECTORY_NAME_FOR_DATATYPE, "collection name of index on data type index name for datatype", 3, protocol));
        metaDataGroup.add(new MetaDataField(IX_DATATYPE_FOR_DATATYPE, "index type for index name for datatype", 3, protocol));
        metaDataGroup.add(new MetaDataField(IX_LOCATION_FOR_DATATYPE, "path name of index in index name for datatype", 3, protocol));
        metaDataGroup.add(new MetaDataField(INDEX_NAME_FOR_DIRECTORY, "data name of index on collection", 3, protocol));
        metaDataGroup.add(new MetaDataField(IX_DIRECTORY_NAME_FOR_DIRECTORY, "collection name of index on collection index name for directory", 3, protocol));
        metaDataGroup.add(new MetaDataField(IX_DATATYPE_FOR_DIRECTORY, "index type for index name for directory", 3, protocol));
        metaDataGroup.add(new MetaDataField(IX_LOCATION_FOR_DIRECTORY, "path name of index in index name for directory", 3, protocol));
        MetaDataSet.add(metaDataGroup);
        metaDataGroup = new MetaDataGroup(GROUP_STRUCTURED_METADATA, "The user can store structured (treated as a blob) metadata information.");
        metaDataGroup.add(new MetaDataField(STRUCTURED_METADATA_TYPE, "type of user-inserted structured metadata for data in (STRUCTURED_METADATA_FILE_NAME) or (INTERNAL_STRUCTURED_METADATA)", 3, protocol));
        metaDataGroup.add(new MetaDataField(STRUCTURED_METADATA_COMMENTS, "comments on the structured metadata in (STRUCTURED_METADATA_FILE_NAME) or (INTERNAL_STRUCTURED_METADATA)", 3, protocol));
        metaDataGroup.add(new MetaDataField(STRUCTURED_METADATA_FILE_NAME, "data name of user-inserted structured metadata stored as another data object inside SRB see also (STRUCTURED_METADATA_DIRECTORY_NAME)", 3, protocol));
        metaDataGroup.add(new MetaDataField(INTERNAL_STRUCTURED_METADATA, "user-inserted structured metadata stored as a string inside MCAT", 3, protocol));
        metaDataGroup.add(new MetaDataField(STRUCTURED_METADATA_DIRECTORY_NAME, "collection name of user-inserted structured metadata stored as another data object inside SRB see also (92)", 3, protocol));
        MetaDataSet.add(metaDataGroup);
        metaDataGroup = new MetaDataGroup(GROUP_METHOD, "users can associate methods on dataset , datasets of given type or datasets in a collection. the method is treated as a SRB registered dataset and hence inherits all meta information about datasets including structured metadata which can be used to store information about the arguments and method return values. see datacutter proxy for more information.");
        metaDataGroup.add(new MetaDataField(METHOD_NAME_FOR_FILE, "data name of method on data", 3, protocol));
        metaDataGroup.add(new MetaDataField(METHOD_NAME_FOR_DATATYPE, "data name of method on data type", 3, protocol));
        metaDataGroup.add(new MetaDataField(METHOD_NAME_FOR_DIRECTORY, "data name of method on collection", 3, protocol));
        metaDataGroup.add(new MetaDataField(METHOD_DIRECTORY_NAME_FOR_FILE, "collection name of method on data  (method name for file)", 3, protocol));
        metaDataGroup.add(new MetaDataField(METHOD_DIRECTORY_NAME_FOR_DATATYPE, "collection name of method on data type (method name for datatype)", 3, protocol));
        metaDataGroup.add(new MetaDataField(METHOD_DIRECTORY_NAME_FOR_DIRECTORY, "collection name of method on collection (method name for directory)", 3, protocol));
        metaDataGroup.add(new MetaDataField(METHOD_DATATYPE_FOR_FILE, "method type for (method name for file)", 3, protocol));
        metaDataGroup.add(new MetaDataField(METHOD_DATATYPE_FOR_DATATYPE, "method type for (method name for datatype)", 3, protocol));
        metaDataGroup.add(new MetaDataField(METHOD_DATATYPE_FOR_DIRECTORY, "method type for (method name for directory)", 3, protocol));
        MetaDataSet.add(metaDataGroup);
        metaDataGroup = new MetaDataGroup(GROUP_GUID, "Metadata attributes relating to GUIDs.");
        metaDataGroup.add(new MetaDataField(GUID, GUID, 3, protocol));
        metaDataGroup.add(new MetaDataField(GUID_FLAG, GUID_FLAG, 3, protocol));
        metaDataGroup.add(new MetaDataField(GUID_TIME_STAMP, GUID_TIME_STAMP, 3, protocol));
        MetaDataSet.add(metaDataGroup);
        metaDataGroup = new MetaDataGroup(GROUP_UNDEFINED, "Metadata attributes that have not yet been added to a group.");
        metaDataGroup.add(new MetaDataField(UDIMD_USER1, UDIMD_USER1, 3, protocol));
        metaDataGroup.add(new MetaDataField(USER_UDEF_MDATA_MODIFY_DATE, USER_UDEF_MDATA_MODIFY_DATE, 3, protocol));
        metaDataGroup.add(new MetaDataField("change MAX_RSRC_INTEGER_METADATA", "change MAX_RSRC_INTEGER_METADATA", 3, protocol));
        metaDataGroup.add(new MetaDataField("user-def metadata for resource mod", "user-def metadata for resource mod", 3, protocol));
        metaDataGroup.add(new MetaDataField(USER_GROUP_MODIFY_DATE, USER_GROUP_MODIFY_DATE, 3, protocol));
        metaDataGroup.add(new MetaDataField(USER_GROUP_ZONE_NAME, USER_GROUP_ZONE_NAME, 3, protocol));
        metaDataGroup.add(new MetaDataField(USER_GROUP_DOMAIN_DESC, USER_GROUP_DOMAIN_DESC, 3, protocol));
        metaDataGroup.add(new MetaDataField(DATA_UDEF_MDATA_MODIFY_DATE, DATA_UDEF_MDATA_MODIFY_DATE, 3, protocol));
        metaDataGroup.add(new MetaDataField(COLL_UDEF_MDATA_MODIFY_DATE, COLL_UDEF_MDATA_MODIFY_DATE, 3, protocol));
        metaDataGroup.add(new MetaDataField(DATA_TYPE_MIME_STRING, DATA_TYPE_MIME_STRING, 3, protocol));
        metaDataGroup.add(new MetaDataField(DATA_TYPE_EXTENDERS, DATA_TYPE_EXTENDERS, 3, protocol));
        metaDataGroup.add(new MetaDataField(USER_CREATE_DATE, USER_CREATE_DATE, 3, protocol));
        metaDataGroup.add(new MetaDataField(USER_MODIFY_DATE, USER_MODIFY_DATE, 3, protocol));
        metaDataGroup.add(new MetaDataField(DATA_OWNER_ZONE, DATA_OWNER_ZONE, 3, protocol));
        metaDataGroup.add(new MetaDataField(DATA_ANNOTATION_USER_ZONE, DATA_ANNOTATION_USER_ZONE, 3, protocol));
        metaDataGroup.add(new MetaDataField(AUDIT_USER_ZONE, AUDIT_USER_ZONE, 3, protocol));
        metaDataGroup.add(new MetaDataField(COLL_OWNER_ZONE, COLL_OWNER_ZONE, 3, protocol));
        metaDataGroup.add(new MetaDataField(DATA_LOCK_OWNER_ZONE, DATA_LOCK_OWNER_ZONE, 3, protocol));
        metaDataGroup.add(new MetaDataField(COLL_ANNOTATION_USER_ZONE, COLL_ANNOTATION_USER_ZONE, 3, protocol));
        metaDataGroup.add(new MetaDataField(DATA_PIN_OWNER_ZONE, "zone for data pin owner", 3, protocol));
        metaDataGroup.add(new MetaDataField(COMP_OBJ_USER_ZONE, COMP_OBJ_USER_ZONE, 3, protocol));
        metaDataGroup.add(new MetaDataField(PARENT_SERVER_LOCATION, PARENT_SERVER_LOCATION, 3, protocol));
        metaDataGroup.add(new MetaDataField(PARENT_DOMAIN_DESC, PARENT_DOMAIN_DESC, 3, protocol));
        metaDataGroup.add(new MetaDataField(PARENT_USER_TYPE, PARENT_USER_TYPE, 3, protocol));
        metaDataGroup.add(new MetaDataField(PARENT_RSRC_TYPE, "parent of a resource type", 3, protocol));
        metaDataGroup.add(new MetaDataField(PARENT_DATA_TYPE, PARENT_DATA_TYPE, 3, protocol));
        metaDataGroup.add(new MetaDataField(ZONE_LOCN_DESC, ZONE_LOCN_DESC, 3, protocol));
        metaDataGroup.add(new MetaDataField(COLL_MODIFY_TIMESTAMP, COLL_MODIFY_TIMESTAMP, 3, protocol));
        metaDataGroup.add(new MetaDataField(DATA_ACCS_GRPUSER_NAME, DATA_ACCS_GRPUSER_NAME, 3, protocol));
        metaDataGroup.add(new MetaDataField(DATA_ACCS_GRPUSER_DOMAIN, DATA_ACCS_GRPUSER_DOMAIN, 3, protocol));
        metaDataGroup.add(new MetaDataField(DATA_ACCS_GRPUSER_ZONE, DATA_ACCS_GRPUSER_ZONE, 3, protocol));
        metaDataGroup.add(new MetaDataField(COLL_ACCS_GRPUSER_NAME, COLL_ACCS_GRPUSER_NAME, 3, protocol));
        metaDataGroup.add(new MetaDataField(COLL_ACCS_GRPUSER_DOMAIN, COLL_ACCS_GRPUSER_DOMAIN, 3, protocol));
        metaDataGroup.add(new MetaDataField(COLL_ACCS_GRPUSER_ZONE, COLL_ACCS_GRPUSER_ZONE, 3, protocol));
        metaDataGroup.add(new MetaDataField(COLL_ACCS_COLLECTION_NAME, COLL_ACCS_COLLECTION_NAME, 3, protocol));
        metaDataGroup.add(new MetaDataField(COLL_ACCS_ACCESS_CONSTRAINT, COLL_ACCS_ACCESS_CONSTRAINT, 3, protocol));
        metaDataGroup.add(new MetaDataField(DATA_TYPE_FOR_CONTAINER_FOR_COLLECTION, DATA_TYPE_FOR_CONTAINER_FOR_COLLECTION, 3, protocol));
        metaDataGroup.add(new MetaDataField(DATA_UDEF_MDATA_CREATE_DATE, DATA_UDEF_MDATA_CREATE_DATE, 3, protocol));
        metaDataGroup.add(new MetaDataField(COLL_UDEF_MDATA_CREATE_DATE, COLL_UDEF_MDATA_CREATE_DATE, 3, protocol));
        metaDataGroup.add(new MetaDataField(RSRC_UDEF_MDATA_CREATE_DATE, RSRC_UDEF_MDATA_CREATE_DATE, 3, protocol));
        metaDataGroup.add(new MetaDataField(USER_UDEF_MDATA_CREATE_DATE, USER_UDEF_MDATA_CREATE_DATE, 3, protocol));
        metaDataGroup.add(new MetaDataField(CONTAINER_ID, CONTAINER_ID, 3, protocol));
        metaDataGroup.add(new MetaDataField(ORDERBY, "return the query values sorted according to another attribute. Used in the condition as a comma seperated list: ORDER_BY = FILE_TYPE_NAME, FILE_NAME", 3, protocol));
        metaDataGroup.add(new MetaDataField(DELETE_FILE_ID, "data_id of deleted data object", 0, protocol));
        metaDataGroup.add(new MetaDataField(DELETE_FILE_REPLICATION_ENUM, "repl_enum of deleted data object", 0, protocol));
        metaDataGroup.add(new MetaDataField(DELETE_FILE_NAME, "data_name of deleted data object", 3, protocol));
        metaDataGroup.add(new MetaDataField(DELETE_MODIFICATION_DATE, "timestamp of deleted data object", 3, protocol));
        metaDataGroup.add(new MetaDataField(DELETE_DIRECTORY_NAME, "collection_name of deleted data object", 3, protocol));
        metaDataGroup.add(new MetaDataField(DEL_COLLECTION_ID, DEL_COLLECTION_ID, 3, protocol));
        metaDataGroup.add(new MetaDataField(DEL_DATA_COMMENT, DEL_DATA_COMMENT, 3, protocol));
        metaDataGroup.add(new MetaDataField(FREE_SPACE, FREE_SPACE, 3, protocol));
        metaDataGroup.add(new MetaDataField(FS_TIMESTAMP, FS_TIMESTAMP, 3, protocol));
        metaDataGroup.add(new MetaDataField(RESOURCE_STATUS, RESOURCE_STATUS, 3, protocol));
        MetaDataSet.add(metaDataGroup);
        metaDataGroup = new MetaDataGroup(GROUP_EXTENSIBLE, "Extensible metadata");
        metaDataGroup.add(new MetaDataField(EXTENSIBLE_SCHEMA_NAME, EXTENSIBLE_SCHEMA_NAME, 3, protocol));
        metaDataGroup.add(new MetaDataField(EXTENSIBLE_TABLE_NAME, EXTENSIBLE_TABLE_NAME, 3, protocol));
        metaDataGroup.add(new MetaDataField(EXTENSIBLE_ATTR_NAME, EXTENSIBLE_ATTR_NAME, 3, protocol));
        metaDataGroup.add(new MetaDataField(EXTENSIBLE_ATTR_OUTSIDE_NAME, EXTENSIBLE_ATTR_OUTSIDE_NAME, 3, protocol));
        metaDataGroup.add(new MetaDataField(EXTENSIBLE_ATTR_COMMENTS, EXTENSIBLE_ATTR_COMMENTS, 3, protocol));
        MetaDataSet.add(metaDataGroup);
        srbToJargon.put("DC_AUTHCONTRIB\u0000dc_contr_address\u0000", catalogNames[175]);
        srbToJargon.put("DC_AUTHCONTRIB\u0000dc_contr_corp_name\u0000", catalogNames[179]);
        srbToJargon.put("DC_AUTHCONTRIB\u0000dc_contr_email\u0000", catalogNames[176]);
        srbToJargon.put("DC_AUTHCONTRIB\u0000dc_contr_name\u0000", catalogNames[164]);
        srbToJargon.put("DC_AUTHCONTRIB\u0000dc_contr_phone\u0000", catalogNames[177]);
        srbToJargon.put("DC_AUTHCONTRIB\u0000dc_contr_web\u0000", catalogNames[178]);
        srbToJargon.put("DC_COLLECTION\u0000data_grp_name\u0000", catalogNames[153]);
        srbToJargon.put("DC_COVERAGE\u0000coverage_desc\u0000", catalogNames[172]);
        srbToJargon.put("DC_DATA\u0000data_name\u0000", catalogNames[152]);
        srbToJargon.put("DC_DESCRIPTION\u0000dc_desc\u0000", catalogNames[166]);
        srbToJargon.put("DC_PUBLISHER\u0000dc_pub_addr\u0000", catalogNames[174]);
        srbToJargon.put("DC_PUBLISHER\u0000dc_pub_name\u0000", catalogNames[167]);
        srbToJargon.put("DC_RELATION\u0000related_data_desc\u0000", catalogNames[169]);
        srbToJargon.put("DC_RIGHTS\u0000rights_data_desc\u0000", catalogNames[173]);
        srbToJargon.put("DC_SOURCE\u0000source_desc\u0000", catalogNames[168]);
        srbToJargon.put("DC_SUBJECT\u0000dc_subject_name\u0000", catalogNames[165]);
        srbToJargon.put("DC_TD_CONTR_TYPE\u0000dc_contr_type_name\u0000", catalogNames[154]);
        srbToJargon.put("DC_TD_COVERAGE\u0000coverage_type_name\u0000", catalogNames[161]);
        srbToJargon.put("DC_TD_DESCR_TYPE\u0000dc_desc_type_name\u0000", catalogNames[156]);
        srbToJargon.put("DC_TD_LANGUAGE\u0000language_name\u0000", catalogNames[159]);
        srbToJargon.put("DC_TD_RELATION_TYP\u0000relation_type_name\u0000", catalogNames[160]);
        srbToJargon.put("DC_TD_RIGHTS\u0000rights_type_name\u0000", catalogNames[162]);
        srbToJargon.put("DC_TD_SOURCE_TYPE\u0000source_type_name\u0000", catalogNames[158]);
        srbToJargon.put("DC_TD_SUBJ_CLASS\u0000dc_subj_class_name\u0000", catalogNames[155]);
        srbToJargon.put("DC_TD_TYPE\u0000dc_type_name\u0000", catalogNames[157]);
        srbToJargon.put("DC_TITLE\u0000dc_title\u0000", catalogNames[163]);
        srbToJargon.put("MDAS_AC_ANNOTATION\u0000anno_date\u0000", catalogNames[233]);
        srbToJargon.put("MDAS_AC_ANNOTATION\u0000anno_type\u0000", catalogNames[234]);
        srbToJargon.put("MDAS_AC_ANNOTATION\u0000annotations\u0000", catalogNames[232]);
        srbToJargon.put("MDAS_ADCONT_REPL\u0000data_size\u0000", catalogNames[64]);
        srbToJargon.put("MDAS_ADC_REPL\u0000data_name\u0000", catalogNames[281]);
        srbToJargon.put("MDAS_ADC_REPL\u0000path_name\u0000", catalogNames[10]);
        srbToJargon.put("MDAS_ADC_REPL\u0000repl_enum\u0000", catalogNames[1]);
        srbToJargon.put("MDAS_ADC_REPL\u0000seg_num\u0000", catalogNames[265]);
        srbToJargon.put("MDAS_ADIXCOLL_REPL\u0000data_name\u0000", catalogNames[96]);
        srbToJargon.put("MDAS_ADIXCOLL_REPL\u0000path_name\u0000", catalogNames[115]);
        srbToJargon.put("MDAS_ADIXDS_REPL\u0000data_name\u0000", catalogNames[94]);
        srbToJargon.put("MDAS_ADIXDS_REPL\u0000path_name\u0000", catalogNames[113]);
        srbToJargon.put("MDAS_ADIXDTP_REPL\u0000data_name\u0000", catalogNames[95]);
        srbToJargon.put("MDAS_ADIXDTP_REPL\u0000path_name\u0000", catalogNames[114]);
        srbToJargon.put("MDAS_ADMTHCOL_REPL\u0000data_name\u0000", catalogNames[99]);
        srbToJargon.put("MDAS_ADMTHDS_REPL\u0000data_name\u0000", catalogNames[97]);
        srbToJargon.put("MDAS_ADMTHDTP_REPL\u0000data_name\u0000", catalogNames[98]);
        srbToJargon.put("MDAS_ADSTRUCT_REPL\u0000data_name\u0000", catalogNames[92]);
        srbToJargon.put("MDAS_AD_1COLLMDATA\u0000userdef_metastr0\u0000", catalogNames[192]);
        srbToJargon.put("MDAS_AD_1COLLMDATA\u0000userdef_metastr1\u0000", catalogNames[196]);
        srbToJargon.put("MDAS_AD_1COMPOUND\u0000cmpd_path_name\u0000", catalogNames[278]);
        srbToJargon.put("MDAS_AD_1MDATA\u0000userdef_metastr0\u0000", catalogNames[184]);
        srbToJargon.put("MDAS_AD_1MDATA\u0000userdef_metastr1\u0000", catalogNames[188]);
        srbToJargon.put("MDAS_AD_2COLLMDATA\u0000userdef_metastr0\u0000", catalogNames[193]);
        srbToJargon.put("MDAS_AD_2COLLMDATA\u0000userdef_metastr1\u0000", catalogNames[197]);
        srbToJargon.put("MDAS_AD_2MDATA\u0000userdef_metastr0\u0000", catalogNames[185]);
        srbToJargon.put("MDAS_AD_2MDATA\u0000userdef_metastr1\u0000", catalogNames[189]);
        srbToJargon.put("MDAS_AD_3COLLMDATA\u0000userdef_metastr0\u0000", catalogNames[194]);
        srbToJargon.put("MDAS_AD_3COLLMDATA\u0000userdef_metastr1\u0000", catalogNames[198]);
        srbToJargon.put("MDAS_AD_3MDATA\u0000userdef_metastr0\u0000", catalogNames[186]);
        srbToJargon.put("MDAS_AD_3MDATA\u0000userdef_metastr1\u0000", catalogNames[190]);
        srbToJargon.put("MDAS_AD_4COLLMDATA\u0000userdef_metastr0\u0000", catalogNames[195]);
        srbToJargon.put("MDAS_AD_4COLLMDATA\u0000userdef_metastr1\u0000", catalogNames[199]);
        srbToJargon.put("MDAS_AD_4MDATA\u0000userdef_metastr0\u0000", catalogNames[187]);
        srbToJargon.put("MDAS_AD_4MDATA\u0000userdef_metastr1\u0000", catalogNames[191]);
        srbToJargon.put("MDAS_AD_ACCS\u0000access_id\u0000", catalogNames[182]);
        srbToJargon.put("MDAS_AD_ANNOTATION\u0000anno_date\u0000", catalogNames[75]);
        srbToJargon.put("MDAS_AD_ANNOTATION\u0000anno_position\u0000", catalogNames[78]);
        srbToJargon.put("MDAS_AD_ANNOTATION\u0000annotations\u0000", catalogNames[74]);
        srbToJargon.put("MDAS_AD_AUDIT\u0000comments\u0000", catalogNames[24]);
        srbToJargon.put("MDAS_AD_AUDIT\u0000time_stamp\u0000", catalogNames[23]);
        srbToJargon.put("MDAS_AD_CLASS\u0000class_name\u0000", catalogNames[88]);
        srbToJargon.put("MDAS_AD_CLASS\u0000class_type\u0000", catalogNames[89]);
        srbToJargon.put("MDAS_AD_COLLMDATA\u0000metadatanum\u0000", catalogNames[133]);
        srbToJargon.put("MDAS_AD_COLLMDATA\u0000userdef_creat_date\u0000", catalogNames[378]);
        srbToJargon.put("MDAS_AD_COLLMDATA\u0000userdef_metaint0\u0000", catalogNames[144]);
        srbToJargon.put("MDAS_AD_COLLMDATA\u0000userdef_metaint1\u0000", catalogNames[145]);
        srbToJargon.put("MDAS_AD_COLLMDATA\u0000userdef_metastr0\u0000", catalogNames[134]);
        srbToJargon.put("MDAS_AD_COLLMDATA\u0000userdef_metastr1\u0000", catalogNames[135]);
        srbToJargon.put("MDAS_AD_COLLMDATA\u0000userdef_metastr2\u0000", catalogNames[136]);
        srbToJargon.put("MDAS_AD_COLLMDATA\u0000userdef_metastr3\u0000", catalogNames[137]);
        srbToJargon.put("MDAS_AD_COLLMDATA\u0000userdef_metastr4\u0000", catalogNames[138]);
        srbToJargon.put("MDAS_AD_COLLMDATA\u0000userdef_metastr5\u0000", catalogNames[139]);
        srbToJargon.put("MDAS_AD_COLLMDATA\u0000userdef_metastr6\u0000", catalogNames[140]);
        srbToJargon.put("MDAS_AD_COLLMDATA\u0000userdef_metastr7\u0000", catalogNames[141]);
        srbToJargon.put("MDAS_AD_COLLMDATA\u0000userdef_metastr8\u0000", catalogNames[142]);
        srbToJargon.put("MDAS_AD_COLLMDATA\u0000userdef_metastr9\u0000", catalogNames[143]);
        srbToJargon.put("MDAS_AD_COLLMDATA\u0000userdef_modif_date\u0000", catalogNames[321]);
        srbToJargon.put("MDAS_AD_COMMENTS\u0000com_date\u0000", catalogNames[77]);
        srbToJargon.put("MDAS_AD_COMPOUND\u0000cmpd_path_name\u0000", catalogNames[268]);
        srbToJargon.put("MDAS_AD_COMPOUND\u0000data_size\u0000", catalogNames[275]);
        srbToJargon.put("MDAS_AD_COMPOUND\u0000int_repl_num\u0000", catalogNames[266]);
        srbToJargon.put("MDAS_AD_COMPOUND\u0000int_seg_num\u0000", catalogNames[267]);
        srbToJargon.put("MDAS_AD_COMPOUND\u0000is_dirty\u0000", catalogNames[272]);
        srbToJargon.put("MDAS_AD_COMPOUND\u0000offset\u0000", catalogNames[274]);
        srbToJargon.put("MDAS_AD_DCRELREPL\u0000data_name\u0000", catalogNames[170]);
        srbToJargon.put("MDAS_AD_DEL_REPL\u0000d_comment\u0000", catalogNames[392]);
        srbToJargon.put("MDAS_AD_DEL_REPL\u0000data_grp_id\u0000", catalogNames[391]);
        srbToJargon.put("MDAS_AD_DEL_REPL\u0000data_id\u0000", catalogNames[386]);
        srbToJargon.put("MDAS_AD_DEL_REPL\u0000data_name\u0000", catalogNames[388]);
        srbToJargon.put("MDAS_AD_DEL_REPL\u0000repl_enum\u0000", catalogNames[387]);
        srbToJargon.put("MDAS_AD_DEL_REPL\u0000repl_timestamp\u0000", catalogNames[389]);
        srbToJargon.put("MDAS_AD_GRP_2ACCS\u0000access_id\u0000", catalogNames[180]);
        srbToJargon.put("MDAS_AD_GUID\u0000guid\u0000", catalogNames[382]);
        srbToJargon.put("MDAS_AD_GUID\u0000guid_flag\u0000", catalogNames[383]);
        srbToJargon.put("MDAS_AD_GUID\u0000guid_time_stamp\u0000", catalogNames[384]);
        srbToJargon.put("MDAS_AD_MDATA\u0000metadatanum\u0000", catalogNames[116]);
        srbToJargon.put("MDAS_AD_MDATA\u0000userdef_creat_date\u0000", catalogNames[377]);
        srbToJargon.put("MDAS_AD_MDATA\u0000userdef_metaint0\u0000", catalogNames[127]);
        srbToJargon.put("MDAS_AD_MDATA\u0000userdef_metaint1\u0000", catalogNames[128]);
        srbToJargon.put("MDAS_AD_MDATA\u0000userdef_metastr0\u0000", catalogNames[117]);
        srbToJargon.put("MDAS_AD_MDATA\u0000userdef_metastr1\u0000", catalogNames[118]);
        srbToJargon.put("MDAS_AD_MDATA\u0000userdef_metastr2\u0000", catalogNames[119]);
        srbToJargon.put("MDAS_AD_MDATA\u0000userdef_metastr3\u0000", catalogNames[120]);
        srbToJargon.put("MDAS_AD_MDATA\u0000userdef_metastr4\u0000", catalogNames[121]);
        srbToJargon.put("MDAS_AD_MDATA\u0000userdef_metastr5\u0000", catalogNames[122]);
        srbToJargon.put("MDAS_AD_MDATA\u0000userdef_metastr6\u0000", catalogNames[123]);
        srbToJargon.put("MDAS_AD_MDATA\u0000userdef_metastr7\u0000", catalogNames[124]);
        srbToJargon.put("MDAS_AD_MDATA\u0000userdef_metastr8\u0000", catalogNames[125]);
        srbToJargon.put("MDAS_AD_MDATA\u0000userdef_metastr9\u0000", catalogNames[126]);
        srbToJargon.put("MDAS_AD_MDATA\u0000userdef_modif_date\u0000", catalogNames[320]);
        srbToJargon.put("MDAS_AD_MISC1\u0000dcompressed\u0000", catalogNames[245]);
        srbToJargon.put("MDAS_AD_MISC1\u0000dencrypted\u0000", catalogNames[246]);
        srbToJargon.put("MDAS_AD_MISC1\u0000dexpire_date\u0000", catalogNames[244]);
        srbToJargon.put("MDAS_AD_MISC1\u0000dexpire_date_2\u0000", catalogNames[247]);
        srbToJargon.put("MDAS_AD_MISC1\u0000dpin\u0000", catalogNames[240]);
        srbToJargon.put("MDAS_AD_MISC1\u0000dpinexpiry\u0000", catalogNames[243]);
        srbToJargon.put("MDAS_AD_REPL\u0000auditflag\u0000", catalogNames[238]);
        srbToJargon.put("MDAS_AD_REPL\u0000container_id\u0000", catalogNames[381]);
        srbToJargon.put("MDAS_AD_REPL\u0000d_comment\u0000", catalogNames[21]);
        srbToJargon.put("MDAS_AD_REPL\u0000data_id\u0000", catalogNames[0]);
        srbToJargon.put("MDAS_AD_REPL\u0000data_name\u0000", catalogNames[2]);
        srbToJargon.put("MDAS_AD_REPL\u0000data_size\u0000", catalogNames[18]);
        srbToJargon.put("MDAS_AD_REPL\u0000datalock\u0000", catalogNames[222]);
        srbToJargon.put("MDAS_AD_REPL\u0000dchecksum\u0000", catalogNames[237]);
        srbToJargon.put("MDAS_AD_REPL\u0000dhide\u0000", catalogNames[236]);
        srbToJargon.put("MDAS_AD_REPL\u0000dlockexpiry\u0000", catalogNames[239]);
        srbToJargon.put("MDAS_AD_REPL\u0000is_deleted\u0000", catalogNames[34]);
        srbToJargon.put("MDAS_AD_REPL\u0000is_dirty\u0000", catalogNames[56]);
        srbToJargon.put("MDAS_AD_REPL\u0000last_accs_time\u0000", catalogNames[148]);
        srbToJargon.put("MDAS_AD_REPL\u0000modify_timestamp\u0000", catalogNames[14]);
        srbToJargon.put("MDAS_AD_REPL\u0000offset\u0000", catalogNames[61]);
        srbToJargon.put("MDAS_AD_REPL\u0000repl_enum\u0000", catalogNames[71]);
        srbToJargon.put("MDAS_AD_REPL\u0000repl_timestamp\u0000", catalogNames[76]);
        srbToJargon.put("MDAS_AD_REPL\u0000version_num\u0000", catalogNames[221]);
        srbToJargon.put("MDAS_AD_STRCT_BLOB\u0000internal_structure\u0000", catalogNames[93]);
        srbToJargon.put("MDAS_AD_STRCT_BLOB\u0000structure_comments\u0000", catalogNames[91]);
        srbToJargon.put("MDAS_AD_STRCT_BLOB\u0000structure_type\u0000", catalogNames[90]);
        srbToJargon.put("MDAS_AR_1MDATA\u0000userdef_metastr0\u0000", catalogNames[201]);
        srbToJargon.put("MDAS_AR_1MDATA\u0000userdef_metastr1\u0000", catalogNames[204]);
        srbToJargon.put("MDAS_AR_1PHYSICAL\u0000phy_rsrc_name\u0000", catalogNames[62]);
        srbToJargon.put("MDAS_AR_1REPL\u0000rsrc_name\u0000", catalogNames[65]);
        srbToJargon.put("MDAS_AR_2MDATA\u0000userdef_metastr0\u0000", catalogNames[202]);
        srbToJargon.put("MDAS_AR_2MDATA\u0000userdef_metastr1\u0000", catalogNames[205]);
        srbToJargon.put("MDAS_AR_2PHYSICAL\u0000phy_rsrc_name\u0000", catalogNames[264]);
        srbToJargon.put("MDAS_AR_3MDATA\u0000userdef_metastr0\u0000", catalogNames[203]);
        srbToJargon.put("MDAS_AR_3MDATA\u0000userdef_metastr1\u0000", catalogNames[206]);
        srbToJargon.put("MDAS_AR_3PHYSICAL\u0000phy_rsrc_name\u0000", catalogNames[269]);
        srbToJargon.put("MDAS_AR_INFO\u0000concurrency_max\u0000", catalogNames[337]);
        srbToJargon.put("MDAS_AR_INFO\u0000concurrency_max\u0000", catalogNames[83]);
        srbToJargon.put("MDAS_AR_INFO\u0000description\u0000", catalogNames[87]);
        srbToJargon.put("MDAS_AR_INFO\u0000mbps_bandwidth\u0000", catalogNames[336]);
        srbToJargon.put("MDAS_AR_INFO\u0000mbps_bandwidth\u0000", catalogNames[82]);
        srbToJargon.put("MDAS_AR_INFO\u0000megab_capacity\u0000", catalogNames[340]);
        srbToJargon.put("MDAS_AR_INFO\u0000megab_capacity\u0000", catalogNames[86]);
        srbToJargon.put("MDAS_AR_INFO\u0000mlsec_latency_max\u0000", catalogNames[334]);
        srbToJargon.put("MDAS_AR_INFO\u0000mlsec_latency_max\u0000", catalogNames[80]);
        srbToJargon.put("MDAS_AR_INFO\u0000mlsec_latency_min\u0000", catalogNames[335]);
        srbToJargon.put("MDAS_AR_INFO\u0000mlsec_latency_min\u0000", catalogNames[81]);
        srbToJargon.put("MDAS_AR_INFO\u0000num_of_hierarchies\u0000", catalogNames[338]);
        srbToJargon.put("MDAS_AR_INFO\u0000num_of_hierarchies\u0000", catalogNames[84]);
        srbToJargon.put("MDAS_AR_INFO\u0000num_of_stripes\u0000", catalogNames[339]);
        srbToJargon.put("MDAS_AR_INFO\u0000num_of_stripes\u0000", catalogNames[85]);
        srbToJargon.put("MDAS_AR_MDATA\u0000metadatanum\u0000", catalogNames[262]);
        srbToJargon.put("MDAS_AR_MDATA\u0000userdef_creat_date\u0000", catalogNames[379]);
        srbToJargon.put("MDAS_AR_MDATA\u0000userdef_metaint1\u0000", catalogNames[261]);
        srbToJargon.put("MDAS_AR_MDATA\u0000userdef_metaint1\u0000", catalogNames[316]);
        srbToJargon.put("MDAS_AR_MDATA\u0000userdef_metastr0\u0000", catalogNames[251]);
        srbToJargon.put("MDAS_AR_MDATA\u0000userdef_metastr1\u0000", catalogNames[252]);
        srbToJargon.put("MDAS_AR_MDATA\u0000userdef_metastr2\u0000", catalogNames[253]);
        srbToJargon.put("MDAS_AR_MDATA\u0000userdef_metastr3\u0000", catalogNames[254]);
        srbToJargon.put("MDAS_AR_MDATA\u0000userdef_metastr4\u0000", catalogNames[255]);
        srbToJargon.put("MDAS_AR_MDATA\u0000userdef_metastr5\u0000", catalogNames[256]);
        srbToJargon.put("MDAS_AR_MDATA\u0000userdef_metastr6\u0000", catalogNames[257]);
        srbToJargon.put("MDAS_AR_MDATA\u0000userdef_metastr7\u0000", catalogNames[258]);
        srbToJargon.put("MDAS_AR_MDATA\u0000userdef_metastr8\u0000", catalogNames[259]);
        srbToJargon.put("MDAS_AR_MDATA\u0000userdef_metastr9\u0000", catalogNames[260]);
        srbToJargon.put("MDAS_AR_MDATA\u0000userdef_modif_date\u0000", catalogNames[323]);
        srbToJargon.put("MDAS_AR_PHYSICAL\u0000free_space\u0000", catalogNames[393]);
        srbToJargon.put("MDAS_AR_PHYSICAL\u0000fs_timestamp\u0000", catalogNames[394]);
        srbToJargon.put("MDAS_AR_PHYSICAL\u0000max_obj_size\u0000", catalogNames[60]);
        srbToJargon.put("MDAS_AR_PHYSICAL\u0000phy_default_path\u0000", catalogNames[28]);
        srbToJargon.put("MDAS_AR_PHYSICAL\u0000phy_rsrc_name\u0000", catalogNames[29]);
        srbToJargon.put("MDAS_AR_PHYSICAL\u0000rsrc_lock\u0000", catalogNames[400]);
        srbToJargon.put("MDAS_AR_REPL\u0000default_path\u0000", catalogNames[27]);
        srbToJargon.put("MDAS_AR_REPL\u0000max_obj_size\u0000", catalogNames[331]);
        srbToJargon.put("MDAS_AR_REPL\u0000repl_enum\u0000", catalogNames[31]);
        srbToJargon.put("MDAS_AR_REPL\u0000rsrc_comments\u0000", catalogNames[326]);
        srbToJargon.put("MDAS_AR_REPL\u0000rsrc_creation_date\u0000", catalogNames[327]);
        srbToJargon.put("MDAS_AR_REPL\u0000rsrc_modify_date\u0000", catalogNames[328]);
        srbToJargon.put("MDAS_AR_REPL\u0000rsrc_name\u0000", catalogNames[11]);
        srbToJargon.put("MDAS_AR_TAPE_INFO\u0000bytesWritten\u0000", catalogNames[220]);
        srbToJargon.put("MDAS_AR_TAPE_INFO\u0000currentAbsPosition\u0000", catalogNames[219]);
        srbToJargon.put("MDAS_AR_TAPE_INFO\u0000currentFileSeqNum\u0000", catalogNames[218]);
        srbToJargon.put("MDAS_AR_TAPE_INFO\u0000fullFlag\u0000", catalogNames[217]);
        srbToJargon.put("MDAS_AR_TAPE_INFO\u0000tapeLibInx\u0000", catalogNames[216]);
        srbToJargon.put("MDAS_AR_TAPE_INFO\u0000tapeNumber\u0000", catalogNames[213]);
        srbToJargon.put("MDAS_AR_TAPE_INFO\u0000tapeOwner\u0000", catalogNames[214]);
        srbToJargon.put("MDAS_AR_TAPE_INFO\u0000tapeType\u0000", catalogNames[215]);
        srbToJargon.put("MDAS_AT_DATA_TYP_EXT\u0000data_typ_ext\u0000", catalogNames[325]);
        srbToJargon.put("MDAS_AT_DATA_TYP_EXT\u0000data_typ_mime\u0000", catalogNames[324]);
        srbToJargon.put("MDAS_AUDIT\u0000aud_comments\u0000", catalogNames[250]);
        srbToJargon.put("MDAS_AUDIT\u0000aud_timestamp\u0000", catalogNames[249]);
        srbToJargon.put("MDAS_AUDIT_DESC\u0000actionDesc\u0000", catalogNames[248]);
        srbToJargon.put("MDAS_AU_1MDATA\u0000userdef_metastr0\u0000", catalogNames[207]);
        srbToJargon.put("MDAS_AU_1MDATA\u0000userdef_metastr1\u0000", catalogNames[210]);
        srbToJargon.put("MDAS_AU_2MDATA\u0000userdef_metastr0\u0000", catalogNames[208]);
        srbToJargon.put("MDAS_AU_2MDATA\u0000userdef_metastr1\u0000", catalogNames[211]);
        srbToJargon.put("MDAS_AU_3MDATA\u0000userdef_metastr0\u0000", catalogNames[209]);
        srbToJargon.put("MDAS_AU_3MDATA\u0000userdef_metastr1\u0000", catalogNames[212]);
        srbToJargon.put("MDAS_AU_AUDIT\u0000comments\u0000", catalogNames[20]);
        srbToJargon.put("MDAS_AU_AUDIT\u0000time_stamp\u0000", catalogNames[19]);
        srbToJargon.put("MDAS_AU_AUTH_MAP\u0000distin_name\u0000", catalogNames[67]);
        srbToJargon.put("MDAS_AU_INFO\u0000user_address\u0000", catalogNames[6]);
        srbToJargon.put("MDAS_AU_INFO\u0000user_email\u0000", catalogNames[17]);
        srbToJargon.put("MDAS_AU_INFO\u0000user_phone\u0000", catalogNames[16]);
        srbToJargon.put("MDAS_AU_MDATA\u0000metadatanum\u0000", catalogNames[263]);
        srbToJargon.put("MDAS_AU_MDATA\u0000userdef_creat_date\u0000", catalogNames[380]);
        srbToJargon.put("MDAS_AU_MDATA\u0000userdef_metaint0\u0000", catalogNames[293]);
        srbToJargon.put("MDAS_AU_MDATA\u0000userdef_metaint1\u0000", catalogNames[315]);
        srbToJargon.put("MDAS_AU_MDATA\u0000userdef_metastr0\u0000", catalogNames[283]);
        srbToJargon.put("MDAS_AU_MDATA\u0000userdef_metastr1\u0000", catalogNames[284]);
        srbToJargon.put("MDAS_AU_MDATA\u0000userdef_metastr2\u0000", catalogNames[285]);
        srbToJargon.put("MDAS_AU_MDATA\u0000userdef_metastr3\u0000", catalogNames[286]);
        srbToJargon.put("MDAS_AU_MDATA\u0000userdef_metastr4\u0000", catalogNames[287]);
        srbToJargon.put("MDAS_AU_MDATA\u0000userdef_metastr5\u0000", catalogNames[288]);
        srbToJargon.put("MDAS_AU_MDATA\u0000userdef_metastr6\u0000", catalogNames[289]);
        srbToJargon.put("MDAS_AU_MDATA\u0000userdef_metastr7\u0000", catalogNames[290]);
        srbToJargon.put("MDAS_AU_MDATA\u0000userdef_metastr8\u0000", catalogNames[291]);
        srbToJargon.put("MDAS_AU_MDATA\u0000userdef_metastr9\u0000", catalogNames[292]);
        srbToJargon.put("MDAS_AU_MDATA\u0000userdef_modif_date\u0000", catalogNames[322]);
        srbToJargon.put("MDAS_AU_OWNER_INFO\u0000user_email\u0000", catalogNames[129]);
        srbToJargon.put("MDAS_AU_TCKT_DATA\u0000access_count\u0000", catalogNames[39]);
        srbToJargon.put("MDAS_AU_TCKT_DATA\u0000begin_time\u0000", catalogNames[37]);
        srbToJargon.put("MDAS_AU_TCKT_DATA\u0000end_time\u0000", catalogNames[38]);
        srbToJargon.put("MDAS_AU_TCKT_DATA\u0000ticket_id\u0000", catalogNames[36]);
        srbToJargon.put("MDAS_AU_TCKT_GRP\u0000access_count\u0000", catalogNames[46]);
        srbToJargon.put("MDAS_AU_TCKT_GRP\u0000begin_time\u0000", catalogNames[44]);
        srbToJargon.put("MDAS_AU_TCKT_GRP\u0000end_time\u0000", catalogNames[45]);
        srbToJargon.put("MDAS_AU_TCKT_GRP\u0000is_recursive\u0000", catalogNames[200]);
        srbToJargon.put("MDAS_AU_TCKT_GRP\u0000ticket_id\u0000", catalogNames[43]);
        srbToJargon.put("MDAS_AU_ZN_ATHMAP\u0000distin_name\u0000", catalogNames[305]);
        srbToJargon.put("MDAS_CD_ANNO_USER\u0000user_name\u0000", catalogNames[72]);
        srbToJargon.put("MDAS_CD_ANNO_USER\u0000zone_id\u0000", catalogNames[350]);
        srbToJargon.put("MDAS_CD_CAGRP_USER\u0000user_name\u0000", catalogNames[371]);
        srbToJargon.put("MDAS_CD_CAGRP_USER\u0000zone_id\u0000", catalogNames[373]);
        srbToJargon.put("MDAS_CD_CANNO_USER\u0000user_name\u0000", catalogNames[230]);
        srbToJargon.put("MDAS_CD_CANNO_USER\u0000user_name\u0000", catalogNames[276]);
        srbToJargon.put("MDAS_CD_CANNO_USER\u0000zone_id\u0000", catalogNames[354]);
        srbToJargon.put("MDAS_CD_CANNO_USER\u0000zone_id\u0000", catalogNames[356]);
        srbToJargon.put("MDAS_CD_COOWN_USER\u0000user_name\u0000", catalogNames[149]);
        srbToJargon.put("MDAS_CD_COOWN_USER\u0000zone_id\u0000", catalogNames[352]);
        srbToJargon.put("MDAS_CD_CTKTOWNER\u0000user_name\u0000", catalogNames[48]);
        srbToJargon.put("MDAS_CD_CTKTOWNER\u0000zone_id\u0000", catalogNames[348]);
        srbToJargon.put("MDAS_CD_CTKTUSER\u0000user_name\u0000", catalogNames[49]);
        srbToJargon.put("MDAS_CD_CTKTUSER\u0000zone_id\u0000", catalogNames[349]);
        srbToJargon.put("MDAS_CD_DAGRP_USER\u0000user_name\u0000", catalogNames[368]);
        srbToJargon.put("MDAS_CD_DAGRP_USER\u0000zone_id\u0000", catalogNames[370]);
        srbToJargon.put("MDAS_CD_DAUDT_USER\u0000user_name\u0000", catalogNames[130]);
        srbToJargon.put("MDAS_CD_DAUDT_USER\u0000zone_id\u0000", catalogNames[351]);
        srbToJargon.put("MDAS_CD_DLOWN_USER\u0000user_name\u0000", catalogNames[224]);
        srbToJargon.put("MDAS_CD_DLOWN_USER\u0000zone_id\u0000", catalogNames[353]);
        srbToJargon.put("MDAS_CD_DTKTOWNER\u0000user_name\u0000", catalogNames[41]);
        srbToJargon.put("MDAS_CD_DTKTOWNER\u0000zone_id\u0000", catalogNames[346]);
        srbToJargon.put("MDAS_CD_DTKTUSER\u0000user_name\u0000", catalogNames[42]);
        srbToJargon.put("MDAS_CD_DTKTUSER\u0000zone_id\u0000", catalogNames[347]);
        srbToJargon.put("MDAS_CD_OWNER_USER\u0000user_name\u0000", catalogNames[35]);
        srbToJargon.put("MDAS_CD_OWNER_USER\u0000zone_id\u0000", catalogNames[345]);
        srbToJargon.put("MDAS_CD_PAR_USER\u0000user_modify_date\u0000", catalogNames[317]);
        srbToJargon.put("MDAS_CD_PAR_USER\u0000user_name\u0000", catalogNames[3]);
        srbToJargon.put("MDAS_CD_PAR_USER\u0000zone_id\u0000", catalogNames[318]);
        srbToJargon.put("MDAS_CD_PIN_USER\u0000user_name\u0000", catalogNames[241]);
        srbToJargon.put("MDAS_CD_PIN_USER\u0000zone_id\u0000", catalogNames[355]);
        srbToJargon.put("MDAS_CD_RAGRP_USER\u0000user_name\u0000", catalogNames[364]);
        srbToJargon.put("MDAS_CD_RAGRP_USER\u0000zone_id\u0000", catalogNames[366]);
        srbToJargon.put("MDAS_CD_RSAC_USER\u0000user_name\u0000", catalogNames[341]);
        srbToJargon.put("MDAS_CD_RSAC_USER\u0000zone_id\u0000", catalogNames[343]);
        srbToJargon.put("MDAS_CD_RS_USER\u0000user_name\u0000", catalogNames[332]);
        srbToJargon.put("MDAS_CD_RS_USER\u0000zone_id\u0000", catalogNames[344]);
        srbToJargon.put("MDAS_CD_USER\u0000user_creation_date\u0000", catalogNames[329]);
        srbToJargon.put("MDAS_CD_USER\u0000user_id\u0000", catalogNames[147]);
        srbToJargon.put("MDAS_CD_USER\u0000user_modify_date\u0000", catalogNames[330]);
        srbToJargon.put("MDAS_CD_USER\u0000user_name\u0000", catalogNames[7]);
        srbToJargon.put("MDAS_CD_ZN_USER\u0000user_name\u0000", catalogNames[311]);
        srbToJargon.put("MDAS_TD_1RSRC_CLASS\u0000rsrc_class_name\u0000", catalogNames[63]);
        srbToJargon.put("MDAS_TD_2RSRC_CLASS\u0000rsrc_class_name\u0000", catalogNames[273]);
        srbToJargon.put("MDAS_TD_ACTN\u0000action_desc\u0000", catalogNames[22]);
        srbToJargon.put("MDAS_TD_ANNO_DOMN\u0000domain_desc\u0000", catalogNames[73]);
        srbToJargon.put("MDAS_TD_AUTH_SCHM\u0000auth_scheme\u0000", catalogNames[68]);
        srbToJargon.put("MDAS_TD_CADATA_GRP\u0000data_grp_name\u0000", catalogNames[374]);
        srbToJargon.put("MDAS_TD_CAGRP_ACCS\u0000access_constraint\u0000", catalogNames[375]);
        srbToJargon.put("MDAS_TD_CAGRP_DOMN\u0000domain_desc\u0000", catalogNames[372]);
        srbToJargon.put("MDAS_TD_CANNO_DOMN\u0000domain_desc\u0000", catalogNames[231]);
        srbToJargon.put("MDAS_TD_CANNO_DOMN\u0000domain_desc\u0000", catalogNames[277]);
        srbToJargon.put("MDAS_TD_CCDATA_TYP\u0000data_typ_name\u0000", catalogNames[376]);
        srbToJargon.put("MDAS_TD_COLLCONT\u0000container_name\u0000", catalogNames[132]);
        srbToJargon.put("MDAS_TD_CONTAINER\u0000container_max_size\u0000", catalogNames[57]);
        srbToJargon.put("MDAS_TD_CONTAINER\u0000container_name\u0000", catalogNames[58]);
        srbToJargon.put("MDAS_TD_COOWN_DOMN\u0000domain_desc\u0000", catalogNames[226]);
        srbToJargon.put("MDAS_TD_CTKTO_DOMN\u0000domain_desc\u0000", catalogNames[52]);
        srbToJargon.put("MDAS_TD_CTKTU_DOMN\u0000domain_desc\u0000", catalogNames[50]);
        srbToJargon.put("MDAS_TD_DAGRP_DOMN\u0000domain_desc\u0000", catalogNames[369]);
        srbToJargon.put("MDAS_TD_DATA_2GRP\u0000data_grp_name\u0000", catalogNames[26]);
        srbToJargon.put("MDAS_TD_DATA_3GRP\u0000coll_comments\u0000", catalogNames[229]);
        srbToJargon.put("MDAS_TD_DATA_3GRP\u0000coll_cr_timestamp\u0000", catalogNames[228]);
        srbToJargon.put("MDAS_TD_DATA_3GRP\u0000data_grp_name\u0000", catalogNames[227]);
        srbToJargon.put("MDAS_TD_DATA_4GRP\u0000data_grp_name\u0000", catalogNames[280]);
        srbToJargon.put("MDAS_TD_DATA_5GRP\u0000data_grp_name\u0000", catalogNames[282]);
        srbToJargon.put("MDAS_TD_DATA_GRP\u0000coll_comments\u0000", catalogNames[151]);
        srbToJargon.put("MDAS_TD_DATA_GRP\u0000coll_cr_timestamp\u0000", catalogNames[150]);
        srbToJargon.put("MDAS_TD_DATA_GRP\u0000coll_link\u0000", catalogNames[279]);
        srbToJargon.put("MDAS_TD_DATA_GRP\u0000coll_mod_timestamp\u0000", catalogNames[367]);
        srbToJargon.put("MDAS_TD_DATA_GRP\u0000data_grp_id\u0000", catalogNames[235]);
        srbToJargon.put("MDAS_TD_DATA_GRP\u0000data_grp_name\u0000", catalogNames[15]);
        srbToJargon.put("MDAS_TD_DATA_GRP\u0000parent_grp_name\u0000", catalogNames[54]);
        srbToJargon.put("MDAS_TD_DATA_TYP\u0000data_typ_name\u0000", catalogNames[4]);
        srbToJargon.put("MDAS_TD_DAUDT_DOMN\u0000domain_desc\u0000", catalogNames[131]);
        srbToJargon.put("MDAS_TD_DCRELGRP\u0000data_grp_name\u0000", catalogNames[171]);
        srbToJargon.put("MDAS_TD_DEL_DATA_GRP\u0000data_grp_name\u0000", catalogNames[390]);
        srbToJargon.put("MDAS_TD_DGRP_IXCOL\u0000data_grp_name\u0000", catalogNames[102]);
        srbToJargon.put("MDAS_TD_DGRP_IXDS\u0000data_grp_name\u0000", catalogNames[100]);
        srbToJargon.put("MDAS_TD_DGRP_IXDTP\u0000data_grp_name\u0000", catalogNames[101]);
        srbToJargon.put("MDAS_TD_DGRP_MTCOL\u0000data_grp_name\u0000", catalogNames[105]);
        srbToJargon.put("MDAS_TD_DGRP_MTDTP\u0000data_grp_name\u0000", catalogNames[104]);
        srbToJargon.put("MDAS_TD_DGRP_MTHDS\u0000data_grp_name\u0000", catalogNames[103]);
        srbToJargon.put("MDAS_TD_DGRP_STRUC\u0000data_grp_name\u0000", catalogNames[112]);
        srbToJargon.put("MDAS_TD_DLOWN_DOMN\u0000domain_desc\u0000", catalogNames[225]);
        srbToJargon.put("MDAS_TD_DOMN\u0000domain_desc\u0000", catalogNames[9]);
        srbToJargon.put("MDAS_TD_DSTKT_ACCS\u0000access_constraint\u0000", catalogNames[40]);
        srbToJargon.put("MDAS_TD_DS_ACCS\u0000access_constraint\u0000", catalogNames[8]);
        srbToJargon.put("MDAS_TD_DS_ACCS\u0000access_id\u0000", catalogNames[146]);
        srbToJargon.put("MDAS_TD_DS_ACCS\u0000access_list\u0000", catalogNames[32]);
        srbToJargon.put("MDAS_TD_DS_ACCS\u0000access_privilege\u0000", catalogNames[79]);
        srbToJargon.put("MDAS_TD_DTKTO_DOMN\u0000domain_desc\u0000", catalogNames[53]);
        srbToJargon.put("MDAS_TD_DTKTU_DOMN\u0000domain_desc\u0000", catalogNames[51]);
        srbToJargon.put("MDAS_TD_DTYP_IXCOL\u0000data_typ_name\u0000", catalogNames[108]);
        srbToJargon.put("MDAS_TD_DTYP_IXDS\u0000data_typ_name\u0000", catalogNames[106]);
        srbToJargon.put("MDAS_TD_DTYP_IXDTP\u0000data_typ_name\u0000", catalogNames[107]);
        srbToJargon.put("MDAS_TD_DTYP_MTCOL\u0000data_typ_name\u0000", catalogNames[111]);
        srbToJargon.put("MDAS_TD_DTYP_MTDTP\u0000data_typ_name\u0000", catalogNames[110]);
        srbToJargon.put("MDAS_TD_DTYP_MTHDS\u0000data_typ_name\u0000", catalogNames[109]);
        srbToJargon.put("MDAS_TD_DTYP_PARENT\u0000data_typ_name\u0000", catalogNames[359]);
        srbToJargon.put("MDAS_TD_EXTAB_INFO\u0000ext_attr_comments\u0000", catalogNames[399]);
        srbToJargon.put("MDAS_TD_EXTAB_INFO\u0000ext_attr_name\u0000", catalogNames[397]);
        srbToJargon.put("MDAS_TD_EXTAB_INFO\u0000ext_attr_out_name\u0000", catalogNames[398]);
        srbToJargon.put("MDAS_TD_EXTAB_INFO\u0000ext_schema_name\u0000", catalogNames[395]);
        srbToJargon.put("MDAS_TD_EXTAB_INFO\u0000ext_table_name\u0000", catalogNames[396]);
        srbToJargon.put("MDAS_TD_GRP_ACCS\u0000access_constraint\u0000", catalogNames[25]);
        srbToJargon.put("MDAS_TD_GRTKT_ACCS\u0000access_constraint\u0000", catalogNames[47]);
        srbToJargon.put("MDAS_TD_IDGRPUSER1\u0000user_id\u0000", catalogNames[183]);
        srbToJargon.put("MDAS_TD_IDGRPUSER2\u0000user_id\u0000", catalogNames[181]);
        srbToJargon.put("MDAS_TD_INT_LOCN\u0000netprefix\u0000", catalogNames[270]);
        srbToJargon.put("MDAS_TD_LCK_ACCS\u0000access_constraint\u0000", catalogNames[223]);
        srbToJargon.put("MDAS_TD_LOCN\u0000locn_desc\u0000", catalogNames[55]);
        srbToJargon.put("MDAS_TD_LOCN\u0000netprefix\u0000", catalogNames[12]);
        srbToJargon.put("MDAS_TD_ORDERBY\u0000orderby\u0000", catalogNames[385]);
        srbToJargon.put("MDAS_TD_OWNER_DOMN\u0000domain_desc\u0000", catalogNames[66]);
        srbToJargon.put("MDAS_TD_PARDOMN\u0000domain_desc\u0000", catalogNames[361]);
        srbToJargon.put("MDAS_TD_PAR_DOMN\u0000domain_desc\u0000", catalogNames[319]);
        srbToJargon.put("MDAS_TD_PAR_LOCN\u0000locn_desc\u0000", catalogNames[357]);
        srbToJargon.put("MDAS_TD_PIN_DOMN\u0000domain_desc\u0000", catalogNames[242]);
        srbToJargon.put("MDAS_TD_RAGRP_DOMN\u0000domain_desc\u0000", catalogNames[365]);
        srbToJargon.put("MDAS_TD_RSAC_DOMN\u0000domain_desc\u0000", catalogNames[342]);
        srbToJargon.put("MDAS_TD_RSRC_2TYP\u0000rsrc_typ_name\u0000", catalogNames[30]);
        srbToJargon.put("MDAS_TD_RSRC_3TYP\u0000rsrc_typ_name\u0000", catalogNames[271]);
        srbToJargon.put("MDAS_TD_RSRC_ACCS\u0000access_constraint\u0000", catalogNames[314]);
        srbToJargon.put("MDAS_TD_RSRC_ACCS\u0000access_id\u0000", catalogNames[358]);
        srbToJargon.put("MDAS_TD_RSRC_ACCS\u0000access_list\u0000", catalogNames[33]);
        srbToJargon.put("MDAS_TD_RSRC_ACCS\u0000access_privilege\u0000", catalogNames[313]);
        srbToJargon.put("MDAS_TD_RSRC_CLASS\u0000rsrc_class_name\u0000", catalogNames[59]);
        srbToJargon.put("MDAS_TD_RSRC_PARENT\u0000rsrc_typ_name\u0000", catalogNames[363]);
        srbToJargon.put("MDAS_TD_RSRC_TYP\u0000rsrc_typ_name\u0000", catalogNames[13]);
        srbToJargon.put("MDAS_TD_RS_DOMN\u0000domain_desc\u0000", catalogNames[333]);
        srbToJargon.put("MDAS_TD_SRVR_LOCN\u0000locn_desc\u0000", catalogNames[69]);
        srbToJargon.put("MDAS_TD_SRVR_LOCN\u0000netprefix\u0000", catalogNames[70]);
        srbToJargon.put("MDAS_TD_UDF\u0000udf\u0000", catalogNames[295]);
        srbToJargon.put("MDAS_TD_UDF\u0000udf\u0000", catalogNames[296]);
        srbToJargon.put("MDAS_TD_UDF\u0000udf\u0000", catalogNames[297]);
        srbToJargon.put("MDAS_TD_UDF\u0000udf\u0000", catalogNames[298]);
        srbToJargon.put("MDAS_TD_UDF\u0000udf\u0000", catalogNames[299]);
        srbToJargon.put("MDAS_TD_USER_TYP\u0000user_typ_name\u0000", catalogNames[5]);
        srbToJargon.put("MDAS_TD_UTYP_PARENT\u0000user_typ_name\u0000", catalogNames[362]);
        srbToJargon.put("MDAS_TD_ZN_ATHSCHM\u0000auth_scheme\u0000", catalogNames[304]);
        srbToJargon.put("MDAS_TD_ZN_DOMN\u0000domain_desc\u0000", catalogNames[312]);
        srbToJargon.put("MDAS_TD_ZN_LOCN\u0000locn_desc\u0000", catalogNames[360]);
        srbToJargon.put("MDAS_TD_ZN_LOCN\u0000netprefix\u0000", catalogNames[302]);
        srbToJargon.put("MDAS_TD_ZONE\u0000local_zone_flag\u0000", catalogNames[301]);
        srbToJargon.put("MDAS_TD_ZONE\u0000port_number\u0000", catalogNames[303]);
        srbToJargon.put("MDAS_TD_ZONE\u0000zone_comments\u0000", catalogNames[309]);
        srbToJargon.put("MDAS_TD_ZONE\u0000zone_contact\u0000", catalogNames[310]);
        srbToJargon.put("MDAS_TD_ZONE\u0000zone_create_date\u0000", catalogNames[307]);
        srbToJargon.put("MDAS_TD_ZONE\u0000zone_id\u0000", catalogNames[300]);
        srbToJargon.put("MDAS_TD_ZONE\u0000zone_modify_date\u0000", catalogNames[308]);
        srbToJargon.put("MDAS_TD_ZONE\u0000zone_status\u0000", catalogNames[306]);
        srbToJargon.put("NONDISTINCT\u0000nondistinct\u0000", catalogNames[294]);
        jargonToSRB.put(catalogNames[175], "DC_AUTHCONTRIB\u0000dc_contr_address\u0000");
        jargonToSRB.put(catalogNames[179], "DC_AUTHCONTRIB\u0000dc_contr_corp_name\u0000");
        jargonToSRB.put(catalogNames[176], "DC_AUTHCONTRIB\u0000dc_contr_email\u0000");
        jargonToSRB.put(catalogNames[164], "DC_AUTHCONTRIB\u0000dc_contr_name\u0000");
        jargonToSRB.put(catalogNames[177], "DC_AUTHCONTRIB\u0000dc_contr_phone\u0000");
        jargonToSRB.put(catalogNames[178], "DC_AUTHCONTRIB\u0000dc_contr_web\u0000");
        jargonToSRB.put(catalogNames[153], "DC_COLLECTION\u0000data_grp_name\u0000");
        jargonToSRB.put(catalogNames[172], "DC_COVERAGE\u0000coverage_desc\u0000");
        jargonToSRB.put(catalogNames[152], "DC_DATA\u0000data_name\u0000");
        jargonToSRB.put(catalogNames[166], "DC_DESCRIPTION\u0000dc_desc\u0000");
        jargonToSRB.put(catalogNames[174], "DC_PUBLISHER\u0000dc_pub_addr\u0000");
        jargonToSRB.put(catalogNames[167], "DC_PUBLISHER\u0000dc_pub_name\u0000");
        jargonToSRB.put(catalogNames[169], "DC_RELATION\u0000related_data_desc\u0000");
        jargonToSRB.put(catalogNames[173], "DC_RIGHTS\u0000rights_data_desc\u0000");
        jargonToSRB.put(catalogNames[168], "DC_SOURCE\u0000source_desc\u0000");
        jargonToSRB.put(catalogNames[165], "DC_SUBJECT\u0000dc_subject_name\u0000");
        jargonToSRB.put(catalogNames[154], "DC_TD_CONTR_TYPE\u0000dc_contr_type_name\u0000");
        jargonToSRB.put(catalogNames[161], "DC_TD_COVERAGE\u0000coverage_type_name\u0000");
        jargonToSRB.put(catalogNames[156], "DC_TD_DESCR_TYPE\u0000dc_desc_type_name\u0000");
        jargonToSRB.put(catalogNames[159], "DC_TD_LANGUAGE\u0000language_name\u0000");
        jargonToSRB.put(catalogNames[160], "DC_TD_RELATION_TYP\u0000relation_type_name\u0000");
        jargonToSRB.put(catalogNames[162], "DC_TD_RIGHTS\u0000rights_type_name\u0000");
        jargonToSRB.put(catalogNames[158], "DC_TD_SOURCE_TYPE\u0000source_type_name\u0000");
        jargonToSRB.put(catalogNames[155], "DC_TD_SUBJ_CLASS\u0000dc_subj_class_name\u0000");
        jargonToSRB.put(catalogNames[157], "DC_TD_TYPE\u0000dc_type_name\u0000");
        jargonToSRB.put(catalogNames[163], "DC_TITLE\u0000dc_title\u0000");
        jargonToSRB.put(catalogNames[233], "MDAS_AC_ANNOTATION\u0000anno_date\u0000");
        jargonToSRB.put(catalogNames[234], "MDAS_AC_ANNOTATION\u0000anno_type\u0000");
        jargonToSRB.put(catalogNames[232], "MDAS_AC_ANNOTATION\u0000annotations\u0000");
        jargonToSRB.put(catalogNames[64], "MDAS_ADCONT_REPL\u0000data_size\u0000");
        jargonToSRB.put(catalogNames[281], "MDAS_ADC_REPL\u0000data_name\u0000");
        jargonToSRB.put(catalogNames[10], "MDAS_ADC_REPL\u0000path_name\u0000");
        jargonToSRB.put(catalogNames[1], "MDAS_ADC_REPL\u0000repl_enum\u0000");
        jargonToSRB.put(catalogNames[265], "MDAS_ADC_REPL\u0000seg_num\u0000");
        jargonToSRB.put(catalogNames[96], "MDAS_ADIXCOLL_REPL\u0000data_name\u0000");
        jargonToSRB.put(catalogNames[115], "MDAS_ADIXCOLL_REPL\u0000path_name\u0000");
        jargonToSRB.put(catalogNames[94], "MDAS_ADIXDS_REPL\u0000data_name\u0000");
        jargonToSRB.put(catalogNames[113], "MDAS_ADIXDS_REPL\u0000path_name\u0000");
        jargonToSRB.put(catalogNames[95], "MDAS_ADIXDTP_REPL\u0000data_name\u0000");
        jargonToSRB.put(catalogNames[114], "MDAS_ADIXDTP_REPL\u0000path_name\u0000");
        jargonToSRB.put(catalogNames[99], "MDAS_ADMTHCOL_REPL\u0000data_name\u0000");
        jargonToSRB.put(catalogNames[97], "MDAS_ADMTHDS_REPL\u0000data_name\u0000");
        jargonToSRB.put(catalogNames[98], "MDAS_ADMTHDTP_REPL\u0000data_name\u0000");
        jargonToSRB.put(catalogNames[92], "MDAS_ADSTRUCT_REPL\u0000data_name\u0000");
        jargonToSRB.put(catalogNames[192], "MDAS_AD_1COLLMDATA\u0000userdef_metastr0\u0000");
        jargonToSRB.put(catalogNames[196], "MDAS_AD_1COLLMDATA\u0000userdef_metastr1\u0000");
        jargonToSRB.put(catalogNames[278], "MDAS_AD_1COMPOUND\u0000cmpd_path_name\u0000");
        jargonToSRB.put(catalogNames[184], "MDAS_AD_1MDATA\u0000userdef_metastr0\u0000");
        jargonToSRB.put(catalogNames[188], "MDAS_AD_1MDATA\u0000userdef_metastr1\u0000");
        jargonToSRB.put(catalogNames[193], "MDAS_AD_2COLLMDATA\u0000userdef_metastr0\u0000");
        jargonToSRB.put(catalogNames[197], "MDAS_AD_2COLLMDATA\u0000userdef_metastr1\u0000");
        jargonToSRB.put(catalogNames[185], "MDAS_AD_2MDATA\u0000userdef_metastr0\u0000");
        jargonToSRB.put(catalogNames[189], "MDAS_AD_2MDATA\u0000userdef_metastr1\u0000");
        jargonToSRB.put(catalogNames[194], "MDAS_AD_3COLLMDATA\u0000userdef_metastr0\u0000");
        jargonToSRB.put(catalogNames[198], "MDAS_AD_3COLLMDATA\u0000userdef_metastr1\u0000");
        jargonToSRB.put(catalogNames[186], "MDAS_AD_3MDATA\u0000userdef_metastr0\u0000");
        jargonToSRB.put(catalogNames[190], "MDAS_AD_3MDATA\u0000userdef_metastr1\u0000");
        jargonToSRB.put(catalogNames[195], "MDAS_AD_4COLLMDATA\u0000userdef_metastr0\u0000");
        jargonToSRB.put(catalogNames[199], "MDAS_AD_4COLLMDATA\u0000userdef_metastr1\u0000");
        jargonToSRB.put(catalogNames[187], "MDAS_AD_4MDATA\u0000userdef_metastr0\u0000");
        jargonToSRB.put(catalogNames[191], "MDAS_AD_4MDATA\u0000userdef_metastr1\u0000");
        jargonToSRB.put(catalogNames[182], "MDAS_AD_ACCS\u0000access_id\u0000");
        jargonToSRB.put(catalogNames[75], "MDAS_AD_ANNOTATION\u0000anno_date\u0000");
        jargonToSRB.put(catalogNames[78], "MDAS_AD_ANNOTATION\u0000anno_position\u0000");
        jargonToSRB.put(catalogNames[74], "MDAS_AD_ANNOTATION\u0000annotations\u0000");
        jargonToSRB.put(catalogNames[24], "MDAS_AD_AUDIT\u0000comments\u0000");
        jargonToSRB.put(catalogNames[23], "MDAS_AD_AUDIT\u0000time_stamp\u0000");
        jargonToSRB.put(catalogNames[88], "MDAS_AD_CLASS\u0000class_name\u0000");
        jargonToSRB.put(catalogNames[89], "MDAS_AD_CLASS\u0000class_type\u0000");
        jargonToSRB.put(catalogNames[133], "MDAS_AD_COLLMDATA\u0000metadatanum\u0000");
        jargonToSRB.put(catalogNames[378], "MDAS_AD_COLLMDATA\u0000userdef_creat_date\u0000");
        jargonToSRB.put(catalogNames[144], "MDAS_AD_COLLMDATA\u0000userdef_metaint0\u0000");
        jargonToSRB.put(catalogNames[145], "MDAS_AD_COLLMDATA\u0000userdef_metaint1\u0000");
        jargonToSRB.put(catalogNames[134], "MDAS_AD_COLLMDATA\u0000userdef_metastr0\u0000");
        jargonToSRB.put(catalogNames[135], "MDAS_AD_COLLMDATA\u0000userdef_metastr1\u0000");
        jargonToSRB.put(catalogNames[136], "MDAS_AD_COLLMDATA\u0000userdef_metastr2\u0000");
        jargonToSRB.put(catalogNames[137], "MDAS_AD_COLLMDATA\u0000userdef_metastr3\u0000");
        jargonToSRB.put(catalogNames[138], "MDAS_AD_COLLMDATA\u0000userdef_metastr4\u0000");
        jargonToSRB.put(catalogNames[139], "MDAS_AD_COLLMDATA\u0000userdef_metastr5\u0000");
        jargonToSRB.put(catalogNames[140], "MDAS_AD_COLLMDATA\u0000userdef_metastr6\u0000");
        jargonToSRB.put(catalogNames[141], "MDAS_AD_COLLMDATA\u0000userdef_metastr7\u0000");
        jargonToSRB.put(catalogNames[142], "MDAS_AD_COLLMDATA\u0000userdef_metastr8\u0000");
        jargonToSRB.put(catalogNames[143], "MDAS_AD_COLLMDATA\u0000userdef_metastr9\u0000");
        jargonToSRB.put(catalogNames[321], "MDAS_AD_COLLMDATA\u0000userdef_modif_date\u0000");
        jargonToSRB.put(catalogNames[77], "MDAS_AD_COMMENTS\u0000com_date\u0000");
        jargonToSRB.put(catalogNames[268], "MDAS_AD_COMPOUND\u0000cmpd_path_name\u0000");
        jargonToSRB.put(catalogNames[275], "MDAS_AD_COMPOUND\u0000data_size\u0000");
        jargonToSRB.put(catalogNames[266], "MDAS_AD_COMPOUND\u0000int_repl_num\u0000");
        jargonToSRB.put(catalogNames[267], "MDAS_AD_COMPOUND\u0000int_seg_num\u0000");
        jargonToSRB.put(catalogNames[272], "MDAS_AD_COMPOUND\u0000is_dirty\u0000");
        jargonToSRB.put(catalogNames[274], "MDAS_AD_COMPOUND\u0000offset\u0000");
        jargonToSRB.put(catalogNames[170], "MDAS_AD_DCRELREPL\u0000data_name\u0000");
        jargonToSRB.put(catalogNames[392], "MDAS_AD_DEL_REPL\u0000d_comment\u0000");
        jargonToSRB.put(catalogNames[391], "MDAS_AD_DEL_REPL\u0000data_grp_id\u0000");
        jargonToSRB.put(catalogNames[386], "MDAS_AD_DEL_REPL\u0000data_id\u0000");
        jargonToSRB.put(catalogNames[388], "MDAS_AD_DEL_REPL\u0000data_name\u0000");
        jargonToSRB.put(catalogNames[387], "MDAS_AD_DEL_REPL\u0000repl_enum\u0000");
        jargonToSRB.put(catalogNames[389], "MDAS_AD_DEL_REPL\u0000repl_timestamp\u0000");
        jargonToSRB.put(catalogNames[180], "MDAS_AD_GRP_2ACCS\u0000access_id\u0000");
        jargonToSRB.put(catalogNames[382], "MDAS_AD_GUID\u0000guid\u0000");
        jargonToSRB.put(catalogNames[383], "MDAS_AD_GUID\u0000guid_flag\u0000");
        jargonToSRB.put(catalogNames[384], "MDAS_AD_GUID\u0000guid_time_stamp\u0000");
        jargonToSRB.put(catalogNames[116], "MDAS_AD_MDATA\u0000metadatanum\u0000");
        jargonToSRB.put(catalogNames[377], "MDAS_AD_MDATA\u0000userdef_creat_date\u0000");
        jargonToSRB.put(catalogNames[127], "MDAS_AD_MDATA\u0000userdef_metaint0\u0000");
        jargonToSRB.put(catalogNames[128], "MDAS_AD_MDATA\u0000userdef_metaint1\u0000");
        jargonToSRB.put(catalogNames[117], "MDAS_AD_MDATA\u0000userdef_metastr0\u0000");
        jargonToSRB.put(catalogNames[118], "MDAS_AD_MDATA\u0000userdef_metastr1\u0000");
        jargonToSRB.put(catalogNames[119], "MDAS_AD_MDATA\u0000userdef_metastr2\u0000");
        jargonToSRB.put(catalogNames[120], "MDAS_AD_MDATA\u0000userdef_metastr3\u0000");
        jargonToSRB.put(catalogNames[121], "MDAS_AD_MDATA\u0000userdef_metastr4\u0000");
        jargonToSRB.put(catalogNames[122], "MDAS_AD_MDATA\u0000userdef_metastr5\u0000");
        jargonToSRB.put(catalogNames[123], "MDAS_AD_MDATA\u0000userdef_metastr6\u0000");
        jargonToSRB.put(catalogNames[124], "MDAS_AD_MDATA\u0000userdef_metastr7\u0000");
        jargonToSRB.put(catalogNames[125], "MDAS_AD_MDATA\u0000userdef_metastr8\u0000");
        jargonToSRB.put(catalogNames[126], "MDAS_AD_MDATA\u0000userdef_metastr9\u0000");
        jargonToSRB.put(catalogNames[320], "MDAS_AD_MDATA\u0000userdef_modif_date\u0000");
        jargonToSRB.put(catalogNames[245], "MDAS_AD_MISC1\u0000dcompressed\u0000");
        jargonToSRB.put(catalogNames[246], "MDAS_AD_MISC1\u0000dencrypted\u0000");
        jargonToSRB.put(catalogNames[244], "MDAS_AD_MISC1\u0000dexpire_date\u0000");
        jargonToSRB.put(catalogNames[247], "MDAS_AD_MISC1\u0000dexpire_date_2\u0000");
        jargonToSRB.put(catalogNames[240], "MDAS_AD_MISC1\u0000dpin\u0000");
        jargonToSRB.put(catalogNames[243], "MDAS_AD_MISC1\u0000dpinexpiry\u0000");
        jargonToSRB.put(catalogNames[238], "MDAS_AD_REPL\u0000auditflag\u0000");
        jargonToSRB.put(catalogNames[381], "MDAS_AD_REPL\u0000container_id\u0000");
        jargonToSRB.put(catalogNames[21], "MDAS_AD_REPL\u0000d_comment\u0000");
        jargonToSRB.put(catalogNames[0], "MDAS_AD_REPL\u0000data_id\u0000");
        jargonToSRB.put(catalogNames[2], "MDAS_AD_REPL\u0000data_name\u0000");
        jargonToSRB.put(catalogNames[18], "MDAS_AD_REPL\u0000data_size\u0000");
        jargonToSRB.put(catalogNames[222], "MDAS_AD_REPL\u0000datalock\u0000");
        jargonToSRB.put(catalogNames[237], "MDAS_AD_REPL\u0000dchecksum\u0000");
        jargonToSRB.put(catalogNames[236], "MDAS_AD_REPL\u0000dhide\u0000");
        jargonToSRB.put(catalogNames[239], "MDAS_AD_REPL\u0000dlockexpiry\u0000");
        jargonToSRB.put(catalogNames[34], "MDAS_AD_REPL\u0000is_deleted\u0000");
        jargonToSRB.put(catalogNames[56], "MDAS_AD_REPL\u0000is_dirty\u0000");
        jargonToSRB.put(catalogNames[148], "MDAS_AD_REPL\u0000last_accs_time\u0000");
        jargonToSRB.put(catalogNames[14], "MDAS_AD_REPL\u0000modify_timestamp\u0000");
        jargonToSRB.put(catalogNames[61], "MDAS_AD_REPL\u0000offset\u0000");
        jargonToSRB.put(catalogNames[71], "MDAS_AD_REPL\u0000repl_enum\u0000");
        jargonToSRB.put(catalogNames[76], "MDAS_AD_REPL\u0000repl_timestamp\u0000");
        jargonToSRB.put(catalogNames[221], "MDAS_AD_REPL\u0000version_num\u0000");
        jargonToSRB.put(catalogNames[93], "MDAS_AD_STRCT_BLOB\u0000internal_structure\u0000");
        jargonToSRB.put(catalogNames[91], "MDAS_AD_STRCT_BLOB\u0000structure_comments\u0000");
        jargonToSRB.put(catalogNames[90], "MDAS_AD_STRCT_BLOB\u0000structure_type\u0000");
        jargonToSRB.put(catalogNames[201], "MDAS_AR_1MDATA\u0000userdef_metastr0\u0000");
        jargonToSRB.put(catalogNames[204], "MDAS_AR_1MDATA\u0000userdef_metastr1\u0000");
        jargonToSRB.put(catalogNames[62], "MDAS_AR_1PHYSICAL\u0000phy_rsrc_name\u0000");
        jargonToSRB.put(catalogNames[65], "MDAS_AR_1REPL\u0000rsrc_name\u0000");
        jargonToSRB.put(catalogNames[202], "MDAS_AR_2MDATA\u0000userdef_metastr0\u0000");
        jargonToSRB.put(catalogNames[205], "MDAS_AR_2MDATA\u0000userdef_metastr1\u0000");
        jargonToSRB.put(catalogNames[264], "MDAS_AR_2PHYSICAL\u0000phy_rsrc_name\u0000");
        jargonToSRB.put(catalogNames[203], "MDAS_AR_3MDATA\u0000userdef_metastr0\u0000");
        jargonToSRB.put(catalogNames[206], "MDAS_AR_3MDATA\u0000userdef_metastr1\u0000");
        jargonToSRB.put(catalogNames[269], "MDAS_AR_3PHYSICAL\u0000phy_rsrc_name\u0000");
        jargonToSRB.put(catalogNames[337], "MDAS_AR_INFO\u0000concurrency_max\u0000");
        jargonToSRB.put(catalogNames[83], "MDAS_AR_INFO\u0000concurrency_max\u0000");
        jargonToSRB.put(catalogNames[87], "MDAS_AR_INFO\u0000description\u0000");
        jargonToSRB.put(catalogNames[336], "MDAS_AR_INFO\u0000mbps_bandwidth\u0000");
        jargonToSRB.put(catalogNames[82], "MDAS_AR_INFO\u0000mbps_bandwidth\u0000");
        jargonToSRB.put(catalogNames[340], "MDAS_AR_INFO\u0000megab_capacity\u0000");
        jargonToSRB.put(catalogNames[86], "MDAS_AR_INFO\u0000megab_capacity\u0000");
        jargonToSRB.put(catalogNames[334], "MDAS_AR_INFO\u0000mlsec_latency_max\u0000");
        jargonToSRB.put(catalogNames[80], "MDAS_AR_INFO\u0000mlsec_latency_max\u0000");
        jargonToSRB.put(catalogNames[335], "MDAS_AR_INFO\u0000mlsec_latency_min\u0000");
        jargonToSRB.put(catalogNames[81], "MDAS_AR_INFO\u0000mlsec_latency_min\u0000");
        jargonToSRB.put(catalogNames[338], "MDAS_AR_INFO\u0000num_of_hierarchies\u0000");
        jargonToSRB.put(catalogNames[84], "MDAS_AR_INFO\u0000num_of_hierarchies\u0000");
        jargonToSRB.put(catalogNames[339], "MDAS_AR_INFO\u0000num_of_stripes\u0000");
        jargonToSRB.put(catalogNames[85], "MDAS_AR_INFO\u0000num_of_stripes\u0000");
        jargonToSRB.put(catalogNames[262], "MDAS_AR_MDATA\u0000metadatanum\u0000");
        jargonToSRB.put(catalogNames[379], "MDAS_AR_MDATA\u0000userdef_creat_date\u0000");
        jargonToSRB.put(catalogNames[261], "MDAS_AR_MDATA\u0000userdef_metaint1\u0000");
        jargonToSRB.put(catalogNames[316], "MDAS_AR_MDATA\u0000userdef_metaint1\u0000");
        jargonToSRB.put(catalogNames[251], "MDAS_AR_MDATA\u0000userdef_metastr0\u0000");
        jargonToSRB.put(catalogNames[252], "MDAS_AR_MDATA\u0000userdef_metastr1\u0000");
        jargonToSRB.put(catalogNames[253], "MDAS_AR_MDATA\u0000userdef_metastr2\u0000");
        jargonToSRB.put(catalogNames[254], "MDAS_AR_MDATA\u0000userdef_metastr3\u0000");
        jargonToSRB.put(catalogNames[255], "MDAS_AR_MDATA\u0000userdef_metastr4\u0000");
        jargonToSRB.put(catalogNames[256], "MDAS_AR_MDATA\u0000userdef_metastr5\u0000");
        jargonToSRB.put(catalogNames[257], "MDAS_AR_MDATA\u0000userdef_metastr6\u0000");
        jargonToSRB.put(catalogNames[258], "MDAS_AR_MDATA\u0000userdef_metastr7\u0000");
        jargonToSRB.put(catalogNames[259], "MDAS_AR_MDATA\u0000userdef_metastr8\u0000");
        jargonToSRB.put(catalogNames[260], "MDAS_AR_MDATA\u0000userdef_metastr9\u0000");
        jargonToSRB.put(catalogNames[323], "MDAS_AR_MDATA\u0000userdef_modif_date\u0000");
        jargonToSRB.put(catalogNames[393], "MDAS_AR_PHYSICAL\u0000free_space\u0000");
        jargonToSRB.put(catalogNames[394], "MDAS_AR_PHYSICAL\u0000fs_timestamp\u0000");
        jargonToSRB.put(catalogNames[60], "MDAS_AR_PHYSICAL\u0000max_obj_size\u0000");
        jargonToSRB.put(catalogNames[28], "MDAS_AR_PHYSICAL\u0000phy_default_path\u0000");
        jargonToSRB.put(catalogNames[29], "MDAS_AR_PHYSICAL\u0000phy_rsrc_name\u0000");
        jargonToSRB.put(catalogNames[400], "MDAS_AR_PHYSICAL\u0000rsrc_lock\u0000");
        jargonToSRB.put(catalogNames[27], "MDAS_AR_REPL\u0000default_path\u0000");
        jargonToSRB.put(catalogNames[331], "MDAS_AR_REPL\u0000max_obj_size\u0000");
        jargonToSRB.put(catalogNames[31], "MDAS_AR_REPL\u0000repl_enum\u0000");
        jargonToSRB.put(catalogNames[326], "MDAS_AR_REPL\u0000rsrc_comments\u0000");
        jargonToSRB.put(catalogNames[327], "MDAS_AR_REPL\u0000rsrc_creation_date\u0000");
        jargonToSRB.put(catalogNames[328], "MDAS_AR_REPL\u0000rsrc_modify_date\u0000");
        jargonToSRB.put(catalogNames[11], "MDAS_AR_REPL\u0000rsrc_name\u0000");
        jargonToSRB.put(catalogNames[220], "MDAS_AR_TAPE_INFO\u0000bytesWritten\u0000");
        jargonToSRB.put(catalogNames[219], "MDAS_AR_TAPE_INFO\u0000currentAbsPosition\u0000");
        jargonToSRB.put(catalogNames[218], "MDAS_AR_TAPE_INFO\u0000currentFileSeqNum\u0000");
        jargonToSRB.put(catalogNames[217], "MDAS_AR_TAPE_INFO\u0000fullFlag\u0000");
        jargonToSRB.put(catalogNames[216], "MDAS_AR_TAPE_INFO\u0000tapeLibInx\u0000");
        jargonToSRB.put(catalogNames[213], "MDAS_AR_TAPE_INFO\u0000tapeNumber\u0000");
        jargonToSRB.put(catalogNames[214], "MDAS_AR_TAPE_INFO\u0000tapeOwner\u0000");
        jargonToSRB.put(catalogNames[215], "MDAS_AR_TAPE_INFO\u0000tapeType\u0000");
        jargonToSRB.put(catalogNames[325], "MDAS_AT_DATA_TYP_EXT\u0000data_typ_ext\u0000");
        jargonToSRB.put(catalogNames[324], "MDAS_AT_DATA_TYP_EXT\u0000data_typ_mime\u0000");
        jargonToSRB.put(catalogNames[250], "MDAS_AUDIT\u0000aud_comments\u0000");
        jargonToSRB.put(catalogNames[249], "MDAS_AUDIT\u0000aud_timestamp\u0000");
        jargonToSRB.put(catalogNames[248], "MDAS_AUDIT_DESC\u0000actionDesc\u0000");
        jargonToSRB.put(catalogNames[207], "MDAS_AU_1MDATA\u0000userdef_metastr0\u0000");
        jargonToSRB.put(catalogNames[210], "MDAS_AU_1MDATA\u0000userdef_metastr1\u0000");
        jargonToSRB.put(catalogNames[208], "MDAS_AU_2MDATA\u0000userdef_metastr0\u0000");
        jargonToSRB.put(catalogNames[211], "MDAS_AU_2MDATA\u0000userdef_metastr1\u0000");
        jargonToSRB.put(catalogNames[209], "MDAS_AU_3MDATA\u0000userdef_metastr0\u0000");
        jargonToSRB.put(catalogNames[212], "MDAS_AU_3MDATA\u0000userdef_metastr1\u0000");
        jargonToSRB.put(catalogNames[20], "MDAS_AU_AUDIT\u0000comments\u0000");
        jargonToSRB.put(catalogNames[19], "MDAS_AU_AUDIT\u0000time_stamp\u0000");
        jargonToSRB.put(catalogNames[67], "MDAS_AU_AUTH_MAP\u0000distin_name\u0000");
        jargonToSRB.put(catalogNames[6], "MDAS_AU_INFO\u0000user_address\u0000");
        jargonToSRB.put(catalogNames[17], "MDAS_AU_INFO\u0000user_email\u0000");
        jargonToSRB.put(catalogNames[16], "MDAS_AU_INFO\u0000user_phone\u0000");
        jargonToSRB.put(catalogNames[263], "MDAS_AU_MDATA\u0000metadatanum\u0000");
        jargonToSRB.put(catalogNames[380], "MDAS_AU_MDATA\u0000userdef_creat_date\u0000");
        jargonToSRB.put(catalogNames[293], "MDAS_AU_MDATA\u0000userdef_metaint0\u0000");
        jargonToSRB.put(catalogNames[315], "MDAS_AU_MDATA\u0000userdef_metaint1\u0000");
        jargonToSRB.put(catalogNames[283], "MDAS_AU_MDATA\u0000userdef_metastr0\u0000");
        jargonToSRB.put(catalogNames[284], "MDAS_AU_MDATA\u0000userdef_metastr1\u0000");
        jargonToSRB.put(catalogNames[285], "MDAS_AU_MDATA\u0000userdef_metastr2\u0000");
        jargonToSRB.put(catalogNames[286], "MDAS_AU_MDATA\u0000userdef_metastr3\u0000");
        jargonToSRB.put(catalogNames[287], "MDAS_AU_MDATA\u0000userdef_metastr4\u0000");
        jargonToSRB.put(catalogNames[288], "MDAS_AU_MDATA\u0000userdef_metastr5\u0000");
        jargonToSRB.put(catalogNames[289], "MDAS_AU_MDATA\u0000userdef_metastr6\u0000");
        jargonToSRB.put(catalogNames[290], "MDAS_AU_MDATA\u0000userdef_metastr7\u0000");
        jargonToSRB.put(catalogNames[291], "MDAS_AU_MDATA\u0000userdef_metastr8\u0000");
        jargonToSRB.put(catalogNames[292], "MDAS_AU_MDATA\u0000userdef_metastr9\u0000");
        jargonToSRB.put(catalogNames[322], "MDAS_AU_MDATA\u0000userdef_modif_date\u0000");
        jargonToSRB.put(catalogNames[129], "MDAS_AU_OWNER_INFO\u0000user_email\u0000");
        jargonToSRB.put(catalogNames[39], "MDAS_AU_TCKT_DATA\u0000access_count\u0000");
        jargonToSRB.put(catalogNames[37], "MDAS_AU_TCKT_DATA\u0000begin_time\u0000");
        jargonToSRB.put(catalogNames[38], "MDAS_AU_TCKT_DATA\u0000end_time\u0000");
        jargonToSRB.put(catalogNames[36], "MDAS_AU_TCKT_DATA\u0000ticket_id\u0000");
        jargonToSRB.put(catalogNames[46], "MDAS_AU_TCKT_GRP\u0000access_count\u0000");
        jargonToSRB.put(catalogNames[44], "MDAS_AU_TCKT_GRP\u0000begin_time\u0000");
        jargonToSRB.put(catalogNames[45], "MDAS_AU_TCKT_GRP\u0000end_time\u0000");
        jargonToSRB.put(catalogNames[200], "MDAS_AU_TCKT_GRP\u0000is_recursive\u0000");
        jargonToSRB.put(catalogNames[43], "MDAS_AU_TCKT_GRP\u0000ticket_id\u0000");
        jargonToSRB.put(catalogNames[305], "MDAS_AU_ZN_ATHMAP\u0000distin_name\u0000");
        jargonToSRB.put(catalogNames[72], "MDAS_CD_ANNO_USER\u0000user_name\u0000");
        jargonToSRB.put(catalogNames[350], "MDAS_CD_ANNO_USER\u0000zone_id\u0000");
        jargonToSRB.put(catalogNames[371], "MDAS_CD_CAGRP_USER\u0000user_name\u0000");
        jargonToSRB.put(catalogNames[373], "MDAS_CD_CAGRP_USER\u0000zone_id\u0000");
        jargonToSRB.put(catalogNames[230], "MDAS_CD_CANNO_USER\u0000user_name\u0000");
        jargonToSRB.put(catalogNames[276], "MDAS_CD_CANNO_USER\u0000user_name\u0000");
        jargonToSRB.put(catalogNames[354], "MDAS_CD_CANNO_USER\u0000zone_id\u0000");
        jargonToSRB.put(catalogNames[356], "MDAS_CD_CANNO_USER\u0000zone_id\u0000");
        jargonToSRB.put(catalogNames[149], "MDAS_CD_COOWN_USER\u0000user_name\u0000");
        jargonToSRB.put(catalogNames[352], "MDAS_CD_COOWN_USER\u0000zone_id\u0000");
        jargonToSRB.put(catalogNames[48], "MDAS_CD_CTKTOWNER\u0000user_name\u0000");
        jargonToSRB.put(catalogNames[348], "MDAS_CD_CTKTOWNER\u0000zone_id\u0000");
        jargonToSRB.put(catalogNames[49], "MDAS_CD_CTKTUSER\u0000user_name\u0000");
        jargonToSRB.put(catalogNames[349], "MDAS_CD_CTKTUSER\u0000zone_id\u0000");
        jargonToSRB.put(catalogNames[368], "MDAS_CD_DAGRP_USER\u0000user_name\u0000");
        jargonToSRB.put(catalogNames[370], "MDAS_CD_DAGRP_USER\u0000zone_id\u0000");
        jargonToSRB.put(catalogNames[130], "MDAS_CD_DAUDT_USER\u0000user_name\u0000");
        jargonToSRB.put(catalogNames[351], "MDAS_CD_DAUDT_USER\u0000zone_id\u0000");
        jargonToSRB.put(catalogNames[224], "MDAS_CD_DLOWN_USER\u0000user_name\u0000");
        jargonToSRB.put(catalogNames[353], "MDAS_CD_DLOWN_USER\u0000zone_id\u0000");
        jargonToSRB.put(catalogNames[41], "MDAS_CD_DTKTOWNER\u0000user_name\u0000");
        jargonToSRB.put(catalogNames[346], "MDAS_CD_DTKTOWNER\u0000zone_id\u0000");
        jargonToSRB.put(catalogNames[42], "MDAS_CD_DTKTUSER\u0000user_name\u0000");
        jargonToSRB.put(catalogNames[347], "MDAS_CD_DTKTUSER\u0000zone_id\u0000");
        jargonToSRB.put(catalogNames[35], "MDAS_CD_OWNER_USER\u0000user_name\u0000");
        jargonToSRB.put(catalogNames[345], "MDAS_CD_OWNER_USER\u0000zone_id\u0000");
        jargonToSRB.put(catalogNames[317], "MDAS_CD_PAR_USER\u0000user_modify_date\u0000");
        jargonToSRB.put(catalogNames[3], "MDAS_CD_PAR_USER\u0000user_name\u0000");
        jargonToSRB.put(catalogNames[318], "MDAS_CD_PAR_USER\u0000zone_id\u0000");
        jargonToSRB.put(catalogNames[241], "MDAS_CD_PIN_USER\u0000user_name\u0000");
        jargonToSRB.put(catalogNames[355], "MDAS_CD_PIN_USER\u0000zone_id\u0000");
        jargonToSRB.put(catalogNames[364], "MDAS_CD_RAGRP_USER\u0000user_name\u0000");
        jargonToSRB.put(catalogNames[366], "MDAS_CD_RAGRP_USER\u0000zone_id\u0000");
        jargonToSRB.put(catalogNames[341], "MDAS_CD_RSAC_USER\u0000user_name\u0000");
        jargonToSRB.put(catalogNames[343], "MDAS_CD_RSAC_USER\u0000zone_id\u0000");
        jargonToSRB.put(catalogNames[332], "MDAS_CD_RS_USER\u0000user_name\u0000");
        jargonToSRB.put(catalogNames[344], "MDAS_CD_RS_USER\u0000zone_id\u0000");
        jargonToSRB.put(catalogNames[329], "MDAS_CD_USER\u0000user_creation_date\u0000");
        jargonToSRB.put(catalogNames[147], "MDAS_CD_USER\u0000user_id\u0000");
        jargonToSRB.put(catalogNames[330], "MDAS_CD_USER\u0000user_modify_date\u0000");
        jargonToSRB.put(catalogNames[7], "MDAS_CD_USER\u0000user_name\u0000");
        jargonToSRB.put(catalogNames[311], "MDAS_CD_ZN_USER\u0000user_name\u0000");
        jargonToSRB.put(catalogNames[63], "MDAS_TD_1RSRC_CLASS\u0000rsrc_class_name\u0000");
        jargonToSRB.put(catalogNames[273], "MDAS_TD_2RSRC_CLASS\u0000rsrc_class_name\u0000");
        jargonToSRB.put(catalogNames[22], "MDAS_TD_ACTN\u0000action_desc\u0000");
        jargonToSRB.put(catalogNames[73], "MDAS_TD_ANNO_DOMN\u0000domain_desc\u0000");
        jargonToSRB.put(catalogNames[68], "MDAS_TD_AUTH_SCHM\u0000auth_scheme\u0000");
        jargonToSRB.put(catalogNames[374], "MDAS_TD_CADATA_GRP\u0000data_grp_name\u0000");
        jargonToSRB.put(catalogNames[375], "MDAS_TD_CAGRP_ACCS\u0000access_constraint\u0000");
        jargonToSRB.put(catalogNames[372], "MDAS_TD_CAGRP_DOMN\u0000domain_desc\u0000");
        jargonToSRB.put(catalogNames[231], "MDAS_TD_CANNO_DOMN\u0000domain_desc\u0000");
        jargonToSRB.put(catalogNames[277], "MDAS_TD_CANNO_DOMN\u0000domain_desc\u0000");
        jargonToSRB.put(catalogNames[376], "MDAS_TD_CCDATA_TYP\u0000data_typ_name\u0000");
        jargonToSRB.put(catalogNames[132], "MDAS_TD_COLLCONT\u0000container_name\u0000");
        jargonToSRB.put(catalogNames[57], "MDAS_TD_CONTAINER\u0000container_max_size\u0000");
        jargonToSRB.put(catalogNames[58], "MDAS_TD_CONTAINER\u0000container_name\u0000");
        jargonToSRB.put(catalogNames[226], "MDAS_TD_COOWN_DOMN\u0000domain_desc\u0000");
        jargonToSRB.put(catalogNames[52], "MDAS_TD_CTKTO_DOMN\u0000domain_desc\u0000");
        jargonToSRB.put(catalogNames[50], "MDAS_TD_CTKTU_DOMN\u0000domain_desc\u0000");
        jargonToSRB.put(catalogNames[369], "MDAS_TD_DAGRP_DOMN\u0000domain_desc\u0000");
        jargonToSRB.put(catalogNames[26], "MDAS_TD_DATA_2GRP\u0000data_grp_name\u0000");
        jargonToSRB.put(catalogNames[229], "MDAS_TD_DATA_3GRP\u0000coll_comments\u0000");
        jargonToSRB.put(catalogNames[228], "MDAS_TD_DATA_3GRP\u0000coll_cr_timestamp\u0000");
        jargonToSRB.put(catalogNames[227], "MDAS_TD_DATA_3GRP\u0000data_grp_name\u0000");
        jargonToSRB.put(catalogNames[280], "MDAS_TD_DATA_4GRP\u0000data_grp_name\u0000");
        jargonToSRB.put(catalogNames[282], "MDAS_TD_DATA_5GRP\u0000data_grp_name\u0000");
        jargonToSRB.put(catalogNames[151], "MDAS_TD_DATA_GRP\u0000coll_comments\u0000");
        jargonToSRB.put(catalogNames[150], "MDAS_TD_DATA_GRP\u0000coll_cr_timestamp\u0000");
        jargonToSRB.put(catalogNames[279], "MDAS_TD_DATA_GRP\u0000coll_link\u0000");
        jargonToSRB.put(catalogNames[367], "MDAS_TD_DATA_GRP\u0000coll_mod_timestamp\u0000");
        jargonToSRB.put(catalogNames[235], "MDAS_TD_DATA_GRP\u0000data_grp_id\u0000");
        jargonToSRB.put(catalogNames[15], "MDAS_TD_DATA_GRP\u0000data_grp_name\u0000");
        jargonToSRB.put(catalogNames[54], "MDAS_TD_DATA_GRP\u0000parent_grp_name\u0000");
        jargonToSRB.put(catalogNames[4], "MDAS_TD_DATA_TYP\u0000data_typ_name\u0000");
        jargonToSRB.put(catalogNames[131], "MDAS_TD_DAUDT_DOMN\u0000domain_desc\u0000");
        jargonToSRB.put(catalogNames[171], "MDAS_TD_DCRELGRP\u0000data_grp_name\u0000");
        jargonToSRB.put(catalogNames[390], "MDAS_TD_DEL_DATA_GRP\u0000data_grp_name\u0000");
        jargonToSRB.put(catalogNames[102], "MDAS_TD_DGRP_IXCOL\u0000data_grp_name\u0000");
        jargonToSRB.put(catalogNames[100], "MDAS_TD_DGRP_IXDS\u0000data_grp_name\u0000");
        jargonToSRB.put(catalogNames[101], "MDAS_TD_DGRP_IXDTP\u0000data_grp_name\u0000");
        jargonToSRB.put(catalogNames[105], "MDAS_TD_DGRP_MTCOL\u0000data_grp_name\u0000");
        jargonToSRB.put(catalogNames[104], "MDAS_TD_DGRP_MTDTP\u0000data_grp_name\u0000");
        jargonToSRB.put(catalogNames[103], "MDAS_TD_DGRP_MTHDS\u0000data_grp_name\u0000");
        jargonToSRB.put(catalogNames[112], "MDAS_TD_DGRP_STRUC\u0000data_grp_name\u0000");
        jargonToSRB.put(catalogNames[225], "MDAS_TD_DLOWN_DOMN\u0000domain_desc\u0000");
        jargonToSRB.put(catalogNames[9], "MDAS_TD_DOMN\u0000domain_desc\u0000");
        jargonToSRB.put(catalogNames[40], "MDAS_TD_DSTKT_ACCS\u0000access_constraint\u0000");
        jargonToSRB.put(catalogNames[8], "MDAS_TD_DS_ACCS\u0000access_constraint\u0000");
        jargonToSRB.put(catalogNames[146], "MDAS_TD_DS_ACCS\u0000access_id\u0000");
        jargonToSRB.put(catalogNames[32], "MDAS_TD_DS_ACCS\u0000access_list\u0000");
        jargonToSRB.put(catalogNames[79], "MDAS_TD_DS_ACCS\u0000access_privilege\u0000");
        jargonToSRB.put(catalogNames[53], "MDAS_TD_DTKTO_DOMN\u0000domain_desc\u0000");
        jargonToSRB.put(catalogNames[51], "MDAS_TD_DTKTU_DOMN\u0000domain_desc\u0000");
        jargonToSRB.put(catalogNames[108], "MDAS_TD_DTYP_IXCOL\u0000data_typ_name\u0000");
        jargonToSRB.put(catalogNames[106], "MDAS_TD_DTYP_IXDS\u0000data_typ_name\u0000");
        jargonToSRB.put(catalogNames[107], "MDAS_TD_DTYP_IXDTP\u0000data_typ_name\u0000");
        jargonToSRB.put(catalogNames[111], "MDAS_TD_DTYP_MTCOL\u0000data_typ_name\u0000");
        jargonToSRB.put(catalogNames[110], "MDAS_TD_DTYP_MTDTP\u0000data_typ_name\u0000");
        jargonToSRB.put(catalogNames[109], "MDAS_TD_DTYP_MTHDS\u0000data_typ_name\u0000");
        jargonToSRB.put(catalogNames[359], "MDAS_TD_DTYP_PARENT\u0000data_typ_name\u0000");
        jargonToSRB.put(catalogNames[399], "MDAS_TD_EXTAB_INFO\u0000ext_attr_comments\u0000");
        jargonToSRB.put(catalogNames[397], "MDAS_TD_EXTAB_INFO\u0000ext_attr_name\u0000");
        jargonToSRB.put(catalogNames[398], "MDAS_TD_EXTAB_INFO\u0000ext_attr_out_name\u0000");
        jargonToSRB.put(catalogNames[395], "MDAS_TD_EXTAB_INFO\u0000ext_schema_name\u0000");
        jargonToSRB.put(catalogNames[396], "MDAS_TD_EXTAB_INFO\u0000ext_table_name\u0000");
        jargonToSRB.put(catalogNames[25], "MDAS_TD_GRP_ACCS\u0000access_constraint\u0000");
        jargonToSRB.put(catalogNames[47], "MDAS_TD_GRTKT_ACCS\u0000access_constraint\u0000");
        jargonToSRB.put(catalogNames[183], "MDAS_TD_IDGRPUSER1\u0000user_id\u0000");
        jargonToSRB.put(catalogNames[181], "MDAS_TD_IDGRPUSER2\u0000user_id\u0000");
        jargonToSRB.put(catalogNames[270], "MDAS_TD_INT_LOCN\u0000netprefix\u0000");
        jargonToSRB.put(catalogNames[223], "MDAS_TD_LCK_ACCS\u0000access_constraint\u0000");
        jargonToSRB.put(catalogNames[55], "MDAS_TD_LOCN\u0000locn_desc\u0000");
        jargonToSRB.put(catalogNames[12], "MDAS_TD_LOCN\u0000netprefix\u0000");
        jargonToSRB.put(catalogNames[385], "MDAS_TD_ORDERBY\u0000orderby\u0000");
        jargonToSRB.put(catalogNames[66], "MDAS_TD_OWNER_DOMN\u0000domain_desc\u0000");
        jargonToSRB.put(catalogNames[361], "MDAS_TD_PARDOMN\u0000domain_desc\u0000");
        jargonToSRB.put(catalogNames[319], "MDAS_TD_PAR_DOMN\u0000domain_desc\u0000");
        jargonToSRB.put(catalogNames[357], "MDAS_TD_PAR_LOCN\u0000locn_desc\u0000");
        jargonToSRB.put(catalogNames[242], "MDAS_TD_PIN_DOMN\u0000domain_desc\u0000");
        jargonToSRB.put(catalogNames[365], "MDAS_TD_RAGRP_DOMN\u0000domain_desc\u0000");
        jargonToSRB.put(catalogNames[342], "MDAS_TD_RSAC_DOMN\u0000domain_desc\u0000");
        jargonToSRB.put(catalogNames[30], "MDAS_TD_RSRC_2TYP\u0000rsrc_typ_name\u0000");
        jargonToSRB.put(catalogNames[271], "MDAS_TD_RSRC_3TYP\u0000rsrc_typ_name\u0000");
        jargonToSRB.put(catalogNames[314], "MDAS_TD_RSRC_ACCS\u0000access_constraint\u0000");
        jargonToSRB.put(catalogNames[358], "MDAS_TD_RSRC_ACCS\u0000access_id\u0000");
        jargonToSRB.put(catalogNames[33], "MDAS_TD_RSRC_ACCS\u0000access_list\u0000");
        jargonToSRB.put(catalogNames[313], "MDAS_TD_RSRC_ACCS\u0000access_privilege\u0000");
        jargonToSRB.put(catalogNames[59], "MDAS_TD_RSRC_CLASS\u0000rsrc_class_name\u0000");
        jargonToSRB.put(catalogNames[363], "MDAS_TD_RSRC_PARENT\u0000rsrc_typ_name\u0000");
        jargonToSRB.put(catalogNames[13], "MDAS_TD_RSRC_TYP\u0000rsrc_typ_name\u0000");
        jargonToSRB.put(catalogNames[333], "MDAS_TD_RS_DOMN\u0000domain_desc\u0000");
        jargonToSRB.put(catalogNames[69], "MDAS_TD_SRVR_LOCN\u0000locn_desc\u0000");
        jargonToSRB.put(catalogNames[70], "MDAS_TD_SRVR_LOCN\u0000netprefix\u0000");
        jargonToSRB.put(catalogNames[295], "MDAS_TD_UDF\u0000udf\u0000");
        jargonToSRB.put(catalogNames[296], "MDAS_TD_UDF\u0000udf\u0000");
        jargonToSRB.put(catalogNames[297], "MDAS_TD_UDF\u0000udf\u0000");
        jargonToSRB.put(catalogNames[298], "MDAS_TD_UDF\u0000udf\u0000");
        jargonToSRB.put(catalogNames[299], "MDAS_TD_UDF\u0000udf\u0000");
        jargonToSRB.put(catalogNames[5], "MDAS_TD_USER_TYP\u0000user_typ_name\u0000");
        jargonToSRB.put(catalogNames[362], "MDAS_TD_UTYP_PARENT\u0000user_typ_name\u0000");
        jargonToSRB.put(catalogNames[304], "MDAS_TD_ZN_ATHSCHM\u0000auth_scheme\u0000");
        jargonToSRB.put(catalogNames[312], "MDAS_TD_ZN_DOMN\u0000domain_desc\u0000");
        jargonToSRB.put(catalogNames[360], "MDAS_TD_ZN_LOCN\u0000locn_desc\u0000");
        jargonToSRB.put(catalogNames[302], "MDAS_TD_ZN_LOCN\u0000netprefix\u0000");
        jargonToSRB.put(catalogNames[301], "MDAS_TD_ZONE\u0000local_zone_flag\u0000");
        jargonToSRB.put(catalogNames[303], "MDAS_TD_ZONE\u0000port_number\u0000");
        jargonToSRB.put(catalogNames[309], "MDAS_TD_ZONE\u0000zone_comments\u0000");
        jargonToSRB.put(catalogNames[310], "MDAS_TD_ZONE\u0000zone_contact\u0000");
        jargonToSRB.put(catalogNames[307], "MDAS_TD_ZONE\u0000zone_create_date\u0000");
        jargonToSRB.put(catalogNames[300], "MDAS_TD_ZONE\u0000zone_id\u0000");
        jargonToSRB.put(catalogNames[308], "MDAS_TD_ZONE\u0000zone_modify_date\u0000");
        jargonToSRB.put(catalogNames[306], "MDAS_TD_ZONE\u0000zone_status\u0000");
        jargonToSRB.put(catalogNames[294], "NONDISTINCT\u0000nondistinct\u0000");
        int n = 0;
        while (n < catalogNames.length) {
            jargonToSRBID.put(catalogNames[n], new Integer(n));
            ++n;
        }
        jargonToSRBID.put(DEFINABLE_METADATA_FOR_FILES, new Integer(-1));
        jargonToSRBID.put(DEFINABLE_METADATA_FOR_DIRECTORIES, new Integer(-2));
        jargonToSRBID.put(DEFINABLE_METADATA_FOR_USERS, new Integer(-3));
        jargonToSRBID.put(DEFINABLE_METADATA_FOR_RESOURCES, new Integer(-4));
        if (protocol == null) {
            protocol = new SRBProtocol();
        }
    }
}

