/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.mets;

import edu.harvard.hul.ois.mets.Name;
import edu.harvard.hul.ois.mets.Note;
import edu.harvard.hul.ois.mets.Role;
import edu.harvard.hul.ois.mets.Type;
import edu.harvard.hul.ois.mets.helper.MetsException;
import edu.harvard.hul.ois.mets.helper.MetsIDElement;
import edu.harvard.hul.ois.mets.helper.MetsReader;
import edu.harvard.hul.ois.mets.helper.MetsSerializable;
import edu.harvard.hul.ois.mets.helper.MetsValidator;
import edu.harvard.hul.ois.mets.helper.MetsWriter;
import edu.harvard.hul.ois.mets.helper.parser.Attribute;
import edu.harvard.hul.ois.mets.helper.parser.Attributes;
import edu.harvard.hul.ois.mets.helper.parser.Token;

public class Agent
extends MetsIDElement {
    private String _OTHERROLE;
    private String _OTHERTYPE;
    private Role _ROLE;
    private Type _TYPE;

    public Agent() {
        super("agent");
    }

    public String getOTHERROLE() {
        return this._OTHERROLE;
    }

    public String getOTHERTYPE() {
        return this._OTHERTYPE;
    }

    public Role getROLE() {
        return this._ROLE;
    }

    public Type getTYPE() {
        return this._TYPE;
    }

    public void setOTHERROLE(String string) {
        this._OTHERROLE = string;
    }

    public void setOTHERTYPE(String string) {
        this._OTHERTYPE = string;
    }

    public void setROLE(Role role) {
        this._ROLE = role;
    }

    public void setTYPE(Type type) {
        this._TYPE = type;
    }

    public static Agent reader(MetsReader metsReader) throws MetsException {
        Agent agent = new Agent();
        agent.read(metsReader);
        return agent;
    }

    public void read(MetsReader metsReader) throws MetsException {
        Object object;
        Token token = metsReader.getStart(this._localName);
        this._qName = token.getQName();
        this._namespace = token.getNamespace();
        this._localName = token.getLocalName();
        Attributes attributes = token.getAttributes();
        while (attributes.hasNext()) {
            object = attributes.next();
            String string = ((Attribute)object).getLocalName();
            String string2 = ((Attribute)object).getValue();
            if (string.equals("ID")) {
                this.setID(string2);
                continue;
            }
            if (string.equals("ROLE")) {
                this.setROLE(Role.parse(string2));
                continue;
            }
            if (string.equals("OTHERROLE")) {
                this.setOTHERROLE(string2);
                continue;
            }
            if (string.equals("TYPE")) {
                this.setTYPE(Type.parse(string2));
                continue;
            }
            if (string.equals("OTHERTYPE")) {
                this.setOTHERTYPE(string2);
                continue;
            }
            if (this._attrs == null) {
                this._attrs = new Attributes();
            }
            this._attrs.add(new Attribute(((Attribute)object).getQName(), string2, '\"'));
        }
        if (metsReader.atStart("name")) {
            object = Name.reader(metsReader);
            this._content.add(object);
        }
        while (metsReader.atStart("note")) {
            object = Note.reader(metsReader);
            this._content.add(object);
        }
        metsReader.getEnd(this._localName);
    }

    public void write(MetsWriter metsWriter) throws MetsException {
        Object object;
        metsWriter.start(this._qName);
        if (this._ID != null) {
            metsWriter.attribute("ID", this._ID);
        }
        metsWriter.attribute("ROLE", this._ROLE.toString());
        if (this._OTHERROLE != null) {
            metsWriter.attribute("OTHERROLE", this._OTHERROLE);
        }
        if (this._TYPE != null) {
            metsWriter.attribute("TYPE", this._TYPE.toString());
        }
        if (this._OTHERTYPE != null) {
            metsWriter.attribute("OTHERTYPE", this._OTHERTYPE);
        }
        if (this._attrs != null) {
            this._attrs.reset();
            while (this._attrs.hasNext()) {
                object = this._attrs.next();
                metsWriter.attribute(((Attribute)object).getQName(), ((Attribute)object).getValue());
            }
        }
        object = this._content.iterator();
        while (object.hasNext()) {
            ((MetsSerializable)object.next()).write(metsWriter);
        }
        metsWriter.end(this._qName);
    }

    public void validateThis(MetsValidator metsValidator) throws MetsException {
        if (this._ROLE == null) {
            throw new MetsException("No agent ROLE");
        }
        if (this._ROLE.toString().equals("OTHER")) {
            if (this._OTHERROLE == null) {
                System.err.println("No agent OTHERROLE");
            }
        } else if (this._OTHERROLE != null) {
            System.err.println("Agent OTHERROLE only valid with ROLE=\"OTHER\"");
        }
        if (this._TYPE != null) {
            if (this._TYPE.toString().equals("OTHER")) {
                if (this._OTHERTYPE == null) {
                    System.err.println("No agent OTHERTYPE");
                }
            } else if (this._OTHERTYPE != null) {
                System.err.println("Agent OTHERTYPE only valid with TYPE=\"OTHER\"");
            }
        }
        if (this._content == null || this._content.isEmpty()) {
            throw new MetsException("No agent name");
        }
        this._valid = true;
    }
}

