/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.mets;

import edu.harvard.hul.ois.mets.Actuate;
import edu.harvard.hul.ois.mets.Loctype;
import edu.harvard.hul.ois.mets.Show;
import edu.harvard.hul.ois.mets.helper.MetsException;
import edu.harvard.hul.ois.mets.helper.MetsIDElement;
import edu.harvard.hul.ois.mets.helper.MetsReader;
import edu.harvard.hul.ois.mets.helper.MetsValidator;
import edu.harvard.hul.ois.mets.helper.MetsWriter;
import edu.harvard.hul.ois.mets.helper.parser.Attribute;
import edu.harvard.hul.ois.mets.helper.parser.Attributes;
import edu.harvard.hul.ois.mets.helper.parser.Token;

public class FLocat
extends MetsIDElement {
    private Loctype _LOCTYPE;
    private String _OTHERLOCTYPE;
    private String _USE;
    private Actuate _xlinkActuate;
    private String _xlinkArcrole;
    private String _xlinkHref;
    private String _xlinkRole;
    private Show _xlinkShow;
    private String _xlinkTitle;

    public FLocat() {
        super("FLocat");
    }

    public Loctype getLOCTYPE() {
        return this._LOCTYPE;
    }

    public String getOTHERLOCTYPE() {
        return this._OTHERLOCTYPE;
    }

    public String getUSE() {
        return this._USE;
    }

    public Actuate getXlinkActuate() {
        return this._xlinkActuate;
    }

    public String getXlinkArcrole() {
        return this._xlinkArcrole;
    }

    public String getXlinkHref() {
        return this._xlinkHref;
    }

    public String getXlinkRole() {
        return this._xlinkRole;
    }

    public Show getXlinkShow() {
        return this._xlinkShow;
    }

    public String getXlinkTitle() {
        return this._xlinkTitle;
    }

    public void setLOCTYPE(Loctype loctype) {
        this._LOCTYPE = loctype;
    }

    public void setOTHERLOCTYPE(String string) {
        this._OTHERLOCTYPE = string;
    }

    public void setUSE(String string) {
        this._USE = string;
    }

    public void setXlinkActuate(Actuate actuate) {
        this._xlinkActuate = actuate;
    }

    public void setXlinkArcrole(String string) {
        this._xlinkArcrole = string;
    }

    public void setXlinkHref(String string) {
        this._xlinkHref = string;
    }

    public void setXlinkRole(String string) {
        this._xlinkRole = string;
    }

    public void setXlinkShow(Show show) {
        this._xlinkShow = show;
    }

    public void setXlinkTitle(String string) {
        this._xlinkTitle = string;
    }

    public static FLocat reader(MetsReader metsReader) throws MetsException {
        FLocat fLocat = new FLocat();
        fLocat.read(metsReader);
        return fLocat;
    }

    public void read(MetsReader metsReader) throws MetsException {
        Token token = metsReader.getStart(this._localName);
        this._qName = token.getQName();
        this._namespace = token.getNamespace();
        this._localName = token.getLocalName();
        Attributes attributes = token.getAttributes();
        while (attributes.hasNext()) {
            Attribute attribute = attributes.next();
            String string = attribute.getQName();
            String string2 = attribute.getLocalName();
            String string3 = attribute.getValue();
            if (string2.equals("ID")) {
                this.setID(string3);
                continue;
            }
            if (string2.equals("LOCTYPE")) {
                this.setLOCTYPE(Loctype.parse(string3));
                continue;
            }
            if (string2.equals("OTHERLOCTYPE")) {
                this.setOTHERLOCTYPE(string3);
                continue;
            }
            if (string2.equals("USE")) {
                this.setUSE(string3);
                continue;
            }
            if (string.equals("xlink:href")) {
                this.setXlinkHref(string3);
                continue;
            }
            if (string.equals("xlink:role")) {
                this.setXlinkRole(string3);
                continue;
            }
            if (string.equals("xlink:arcrole")) {
                this.setXlinkArcrole(string3);
                continue;
            }
            if (string.equals("xlink:title")) {
                this.setXlinkTitle(string3);
                continue;
            }
            if (string.equals("xlink:show")) {
                this.setXlinkShow(Show.parse(string3));
                continue;
            }
            if (string.equals("xlink:actuate")) {
                this.setXlinkActuate(Actuate.parse(string3));
                continue;
            }
            if (string.equals("xlink:type")) continue;
            if (this._attrs == null) {
                this._attrs = new Attributes();
            }
            this._attrs.add(new Attribute(string, string3, '\"'));
        }
        if (metsReader.atEnd(this._localName)) {
            metsReader.getEnd(this._localName);
        }
    }

    public void write(MetsWriter metsWriter) throws MetsException {
        metsWriter.start(this._qName);
        if (this._ID != null) {
            metsWriter.attribute("ID", this._ID);
        }
        metsWriter.attribute("LOCTYPE", this._LOCTYPE.toString());
        if (this._OTHERLOCTYPE != null) {
            metsWriter.attribute("OTHERLOCTYPE", this._OTHERLOCTYPE);
        }
        if (this._USE != null) {
            metsWriter.attribute("USE", this._USE);
        }
        metsWriter.attribute("xlink:type", "simple");
        metsWriter.attribute("xlink:href", this._xlinkHref);
        if (this._xlinkRole != null) {
            metsWriter.attribute("xlink:role", this._xlinkRole);
        }
        if (this._xlinkArcrole != null) {
            metsWriter.attribute("xlink:arcrole", this._xlinkArcrole);
        }
        if (this._xlinkTitle != null) {
            metsWriter.attribute("xlink:title", this._xlinkTitle);
        }
        if (this._xlinkShow != null) {
            metsWriter.attribute("xlink:show", this._xlinkShow.toString());
        }
        if (this._xlinkActuate != null) {
            metsWriter.attribute("xlink:actuate", this._xlinkActuate.toString());
        }
        if (this._attrs != null) {
            this._attrs.reset();
            while (this._attrs.hasNext()) {
                Attribute attribute = this._attrs.next();
                metsWriter.attribute(attribute.getQName(), attribute.getValue());
            }
        }
        metsWriter.end(this._qName);
    }

    public void validateThis(MetsValidator metsValidator) throws MetsException {
        if (this._LOCTYPE == null) {
            throw new MetsException("No value for FLocat LOCTYPE");
        }
        if (this._LOCTYPE.toString().equals("OTHER")) {
            if (this._OTHERLOCTYPE == null) {
                System.err.println("No FLocat OTHERLOCTYPE value");
            }
        } else if (this._OTHERLOCTYPE != null) {
            System.err.println("FLocat OTHERLOCTYPE only valid with LOCTYPE=\"OTHER\"");
        }
        if (this._xlinkHref == null) {
            throw new MetsException("No FLocat xlink:href value");
        }
        this._valid = true;
    }
}

