/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.mets;

import edu.harvard.hul.ois.mets.Area;
import edu.harvard.hul.ois.mets.File;
import edu.harvard.hul.ois.mets.Par;
import edu.harvard.hul.ois.mets.Seq;
import edu.harvard.hul.ois.mets.helper.MetsElement;
import edu.harvard.hul.ois.mets.helper.MetsException;
import edu.harvard.hul.ois.mets.helper.MetsIDElement;
import edu.harvard.hul.ois.mets.helper.MetsReader;
import edu.harvard.hul.ois.mets.helper.MetsValidator;
import edu.harvard.hul.ois.mets.helper.MetsWriter;
import edu.harvard.hul.ois.mets.helper.parser.Attribute;
import edu.harvard.hul.ois.mets.helper.parser.Attributes;
import edu.harvard.hul.ois.mets.helper.parser.Token;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class Fptr
extends MetsIDElement {
    private List _CONTENTIDS = new ArrayList();
    private Map _FILEID = new HashMap();

    public Fptr() {
        super("fptr");
    }

    public List getCONTENTIDS() {
        return this._CONTENTIDS;
    }

    public Map getFILEID() {
        return this._FILEID;
    }

    public void setCONTENTIDS(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            this._CONTENTIDS.add(stringTokenizer.nextToken());
        }
    }

    public void setFILEID(String string) {
        this.setFILEID(string, null);
    }

    public void setFILEID(String string, File file) {
        this._FILEID.clear();
        this._FILEID.put(string, file);
        this._valid = false;
    }

    public static Fptr reader(MetsReader metsReader) throws MetsException {
        Fptr fptr = new Fptr();
        fptr.read(metsReader);
        return fptr;
    }

    public void read(MetsReader metsReader) throws MetsException {
        Object object;
        Token token = metsReader.getStart(this._localName);
        this._qName = token.getQName();
        this._namespace = token.getNamespace();
        this._localName = token.getLocalName();
        Attributes attributes = token.getAttributes();
        while (attributes.hasNext()) {
            object = attributes.next();
            String string = ((Attribute)object).getLocalName();
            String string2 = ((Attribute)object).getValue();
            if (string.equals("ID")) {
                this.setID(string2);
                continue;
            }
            if (string.equals("FILEID")) {
                this.setFILEID(string2);
                continue;
            }
            if (string.equals("CONTENTIDS")) {
                this.setCONTENTIDS(string2);
                continue;
            }
            if (this._attrs == null) {
                this._attrs = new Attributes();
            }
            this._attrs.add(new Attribute(((Attribute)object).getQName(), string2, '\"'));
        }
        while (metsReader.atStart("par")) {
            object = Par.reader(metsReader);
            this._content.add(object);
        }
        while (metsReader.atStart("seq")) {
            object = Seq.reader(metsReader);
            this._content.add(object);
        }
        while (metsReader.atStart("area")) {
            object = Area.reader(metsReader);
            this._content.add(object);
        }
        if (metsReader.atEnd(this._localName)) {
            metsReader.getEnd(this._localName);
        }
    }

    public void write(MetsWriter metsWriter) throws MetsException {
        Object object;
        metsWriter.start(this._qName);
        if (this._ID != null) {
            metsWriter.attribute("ID", this._ID);
        }
        if (!this._FILEID.isEmpty()) {
            metsWriter.attributeName("FILEID");
            object = this._FILEID.keySet().iterator();
            while (object.hasNext()) {
                metsWriter.attributeValue((String)object.next());
            }
        }
        if (!this._CONTENTIDS.isEmpty()) {
            metsWriter.attributeName("CONTENTIDS");
            int n = this._CONTENTIDS.size();
            int n2 = 0;
            while (n2 < n) {
                metsWriter.attributeValue((String)this._CONTENTIDS.get(n2));
                ++n2;
            }
        }
        if (this._attrs != null) {
            this._attrs.reset();
            while (this._attrs.hasNext()) {
                object = this._attrs.next();
                metsWriter.attribute(((Attribute)object).getQName(), ((Attribute)object).getValue());
            }
        }
        object = this._content.iterator();
        while (object.hasNext()) {
            ((MetsElement)object.next()).write(metsWriter);
        }
        metsWriter.end(this._qName);
    }

    public void validateThisIDREFs(MetsValidator metsValidator) throws MetsException {
        if (!this._FILEID.isEmpty()) {
            Iterator iterator = this._FILEID.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                boolean bl = false;
                Map map = metsValidator.getIDs();
                Iterator iterator2 = map.keySet().iterator();
                while (iterator2.hasNext()) {
                    String string2 = (String)iterator2.next();
                    if (!string.equals(string2)) continue;
                    bl = true;
                    this.setFILEID(string, (File)map.get(string2));
                    break;
                }
                if (bl) continue;
                throw new MetsException("Can't resolve IDREF: " + string);
            }
        }
    }
}

