/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.mets;

import edu.harvard.hul.ois.mets.Actuate;
import edu.harvard.hul.ois.mets.Loctype;
import edu.harvard.hul.ois.mets.Mdtype;
import edu.harvard.hul.ois.mets.Show;
import edu.harvard.hul.ois.mets.helper.MetsException;
import edu.harvard.hul.ois.mets.helper.MetsIDElement;
import edu.harvard.hul.ois.mets.helper.MetsReader;
import edu.harvard.hul.ois.mets.helper.MetsValidator;
import edu.harvard.hul.ois.mets.helper.MetsWriter;
import edu.harvard.hul.ois.mets.helper.parser.Attribute;
import edu.harvard.hul.ois.mets.helper.parser.Attributes;
import edu.harvard.hul.ois.mets.helper.parser.Token;

public class MdRef
extends MetsIDElement {
    private String _LABEL;
    private Loctype _LOCTYPE;
    private Mdtype _MDTYPE;
    private String _MIMETYPE;
    private String _OTHERLOCTYPE;
    private String _OTHERMDTYPE;
    private Actuate _xlinkActuate;
    private String _xlinkArcrole;
    private String _xlinkHref;
    private String _xlinkRole;
    private Show _xlinkShow;
    private String _xlinkTitle;
    private String _XPTR;

    public MdRef() {
        super("mdRef");
    }

    public String getLABEL() {
        return this._LABEL;
    }

    public Loctype getLOCTYPE() {
        return this._LOCTYPE;
    }

    public Mdtype getMDTYPE() {
        return this._MDTYPE;
    }

    public String getMIMETYPE() {
        return this._MIMETYPE;
    }

    public String getOTHERLOCTYPE() {
        return this._OTHERLOCTYPE;
    }

    public String getOTHERMDTYPE() {
        return this._OTHERMDTYPE;
    }

    public Actuate getXlinkActuate() {
        return this._xlinkActuate;
    }

    public String getXlinkArcrole() {
        return this._xlinkArcrole;
    }

    public String getXlinkHref() {
        return this._xlinkHref;
    }

    public String getXlinkRole() {
        return this._xlinkRole;
    }

    public Show getXlinkShow() {
        return this._xlinkShow;
    }

    public String getXlinkTitle() {
        return this._xlinkTitle;
    }

    public String getXPTR() {
        return this._XPTR;
    }

    public void setLABEL(String string) {
        this._LABEL = string;
    }

    public void setLOCTYPE(Loctype loctype) {
        this._LOCTYPE = loctype;
    }

    public void setMDTYPE(Mdtype mdtype) {
        this._MDTYPE = mdtype;
    }

    public void setMIMETYPE(String string) {
        this._MIMETYPE = string;
    }

    public void setOTHERLOCTYPE(String string) {
        this._OTHERLOCTYPE = string;
    }

    public void setOTHERMDTYPE(String string) {
        this._OTHERMDTYPE = string;
    }

    public void setXlinkActuate(Actuate actuate) {
        this._xlinkActuate = actuate;
    }

    public void setXlinkArcrole(String string) {
        this._xlinkArcrole = string;
    }

    public void setXlinkHref(String string) {
        this._xlinkHref = string;
    }

    public void setXlinkRole(String string) {
        this._xlinkRole = string;
    }

    public void setXlinkShow(Show show) {
        this._xlinkShow = show;
    }

    public void setXlinkTitle(String string) {
        this._xlinkTitle = string;
    }

    public void setXPTR(String string) {
        this._XPTR = string;
    }

    public static MdRef reader(MetsReader metsReader) throws MetsException {
        MdRef mdRef = new MdRef();
        mdRef.read(metsReader);
        return mdRef;
    }

    public void read(MetsReader metsReader) throws MetsException {
        Token token = metsReader.getStart(this._localName);
        this._qName = token.getQName();
        this._namespace = token.getNamespace();
        this._localName = token.getLocalName();
        Attributes attributes = token.getAttributes();
        while (attributes.hasNext()) {
            Attribute attribute = attributes.next();
            String string = attribute.getQName();
            String string2 = attribute.getLocalName();
            String string3 = attribute.getValue();
            if (string2.equals("ID")) {
                this.setID(string3);
                continue;
            }
            if (string2.equals("LOCTYPE")) {
                this.setLOCTYPE(Loctype.parse(string3));
                continue;
            }
            if (string2.equals("OTHERLOCTYPE")) {
                this.setOTHERLOCTYPE(string3);
                continue;
            }
            if (string.equals("xlink:href")) {
                this.setXlinkHref(string3);
                continue;
            }
            if (string.equals("xlink:role")) {
                this.setXlinkRole(string3);
                continue;
            }
            if (string.equals("xlink:arcrole")) {
                this.setXlinkArcrole(string3);
                continue;
            }
            if (string.equals("xlink:title")) {
                this.setXlinkTitle(string3);
                continue;
            }
            if (string.equals("xlink:show")) {
                this.setXlinkShow(Show.parse(string3));
                continue;
            }
            if (string.equals("xlink:actuate")) {
                this.setXlinkActuate(Actuate.parse(string3));
                continue;
            }
            if (string2.equals("MIMETYPE")) {
                this.setMIMETYPE(string3);
                continue;
            }
            if (string2.equals("MDTYPE")) {
                this.setMDTYPE(Mdtype.parse(string3));
                continue;
            }
            if (string2.equals("OTHERMDTYPE")) {
                this.setOTHERMDTYPE(string3);
                continue;
            }
            if (string2.equals("LABEL")) {
                this.setLABEL(string3);
                continue;
            }
            if (string2.equals("XPTR")) {
                this.setXPTR(string3);
                continue;
            }
            if (string.equals("xlink:type")) continue;
            if (this._attrs == null) {
                this._attrs = new Attributes();
            }
            this._attrs.add(new Attribute(string, string3, '\"'));
        }
        if (metsReader.atEnd(this._localName)) {
            metsReader.getEnd(this._localName);
        }
    }

    public void write(MetsWriter metsWriter) throws MetsException {
        metsWriter.start(this._qName);
        if (this._ID != null) {
            metsWriter.attribute("ID", this._ID);
        }
        metsWriter.attribute("LOCTYPE", this._LOCTYPE.toString());
        if (this._OTHERLOCTYPE != null) {
            metsWriter.attribute("OTHERLOCTYPE", this._OTHERLOCTYPE);
        }
        metsWriter.attribute("xlink:type", "simple");
        metsWriter.attribute("xlink:href", this._xlinkHref);
        if (this._xlinkRole != null) {
            metsWriter.attribute("xlink:role", this._xlinkRole);
        }
        if (this._xlinkArcrole != null) {
            metsWriter.attribute("xlink:arcrole", this._xlinkArcrole);
        }
        if (this._xlinkTitle != null) {
            metsWriter.attribute("xlink:title", this._xlinkTitle);
        }
        if (this._xlinkShow != null) {
            metsWriter.attribute("xlink:show", this._xlinkShow.toString());
        }
        if (this._xlinkActuate != null) {
            metsWriter.attribute("xlink:actuate", this._xlinkActuate.toString());
        }
        metsWriter.attribute("MDTYPE", this._MDTYPE.toString());
        if (this._OTHERMDTYPE != null) {
            metsWriter.attribute("OTHERMDTYPE", this._OTHERMDTYPE);
        }
        if (this._MIMETYPE != null) {
            metsWriter.attribute("MIMETYPE", this._MIMETYPE);
        }
        if (this._LABEL != null) {
            metsWriter.attribute("LABEL", this._LABEL);
        }
        if (this._XPTR != null) {
            metsWriter.attribute("XPTR", this._XPTR);
        }
        if (this._attrs != null) {
            this._attrs.reset();
            while (this._attrs.hasNext()) {
                Attribute attribute = this._attrs.next();
                metsWriter.attribute(attribute.getQName(), attribute.getValue());
            }
        }
        metsWriter.end(this._qName);
    }

    public void validateThis(MetsValidator metsValidator) throws MetsException {
        if (this._LOCTYPE == null) {
            throw new MetsException("No mdRef LOCTYPE value");
        }
        if (this._LOCTYPE.toString().equals("OTHER")) {
            if (this._OTHERLOCTYPE == null) {
                System.err.println("No mdRef OTHERLOCTYPE value");
            }
        } else if (this._OTHERLOCTYPE != null) {
            System.err.println("mdRef OTHERLOCTYPE only valid with LOCTYPE=\"OTHER\"");
        }
        if (this._xlinkHref == null) {
            throw new MetsException("No value for mdRef xlink:href");
        }
        if (this._MDTYPE == null) {
            throw new MetsException("No value for mdRef MDTYPE");
        }
        if (this._MDTYPE.toString().equals("OTHER")) {
            if (this._OTHERMDTYPE == null) {
                System.err.println("No mdRef OTHERMDTYPE value");
            }
        } else if (this._OTHERMDTYPE != null) {
            System.err.println("mdRef OTHERMDTYPE only valid with MDTYPE=\"OTHER\"");
        }
        this._valid = true;
    }
}

