/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.mets;

import edu.harvard.hul.ois.mets.Agent;
import edu.harvard.hul.ois.mets.AltRecordID;
import edu.harvard.hul.ois.mets.helper.DateTime;
import edu.harvard.hul.ois.mets.helper.MetsElement;
import edu.harvard.hul.ois.mets.helper.MetsException;
import edu.harvard.hul.ois.mets.helper.MetsIDElement;
import edu.harvard.hul.ois.mets.helper.MetsReader;
import edu.harvard.hul.ois.mets.helper.MetsWriter;
import edu.harvard.hul.ois.mets.helper.parser.Attribute;
import edu.harvard.hul.ois.mets.helper.parser.Attributes;
import edu.harvard.hul.ois.mets.helper.parser.Token;
import java.util.Date;

public class MetsHdr
extends MetsIDElement {
    private Date _CREATEDATE;
    private Date _LASTMODDATE;
    private String _RECORDSTATUS;

    public MetsHdr() {
        super("metsHdr");
    }

    public Date getCREATEDATE() {
        return this._CREATEDATE;
    }

    public Date getLASTMODDATE() {
        return this._LASTMODDATE;
    }

    public String getRECORDSTATUS() {
        return this._RECORDSTATUS;
    }

    public void setCREATEDATE(Date date) {
        this._CREATEDATE = date;
    }

    public void setLASTMODDATE(Date date) {
        this._LASTMODDATE = date;
    }

    public void setRECORDSTATUS(String string) {
        this._RECORDSTATUS = string;
    }

    public static MetsHdr reader(MetsReader metsReader) throws MetsException {
        MetsHdr metsHdr = new MetsHdr();
        metsHdr.read(metsReader);
        return metsHdr;
    }

    public void read(MetsReader metsReader) throws MetsException {
        Object object;
        Token token = metsReader.getStart(this._localName);
        this._qName = token.getQName();
        this._namespace = token.getNamespace();
        this._localName = token.getLocalName();
        Attributes attributes = token.getAttributes();
        while (attributes.hasNext()) {
            object = attributes.next();
            String string = ((Attribute)object).getLocalName();
            String string2 = ((Attribute)object).getValue();
            if (string.equals("ID")) {
                this.setID(string2);
                continue;
            }
            if (string.equals("CREATEDATE")) {
                try {
                    this.setCREATEDATE(DateTime.parse(string2));
                    continue;
                }
                catch (Exception exception) {
                    throw new MetsException(exception.toString());
                }
            }
            if (string.equals("LASTMODDATE")) {
                try {
                    this.setLASTMODDATE(DateTime.parse(string2));
                    continue;
                }
                catch (Exception exception) {
                    throw new MetsException(exception.toString());
                }
            }
            if (string.equals("RECORDSTATUS")) {
                this.setRECORDSTATUS(string2);
                continue;
            }
            if (this._attrs == null) {
                this._attrs = new Attributes();
            }
            this._attrs.add(new Attribute(((Attribute)object).getQName(), string2, '\"'));
        }
        while (metsReader.atStart("agent")) {
            object = Agent.reader(metsReader);
            this._content.add(object);
        }
        while (metsReader.atStart("altRecordID")) {
            object = AltRecordID.reader(metsReader);
            this._content.add(object);
        }
        if (metsReader.atEnd(this._localName)) {
            metsReader.getEnd(this._localName);
        }
    }

    public void write(MetsWriter metsWriter) throws MetsException {
        Object object;
        metsWriter.start(this._qName);
        if (this._ID != null) {
            metsWriter.attribute("ID", this._ID);
        }
        if (this._CREATEDATE != null) {
            metsWriter.attribute("CREATEDATE", DateTime.format(this._CREATEDATE));
        }
        if (this._LASTMODDATE != null) {
            metsWriter.attribute("LASTMODDATE", DateTime.format(this._LASTMODDATE));
        }
        if (this._RECORDSTATUS != null) {
            metsWriter.attribute("RECORDSTATUS", this._RECORDSTATUS);
        }
        if (this._attrs != null) {
            this._attrs.reset();
            while (this._attrs.hasNext()) {
                object = this._attrs.next();
                metsWriter.attribute(((Attribute)object).getQName(), ((Attribute)object).getValue());
            }
        }
        if (this._content != null) {
            object = this._content.iterator();
            while (object.hasNext()) {
                ((MetsElement)object.next()).write(metsWriter);
            }
        }
        metsWriter.end(this._qName);
    }
}

