/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.mets;

import edu.harvard.hul.ois.mets.helper.MetsException;
import edu.harvard.hul.ois.mets.helper.MetsReader;
import edu.harvard.hul.ois.mets.helper.MetsSerializable;
import edu.harvard.hul.ois.mets.helper.MetsVElement;
import edu.harvard.hul.ois.mets.helper.MetsValidator;
import edu.harvard.hul.ois.mets.helper.MetsWriter;
import edu.harvard.hul.ois.mets.helper.PCData;
import edu.harvard.hul.ois.mets.helper.parser.Attribute;
import edu.harvard.hul.ois.mets.helper.parser.Attributes;
import edu.harvard.hul.ois.mets.helper.parser.Token;

public class Name
extends MetsVElement {
    public Name() {
        super("name");
    }

    public static Name reader(MetsReader metsReader) throws MetsException {
        Name name = new Name();
        name.read(metsReader);
        return name;
    }

    public void read(MetsReader metsReader) throws MetsException {
        Token token = metsReader.getStart(this._localName);
        this._qName = token.getQName();
        this._namespace = token.getNamespace();
        this._localName = token.getLocalName();
        Attributes attributes = token.getAttributes();
        while (attributes.hasNext()) {
            Attribute attribute = attributes.next();
            String string = attribute.getQName();
            String string2 = attribute.getValue();
            if (this._attrs == null) {
                this._attrs = new Attributes();
            }
            this._attrs.add(new Attribute(string, string2, '\"'));
        }
        if (metsReader.atText()) {
            this._content.add(PCData.reader(metsReader));
        }
        metsReader.getEnd(this._localName);
    }

    public void write(MetsWriter metsWriter) throws MetsException {
        Object object;
        metsWriter.start(this._qName);
        if (this._attrs != null) {
            this._attrs.reset();
            while (this._attrs.hasNext()) {
                object = this._attrs.next();
                metsWriter.attribute(((Attribute)object).getQName(), ((Attribute)object).getValue());
            }
        }
        object = this._content.iterator();
        while (object.hasNext()) {
            ((MetsSerializable)object.next()).write(metsWriter);
        }
        metsWriter.end(this._qName);
    }

    public void validateThis(MetsValidator metsValidator) throws MetsException {
        if (this._content == null || this._content.isEmpty()) {
            throw new MetsException("No name content");
        }
        this._valid = true;
    }
}

