/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.mets;

import edu.harvard.hul.ois.mets.DmdSec;
import edu.harvard.hul.ois.mets.helper.Any;
import edu.harvard.hul.ois.mets.helper.MetsElement;
import edu.harvard.hul.ois.mets.helper.MetsException;
import edu.harvard.hul.ois.mets.helper.MetsIDElement;
import edu.harvard.hul.ois.mets.helper.MetsReader;
import edu.harvard.hul.ois.mets.helper.MetsVElement;
import edu.harvard.hul.ois.mets.helper.MetsValidator;
import edu.harvard.hul.ois.mets.helper.MetsWriter;
import edu.harvard.hul.ois.mets.helper.parser.Attribute;
import edu.harvard.hul.ois.mets.helper.parser.Attributes;
import edu.harvard.hul.ois.mets.helper.parser.Token;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public class Stream
extends MetsVElement {
    private Map _ADMID = new HashMap();
    private Map _DMDID = new HashMap();
    private String _OWNERID;
    private String _streamType;

    public Stream() {
        super("stream");
    }

    public Map getADMID() {
        return this._ADMID;
    }

    public Map getDMDID() {
        return this._DMDID;
    }

    public String getOWNERID() {
        return this._OWNERID;
    }

    public String getStreamType() {
        return this._streamType;
    }

    public void setADMID(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            this.setADMID(stringTokenizer.nextToken(), null);
        }
    }

    public void setADMID(String string, MetsIDElement metsIDElement) {
        this._ADMID.put(string, metsIDElement);
        this._valid = false;
    }

    public void setDMDID(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            this.setDMDID(stringTokenizer.nextToken(), null);
        }
    }

    public void setDMDID(String string, DmdSec dmdSec) {
        this._DMDID.put(string, dmdSec);
        this._valid = false;
    }

    public void setOWNERID(String string) {
        this._OWNERID = string;
    }

    public void setStreamType(String string) {
        this._streamType = string;
    }

    public static Stream reader(MetsReader metsReader) throws MetsException {
        Stream stream = new Stream();
        stream.read(metsReader);
        return stream;
    }

    public void read(MetsReader metsReader) throws MetsException {
        Object object;
        Token token = metsReader.getStart(this._localName);
        this._qName = token.getQName();
        this._namespace = token.getNamespace();
        this._localName = token.getLocalName();
        Attributes attributes = token.getAttributes();
        while (attributes.hasNext()) {
            object = attributes.next();
            String string = ((Attribute)object).getQName();
            String string2 = ((Attribute)object).getLocalName();
            String string3 = ((Attribute)object).getValue();
            if (string2.equals("streamType")) {
                this.setStreamType(string3);
                continue;
            }
            if (string2.equals("OWNERID")) {
                this.setOWNERID(string3);
                continue;
            }
            if (string2.equals("ADMID")) {
                this.setADMID(string3);
                continue;
            }
            if (string2.equals("DMDID")) {
                this.setDMDID(string3);
                continue;
            }
            if (this._attrs == null) {
                this._attrs = new Attributes();
            }
            this._attrs.add(new Attribute(((Attribute)object).getQName(), string3, '\"'));
        }
        while (metsReader.atStart()) {
            object = Any.reader(metsReader);
            this._content.add(object);
        }
        metsReader.getEnd(this._localName);
    }

    public void write(MetsWriter metsWriter) throws MetsException {
        Object object;
        metsWriter.start(this._qName);
        if (this._streamType != null) {
            metsWriter.attribute("streaType", this._streamType);
        }
        if (this._OWNERID != null) {
            metsWriter.attribute("OWNERID", this._OWNERID);
        }
        if (!this._ADMID.isEmpty()) {
            metsWriter.attributeName("ADMID");
            object = this._ADMID.keySet().iterator();
            while (object.hasNext()) {
                metsWriter.attributeValue((String)object.next());
            }
        }
        if (!this._DMDID.isEmpty()) {
            metsWriter.attributeName("DMDID");
            object = this._DMDID.keySet().iterator();
            while (object.hasNext()) {
                metsWriter.attributeValue((String)object.next());
            }
        }
        if (this._attrs != null) {
            this._attrs.reset();
            while (this._attrs.hasNext()) {
                object = this._attrs.next();
                metsWriter.attribute(((Attribute)object).getQName(), ((Attribute)object).getValue());
            }
        }
        object = this._content.iterator();
        while (object.hasNext()) {
            ((MetsElement)object.next()).write(metsWriter);
        }
        metsWriter.end(this._qName);
    }

    public void validateThisIDREFs(MetsValidator metsValidator) throws MetsException {
        String string;
        Iterator iterator;
        Map map;
        boolean bl;
        String string2;
        Iterator iterator2;
        if (!this._ADMID.isEmpty()) {
            iterator2 = this._ADMID.keySet().iterator();
            while (iterator2.hasNext()) {
                string2 = (String)iterator2.next();
                bl = false;
                map = metsValidator.getIDs();
                iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    if (!string2.equals(string)) continue;
                    bl = true;
                    this.setADMID(string2, (MetsIDElement)map.get(string));
                    break;
                }
                if (bl) continue;
                throw new MetsException("Can't resolve IDREF: " + string2);
            }
        }
        if (!this._DMDID.isEmpty()) {
            iterator2 = this._DMDID.keySet().iterator();
            while (iterator2.hasNext()) {
                string2 = (String)iterator2.next();
                bl = false;
                map = metsValidator.getIDs();
                iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    if (!string2.equals(string)) continue;
                    bl = true;
                    this.setDMDID(string2, (DmdSec)map.get(string));
                    break;
                }
                if (bl) continue;
                throw new MetsException("Can't resolve IDREF: " + string2);
            }
        }
    }
}

