/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.mets;

import edu.harvard.hul.ois.mets.Behavior;
import edu.harvard.hul.ois.mets.Transformtype;
import edu.harvard.hul.ois.mets.helper.Any;
import edu.harvard.hul.ois.mets.helper.MetsException;
import edu.harvard.hul.ois.mets.helper.MetsReader;
import edu.harvard.hul.ois.mets.helper.MetsSerializable;
import edu.harvard.hul.ois.mets.helper.MetsVElement;
import edu.harvard.hul.ois.mets.helper.MetsValidator;
import edu.harvard.hul.ois.mets.helper.MetsWriter;
import edu.harvard.hul.ois.mets.helper.parser.Attribute;
import edu.harvard.hul.ois.mets.helper.parser.Attributes;
import edu.harvard.hul.ois.mets.helper.parser.Token;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TransformFile
extends MetsVElement {
    private boolean _hasTRANSFORMORDER = false;
    private String _TRANSFORMALGORITHM;
    private Map _TRANSFORMBEHAVIOR = new HashMap();
    private String _TRANSFORMKEY;
    private int _TRANSFORMORDER;
    private Transformtype _TRANSFORMTYPE;

    public TransformFile() {
        super("transformFile");
    }

    public String getTRANSFORMALGORITHM() {
        return this._TRANSFORMALGORITHM;
    }

    public Map getTRANSFORMBEHAVIOR() {
        return this._TRANSFORMBEHAVIOR;
    }

    public String getTRANSFORMKEY() {
        return this._TRANSFORMKEY;
    }

    public int getTRANSFORMORDER() throws MetsException {
        if (this._hasTRANSFORMORDER) {
            throw new MetsException("No transformFile TRANSFORMORDER value");
        }
        return this._TRANSFORMORDER;
    }

    public Transformtype getTRANSFORMTYPE() {
        return this._TRANSFORMTYPE;
    }

    public void setTRANSFORMALGORITHM(String string) {
        this._TRANSFORMALGORITHM = string;
    }

    public void setTRANSFORMBEHAVIOR(String string) {
        this.setTRANSFORMBEHAVIOR(string, null);
    }

    public void setTRANSFORMBEHAVIOR(String string, Behavior behavior) {
        this._TRANSFORMBEHAVIOR.clear();
        this._TRANSFORMBEHAVIOR.put(string, behavior);
        this._valid = false;
    }

    public void setTRANSFORMKEY(String string) {
        this._TRANSFORMKEY = string;
    }

    public void setTRANSFORMORDER(int n) {
        this._TRANSFORMORDER = n;
        this._hasTRANSFORMORDER = true;
    }

    public void setTRANSFORMTYPE(Transformtype transformtype) {
        this._TRANSFORMTYPE = transformtype;
    }

    public static TransformFile reader(MetsReader metsReader) throws MetsException {
        TransformFile transformFile = new TransformFile();
        transformFile.read(metsReader);
        return transformFile;
    }

    public void read(MetsReader metsReader) throws MetsException {
        Object object;
        Token token = metsReader.getStart(this._localName);
        this._qName = token.getQName();
        this._namespace = token.getNamespace();
        this._localName = token.getLocalName();
        Attributes attributes = token.getAttributes();
        while (attributes.hasNext()) {
            object = attributes.next();
            String string = ((Attribute)object).getQName();
            String string2 = ((Attribute)object).getLocalName();
            String string3 = ((Attribute)object).getValue();
            if (string2.equals("TRANSFORMTYPE")) {
                this.setTRANSFORMTYPE(Transformtype.parse(string3));
                continue;
            }
            if (string2.equals("TRANSFORMALGORITHM")) {
                this.setTRANSFORMALGORITHM(string3);
                continue;
            }
            if (string2.equals("TRANSFORMKEY")) {
                this.setTRANSFORMKEY(string3);
                continue;
            }
            if (string2.equals("TRANSFORMBEHAVIOR")) {
                this.setTRANSFORMBEHAVIOR(string3);
                continue;
            }
            if (string2.equals("TRANSFORMORDER")) {
                this.setTRANSFORMORDER(Integer.parseInt(string3));
                continue;
            }
            if (this._attrs == null) {
                this._attrs = new Attributes();
            }
            this._attrs.add(new Attribute(((Attribute)object).getQName(), string3, '\"'));
        }
        while (metsReader.atStart()) {
            object = Any.reader(metsReader);
            this._content.add(object);
        }
        metsReader.getEnd(this._localName);
    }

    public void write(MetsWriter metsWriter) throws MetsException {
        Object object;
        metsWriter.start(this._qName);
        metsWriter.attribute("TRANSFORMTYPE", this._TRANSFORMTYPE.toString());
        metsWriter.attribute("TRANSFORMALGORITHM", this._TRANSFORMALGORITHM);
        if (this._TRANSFORMKEY != null) {
            metsWriter.attribute("TRANSFORMKEY", this._TRANSFORMKEY);
        }
        if (!this._TRANSFORMBEHAVIOR.isEmpty()) {
            metsWriter.attributeName("TRANSFORMBEHAVIOR");
            object = this._TRANSFORMBEHAVIOR.keySet().iterator();
            while (object.hasNext()) {
                metsWriter.attributeValue((String)object.next());
            }
        }
        metsWriter.attribute("TRANSFORMORDER", String.valueOf(this._TRANSFORMORDER));
        if (this._attrs != null) {
            this._attrs.reset();
            while (this._attrs.hasNext()) {
                object = this._attrs.next();
                metsWriter.attribute(((Attribute)object).getQName(), ((Attribute)object).getValue());
            }
        }
        object = this._content.iterator();
        while (object.hasNext()) {
            ((MetsSerializable)object.next()).write(metsWriter);
        }
        metsWriter.end(this._qName);
    }

    public void validateThis(MetsValidator metsValidator) throws MetsException {
        if (this._TRANSFORMALGORITHM == null) {
            throw new MetsException("No transformFile TRANSFORMALGORITHM value");
        }
        if (!this._hasTRANSFORMORDER) {
            throw new MetsException("No transformFile TRANSFORMORDER value");
        }
        if (this._TRANSFORMTYPE == null) {
            throw new MetsException("No transformFile TRANSFORMTYPE value");
        }
        this._valid = true;
    }

    public void validateThisIDREFs(MetsValidator metsValidator) throws MetsException {
        if (!this._TRANSFORMBEHAVIOR.isEmpty()) {
            Iterator iterator = this._TRANSFORMBEHAVIOR.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                boolean bl = false;
                Map map = metsValidator.getIDs();
                Iterator iterator2 = map.keySet().iterator();
                while (iterator2.hasNext()) {
                    String string2 = (String)iterator2.next();
                    if (!string.equals(string2)) continue;
                    bl = true;
                    this.setTRANSFORMBEHAVIOR(string, (Behavior)map.get(string2));
                    break;
                }
                if (bl) continue;
                throw new MetsException("Can't resolve IDREF: " + string);
            }
        }
    }
}

