/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.mets.helper;

import edu.harvard.hul.ois.mets.helper.MetsException;
import edu.harvard.hul.ois.mets.helper.MetsReader;
import edu.harvard.hul.ois.mets.helper.MetsSerializable;
import edu.harvard.hul.ois.mets.helper.MetsWriter;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;

public class Base64
implements MetsSerializable {
    private static final int BUFFERSIZE = 8192;
    private static final char[] _base64 = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private List _content;
    private InputStream _stream;

    public Base64() {
        this.init();
    }

    public Base64(String string) {
        this.init();
        this._content.add(string);
    }

    public Base64(InputStream inputStream) {
        this._stream = inputStream;
        if (!(this._stream instanceof BufferedInputStream)) {
            this._stream = new BufferedInputStream(this._stream);
        }
    }

    private void init() {
        this._content = new ArrayList();
    }

    public List getContent() {
        return this._content;
    }

    public void add(String string) {
        this._content.add(string);
    }

    public void decode(MetsWriter metsWriter) throws MetsException {
        try {
            int n;
            Object object;
            BufferedReader bufferedReader = null;
            if (this._stream != null) {
                bufferedReader = new BufferedReader(new InputStreamReader(this._stream));
            } else if (this._content != null) {
                object = new StringBuffer();
                n = 0;
                while (n < this._content.size()) {
                    ((StringBuffer)object).append((String)this._content.get(n));
                    ++n;
                }
                bufferedReader = new BufferedReader(new StringReader(((StringBuffer)object).toString()));
            } else {
                return;
            }
            object = new char[8192];
            n = 0;
            StringBuffer stringBuffer = new StringBuffer();
            while ((n = bufferedReader.read((char[])object, 0, 8192)) != -1) {
                String string = new String((char[])object, 0, n);
                string = string.replace('\t', ' ');
                string = string.replace('\n', ' ');
                string = string.replace('\r', ' ');
                stringBuffer.append(string);
                while (stringBuffer.length() > 0) {
                    if (stringBuffer.charAt(0) != ' ') break;
                    stringBuffer.delete(0, 1);
                }
                StringBuffer stringBuffer2 = new StringBuffer();
                int n2 = 0;
                while (n2 < stringBuffer.length()) {
                    if (stringBuffer.charAt(n2) != ' ' || stringBuffer.charAt(n2 - 1) != ' ') {
                        stringBuffer2.append(stringBuffer.charAt(n2));
                    }
                    ++n2;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer2.toString(), " ", true);
                int n3 = stringTokenizer.countTokens();
                int n4 = 0;
                while (n4 < n3 - 1) {
                    String string2 = stringTokenizer.nextToken();
                    if (!string2.equals(" ")) {
                        this.decode(metsWriter, string2);
                    }
                    ++n4;
                }
                stringBuffer = stringTokenizer.hasMoreTokens() ? new StringBuffer(stringTokenizer.nextToken()) : new StringBuffer();
            }
            if (stringBuffer.length() > 0 && !stringBuffer.toString().equals(" ")) {
                this.decode(metsWriter, stringBuffer.toString());
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new MetsException(iOException.toString());
        }
    }

    private void decode(MetsWriter metsWriter, String string) throws MetsException {
        int[] nArray = new int[178];
        Arrays.fill(nArray, -1);
        int n = 0;
        while (n < _base64.length) {
            nArray[Base64._base64[n]] = n;
            ++n;
        }
        if (string.length() % 4 != 0) {
            throw new MetsException("base64 data not a factor of 4");
        }
        int n2 = string.length() / 4;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            char[] cArray = string.substring(n4 * 4, n4 * 4 + 4).toCharArray();
            int[] nArray2 = new int[3];
            int[] nArray3 = new int[]{nArray[cArray[0]], nArray[cArray[1]], nArray[cArray[2]], nArray[cArray[3]]};
            nArray2[0] = nArray3[0] % 64 * 4;
            nArray2[0] = nArray2[0] + nArray3[1] / 16;
            nArray2[1] = nArray3[1] % 16 * 16;
            nArray2[1] = nArray2[1] + nArray3[2] / 4;
            nArray2[2] = nArray3[2] % 4 * 64;
            nArray2[2] = nArray2[2] + nArray3[3];
            int n5 = 3;
            if (nArray3[3] == -1) {
                n5 = nArray3[2] == -1 ? 1 : 2;
            }
            byte[] byArray = new byte[]{new Integer(nArray2[0]).byteValue(), new Integer(nArray2[1]).byteValue(), new Integer(nArray2[2]).byteValue()};
            n3 += n5;
            metsWriter.binary(byArray, 0, n5);
            ++n4;
        }
    }

    public void encode(MetsWriter metsWriter) throws MetsException {
        if (this._stream != null) {
            byte[] byArray = new byte[3];
            int n = 0;
            try {
                int n2;
                while ((n2 = this._stream.read(byArray, 0, 3)) > 0) {
                    int[] nArray = new int[4];
                    int n3 = 0;
                    while (n3 < n2) {
                        nArray[n3] = byArray[n3] < 0 ? byArray[n3] + 256 : byArray[n3];
                        ++n3;
                    }
                    int[] nArray2 = new int[4];
                    nArray2[0] = nArray[0] / 4;
                    nArray2[1] = nArray[0] % 4 * 16;
                    int n4 = 2;
                    if (n2 > 1) {
                        nArray2[1] = nArray2[1] + nArray[1] / 16;
                        nArray2[2] = nArray[1] % 16 * 4;
                        n4 = 3;
                        if (n2 > 2) {
                            nArray2[2] = nArray2[2] + nArray[2] / 64;
                            nArray2[3] = nArray[2] % 64;
                            n4 = 4;
                        }
                    }
                    StringBuffer stringBuffer = new StringBuffer();
                    int n5 = 0;
                    while (n5 < n4) {
                        stringBuffer.append(_base64[nArray2[n5]]);
                        ++n5;
                    }
                    int n6 = n4;
                    while (n6 < 4) {
                        stringBuffer.append("=");
                        ++n6;
                    }
                    int n7 = stringBuffer.length();
                    if (n + n7 < 76) {
                        metsWriter.text(stringBuffer.toString());
                        n += n7;
                        continue;
                    }
                    int n8 = n + n7 - 76;
                    metsWriter.text(stringBuffer.substring(0, n8));
                    metsWriter.text("\n");
                    metsWriter.text(stringBuffer.substring(n8));
                    n = n8;
                }
                this._stream.close();
            }
            catch (IOException iOException) {
                throw new MetsException(iOException.toString());
            }
        } else {
            int n = 0;
            while (n < this._content.size()) {
                metsWriter.text((String)this._content.get(n));
                ++n;
            }
        }
    }

    public static Base64 reader(MetsReader metsReader) throws MetsException {
        Base64 base64 = new Base64();
        base64.read(metsReader);
        return base64;
    }

    public void read(MetsReader metsReader) throws MetsException {
        String string = metsReader.getText();
        this._content.add(string);
    }

    public void write(MetsWriter metsWriter) throws MetsException {
        this.encode(metsWriter);
    }
}

