/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.mets.helper;

import edu.harvard.hul.ois.mets.MdRef;
import edu.harvard.hul.ois.mets.MdWrap;
import edu.harvard.hul.ois.mets.helper.DateTime;
import edu.harvard.hul.ois.mets.helper.MetsElement;
import edu.harvard.hul.ois.mets.helper.MetsException;
import edu.harvard.hul.ois.mets.helper.MetsIDElement;
import edu.harvard.hul.ois.mets.helper.MetsReader;
import edu.harvard.hul.ois.mets.helper.MetsVElement;
import edu.harvard.hul.ois.mets.helper.MetsValidator;
import edu.harvard.hul.ois.mets.helper.MetsWriter;
import edu.harvard.hul.ois.mets.helper.parser.Attribute;
import edu.harvard.hul.ois.mets.helper.parser.Attributes;
import edu.harvard.hul.ois.mets.helper.parser.Token;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public abstract class MdSec
extends MetsIDElement {
    private Map _ADMID = new HashMap();
    private Date _CREATED;
    private String _GROUPID;
    private String _STATUS;

    public MdSec(String string) {
        super(string);
    }

    public Map getADMID() {
        return this._ADMID;
    }

    public Date getCREATED() {
        return this._CREATED;
    }

    public String getGROUPID() {
        return this._GROUPID;
    }

    public String getSTATUS() {
        return this._STATUS;
    }

    public void setADMID(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            this.setADMID(stringTokenizer.nextToken(), null);
        }
    }

    public void setADMID(String string, MetsIDElement metsIDElement) {
        this._ADMID.put(string, metsIDElement);
        this._valid = false;
    }

    public void setCREATED(Date date) {
        this._CREATED = date;
    }

    public void setGROUPID(String string) {
        this._GROUPID = string;
    }

    public void setSTATUS(String string) {
        this._STATUS = string;
    }

    public void read(MetsReader metsReader) throws MetsException {
        Object object;
        Token token = metsReader.getStart(this._localName);
        this._qName = token.getQName();
        this._namespace = token.getNamespace();
        this._localName = token.getLocalName();
        Attributes attributes = token.getAttributes();
        while (attributes.hasNext()) {
            object = attributes.next();
            String string = ((Attribute)object).getQName();
            String string2 = ((Attribute)object).getLocalName();
            String string3 = ((Attribute)object).getValue();
            if (string2.equals("ID")) {
                this.setID(string3);
                continue;
            }
            if (string2.equals("GROUPID")) {
                this.setGROUPID(string3);
                continue;
            }
            if (string2.equals("ADMID")) {
                this.setADMID(string3);
                continue;
            }
            if (string2.equals("CREATED")) {
                try {
                    this.setCREATED(DateTime.parse(string3));
                    continue;
                }
                catch (Exception exception) {
                    throw new MetsException(exception.toString());
                }
            }
            if (string2.equals("STATUS")) {
                this.setSTATUS(string3);
                continue;
            }
            if (string.substring(0, 6).equals("xmlns:")) {
                String string4 = string.substring(6);
                this.setSchema(string4, string3);
                continue;
            }
            if (this._attrs == null) {
                this._attrs = new Attributes();
            }
            this._attrs.add(new Attribute(((Attribute)object).getQName(), string3, '\"'));
        }
        if (metsReader.atStart("mdRef")) {
            object = MdRef.reader(metsReader);
            this._content.add(object);
        }
        if (metsReader.atStart("mdWrap")) {
            object = MdWrap.reader(metsReader);
            this._content.add(object);
        }
        if (metsReader.atEnd(this._localName)) {
            metsReader.getEnd(this._localName);
        }
    }

    public void write(MetsWriter metsWriter) throws MetsException {
        Iterator<Object> iterator;
        metsWriter.start(this._qName);
        if (this._ID != null) {
            metsWriter.attribute("ID", this._ID);
        }
        if (this._GROUPID != null) {
            metsWriter.attribute("GROUPID", this._GROUPID);
        }
        if (!this._ADMID.isEmpty()) {
            metsWriter.attributeName("ADMID");
            iterator = this._ADMID.keySet().iterator();
            while (iterator.hasNext()) {
                metsWriter.attributeValue((String)iterator.next());
            }
        }
        if (this._CREATED != null) {
            metsWriter.attribute("CREATED", DateTime.format(this._CREATED));
        }
        if (this._STATUS != null) {
            metsWriter.attribute("STATUS", this._STATUS);
        }
        this.writeSchemas(metsWriter);
        iterator = this._content.iterator();
        while (iterator.hasNext()) {
            ((MetsElement)iterator.next()).write(metsWriter);
        }
        metsWriter.end(this._qName);
    }

    public void validateThisIDREFs(MetsValidator metsValidator) throws MetsException {
        if (!this._ADMID.isEmpty()) {
            Iterator iterator = this._ADMID.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                boolean bl = false;
                Map map = metsValidator.getIDs();
                Iterator iterator2 = map.keySet().iterator();
                while (iterator2.hasNext()) {
                    String string2 = (String)iterator2.next();
                    if (!string.equals(string2)) continue;
                    bl = true;
                    MetsVElement metsVElement = (MetsVElement)map.get(string2);
                    this.setADMID(string, (MdWrap)map.get(string2));
                    break;
                }
                if (bl) continue;
                throw new MetsException("Can't resolve IDREF: " + string);
            }
        }
    }
}

