/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.mets.helper;

import edu.harvard.hul.ois.mets.helper.MetsException;
import edu.harvard.hul.ois.mets.helper.MetsWriterState;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class MetsWriter {
    private static final String DEFAULT_ENCODING = "utf-8";
    private static final String XML_VERSION = "1.0";
    private String _encoding;
    private int _level;
    private MetsWriterState _state;
    private Writer _charWriter;
    private OutputStream _byteWriter;
    private boolean _noEscape;

    public MetsWriter(OutputStream outputStream) throws MetsException {
        this.init(outputStream, DEFAULT_ENCODING);
    }

    public MetsWriter(OutputStream outputStream, String string) throws MetsException {
        this.init(outputStream, string);
    }

    private void init(OutputStream outputStream, String string) throws MetsException {
        try {
            this._byteWriter = new BufferedOutputStream(outputStream);
            this._encoding = string;
            this._charWriter = new BufferedWriter(new OutputStreamWriter(outputStream, this._encoding));
            this._noEscape = false;
            this._level = -1;
            this._state = MetsWriterState.INIT;
        }
        catch (Exception exception) {
            throw new MetsException(exception.toString());
        }
    }

    private static String escapeValue(String string) {
        StringBuffer stringBuffer = new StringBuffer(MetsWriter.escapeText(string));
        int n = 0;
        while ((n = stringBuffer.toString().indexOf(34, n)) > -1) {
            stringBuffer.replace(n, n + 1, "&quot;");
            n += 6;
        }
        return stringBuffer.toString();
    }

    private static String escapeText(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while ((n = stringBuffer.toString().indexOf(38, n)) > -1) {
            stringBuffer.replace(n, n + 1, "&amp;");
            n += 5;
        }
        int n2 = 0;
        while ((n2 = stringBuffer.toString().indexOf(60, n2)) > -1) {
            stringBuffer.replace(n2, n2 + 1, "&lt;");
            n2 += 4;
        }
        return stringBuffer.toString();
    }

    public boolean getNoEscape() {
        return this._noEscape;
    }

    public void setNoEscape(boolean bl) {
        this._noEscape = bl;
    }

    public void attribute(String string, String string2) throws MetsException {
        this.attribute(string, string2, false);
    }

    public void attribute(String string, String string2, boolean bl) throws MetsException {
        try {
            if (this._state.equals(MetsWriterState.ATTRIBUTE_VALUE)) {
                this._charWriter.write("\"");
            }
            if (string != null && string2 != null) {
                if (this._noEscape || bl) {
                    this._charWriter.write(" " + string + "=\"" + string2 + "\"");
                } else {
                    this._charWriter.write(" " + string + "=\"" + MetsWriter.escapeValue(string2) + "\"");
                }
            }
            this._state = MetsWriterState.ATTRIBUTE;
        }
        catch (Exception exception) {
            throw new MetsException(exception.toString());
        }
    }

    public void attributeName(String string) throws MetsException {
        try {
            if (this._state.equals(MetsWriterState.ATTRIBUTE_VALUE)) {
                this._charWriter.write("\"");
            }
            this._charWriter.write(" " + string);
            this._state = MetsWriterState.ATTRIBUTE_NAME;
        }
        catch (Exception exception) {
            throw new MetsException(exception.toString());
        }
    }

    public void attributeValue(String string) throws MetsException {
        this.attributeValue(string, false);
    }

    public void attributeValue(String string, boolean bl) throws MetsException {
        try {
            if (this._state.equals(MetsWriterState.ATTRIBUTE_NAME)) {
                this._charWriter.write("=\"");
            } else if (this._state.equals(MetsWriterState.ATTRIBUTE_VALUE)) {
                this._charWriter.write(" ");
            }
            if (string != null) {
                if (this._noEscape || bl) {
                    this._charWriter.write(string);
                } else {
                    this._charWriter.write(MetsWriter.escapeValue(string));
                }
            }
            this._state = MetsWriterState.ATTRIBUTE_VALUE;
        }
        catch (Exception exception) {
            throw new MetsException(exception.toString());
        }
    }

    public void binary(byte[] byArray) throws MetsException {
        this.binary(byArray, 0, byArray.length);
    }

    public void binary(byte[] byArray, int n, int n2) throws MetsException {
        try {
            if (this._state.equals(MetsWriterState.START_TAG) || this._state.equals(MetsWriterState.ATTRIBUTE)) {
                this._charWriter.write(62);
            } else if (this._state.equals(MetsWriterState.ATTRIBUTE_VALUE)) {
                this._charWriter.write("\">");
            }
            if (byArray != null) {
                this._byteWriter.write(byArray, n, n2);
            }
            this._state = MetsWriterState.BINARY;
        }
        catch (Exception exception) {
            throw new MetsException(exception.toString());
        }
    }

    public void cdata(String string) throws MetsException {
        try {
            if (this._state.equals(MetsWriterState.START_TAG) || this._state.equals(MetsWriterState.ATTRIBUTE)) {
                this._charWriter.write(62);
            } else if (this._state.equals(MetsWriterState.ATTRIBUTE_VALUE)) {
                this._charWriter.write("\">");
            }
            this._charWriter.write("<![CDATA[" + string + "]]>");
            this._state = MetsWriterState.CDATA;
        }
        catch (Exception exception) {
            throw new MetsException(exception.toString());
        }
    }

    public void char_ref(int n) throws MetsException {
        this.char_ref(n, false);
    }

    public void char_ref(int n, boolean bl) throws MetsException {
        try {
            if (this._state.equals(MetsWriterState.START_TAG) || this._state.equals(MetsWriterState.ATTRIBUTE)) {
                this._charWriter.write(62);
            } else if (this._state.equals(MetsWriterState.ATTRIBUTE_VALUE)) {
                this._charWriter.write("\">");
            }
            if (bl) {
                this._charWriter.write("&#x" + Integer.toHexString(n) + ";");
            } else {
                this._charWriter.write("&#" + n + ";");
            }
            this._state = MetsWriterState.CHAR_REF;
        }
        catch (Exception exception) {
            throw new MetsException(exception.toString());
        }
    }

    public void comment(String string) throws MetsException {
        try {
            if (this._state.equals(MetsWriterState.START_TAG) || this._state.equals(MetsWriterState.ATTRIBUTE)) {
                this._charWriter.write(62);
            } else if (this._state.equals(MetsWriterState.ATTRIBUTE_VALUE)) {
                this._charWriter.write("\">");
            }
            this._charWriter.write("<!--" + string + "-->");
            this._state = MetsWriterState.COMMENT;
        }
        catch (Exception exception) {
            throw new MetsException(exception.toString());
        }
    }

    public void declaration() throws MetsException {
        try {
            this._charWriter.write("<?xml version=\"1.0\" encoding=\"" + this._encoding + "\" standalone=\"no\"?>");
            this._state = MetsWriterState.PROLOG;
        }
        catch (Exception exception) {
            throw new MetsException(exception.toString());
        }
    }

    public void end(String string) throws MetsException {
        try {
            if (this._state.equals(MetsWriterState.START_TAG) || this._state.equals(MetsWriterState.ATTRIBUTE)) {
                this._charWriter.write("/>");
            } else if (this._state.equals(MetsWriterState.ATTRIBUTE_VALUE)) {
                this._charWriter.write("\"/>");
            } else {
                if (this._state.equals(MetsWriterState.START_TAG)) {
                    this._charWriter.write(">");
                }
                if (!(this._state.equals(MetsWriterState.TEXT) || this._state.equals(MetsWriterState.BINARY) || this._state.equals(MetsWriterState.CDATA) || this._state.equals(MetsWriterState.CHAR_REF) || this._state.equals(MetsWriterState.ENTITY_REF))) {
                    this._charWriter.write(10);
                    int n = 0;
                    while (n < this._level) {
                        this._charWriter.write(32);
                        ++n;
                    }
                }
                this._charWriter.write("</" + string + ">");
            }
            if (this._level-- == 0) {
                this._charWriter.write(10);
            }
            this._state = MetsWriterState.END_TAG;
        }
        catch (Exception exception) {
            throw new MetsException(exception.toString());
        }
    }

    public void entity_ref(String string) throws MetsException {
        try {
            if (this._state.equals(MetsWriterState.START_TAG) || this._state.equals(MetsWriterState.ATTRIBUTE)) {
                this._charWriter.write(62);
            } else if (this._state.equals(MetsWriterState.ATTRIBUTE_VALUE)) {
                this._charWriter.write("\">");
            }
            this._charWriter.write("&" + string + ";");
            this._state = MetsWriterState.ENTITY_REF;
        }
        catch (Exception exception) {
            throw new MetsException(exception.toString());
        }
    }

    public void flush() throws MetsException {
        try {
            this._byteWriter.flush();
            this._charWriter.flush();
        }
        catch (Exception exception) {
            throw new MetsException(exception.toString());
        }
    }

    public void pi(String string, String string2) throws MetsException {
        try {
            if (this._state.equals(MetsWriterState.START_TAG) || this._state.equals(MetsWriterState.ATTRIBUTE)) {
                this._charWriter.write(62);
            } else if (this._state.equals(MetsWriterState.ATTRIBUTE_VALUE)) {
                this._charWriter.write("\">");
            }
            this._charWriter.write("<?" + string + " " + string2 + "?>");
            this._state = MetsWriterState.PI;
        }
        catch (Exception exception) {
            throw new MetsException(exception.toString());
        }
    }

    public void start(String string) throws MetsException {
        try {
            if (this._state.equals(MetsWriterState.START_TAG) || this._state.equals(MetsWriterState.ATTRIBUTE)) {
                this._charWriter.write(62);
            } else if (this._state.equals(MetsWriterState.ATTRIBUTE_VALUE)) {
                this._charWriter.write("\">");
            }
            ++this._level;
            if (!(this._state.equals(MetsWriterState.INIT) || this._state.equals(MetsWriterState.TEXT) || this._state.equals(MetsWriterState.BINARY) || this._state.equals(MetsWriterState.CDATA) || this._state.equals(MetsWriterState.CHAR_REF) || this._state.equals(MetsWriterState.ENTITY_REF))) {
                this._charWriter.write(10);
                int n = 0;
                while (n < this._level) {
                    this._charWriter.write(32);
                    ++n;
                }
            }
            this._charWriter.write("<" + string);
            this._state = MetsWriterState.START_TAG;
        }
        catch (Exception exception) {
            throw new MetsException(exception.toString());
        }
    }

    public void text(String string) throws MetsException {
        this.text(string, false);
    }

    public void text(String string, boolean bl) throws MetsException {
        try {
            if (this._state.equals(MetsWriterState.START_TAG) || this._state.equals(MetsWriterState.ATTRIBUTE)) {
                this._charWriter.write(62);
            } else if (this._state.equals(MetsWriterState.ATTRIBUTE_VALUE)) {
                this._charWriter.write("\">");
            }
            if (string != null) {
                if (this._noEscape || bl) {
                    this._charWriter.write(string);
                } else {
                    this._charWriter.write(MetsWriter.escapeText(string));
                }
            }
            this._state = MetsWriterState.TEXT;
        }
        catch (Exception exception) {
            throw new MetsException(exception.toString());
        }
    }
}

