/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.mets.helper;

import edu.harvard.hul.ois.mets.helper.MetsException;
import edu.harvard.hul.ois.mets.helper.MetsReader;
import edu.harvard.hul.ois.mets.helper.MetsSerializable;
import edu.harvard.hul.ois.mets.helper.MetsWriter;
import edu.harvard.hul.ois.mets.helper.parser.Attribute;
import edu.harvard.hul.ois.mets.helper.parser.Attributes;
import edu.harvard.hul.ois.mets.helper.parser.Parser;
import edu.harvard.hul.ois.mets.helper.parser.Token;
import edu.harvard.hul.ois.mets.helper.parser.Type;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class XmlStream
implements MetsSerializable {
    private List _content;
    private Reader _reader;

    public XmlStream(String string) {
        this._content = new ArrayList();
        this._content.add(string);
    }

    public XmlStream(Reader reader) {
        this._reader = reader;
    }

    public List getContent() {
        return this._content;
    }

    public void add(String string) {
        this._content.add(string);
    }

    public static XmlStream reader(MetsReader metsReader) throws MetsException {
        return null;
    }

    public void read(MetsReader metsReader) throws MetsException {
    }

    public void write(MetsWriter metsWriter) throws MetsException {
        if (this._reader != null) {
            Parser parser = new Parser();
            try {
                parser.setInput(this._reader);
                Token token = null;
                while ((token = parser.getToken()) != null) {
                    Type type = token.getType();
                    if (type.equals(Type.EMPTY_TAG) || type.equals(Type.START_TAG)) {
                        metsWriter.start(token.getQName());
                        Attributes attributes = token.getAttributes();
                        while (attributes.hasNext()) {
                            Attribute attribute = attributes.next();
                            metsWriter.attribute(attribute.getQName(), attribute.getValue());
                        }
                        if (!type.equals(Type.EMPTY_TAG)) continue;
                        metsWriter.end(token.getQName());
                        continue;
                    }
                    if (type.equals(Type.TEXT)) {
                        metsWriter.text(token.getValue());
                        continue;
                    }
                    if (type.equals(Type.CHAR_REF)) {
                        metsWriter.char_ref(token.getCharValue(), token.isHexValue());
                        continue;
                    }
                    if (type.equals(Type.ENTITY_REF)) {
                        metsWriter.entity_ref(token.getQName());
                        continue;
                    }
                    if (type.equals(Type.CDATA)) {
                        metsWriter.cdata(token.getValue());
                        continue;
                    }
                    if (type.equals(Type.COMMENT)) {
                        metsWriter.comment(token.getValue());
                        continue;
                    }
                    if (type.equals(Type.END_TAG)) {
                        metsWriter.end(token.getQName());
                        continue;
                    }
                    if (!type.equals(Type.PI)) continue;
                    metsWriter.pi(token.getQName(), token.getValue());
                }
            }
            catch (Exception exception) {
                throw new MetsException(exception.toString());
            }
        } else {
            int n = 0;
            while (n < this._content.size()) {
                metsWriter.text((String)this._content.get(n));
                ++n;
            }
        }
    }
}

