/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.primitive;

import java.util.Arrays;
import java.util.Iterator;
import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.bag.primitive.MutableShortBag;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.primitive.ShortPredicate;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.iterator.ShortIterator;
import org.eclipse.collections.api.list.primitive.MutableShortList;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.impl.bag.mutable.primitive.ShortHashBag;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyShortIterable;
import org.eclipse.collections.impl.list.mutable.primitive.ShortArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.ShortHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class CollectShortIterable<T>
extends AbstractLazyShortIterable {
    private final LazyIterable<T> iterable;
    private final ShortFunction<? super T> function;
    private final ShortFunctionToProcedure<T> shortFunctionToProcedure;

    public CollectShortIterable(LazyIterable<T> adapted, ShortFunction<? super T> function) {
        this.iterable = adapted;
        this.function = function;
        this.shortFunctionToProcedure = new ShortFunctionToProcedure(function);
    }

    public ShortIterator shortIterator() {
        return new ShortIterator(){
            private final Iterator<T> iterator;
            {
                this.iterator = CollectShortIterable.this.iterable.iterator();
            }

            public short next() {
                return CollectShortIterable.this.function.shortValueOf(this.iterator.next());
            }

            public boolean hasNext() {
                return this.iterator.hasNext();
            }
        };
    }

    @Override
    public void forEach(ShortProcedure procedure) {
        this.each(procedure);
    }

    public void each(ShortProcedure procedure) {
        this.iterable.forEachWith(this.shortFunctionToProcedure, (Object)procedure);
    }

    @Override
    public int size() {
        return this.iterable.size();
    }

    @Override
    public boolean isEmpty() {
        return this.iterable.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.iterable.notEmpty();
    }

    @Override
    public int count(final ShortPredicate predicate) {
        return this.iterable.count(new Predicate<T>(){

            public boolean accept(T each) {
                return predicate.accept(CollectShortIterable.this.function.shortValueOf(each));
            }
        });
    }

    @Override
    public boolean anySatisfy(final ShortPredicate predicate) {
        return this.iterable.anySatisfy(new Predicate<T>(){

            public boolean accept(T each) {
                return predicate.accept(CollectShortIterable.this.function.shortValueOf(each));
            }
        });
    }

    @Override
    public boolean allSatisfy(final ShortPredicate predicate) {
        return this.iterable.allSatisfy(new Predicate<T>(){

            public boolean accept(T each) {
                return predicate.accept(CollectShortIterable.this.function.shortValueOf(each));
            }
        });
    }

    @Override
    public boolean noneSatisfy(final ShortPredicate predicate) {
        return this.iterable.allSatisfy(new Predicate<T>(){

            public boolean accept(T each) {
                return !predicate.accept(CollectShortIterable.this.function.shortValueOf(each));
            }
        });
    }

    @Override
    public short[] toArray() {
        final short[] array = new short[this.size()];
        this.iterable.forEachWithIndex(new ObjectIntProcedure<T>(){

            public void value(T each, int index) {
                array[index] = CollectShortIterable.this.function.shortValueOf(each);
            }
        });
        return array;
    }

    @Override
    public short[] toSortedArray() {
        short[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    @Override
    public MutableShortList toList() {
        return ShortArrayList.newList((ShortIterable)this);
    }

    @Override
    public MutableShortSet toSet() {
        return ShortHashSet.newSet((ShortIterable)this);
    }

    @Override
    public MutableShortBag toBag() {
        return ShortHashBag.newBag((ShortIterable)this);
    }

    @Override
    public boolean containsAll(short ... source) {
        for (short value : source) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(ShortIterable source) {
        ShortIterator iterator = source.shortIterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ShortFunctionToProcedure<T>
    implements Procedure2<T, ShortProcedure> {
        private static final long serialVersionUID = 1L;
        private final ShortFunction<? super T> function;

        private ShortFunctionToProcedure(ShortFunction<? super T> function) {
            this.function = function;
        }

        public void value(T each, ShortProcedure procedure) {
            procedure.value(this.function.shortValueOf(each));
        }
    }
}

