/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.immutable.primitive;

import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.bag.primitive.ImmutableIntBag;
import org.eclipse.collections.api.factory.bag.primitive.ImmutableIntBagFactory;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableIntEmptyBag;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableIntHashBag;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableIntSingletonBag;

public class ImmutableIntBagFactoryImpl
implements ImmutableIntBagFactory {
    public ImmutableIntBag empty() {
        return ImmutableIntEmptyBag.INSTANCE;
    }

    public ImmutableIntBag of() {
        return this.empty();
    }

    public ImmutableIntBag with() {
        return this.empty();
    }

    public ImmutableIntBag of(int one) {
        return this.with(one);
    }

    public ImmutableIntBag with(int one) {
        return new ImmutableIntSingletonBag(one);
    }

    public ImmutableIntBag of(int ... items) {
        return this.with(items);
    }

    public ImmutableIntBag with(int ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableIntHashBag.newBagWith(items);
    }

    public ImmutableIntBag ofAll(IntIterable items) {
        return this.withAll(items);
    }

    public ImmutableIntBag withAll(IntIterable items) {
        if (items instanceof ImmutableIntBag) {
            return (ImmutableIntBag)items;
        }
        return this.with(items.toArray());
    }
}

