/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.mutable;

import java.util.concurrent.ExecutorService;
import org.eclipse.collections.api.annotation.Beta;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.ParallelUnsortedBag;
import org.eclipse.collections.api.bag.primitive.MutableBooleanBag;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.bag.primitive.MutableShortBag;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.partition.bag.PartitionMutableBag;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.bag.mutable.AbstractMutableBagIterable;
import org.eclipse.collections.impl.bag.mutable.HashBag;
import org.eclipse.collections.impl.bag.mutable.SynchronizedBag;
import org.eclipse.collections.impl.bag.mutable.UnmodifiableBag;
import org.eclipse.collections.impl.bag.mutable.primitive.BooleanHashBag;
import org.eclipse.collections.impl.bag.mutable.primitive.ByteHashBag;
import org.eclipse.collections.impl.bag.mutable.primitive.CharHashBag;
import org.eclipse.collections.impl.bag.mutable.primitive.DoubleHashBag;
import org.eclipse.collections.impl.bag.mutable.primitive.FloatHashBag;
import org.eclipse.collections.impl.bag.mutable.primitive.IntHashBag;
import org.eclipse.collections.impl.bag.mutable.primitive.LongHashBag;
import org.eclipse.collections.impl.bag.mutable.primitive.ShortHashBag;
import org.eclipse.collections.impl.factory.Bags;
import org.eclipse.collections.impl.lazy.parallel.bag.NonParallelUnsortedBag;
import org.eclipse.collections.impl.partition.bag.PartitionHashBag;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMutableBag<T>
extends AbstractMutableBagIterable<T>
implements MutableBag<T> {
    public ImmutableBag<T> toImmutable() {
        return Bags.immutable.withAll((Iterable)this);
    }

    public UnmodifiableBag<T> asUnmodifiable() {
        return UnmodifiableBag.of(this);
    }

    public SynchronizedBag<T> asSynchronized() {
        return new SynchronizedBag(this);
    }

    public MutableBag<T> tap(Procedure<? super T> procedure) {
        this.forEach(procedure);
        return this;
    }

    public <S> MutableBag<S> selectInstancesOf(final Class<S> clazz) {
        final HashBag result = HashBag.newBag();
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T each, int occurrences) {
                if (clazz.isInstance(each)) {
                    result.addOccurrences(each, occurrences);
                }
            }
        });
        return result;
    }

    public MutableBag<T> select(Predicate<? super T> predicate) {
        return this.select(predicate, this.newEmpty());
    }

    public <P> MutableBag<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.selectWith(predicate, parameter, this.newEmpty());
    }

    public MutableBag<T> reject(Predicate<? super T> predicate) {
        return this.reject(predicate, this.newEmpty());
    }

    public <P> MutableBag<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.rejectWith(predicate, parameter, this.newEmpty());
    }

    public PartitionMutableBag<T> partition(final Predicate<? super T> predicate) {
        final PartitionHashBag result = new PartitionHashBag();
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T each, int index) {
                MutableBag bucket = predicate.accept(each) ? result.getSelected() : result.getRejected();
                bucket.addOccurrences(each, index);
            }
        });
        return result;
    }

    public <P> PartitionMutableBag<T> partitionWith(final Predicate2<? super T, ? super P> predicate, final P parameter) {
        final PartitionHashBag result = new PartitionHashBag();
        this.forEachWithOccurrences(new ObjectIntProcedure<T>(){

            public void value(T each, int index) {
                MutableBag bucket = predicate.accept(each, parameter) ? result.getSelected() : result.getRejected();
                bucket.addOccurrences(each, index);
            }
        });
        return result;
    }

    public <V> MutableBag<V> collect(Function<? super T, ? extends V> function) {
        return this.collect(function, HashBag.newBag());
    }

    public <P, V> MutableBag<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        return this.collectWith(function, parameter, HashBag.newBag());
    }

    public <V> MutableBag<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        return this.collectIf(predicate, function, HashBag.newBag());
    }

    public <V> MutableBag<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        return this.flatCollect(function, HashBag.newBag());
    }

    public MutableBooleanBag collectBoolean(BooleanFunction<? super T> booleanFunction) {
        return this.collectBoolean(booleanFunction, new BooleanHashBag());
    }

    public MutableByteBag collectByte(ByteFunction<? super T> byteFunction) {
        return this.collectByte(byteFunction, new ByteHashBag());
    }

    public MutableCharBag collectChar(CharFunction<? super T> charFunction) {
        return this.collectChar(charFunction, new CharHashBag());
    }

    public MutableDoubleBag collectDouble(DoubleFunction<? super T> doubleFunction) {
        return this.collectDouble(doubleFunction, new DoubleHashBag());
    }

    public MutableFloatBag collectFloat(FloatFunction<? super T> floatFunction) {
        return this.collectFloat(floatFunction, new FloatHashBag());
    }

    public MutableIntBag collectInt(IntFunction<? super T> intFunction) {
        return this.collectInt(intFunction, new IntHashBag());
    }

    public MutableLongBag collectLong(LongFunction<? super T> longFunction) {
        return this.collectLong(longFunction, new LongHashBag());
    }

    public MutableShortBag collectShort(ShortFunction<? super T> shortFunction) {
        return this.collectShort(shortFunction, new ShortHashBag());
    }

    @Deprecated
    public <S> MutableBag<Pair<T, S>> zip(Iterable<S> that) {
        return this.zip(that, HashBag.newBag());
    }

    @Deprecated
    public MutableSet<Pair<T, Integer>> zipWithIndex() {
        return this.zipWithIndex(UnifiedSet.newSet());
    }

    @Beta
    public ParallelUnsortedBag<T> asParallel(ExecutorService executorService, int batchSize) {
        if (executorService == null) {
            throw new NullPointerException();
        }
        if (batchSize < 1) {
            throw new IllegalArgumentException();
        }
        return new NonParallelUnsortedBag(this);
    }
}

