/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.parallel;

import java.util.Comparator;
import java.util.concurrent.locks.ReadWriteLock;
import org.eclipse.collections.api.ParallelIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.sorted.MutableSortedBag;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.ParallelListIterable;
import org.eclipse.collections.api.map.MapIterable;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.map.sorted.MutableSortedMap;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.ParallelUnsortedSetIterable;
import org.eclipse.collections.api.set.sorted.MutableSortedSet;
import org.eclipse.collections.impl.lazy.parallel.MultiReaderParallelIterable;
import org.eclipse.collections.impl.lazy.parallel.list.MultiReaderParallelListIterable;
import org.eclipse.collections.impl.lazy.parallel.set.MultiReaderParallelUnsortedSetIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMultiReaderParallelIterable<T, PI extends ParallelIterable<T>>
implements ParallelIterable<T> {
    protected final PI delegate;
    protected final ReadWriteLock lock;

    protected AbstractMultiReaderParallelIterable(PI delegate, ReadWriteLock lock) {
        this.delegate = delegate;
        this.lock = lock;
    }

    protected <A> ParallelListIterable<A> wrap(ParallelListIterable<A> wrapped) {
        return new MultiReaderParallelListIterable<A>(wrapped, this.lock);
    }

    protected <A> ParallelUnsortedSetIterable<A> wrap(ParallelUnsortedSetIterable<A> wrapped) {
        return new MultiReaderParallelUnsortedSetIterable<A>(wrapped, this.lock);
    }

    protected <A> ParallelIterable<A> wrap(ParallelIterable<A> wrapped) {
        return new MultiReaderParallelIterable<A>(wrapped, this.lock);
    }

    public void forEach(Procedure<? super T> procedure) {
        this.lock.readLock().lock();
        try {
            this.delegate.forEach(procedure);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public <P> void forEachWith(Procedure2<? super T, ? super P> procedure, P parameter) {
        this.lock.readLock().lock();
        try {
            this.delegate.forEachWith(procedure, parameter);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public T detect(Predicate<? super T> predicate) {
        this.lock.readLock().lock();
        try {
            Object object = this.delegate.detect(predicate);
            return (T)object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> T detectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        this.lock.readLock().lock();
        try {
            Object object = this.delegate.detectWith(predicate, parameter);
            return (T)object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T detectIfNone(Predicate<? super T> predicate, Function0<? extends T> function) {
        this.lock.readLock().lock();
        try {
            Object object = this.delegate.detectIfNone(predicate, function);
            return (T)object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> T detectWithIfNone(Predicate2<? super T, ? super P> predicate, P parameter, Function0<? extends T> function) {
        this.lock.readLock().lock();
        try {
            Object object = this.delegate.detectWithIfNone(predicate, parameter, function);
            return (T)object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int count(Predicate<? super T> predicate) {
        this.lock.readLock().lock();
        try {
            int n = this.delegate.count(predicate);
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> int countWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        this.lock.readLock().lock();
        try {
            int n = this.delegate.countWith(predicate, parameter);
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean anySatisfy(Predicate<? super T> predicate) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.anySatisfy(predicate);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> boolean anySatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.anySatisfyWith(predicate, parameter);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean allSatisfy(Predicate<? super T> predicate) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.allSatisfy(predicate);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> boolean allSatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.allSatisfyWith(predicate, parameter);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean noneSatisfy(Predicate<? super T> predicate) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.noneSatisfy(predicate);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> boolean noneSatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.noneSatisfyWith(predicate, parameter);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public MutableList<T> toList() {
        this.lock.readLock().lock();
        try {
            MutableList mutableList = this.delegate.toList();
            return mutableList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public MutableList<T> toSortedList() {
        this.lock.readLock().lock();
        try {
            MutableList mutableList = this.delegate.toSortedList();
            return mutableList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public MutableList<T> toSortedList(Comparator<? super T> comparator) {
        this.lock.readLock().lock();
        try {
            MutableList mutableList = this.delegate.toSortedList(comparator);
            return mutableList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public <V extends Comparable<? super V>> MutableList<T> toSortedListBy(Function<? super T, ? extends V> function) {
        this.lock.readLock().lock();
        try {
            MutableList mutableList = this.delegate.toSortedListBy(function);
            return mutableList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public MutableSet<T> toSet() {
        this.lock.readLock().lock();
        try {
            MutableSet mutableSet = this.delegate.toSet();
            return mutableSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public MutableSortedSet<T> toSortedSet() {
        this.lock.readLock().lock();
        try {
            MutableSortedSet mutableSortedSet = this.delegate.toSortedSet();
            return mutableSortedSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public MutableSortedSet<T> toSortedSet(Comparator<? super T> comparator) {
        this.lock.readLock().lock();
        try {
            MutableSortedSet mutableSortedSet = this.delegate.toSortedSet(comparator);
            return mutableSortedSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public <V extends Comparable<? super V>> MutableSortedSet<T> toSortedSetBy(Function<? super T, ? extends V> function) {
        this.lock.readLock().lock();
        try {
            MutableSortedSet mutableSortedSet = this.delegate.toSortedSetBy(function);
            return mutableSortedSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public MutableBag<T> toBag() {
        this.lock.readLock().lock();
        try {
            MutableBag mutableBag = this.delegate.toBag();
            return mutableBag;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public MutableSortedBag<T> toSortedBag() {
        this.lock.readLock().lock();
        try {
            MutableSortedBag mutableSortedBag = this.delegate.toSortedBag();
            return mutableSortedBag;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public MutableSortedBag<T> toSortedBag(Comparator<? super T> comparator) {
        this.lock.readLock().lock();
        try {
            MutableSortedBag mutableSortedBag = this.delegate.toSortedBag(comparator);
            return mutableSortedBag;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public <V extends Comparable<? super V>> MutableSortedBag<T> toSortedBagBy(Function<? super T, ? extends V> function) {
        this.lock.readLock().lock();
        try {
            MutableSortedBag mutableSortedBag = this.delegate.toSortedBagBy(function);
            return mutableSortedBag;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <NK, NV> MutableMap<NK, NV> toMap(Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
        this.lock.readLock().lock();
        try {
            MutableMap mutableMap = this.delegate.toMap(keyFunction, valueFunction);
            return mutableMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
        this.lock.readLock().lock();
        try {
            MutableSortedMap mutableSortedMap = this.delegate.toSortedMap(keyFunction, valueFunction);
            return mutableSortedMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Comparator<? super NK> comparator, Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
        this.lock.readLock().lock();
        try {
            MutableSortedMap mutableSortedMap = this.delegate.toSortedMap(comparator, keyFunction, valueFunction);
            return mutableSortedMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Object[] toArray() {
        this.lock.readLock().lock();
        try {
            Object[] objectArray = this.delegate.toArray();
            return objectArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public <T1> T1[] toArray(T1[] target) {
        this.lock.readLock().lock();
        try {
            Object[] objectArray = this.delegate.toArray((Object[])target);
            return objectArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public T min(Comparator<? super T> comparator) {
        this.lock.readLock().lock();
        try {
            Object object = this.delegate.min(comparator);
            return (T)object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public T max(Comparator<? super T> comparator) {
        this.lock.readLock().lock();
        try {
            Object object = this.delegate.max(comparator);
            return (T)object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public T min() {
        this.lock.readLock().lock();
        try {
            Object object = this.delegate.min();
            return (T)object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public T max() {
        this.lock.readLock().lock();
        try {
            Object object = this.delegate.max();
            return (T)object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public <V extends Comparable<? super V>> T minBy(Function<? super T, ? extends V> function) {
        this.lock.readLock().lock();
        try {
            Object object = this.delegate.minBy(function);
            return (T)object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public <V extends Comparable<? super V>> T maxBy(Function<? super T, ? extends V> function) {
        this.lock.readLock().lock();
        try {
            Object object = this.delegate.maxBy(function);
            return (T)object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long sumOfInt(IntFunction<? super T> function) {
        this.lock.readLock().lock();
        try {
            long l = this.delegate.sumOfInt(function);
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double sumOfFloat(FloatFunction<? super T> function) {
        this.lock.readLock().lock();
        try {
            double d = this.delegate.sumOfFloat(function);
            return d;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long sumOfLong(LongFunction<? super T> function) {
        this.lock.readLock().lock();
        try {
            long l = this.delegate.sumOfLong(function);
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double sumOfDouble(DoubleFunction<? super T> function) {
        this.lock.readLock().lock();
        try {
            double d = this.delegate.sumOfDouble(function);
            return d;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String makeString() {
        this.lock.readLock().lock();
        try {
            String string = this.delegate.makeString();
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String makeString(String separator) {
        this.lock.readLock().lock();
        try {
            String string = this.delegate.makeString(separator);
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String makeString(String start, String separator, String end) {
        this.lock.readLock().lock();
        try {
            String string = this.delegate.makeString(start, separator, end);
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void appendString(Appendable appendable) {
        this.lock.readLock().lock();
        try {
            this.delegate.appendString(appendable);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void appendString(Appendable appendable, String separator) {
        this.lock.readLock().lock();
        try {
            this.delegate.appendString(appendable, separator);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.lock.readLock().lock();
        try {
            this.delegate.appendString(appendable, start, separator, end);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public <V> MapIterable<V, T> groupByUniqueKey(Function<? super T, ? extends V> function) {
        this.lock.readLock().lock();
        try {
            MapIterable mapIterable = this.delegate.groupByUniqueKey(function);
            return mapIterable;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> MapIterable<K, V> aggregateInPlaceBy(Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Procedure2<? super V, ? super T> mutatingAggregator) {
        this.lock.readLock().lock();
        try {
            MapIterable mapIterable = this.delegate.aggregateInPlaceBy(groupBy, zeroValueFactory, mutatingAggregator);
            return mapIterable;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> MapIterable<K, V> aggregateBy(Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Function2<? super V, ? super T, ? extends V> nonMutatingAggregator) {
        this.lock.readLock().lock();
        try {
            MapIterable mapIterable = this.delegate.aggregateBy(groupBy, zeroValueFactory, nonMutatingAggregator);
            return mapIterable;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String toString() {
        this.lock.readLock().lock();
        try {
            String string = this.delegate.toString();
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

