/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.function.primitive.DoubleToLongFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction0;
import org.eclipse.collections.api.block.function.primitive.LongToLongFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoubleLongPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.DoubleLongProcedure;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.iterator.DoubleIterator;
import org.eclipse.collections.api.iterator.MutableDoubleIterator;
import org.eclipse.collections.api.iterator.MutableLongIterator;
import org.eclipse.collections.api.map.primitive.DoubleLongMap;
import org.eclipse.collections.api.map.primitive.ImmutableDoubleLongMap;
import org.eclipse.collections.api.map.primitive.MutableDoubleLongMap;
import org.eclipse.collections.api.set.primitive.DoubleSet;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.api.tuple.primitive.DoubleLongPair;
import org.eclipse.collections.impl.SpreadFunctions;
import org.eclipse.collections.impl.factory.primitive.DoubleLongMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableDoubleIterator;
import org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyDoubleIterable;
import org.eclipse.collections.impl.map.mutable.primitive.AbstractMutableDoubleKeySet;
import org.eclipse.collections.impl.map.mutable.primitive.AbstractMutableLongValuesMap;
import org.eclipse.collections.impl.map.mutable.primitive.ImmutableDoubleMapKeySet;
import org.eclipse.collections.impl.map.mutable.primitive.MutableDoubleKeysMap;
import org.eclipse.collections.impl.map.mutable.primitive.SynchronizedDoubleLongMap;
import org.eclipse.collections.impl.map.mutable.primitive.UnmodifiableDoubleLongMap;
import org.eclipse.collections.impl.set.mutable.primitive.DoubleHashSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleLongHashMap
extends AbstractMutableLongValuesMap
implements MutableDoubleLongMap,
Externalizable,
MutableDoubleKeysMap {
    private static final long EMPTY_VALUE = 0L;
    private static final long serialVersionUID = 1L;
    private static final double EMPTY_KEY = 0.0;
    private static final double REMOVED_KEY = 1.0;
    private static final int CACHE_LINE_SIZE = 64;
    private static final int KEY_SIZE = 8;
    private static final int INITIAL_LINEAR_PROBE = 4;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private double[] keys;
    private long[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private AbstractMutableLongValuesMap.SentinelValues sentinelValues;
    private boolean copyKeysOnWrite;

    public DoubleLongHashMap() {
        this.allocateTable(16);
    }

    public DoubleLongHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(initialCapacity << 1);
        this.allocateTable(capacity);
    }

    public DoubleLongHashMap(DoubleLongMap map) {
        if (map instanceof DoubleLongHashMap && ((DoubleLongHashMap)map).occupiedWithSentinels == 0) {
            DoubleLongHashMap hashMap = (DoubleLongHashMap)map;
            this.occupiedWithData = hashMap.occupiedWithData;
            if (hashMap.sentinelValues != null) {
                this.sentinelValues = hashMap.sentinelValues.copy();
            }
            this.keys = Arrays.copyOf(hashMap.keys, hashMap.keys.length);
            this.values = Arrays.copyOf(hashMap.values, hashMap.values.length);
        } else {
            int capacity = this.smallestPowerOfTwoGreaterThan(Math.max(map.size(), 8) << 1);
            this.allocateTable(capacity);
            this.putAll(map);
        }
    }

    public static DoubleLongHashMap newWithKeysValues(double key1, long value1) {
        return new DoubleLongHashMap(1).withKeyValue(key1, value1);
    }

    public static DoubleLongHashMap newWithKeysValues(double key1, long value1, double key2, long value2) {
        return new DoubleLongHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static DoubleLongHashMap newWithKeysValues(double key1, long value1, double key2, long value2, double key3, long value3) {
        return new DoubleLongHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static DoubleLongHashMap newWithKeysValues(double key1, long value1, double key2, long value2, double key3, long value3, double key4, long value4) {
        return new DoubleLongHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    @Override
    protected int getOccupiedWithData() {
        return this.occupiedWithData;
    }

    @Override
    protected AbstractMutableLongValuesMap.SentinelValues getSentinelValues() {
        return this.sentinelValues;
    }

    @Override
    protected void setSentinelValuesNull() {
        this.sentinelValues = null;
    }

    @Override
    protected long getEmptyValue() {
        return 0L;
    }

    @Override
    protected int getTableSize() {
        return this.values.length;
    }

    @Override
    protected long getValueAtIndex(int index) {
        return this.values[index];
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DoubleLongMap)) {
            return false;
        }
        DoubleLongMap other = (DoubleLongMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey(0.0) || other.containsKey(1.0)) {
                return false;
            }
        } else {
            if (this.sentinelValues.containsZeroKey && (!other.containsKey(0.0) || this.sentinelValues.zeroValue != other.getOrThrow(0.0))) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && (!other.containsKey(1.0) || this.sentinelValues.oneValue != other.getOrThrow(1.0))) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            double key = this.keys[i];
            if (!DoubleLongHashMap.isNonSentinel(key) || other.containsKey(key) && this.values[i] == other.getOrThrow(key)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += (int)(Double.doubleToLongBits(0.0) ^ Double.doubleToLongBits(0.0) >>> 32) ^ (int)(this.sentinelValues.zeroValue ^ this.sentinelValues.zeroValue >>> 32);
            }
            if (this.sentinelValues.containsOneKey) {
                result += (int)(Double.doubleToLongBits(1.0) ^ Double.doubleToLongBits(1.0) >>> 32) ^ (int)(this.sentinelValues.oneValue ^ this.sentinelValues.oneValue >>> 32);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleLongHashMap.isNonSentinel(this.keys[i])) continue;
            result += (int)(Double.doubleToLongBits(this.keys[i]) ^ Double.doubleToLongBits(this.keys[i]) >>> 32) ^ (int)(this.values[i] ^ this.values[i] >>> 32);
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                appendable.append(0.0).append("=").append(this.sentinelValues.zeroValue);
                first = false;
            }
            if (this.sentinelValues.containsOneKey) {
                if (!first) {
                    appendable.append(", ");
                }
                appendable.append(1.0).append("=").append(this.sentinelValues.oneValue);
                first = false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            double key = this.keys[i];
            if (!DoubleLongHashMap.isNonSentinel(key)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(key).append("=").append(this.values[i]);
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    public MutableLongIterator longIterator() {
        return new InternalLongIterator();
    }

    public <V> V injectInto(V injectedValue, ObjectLongToObjectFunction<? super V, ? extends V> function) {
        Object result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.valueOf(result, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.valueOf(result, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleLongHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values[i]);
        }
        return result;
    }

    @Override
    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        Arrays.fill(this.keys, 0.0);
        Arrays.fill(this.values, 0L);
    }

    public void put(double key, long value) {
        if (DoubleLongHashMap.isEmptyKey(key)) {
            this.putForEmptySentinel(value);
            return;
        }
        if (DoubleLongHashMap.isRemovedKey(key)) {
            this.putForRemovedSentinel(value);
            return;
        }
        int index = this.probe(key);
        double keyAtIndex = this.keys[index];
        if (Double.compare(keyAtIndex, key) == 0) {
            this.values[index] = value;
        } else {
            this.addKeyValueAtIndex(key, value, index);
        }
    }

    private void putForRemovedSentinel(long value) {
        if (this.sentinelValues == null) {
            this.sentinelValues = new AbstractMutableLongValuesMap.SentinelValues();
        }
        this.addRemovedKeyValue(value);
    }

    private void putForEmptySentinel(long value) {
        if (this.sentinelValues == null) {
            this.sentinelValues = new AbstractMutableLongValuesMap.SentinelValues();
        }
        this.addEmptyKeyValue(value);
    }

    public void putAll(DoubleLongMap map) {
        map.forEachKeyValue(new DoubleLongProcedure(){

            public void value(double key, long value) {
                DoubleLongHashMap.this.put(key, value);
            }
        });
    }

    @Override
    public void removeKey(double key) {
        if (DoubleLongHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return;
            }
            this.removeEmptyKey();
            return;
        }
        if (DoubleLongHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return;
            }
            this.removeRemovedKey();
            return;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            this.removeKeyAtIndex(index);
        }
    }

    public void remove(double key) {
        this.removeKey(key);
    }

    public long removeKeyIfAbsent(double key, long value) {
        if (DoubleLongHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return value;
            }
            long oldValue = this.sentinelValues.zeroValue;
            this.removeEmptyKey();
            return oldValue;
        }
        if (DoubleLongHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return value;
            }
            long oldValue = this.sentinelValues.oneValue;
            this.removeRemovedKey();
            return oldValue;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            long oldValue = this.values[index];
            this.removeKeyAtIndex(index);
            return oldValue;
        }
        return value;
    }

    public long getIfAbsentPut(double key, long value) {
        if (DoubleLongHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableLongValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            this.addEmptyKeyValue(value);
            return value;
        }
        if (DoubleLongHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableLongValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public long getIfAbsentPut(double key, LongFunction0 function) {
        if (DoubleLongHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                long value = function.value();
                this.sentinelValues = new AbstractMutableLongValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            long value = function.value();
            this.addEmptyKeyValue(value);
            return value;
        }
        if (DoubleLongHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                long value = function.value();
                this.sentinelValues = new AbstractMutableLongValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            long value = function.value();
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        long value = function.value();
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public <P> long getIfAbsentPutWith(double key, LongFunction<? super P> function, P parameter) {
        if (DoubleLongHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                long value = function.longValueOf(parameter);
                this.sentinelValues = new AbstractMutableLongValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            long value = function.longValueOf(parameter);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (DoubleLongHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                long value = function.longValueOf(parameter);
                this.sentinelValues = new AbstractMutableLongValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            long value = function.longValueOf(parameter);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        long value = function.longValueOf(parameter);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public long getIfAbsentPutWithKey(double key, DoubleToLongFunction function) {
        if (DoubleLongHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                long value = function.valueOf(key);
                this.sentinelValues = new AbstractMutableLongValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            long value = function.valueOf(key);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (DoubleLongHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                long value = function.valueOf(key);
                this.sentinelValues = new AbstractMutableLongValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            long value = function.valueOf(key);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        long value = function.valueOf(key);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public long addToValue(double key, long toBeAdded) {
        if (DoubleLongHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableLongValuesMap.SentinelValues();
                this.addEmptyKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue += toBeAdded;
            } else {
                this.addEmptyKeyValue(toBeAdded);
            }
            return this.sentinelValues.zeroValue;
        }
        if (DoubleLongHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableLongValuesMap.SentinelValues();
                this.addRemovedKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue += toBeAdded;
            } else {
                this.addRemovedKeyValue(toBeAdded);
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            int n = index;
            this.values[n] = this.values[n] + toBeAdded;
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, toBeAdded, index);
        return this.values[index];
    }

    private void addKeyValueAtIndex(double key, long value, int index) {
        if (Double.compare(this.keys[index], 1.0) == 0) {
            --this.occupiedWithSentinels;
        }
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData + this.occupiedWithSentinels > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    private void removeKeyAtIndex(int index) {
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keys[index] = 1.0;
        this.values[index] = 0L;
        --this.occupiedWithData;
        ++this.occupiedWithSentinels;
    }

    private void copyKeys() {
        double[] copy = new double[this.keys.length];
        System.arraycopy(this.keys, 0, copy, 0, this.keys.length);
        this.keys = copy;
        this.copyKeysOnWrite = false;
    }

    public long updateValue(double key, long initialValueIfAbsent, LongToLongFunction function) {
        if (DoubleLongHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableLongValuesMap.SentinelValues();
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(this.sentinelValues.zeroValue);
            } else {
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.zeroValue;
        }
        if (DoubleLongHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableLongValuesMap.SentinelValues();
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(this.sentinelValues.oneValue);
            } else {
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        long value = function.valueOf(initialValueIfAbsent);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public DoubleLongHashMap withKeyValue(double key1, long value1) {
        this.put(key1, value1);
        return this;
    }

    public DoubleLongHashMap withKeysValues(double key1, long value1, double key2, long value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public DoubleLongHashMap withKeysValues(double key1, long value1, double key2, long value2, double key3, long value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public DoubleLongHashMap withKeysValues(double key1, long value1, double key2, long value2, double key3, long value3, double key4, long value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public DoubleLongHashMap withoutKey(double key) {
        this.removeKey(key);
        return this;
    }

    public DoubleLongHashMap withoutAllKeys(DoubleIterable keys) {
        keys.forEach(new DoubleProcedure(){

            public void value(double key) {
                DoubleLongHashMap.this.removeKey(key);
            }
        });
        return this;
    }

    public MutableDoubleLongMap asUnmodifiable() {
        return new UnmodifiableDoubleLongMap(this);
    }

    public MutableDoubleLongMap asSynchronized() {
        return new SynchronizedDoubleLongMap(this);
    }

    public ImmutableDoubleLongMap toImmutable() {
        return DoubleLongMaps.immutable.ofAll((DoubleLongMap)this);
    }

    public long get(double key) {
        return this.getIfAbsent(key, 0L);
    }

    public long getIfAbsent(double key, long ifAbsent) {
        if (DoubleLongHashMap.isEmptyKey(key) || DoubleLongHashMap.isRemovedKey(key)) {
            return this.getForSentinel(key, ifAbsent);
        }
        if (this.occupiedWithSentinels == 0) {
            return this.fastGetIfAbsent(key, ifAbsent);
        }
        return this.slowGetIfAbsent(key, ifAbsent);
    }

    private long getForSentinel(double key, long ifAbsent) {
        if (DoubleLongHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return ifAbsent;
            }
            return this.sentinelValues.zeroValue;
        }
        if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
            return ifAbsent;
        }
        return this.sentinelValues.oneValue;
    }

    private long slowGetIfAbsent(double key, long ifAbsent) {
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        return ifAbsent;
    }

    private long fastGetIfAbsent(double key, long ifAbsent) {
        int index = this.mask((int)key);
        for (int i = 0; i < 4; ++i) {
            double keyAtIndex = this.keys[index];
            if (Double.compare(keyAtIndex, key) == 0) {
                return this.values[index];
            }
            if (Double.compare(keyAtIndex, 0.0) == 0) {
                return ifAbsent;
            }
            index = index + 1 & this.keys.length - 1;
        }
        return this.slowGetIfAbsentTwo(key, ifAbsent);
    }

    private long slowGetIfAbsentTwo(double key, long ifAbsent) {
        int index = this.probeTwo(key, -1);
        if (Double.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        return ifAbsent;
    }

    public long getOrThrow(double key) {
        if (DoubleLongHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.zeroValue;
        }
        if (DoubleLongHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (DoubleLongHashMap.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    @Override
    public boolean containsKey(double key) {
        if (DoubleLongHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsZeroKey;
        }
        if (DoubleLongHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsOneKey;
        }
        return Double.compare(this.keys[this.probe(key)], key) == 0;
    }

    @Override
    public void forEachKey(DoubleProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0.0);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1.0);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleLongHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i]);
        }
    }

    public void forEachKeyValue(DoubleLongProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0.0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1.0, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleLongHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.values[i]);
        }
    }

    public LazyDoubleIterable keysView() {
        return new KeysView();
    }

    public RichIterable<DoubleLongPair> keyValuesView() {
        return new KeyValuesView();
    }

    public DoubleLongHashMap select(DoubleLongPredicate predicate) {
        DoubleLongHashMap result = new DoubleLongHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(0.0, this.sentinelValues.zeroValue)) {
                result.put(0.0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(1.0, this.sentinelValues.oneValue)) {
                result.put(1.0, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleLongHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public DoubleLongHashMap reject(DoubleLongPredicate predicate) {
        DoubleLongHashMap result = new DoubleLongHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(0.0, this.sentinelValues.zeroValue)) {
                result.put(0.0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(1.0, this.sentinelValues.oneValue)) {
                result.put(1.0, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleLongHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                out.writeDouble(0.0);
                out.writeLong(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                out.writeDouble(1.0);
                out.writeLong(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleLongHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeDouble(this.keys[i]);
            out.writeLong(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.put(in.readDouble(), in.readLong());
        }
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehashAndGrow() {
        this.rehash(this.keys.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        double[] old = this.keys;
        long[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!DoubleLongHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues[i]);
        }
    }

    int probe(double element) {
        int index = this.mask((int)element);
        double keyAtIndex = this.keys[index];
        if (Double.compare(keyAtIndex, element) == 0 || Double.compare(keyAtIndex, 0.0) == 0) {
            return index;
        }
        int removedIndex = Double.compare(keyAtIndex, 1.0) == 0 ? index : -1;
        for (int i = 1; i < 4; ++i) {
            int nextIndex = index + i & this.keys.length - 1;
            keyAtIndex = this.keys[nextIndex];
            if (Double.compare(keyAtIndex, element) == 0) {
                return nextIndex;
            }
            if (Double.compare(keyAtIndex, 0.0) == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (Double.compare(keyAtIndex, 1.0) != 0 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeTwo(element, removedIndex);
    }

    int probeTwo(double element, int removedIndex) {
        int index = this.spreadTwoAndMask(element);
        for (int i = 0; i < 4; ++i) {
            int nextIndex = index + i & this.keys.length - 1;
            double keyAtIndex = this.keys[nextIndex];
            if (Double.compare(keyAtIndex, element) == 0) {
                return nextIndex;
            }
            if (Double.compare(keyAtIndex, 0.0) == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (Double.compare(keyAtIndex, 1.0) != 0 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeThree(element, removedIndex);
    }

    int probeThree(double element, int removedIndex) {
        int nextIndex = (int)SpreadFunctions.doubleSpreadOne(element);
        int spreadTwo = (int)Long.reverse(SpreadFunctions.doubleSpreadTwo(element)) | 1;
        double keyAtIndex;
        while (Double.compare(keyAtIndex = this.keys[nextIndex = this.mask(nextIndex + spreadTwo)], element) != 0) {
            if (Double.compare(keyAtIndex, 0.0) == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (Double.compare(keyAtIndex, 1.0) != 0 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return nextIndex;
    }

    int spreadAndMask(double element) {
        long code = SpreadFunctions.doubleSpreadOne(element);
        return this.mask((int)code);
    }

    int spreadTwoAndMask(double element) {
        long code = SpreadFunctions.doubleSpreadTwo(element);
        return this.mask((int)code);
    }

    private int mask(int spread) {
        return spread & this.keys.length - 1;
    }

    private void allocateTable(int sizeToAllocate) {
        this.keys = new double[sizeToAllocate];
        this.values = new long[sizeToAllocate];
    }

    private static boolean isEmptyKey(double key) {
        return Double.compare(key, 0.0) == 0;
    }

    private static boolean isRemovedKey(double key) {
        return Double.compare(key, 1.0) == 0;
    }

    private static boolean isNonSentinel(double key) {
        return !DoubleLongHashMap.isEmptyKey(key) && !DoubleLongHashMap.isRemovedKey(key);
    }

    @Override
    protected boolean isNonSentinelAtIndex(int index) {
        return !DoubleLongHashMap.isEmptyKey(this.keys[index]) && !DoubleLongHashMap.isRemovedKey(this.keys[index]);
    }

    private int maxOccupiedWithData() {
        return this.keys.length >> 1;
    }

    private int maxOccupiedWithSentinels() {
        return this.keys.length >> 2;
    }

    public MutableDoubleSet keySet() {
        return new KeySet();
    }

    public MutableLongCollection values() {
        return new ValuesCollection();
    }

    static /* synthetic */ double[] access$302(DoubleLongHashMap x0, double[] x1) {
        x0.keys = x1;
        return x1;
    }

    static /* synthetic */ long[] access$502(DoubleLongHashMap x0, long[] x1) {
        x0.values = x1;
        return x1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyValuesView
    extends AbstractLazyIterable<DoubleLongPair> {
        private KeyValuesView() {
        }

        public void each(Procedure<? super DoubleLongPair> procedure) {
            if (DoubleLongHashMap.this.sentinelValues != null) {
                if (((DoubleLongHashMap)DoubleLongHashMap.this).sentinelValues.containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair(0.0, ((DoubleLongHashMap)DoubleLongHashMap.this).sentinelValues.zeroValue));
                }
                if (((DoubleLongHashMap)DoubleLongHashMap.this).sentinelValues.containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair(1.0, ((DoubleLongHashMap)DoubleLongHashMap.this).sentinelValues.oneValue));
                }
            }
            for (int i = 0; i < DoubleLongHashMap.this.keys.length; ++i) {
                if (!DoubleLongHashMap.isNonSentinel(DoubleLongHashMap.this.keys[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(DoubleLongHashMap.this.keys[i], DoubleLongHashMap.this.values[i]));
            }
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super DoubleLongPair> objectIntProcedure) {
            int index = 0;
            if (DoubleLongHashMap.this.sentinelValues != null) {
                if (((DoubleLongHashMap)DoubleLongHashMap.this).sentinelValues.containsZeroKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair(0.0, ((DoubleLongHashMap)DoubleLongHashMap.this).sentinelValues.zeroValue), index);
                    ++index;
                }
                if (((DoubleLongHashMap)DoubleLongHashMap.this).sentinelValues.containsOneKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair(1.0, ((DoubleLongHashMap)DoubleLongHashMap.this).sentinelValues.oneValue), index);
                    ++index;
                }
            }
            for (int i = 0; i < DoubleLongHashMap.this.keys.length; ++i) {
                if (!DoubleLongHashMap.isNonSentinel(DoubleLongHashMap.this.keys[i])) continue;
                objectIntProcedure.value((Object)PrimitiveTuples.pair(DoubleLongHashMap.this.keys[i], DoubleLongHashMap.this.values[i]), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super DoubleLongPair, ? super P> procedure, P parameter) {
            if (DoubleLongHashMap.this.sentinelValues != null) {
                if (((DoubleLongHashMap)DoubleLongHashMap.this).sentinelValues.containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair(0.0, ((DoubleLongHashMap)DoubleLongHashMap.this).sentinelValues.zeroValue), parameter);
                }
                if (((DoubleLongHashMap)DoubleLongHashMap.this).sentinelValues.containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair(1.0, ((DoubleLongHashMap)DoubleLongHashMap.this).sentinelValues.oneValue), parameter);
                }
            }
            for (int i = 0; i < DoubleLongHashMap.this.keys.length; ++i) {
                if (!DoubleLongHashMap.isNonSentinel(DoubleLongHashMap.this.keys[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(DoubleLongHashMap.this.keys[i], DoubleLongHashMap.this.values[i]), parameter);
            }
        }

        public Iterator<DoubleLongPair> iterator() {
            return new InternalKeyValuesIterator();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class InternalKeyValuesIterator
        implements Iterator<DoubleLongPair> {
            private int count;
            private int position;
            private boolean handledZero;
            private boolean handledOne;

            @Override
            public DoubleLongPair next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                ++this.count;
                if (!this.handledZero) {
                    this.handledZero = true;
                    if (DoubleLongHashMap.this.containsKey(0.0)) {
                        return PrimitiveTuples.pair(0.0, ((DoubleLongHashMap)DoubleLongHashMap.this).sentinelValues.zeroValue);
                    }
                }
                if (!this.handledOne) {
                    this.handledOne = true;
                    if (DoubleLongHashMap.this.containsKey(1.0)) {
                        return PrimitiveTuples.pair(1.0, ((DoubleLongHashMap)DoubleLongHashMap.this).sentinelValues.oneValue);
                    }
                }
                double[] keys = DoubleLongHashMap.this.keys;
                while (!DoubleLongHashMap.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                DoubleLongPair result = PrimitiveTuples.pair(keys[this.position], DoubleLongHashMap.this.values[this.position]);
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != DoubleLongHashMap.this.size();
            }
        }
    }

    private class ValuesCollection
    extends AbstractMutableLongValuesMap.AbstractLongValuesCollection {
        private ValuesCollection() {
        }

        public MutableLongIterator longIterator() {
            return DoubleLongHashMap.this.longIterator();
        }

        public boolean remove(long item) {
            int oldSize = DoubleLongHashMap.this.size();
            if (DoubleLongHashMap.this.sentinelValues != null) {
                if (((DoubleLongHashMap)DoubleLongHashMap.this).sentinelValues.containsZeroKey && item == ((DoubleLongHashMap)DoubleLongHashMap.this).sentinelValues.zeroValue) {
                    DoubleLongHashMap.this.removeKey(0.0);
                }
                if (((DoubleLongHashMap)DoubleLongHashMap.this).sentinelValues.containsOneKey && item == ((DoubleLongHashMap)DoubleLongHashMap.this).sentinelValues.oneValue) {
                    DoubleLongHashMap.this.removeKey(1.0);
                }
            }
            for (int i = 0; i < DoubleLongHashMap.this.keys.length; ++i) {
                if (!DoubleLongHashMap.isNonSentinel(DoubleLongHashMap.this.keys[i]) || item != DoubleLongHashMap.this.values[i]) continue;
                DoubleLongHashMap.this.removeKey(DoubleLongHashMap.this.keys[i]);
            }
            return oldSize != DoubleLongHashMap.this.size();
        }

        public boolean retainAll(LongIterable source) {
            int oldSize = DoubleLongHashMap.this.size();
            Object sourceSet = source instanceof LongSet ? (LongSet)source : source.toSet();
            DoubleLongHashMap retained = DoubleLongHashMap.this.select(new DoubleLongPredicate((LongSet)sourceSet){
                final /* synthetic */ LongSet val$sourceSet;
                {
                    this.val$sourceSet = longSet;
                }

                public boolean accept(double key, long value) {
                    return this.val$sourceSet.contains(value);
                }
            });
            if (retained.size() != oldSize) {
                DoubleLongHashMap.access$302(DoubleLongHashMap.this, retained.keys);
                DoubleLongHashMap.access$502(DoubleLongHashMap.this, retained.values);
                DoubleLongHashMap.this.sentinelValues = retained.sentinelValues;
                DoubleLongHashMap.this.occupiedWithData = retained.occupiedWithData;
                DoubleLongHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }
    }

    private class KeySet
    extends AbstractMutableDoubleKeySet {
        private KeySet() {
        }

        protected MutableDoubleKeysMap getOuter() {
            return DoubleLongHashMap.this;
        }

        protected AbstractMutableLongValuesMap.SentinelValues getSentinelValues() {
            return DoubleLongHashMap.this.sentinelValues;
        }

        protected double getKeyAtIndex(int index) {
            return DoubleLongHashMap.this.keys[index];
        }

        protected int getTableSize() {
            return DoubleLongHashMap.this.keys.length;
        }

        public MutableDoubleIterator doubleIterator() {
            return new KeySetIterator();
        }

        public boolean retainAll(DoubleIterable source) {
            int oldSize = DoubleLongHashMap.this.size();
            Object sourceSet = source instanceof DoubleSet ? (DoubleSet)source : source.toSet();
            DoubleLongHashMap retained = DoubleLongHashMap.this.select(new DoubleLongPredicate((DoubleSet)sourceSet){
                final /* synthetic */ DoubleSet val$sourceSet;
                {
                    this.val$sourceSet = doubleSet;
                }

                public boolean accept(double key, long value) {
                    return this.val$sourceSet.contains(key);
                }
            });
            if (retained.size() != oldSize) {
                DoubleLongHashMap.access$302(DoubleLongHashMap.this, retained.keys);
                DoubleLongHashMap.access$502(DoubleLongHashMap.this, retained.values);
                DoubleLongHashMap.this.sentinelValues = retained.sentinelValues;
                DoubleLongHashMap.this.occupiedWithData = retained.occupiedWithData;
                DoubleLongHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        public boolean retainAll(double ... source) {
            return this.retainAll(DoubleHashSet.newSetWith(source));
        }

        public DoubleSet freeze() {
            DoubleLongHashMap.this.copyKeysOnWrite = true;
            boolean containsZeroKey = false;
            boolean containsOneKey = false;
            if (DoubleLongHashMap.this.sentinelValues != null) {
                containsZeroKey = ((DoubleLongHashMap)DoubleLongHashMap.this).sentinelValues.containsZeroKey;
                containsOneKey = ((DoubleLongHashMap)DoubleLongHashMap.this).sentinelValues.containsOneKey;
            }
            return new ImmutableDoubleMapKeySet(DoubleLongHashMap.this.keys, DoubleLongHashMap.this.occupiedWithData, containsZeroKey, containsOneKey);
        }
    }

    private class KeySetIterator
    implements MutableDoubleIterator {
        private int count;
        private int position;
        private double lastKey;
        private boolean handledZero;
        private boolean handledOne;
        private boolean canRemove;

        private KeySetIterator() {
        }

        public boolean hasNext() {
            return this.count < DoubleLongHashMap.this.size();
        }

        public double next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            this.canRemove = true;
            if (!this.handledZero) {
                this.handledZero = true;
                if (DoubleLongHashMap.this.containsKey(0.0)) {
                    this.lastKey = 0.0;
                    return this.lastKey;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (DoubleLongHashMap.this.containsKey(1.0)) {
                    this.lastKey = 1.0;
                    return this.lastKey;
                }
            }
            double[] keys = DoubleLongHashMap.this.keys;
            while (!DoubleLongHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.lastKey = keys[this.position];
            ++this.position;
            return this.lastKey;
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            DoubleLongHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.canRemove = false;
        }
    }

    private class KeysView
    extends AbstractLazyDoubleIterable {
        private KeysView() {
        }

        public DoubleIterator doubleIterator() {
            return new UnmodifiableDoubleIterator((DoubleIterator)new KeySetIterator());
        }

        public void each(DoubleProcedure procedure) {
            DoubleLongHashMap.this.forEachKey(procedure);
        }
    }

    private class InternalLongIterator
    implements MutableLongIterator {
        private int count;
        private int position;
        private double lastKey;
        private boolean handledZero;
        private boolean handledOne;
        private boolean canRemove;

        private InternalLongIterator() {
        }

        public boolean hasNext() {
            return this.count < DoubleLongHashMap.this.size();
        }

        public long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            this.canRemove = true;
            if (!this.handledZero) {
                this.handledZero = true;
                if (DoubleLongHashMap.this.containsKey(0.0)) {
                    this.lastKey = 0.0;
                    return DoubleLongHashMap.this.get(0.0);
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (DoubleLongHashMap.this.containsKey(1.0)) {
                    this.lastKey = 1.0;
                    return DoubleLongHashMap.this.get(1.0);
                }
            }
            double[] keys = DoubleLongHashMap.this.keys;
            while (!DoubleLongHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.lastKey = keys[this.position];
            long result = DoubleLongHashMap.this.values[this.position];
            ++this.position;
            return result;
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            DoubleLongHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.canRemove = false;
        }
    }
}

