/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import org.eclipse.collections.api.block.function.primitive.DoubleToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoublePredicate;
import org.eclipse.collections.api.block.procedure.primitive.DoubleIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.iterator.DoubleIterator;
import org.eclipse.collections.api.list.primitive.MutableDoubleList;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.primitive.DoubleSet;
import org.eclipse.collections.api.set.primitive.ImmutableDoubleSet;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.impl.bag.mutable.primitive.DoubleHashBag;
import org.eclipse.collections.impl.factory.primitive.DoubleSets;
import org.eclipse.collections.impl.iterator.UnmodifiableDoubleIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.DoubleArrayList;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;
import org.eclipse.collections.impl.set.mutable.primitive.DoubleHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableDoubleSingletonSet
implements ImmutableDoubleSet,
Serializable {
    private static final long serialVersionUID = 1L;
    private final double element;

    ImmutableDoubleSingletonSet(double element) {
        this.element = element;
    }

    public ImmutableDoubleSet newWith(double element) {
        return DoubleSets.immutable.with(new double[]{this.element, element});
    }

    public ImmutableDoubleSet newWithout(double element) {
        return Double.compare(this.element, element) == 0 ? DoubleSets.immutable.with() : this;
    }

    public ImmutableDoubleSet newWithAll(DoubleIterable elements) {
        return DoubleHashSet.newSet(elements).with(this.element).toImmutable();
    }

    public ImmutableDoubleSet newWithoutAll(DoubleIterable elements) {
        return elements.contains(this.element) ? DoubleSets.immutable.with() : this;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public boolean contains(double value) {
        return Double.compare(this.element, value) == 0;
    }

    public boolean containsAll(DoubleIterable source) {
        DoubleIterator iterator = source.doubleIterator();
        while (iterator.hasNext()) {
            if (Double.compare(this.element, iterator.next()) == 0) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(double ... source) {
        for (double value : source) {
            if (Double.compare(this.element, value) == 0) continue;
            return false;
        }
        return true;
    }

    public void forEach(DoubleProcedure procedure) {
        this.each(procedure);
    }

    public void each(DoubleProcedure procedure) {
        procedure.value(this.element);
    }

    public ImmutableDoubleSet select(DoublePredicate predicate) {
        return predicate.accept(this.element) ? DoubleHashSet.newSetWith(this.element).toImmutable() : new DoubleHashSet().toImmutable();
    }

    public ImmutableDoubleSet reject(DoublePredicate predicate) {
        return predicate.accept(this.element) ? new DoubleHashSet().toImmutable() : DoubleHashSet.newSetWith(this.element).toImmutable();
    }

    public <V> ImmutableSet<V> collect(DoubleToObjectFunction<? extends V> function) {
        return UnifiedSet.newSetWith(function.valueOf(this.element)).toImmutable();
    }

    public MutableDoubleList toList() {
        return DoubleArrayList.newListWith(this.element);
    }

    public int sizeDistinct() {
        return 1;
    }

    public int occurrencesOf(double item) {
        return Double.compare(this.element, item) == 0 ? 1 : 0;
    }

    public void forEachWithOccurrences(DoubleIntProcedure doubleIntProcedure) {
        doubleIntProcedure.value(this.element, 1);
    }

    public double detectIfNone(DoublePredicate predicate, double ifNone) {
        return predicate.accept(this.element) ? this.element : ifNone;
    }

    public int count(DoublePredicate predicate) {
        return predicate.accept(this.element) ? 1 : 0;
    }

    public boolean anySatisfy(DoublePredicate predicate) {
        return predicate.accept(this.element);
    }

    public double sum() {
        return this.element;
    }

    public double min() {
        return this.element;
    }

    public double max() {
        return this.element;
    }

    public double maxIfEmpty(double defaultValue) {
        return this.element;
    }

    public double minIfEmpty(double defaultValue) {
        return this.element;
    }

    public double average() {
        return this.element;
    }

    public double median() {
        return this.element;
    }

    public double[] toSortedArray() {
        return new double[]{this.element};
    }

    public MutableDoubleList toSortedList() {
        return DoubleArrayList.newListWith(this.element);
    }

    public boolean noneSatisfy(DoublePredicate predicate) {
        return !predicate.accept(this.element);
    }

    public boolean allSatisfy(DoublePredicate predicate) {
        return predicate.accept(this.element);
    }

    public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.element);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DoubleSet)) {
            return false;
        }
        DoubleSet set = (DoubleSet)obj;
        if (set.size() != 1) {
            return false;
        }
        return set.contains(this.element);
    }

    public int hashCode() {
        return (int)(Double.doubleToLongBits(this.element) ^ Double.doubleToLongBits(this.element) >>> 32);
    }

    public MutableDoubleSet toSet() {
        return DoubleHashSet.newSetWith(this.element);
    }

    public MutableDoubleBag toBag() {
        return DoubleHashBag.newBagWith(this.element);
    }

    public DoubleSet freeze() {
        return this;
    }

    public ImmutableDoubleSet toImmutable() {
        return this;
    }

    public LazyDoubleIterable asLazy() {
        return new LazyDoubleIterableAdapter((DoubleIterable)this);
    }

    public double[] toArray() {
        return new double[]{this.element};
    }

    public String toString() {
        return '[' + this.makeString() + ']';
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.element));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public DoubleIterator doubleIterator() {
        return new UnmodifiableDoubleIterator((DoubleIterator)DoubleHashSet.newSetWith(this.element).doubleIterator());
    }
}

