/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.primitive.ImmutableIntSet;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.bag.mutable.primitive.IntHashBag;
import org.eclipse.collections.impl.factory.Sets;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.eclipse.collections.impl.iterator.ImmutableEmptyIntIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableIntSingletonSet;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableIntEmptySet
implements ImmutableIntSet,
Serializable {
    static final ImmutableIntSet INSTANCE = new ImmutableIntEmptySet();
    private static final long serialVersionUID = 1L;

    ImmutableIntEmptySet() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    public ImmutableIntSet newWith(int element) {
        return new ImmutableIntSingletonSet(element);
    }

    public ImmutableIntSet newWithout(int element) {
        return this;
    }

    public ImmutableIntSet newWithAll(IntIterable elements) {
        return IntSets.immutable.withAll(elements);
    }

    public ImmutableIntSet newWithoutAll(IntIterable elements) {
        return this;
    }

    public int size() {
        return 0;
    }

    public boolean isEmpty() {
        return true;
    }

    public boolean notEmpty() {
        return false;
    }

    public boolean contains(int value) {
        return false;
    }

    public boolean containsAll(IntIterable source) {
        return source.isEmpty();
    }

    public boolean containsAll(int ... elements) {
        return elements.length == 0;
    }

    public void forEach(IntProcedure procedure) {
    }

    public void each(IntProcedure procedure) {
    }

    public ImmutableIntSet select(IntPredicate predicate) {
        return this;
    }

    public ImmutableIntSet reject(IntPredicate predicate) {
        return this;
    }

    public <V> ImmutableSet<V> collect(IntToObjectFunction<? extends V> function) {
        return Sets.immutable.of();
    }

    public MutableIntList toList() {
        return new IntArrayList();
    }

    public int detectIfNone(IntPredicate predicate, int ifNone) {
        return ifNone;
    }

    public int count(IntPredicate predicate) {
        return 0;
    }

    public boolean anySatisfy(IntPredicate predicate) {
        return false;
    }

    public long sum() {
        return 0L;
    }

    public int min() {
        throw new NoSuchElementException();
    }

    public int max() {
        throw new NoSuchElementException();
    }

    public int maxIfEmpty(int defaultValue) {
        return defaultValue;
    }

    public int minIfEmpty(int defaultValue) {
        return defaultValue;
    }

    public double average() {
        throw new ArithmeticException();
    }

    public double median() {
        throw new ArithmeticException();
    }

    public int[] toSortedArray() {
        return new int[0];
    }

    public MutableIntList toSortedList() {
        return new IntArrayList();
    }

    public boolean noneSatisfy(IntPredicate predicate) {
        return true;
    }

    public boolean allSatisfy(IntPredicate predicate) {
        return true;
    }

    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
        return injectedValue;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IntSet)) {
            return false;
        }
        IntSet set = (IntSet)obj;
        return set.isEmpty();
    }

    public int hashCode() {
        return 0;
    }

    public MutableIntSet toSet() {
        return new IntHashSet();
    }

    public MutableIntBag toBag() {
        return new IntHashBag();
    }

    public IntSet freeze() {
        return this;
    }

    public ImmutableIntSet toImmutable() {
        return this;
    }

    public LazyIntIterable asLazy() {
        return new LazyIntIterableAdapter((IntIterable)this);
    }

    public int[] toArray() {
        return new int[0];
    }

    public String toString() {
        return "[]";
    }

    public String makeString() {
        return "";
    }

    public String makeString(String separator) {
        return "";
    }

    public String makeString(String start, String separator, String end) {
        return start + end;
    }

    public void appendString(Appendable appendable) {
    }

    public void appendString(Appendable appendable, String separator) {
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public IntIterator intIterator() {
        return ImmutableEmptyIntIterator.INSTANCE;
    }
}

