/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.eclipse.jetty.http.AbstractGenerator;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeaderValues;
import org.eclipse.jetty.http.HttpHeaders;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.HttpTokens;
import org.eclipse.jetty.http.HttpVersions;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.BufferCache;
import org.eclipse.jetty.io.BufferUtil;
import org.eclipse.jetty.io.Buffers;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.Log;

public class HttpGenerator
extends AbstractGenerator {
    private static final Status[] __status = new Status[508];
    private static final byte[] LAST_CHUNK;
    private static final byte[] CONTENT_LENGTH_0;
    private static final byte[] CONNECTION_KEEP_ALIVE;
    private static final byte[] CONNECTION_CLOSE;
    private static final byte[] CONNECTION_;
    private static final byte[] CRLF;
    private static final byte[] TRANSFER_ENCODING_CHUNKED;
    private static byte[] SERVER;
    private static final int CHUNK_SPACE = 12;
    private boolean _bypass = false;
    private boolean _needCRLF = false;
    private boolean _needEOC = false;
    private boolean _bufferChunked = false;

    public static Buffer getReasonBuffer(int code) {
        Status status;
        Status status2 = status = code < __status.length ? __status[code] : null;
        if (status != null) {
            return status._reason;
        }
        return null;
    }

    public static void setServerVersion(String version) {
        SERVER = StringUtil.getBytes((String)("Server: Jetty(" + version + ")\r\n"));
    }

    public HttpGenerator(Buffers buffers, EndPoint io) {
        super(buffers, io);
    }

    @Override
    public void reset(boolean returnBuffers) {
        super.reset(returnBuffers);
        this._bypass = false;
        this._needCRLF = false;
        this._needEOC = false;
        this._bufferChunked = false;
        this._method = null;
        this._uri = null;
        this._noContent = false;
    }

    @Override
    public void addContent(Buffer content, boolean last) throws IOException {
        if (this._noContent) {
            throw new IllegalStateException("NO CONTENT");
        }
        if (this._last || this._state == 4) {
            Log.debug((String)"Ignoring extra content {}", (Object)content);
            content.clear();
            return;
        }
        this._last = last;
        if (this._content != null && this._content.length() > 0 || this._bufferChunked) {
            if (!this._endp.isOpen()) {
                throw new EofException();
            }
            this.flushBuffer();
            if (this._content != null && this._content.length() > 0) {
                Buffer nc = this._buffers.getBuffer(this._content.length() + content.length());
                nc.put(this._content);
                nc.put(content);
                this._content = nc;
            }
        }
        this._content = content;
        this._contentWritten += (long)content.length();
        if (this._head) {
            content.clear();
            this._content = null;
        } else if (this._endp != null && this._buffer == null && content.length() > 0 && this._last) {
            this._bypass = true;
        } else if (!this._bufferChunked) {
            if (this._buffer == null) {
                this._buffer = this._buffers.getBuffer();
            }
            int len = this._buffer.put(this._content);
            this._content.skip(len);
            if (this._content.length() == 0) {
                this._content = null;
            }
        }
    }

    public void sendResponse(Buffer response) throws IOException {
        if (this._noContent || this._state != 0 || this._content != null && this._content.length() > 0 || this._bufferChunked || this._head) {
            throw new IllegalStateException();
        }
        this._last = true;
        this._content = response;
        this._bypass = true;
        this._state = 3;
        this._contentLength = this._contentWritten = (long)response.length();
    }

    @Override
    public boolean addContent(byte b) throws IOException {
        if (this._noContent) {
            throw new IllegalStateException("NO CONTENT");
        }
        if (this._last || this._state == 4) {
            Log.debug((String)"Ignoring extra content {}", (Object)b);
            return false;
        }
        if (this._content != null && this._content.length() > 0 || this._bufferChunked) {
            this.flushBuffer();
            if (this._content != null && this._content.length() > 0 || this._bufferChunked) {
                throw new IllegalStateException("FULL");
            }
        }
        ++this._contentWritten;
        if (this._head) {
            return false;
        }
        if (this._buffer == null) {
            this._buffer = this._buffers.getBuffer();
        }
        this._buffer.put(b);
        return this._buffer.space() <= (this._contentLength == -2L ? 12 : 0);
    }

    @Override
    public int prepareUncheckedAddContent() throws IOException {
        if (this._noContent) {
            return -1;
        }
        if (this._last || this._state == 4) {
            return -1;
        }
        Buffer content = this._content;
        if (content != null && content.length() > 0 || this._bufferChunked) {
            this.flushBuffer();
            if (content != null && content.length() > 0 || this._bufferChunked) {
                throw new IllegalStateException("FULL");
            }
        }
        if (this._buffer == null) {
            this._buffer = this._buffers.getBuffer();
        }
        this._contentWritten -= (long)this._buffer.length();
        if (this._head) {
            return Integer.MAX_VALUE;
        }
        return this._buffer.space() - (this._contentLength == -2L ? 12 : 0);
    }

    @Override
    public boolean isBufferFull() {
        return super.isBufferFull() || this._bufferChunked || this._bypass || this._contentLength == -2L && this._buffer != null && this._buffer.space() < 12;
    }

    public void send1xx(int code) throws IOException {
        if (this._state != 0) {
            return;
        }
        if (code < 100 || code > 199) {
            throw new IllegalArgumentException("!1xx");
        }
        Status status = __status[code];
        if (status == null) {
            throw new IllegalArgumentException(code + "?");
        }
        if (this._header == null) {
            this._header = this._buffers.getHeader();
        }
        this._header.put(status._responseLine);
        this._header.put(HttpTokens.CRLF);
        try {
            while (this._header.length() > 0) {
                int len = this._endp.flush(this._header);
                if (len < 0) {
                    throw new EofException();
                }
                if (len != 0) continue;
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            Log.debug((Throwable)e);
            throw new InterruptedIOException(e.toString());
        }
    }

    @Override
    public boolean isRequest() {
        return this._method != null;
    }

    @Override
    public boolean isResponse() {
        return this._method == null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void completeHeader(HttpFields fields, boolean allContentAdded) throws IOException {
        if (this._state != 0) {
            return;
        }
        if (this.isResponse() && this._status == 0) {
            throw new EofException();
        }
        if (this._last && !allContentAdded) {
            throw new IllegalStateException("last?");
        }
        this._last |= allContentAdded;
        if (this._header == null) {
            this._header = this._buffers.getHeader();
        }
        boolean has_server = false;
        if (this.isRequest()) {
            this._persistent = true;
            if (this._version == 9) {
                this._contentLength = 0L;
                this._header.put(this._method);
                this._header.put((byte)32);
                this._header.put(this._uri.getBytes("utf-8"));
                this._header.put(HttpTokens.CRLF);
                this._state = 3;
                this._noContent = true;
                return;
            }
            this._header.put(this._method);
            this._header.put((byte)32);
            this._header.put(this._uri.getBytes("utf-8"));
            this._header.put((byte)32);
            this._header.put(this._version == 10 ? HttpVersions.HTTP_1_0_BUFFER : HttpVersions.HTTP_1_1_BUFFER);
            this._header.put(HttpTokens.CRLF);
        } else {
            Status status;
            if (this._version == 9) {
                this._persistent = false;
                this._contentLength = -1L;
                this._state = 2;
                return;
            }
            if (this._persistent == null) {
                this._persistent = this._version > 10;
            }
            Status status2 = status = this._status < __status.length ? __status[this._status] : null;
            if (status == null) {
                this._header.put(HttpVersions.HTTP_1_1_BUFFER);
                this._header.put((byte)32);
                this._header.put((byte)(48 + this._status / 100));
                this._header.put((byte)(48 + this._status % 100 / 10));
                this._header.put((byte)(48 + this._status % 10));
                this._header.put((byte)32);
                if (this._reason == null) {
                    this._header.put((byte)(48 + this._status / 100));
                    this._header.put((byte)(48 + this._status % 100 / 10));
                    this._header.put((byte)(48 + this._status % 10));
                } else {
                    this._header.put(this._reason);
                }
                this._header.put(HttpTokens.CRLF);
            } else if (this._reason == null) {
                this._header.put(status._responseLine);
            } else {
                this._header.put(status._schemeCode);
                this._header.put(this._reason);
                this._header.put(HttpTokens.CRLF);
            }
            if (this._status < 200 && this._status >= 100) {
                this._noContent = true;
                this._content = null;
                if (this._buffer != null) {
                    this._buffer.clear();
                }
                if (this._status != 101) {
                    this._header.put(HttpTokens.CRLF);
                    this._state = 2;
                    return;
                }
            } else if (this._status == 204 || this._status == 304) {
                this._noContent = true;
                this._content = null;
                if (this._buffer != null) {
                    this._buffer.clear();
                }
            }
        }
        if (this._status >= 200 && this._date != null) {
            this._header.put(HttpHeaders.DATE_BUFFER);
            this._header.put((byte)58);
            this._header.put((byte)32);
            this._header.put(this._date);
            this._header.put(CRLF);
        }
        HttpFields.Field content_length = null;
        HttpFields.Field transfer_encoding = null;
        boolean keep_alive = false;
        boolean close = false;
        boolean content_type = false;
        StringBuilder connection = null;
        if (fields != null) {
            int s = fields.size();
            block23: for (int f = 0; f < s; ++f) {
                HttpFields.Field field = fields.getField(f);
                if (field == null) continue;
                switch (field.getNameOrdinal()) {
                    case 12: {
                        content_length = field;
                        this._contentLength = field.getLongValue();
                        if (this._contentLength < this._contentWritten || this._last && this._contentLength != this._contentWritten) {
                            content_length = null;
                        }
                        field.put(this._header);
                        continue block23;
                    }
                    case 16: {
                        if (BufferUtil.isPrefix((Buffer)MimeTypes.MULTIPART_BYTERANGES_BUFFER, (Buffer)field.getValueBuffer())) {
                            this._contentLength = -4L;
                        }
                        content_type = true;
                        field.put(this._header);
                        continue block23;
                    }
                    case 5: {
                        if (this._version != 11) continue block23;
                        transfer_encoding = field;
                        continue block23;
                    }
                    case 1: {
                        if (this.isRequest()) {
                            field.put(this._header);
                        }
                        int connection_value = field.getValueOrdinal();
                        switch (connection_value) {
                            case -1: {
                                String[] values = field.getValue().split(",");
                                block24: for (int i = 0; values != null && i < values.length; ++i) {
                                    BufferCache.CachedBuffer cb = HttpHeaderValues.CACHE.get(values[i].trim());
                                    if (cb != null) {
                                        switch (cb.getOrdinal()) {
                                            case 1: {
                                                close = true;
                                                if (this.isResponse()) {
                                                    this._persistent = false;
                                                }
                                                keep_alive = false;
                                                if (this._persistent.booleanValue() || !this.isResponse() || this._contentLength != -3L) continue block24;
                                                this._contentLength = -1L;
                                                break;
                                            }
                                            case 5: {
                                                if (this._version != 10) continue block24;
                                                keep_alive = true;
                                                if (!this.isResponse()) continue block24;
                                                this._persistent = true;
                                                break;
                                            }
                                            default: {
                                                if (connection == null) {
                                                    connection = new StringBuilder();
                                                } else {
                                                    connection.append(',');
                                                }
                                                connection.append(values[i]);
                                                break;
                                            }
                                        }
                                        continue;
                                    }
                                    if (connection == null) {
                                        connection = new StringBuilder();
                                    } else {
                                        connection.append(',');
                                    }
                                    connection.append(values[i]);
                                }
                                continue block23;
                            }
                            case 11: {
                                if (this.isResponse()) {
                                    field.put(this._header);
                                    break;
                                }
                            }
                            case 1: {
                                close = true;
                                if (this.isResponse()) {
                                    this._persistent = false;
                                }
                                if (this._persistent.booleanValue() || !this.isResponse() || this._contentLength != -3L) continue block23;
                                this._contentLength = -1L;
                                break;
                            }
                            case 5: {
                                if (this._version != 10) continue block23;
                                keep_alive = true;
                                if (!this.isResponse()) continue block23;
                                this._persistent = true;
                                break;
                            }
                            default: {
                                if (connection == null) {
                                    connection = new StringBuilder();
                                } else {
                                    connection.append(',');
                                }
                                connection.append(field.getValue());
                                break;
                            }
                        }
                        continue block23;
                    }
                    case 48: {
                        if (!this.getSendServerVersion()) continue block23;
                        has_server = true;
                        field.put(this._header);
                        continue block23;
                    }
                    default: {
                        field.put(this._header);
                    }
                }
            }
        }
        switch ((int)this._contentLength) {
            case -3: {
                if (this._contentWritten == 0L && this.isResponse() && (this._status < 200 || this._status == 204 || this._status == 304)) {
                    this._contentLength = 0L;
                    break;
                }
                if (this._last) {
                    this._contentLength = this._contentWritten;
                    if (content_length != null || !this.isResponse() && this._contentLength <= 0L && !content_type) break;
                    this._header.put(HttpHeaders.CONTENT_LENGTH_BUFFER);
                    this._header.put((byte)58);
                    this._header.put((byte)32);
                    BufferUtil.putDecLong((Buffer)this._header, (long)this._contentLength);
                    this._header.put(HttpTokens.CRLF);
                    break;
                }
                long l = this._contentLength = this._persistent == false || this._version < 11 ? -1L : -2L;
                if (!this.isRequest() || this._contentLength != -1L) break;
                this._contentLength = 0L;
                this._noContent = true;
                break;
            }
            case 0: {
                if (content_length != null || !this.isResponse() || this._status < 200 || this._status == 204 || this._status == 304) break;
                this._header.put(CONTENT_LENGTH_0);
                break;
            }
            case -1: {
                this._persistent = this.isRequest();
                break;
            }
            case -2: {
                break;
            }
        }
        if (this._contentLength == -2L) {
            if (transfer_encoding != null && 2 != transfer_encoding.getValueOrdinal()) {
                String c = transfer_encoding.getValue();
                if (!c.endsWith("chunked")) throw new IllegalArgumentException("BAD TE");
                transfer_encoding.put(this._header);
            } else {
                this._header.put(TRANSFER_ENCODING_CHUNKED);
            }
        }
        if (this._contentLength == -1L) {
            keep_alive = false;
            this._persistent = false;
        }
        if (this.isResponse()) {
            if (!this._persistent.booleanValue() && (close || this._version > 10)) {
                this._header.put(CONNECTION_CLOSE);
                if (connection != null) {
                    this._header.setPutIndex(this._header.putIndex() - 2);
                    this._header.put((byte)44);
                    this._header.put(connection.toString().getBytes());
                    this._header.put(CRLF);
                }
            } else if (keep_alive) {
                this._header.put(CONNECTION_KEEP_ALIVE);
                if (connection != null) {
                    this._header.setPutIndex(this._header.putIndex() - 2);
                    this._header.put((byte)44);
                    this._header.put(connection.toString().getBytes());
                    this._header.put(CRLF);
                }
            } else if (connection != null) {
                this._header.put(CONNECTION_);
                this._header.put(connection.toString().getBytes());
                this._header.put(CRLF);
            }
        }
        if (!has_server && this._status > 199 && this.getSendServerVersion()) {
            this._header.put(SERVER);
        }
        this._header.put(HttpTokens.CRLF);
        this._state = 2;
    }

    @Override
    public void complete() throws IOException {
        if (this._state == 4) {
            return;
        }
        super.complete();
        if (this._state < 3) {
            this._state = 3;
            if (this._contentLength == -2L) {
                this._needEOC = true;
            }
        }
        this.flushBuffer();
    }

    @Override
    public long flushBuffer() throws IOException {
        try {
            if (this._state == 0) {
                throw new IllegalStateException("State==HEADER");
            }
            this.prepareBuffers();
            if (this._endp == null) {
                if (this._needCRLF && this._buffer != null) {
                    this._buffer.put(HttpTokens.CRLF);
                }
                if (this._needEOC && this._buffer != null && !this._head) {
                    this._buffer.put(LAST_CHUNK);
                }
                this._needCRLF = false;
                this._needEOC = false;
                return 0L;
            }
            int total = 0;
            int len = -1;
            int to_flush = (this._header != null && this._header.length() > 0 ? 4 : 0) | (this._buffer != null && this._buffer.length() > 0 ? 2 : 0) | (this._bypass && this._content != null && this._content.length() > 0 ? 1 : 0);
            switch (to_flush) {
                case 7: {
                    throw new IllegalStateException();
                }
                case 6: {
                    len = this._endp.flush(this._header, this._buffer, null);
                    break;
                }
                case 5: {
                    len = this._endp.flush(this._header, this._content, null);
                    break;
                }
                case 4: {
                    len = this._endp.flush(this._header);
                    break;
                }
                case 3: {
                    throw new IllegalStateException();
                }
                case 2: {
                    len = this._endp.flush(this._buffer);
                    break;
                }
                case 1: {
                    len = this._endp.flush(this._content);
                    break;
                }
                case 0: {
                    if (this._header != null) {
                        this._header.clear();
                    }
                    this._bypass = false;
                    this._bufferChunked = false;
                    if (this._buffer != null) {
                        this._buffer.clear();
                        if (this._contentLength == -2L) {
                            this._buffer.setPutIndex(12);
                            this._buffer.setGetIndex(12);
                            if (this._content != null && this._content.length() < this._buffer.space() && this._state != 3) {
                                this._buffer.put(this._content);
                                this._content.clear();
                                this._content = null;
                            }
                        }
                    }
                    if (!(this._needCRLF || this._needEOC || this._content != null && this._content.length() != 0)) {
                        if (this._state == 3) {
                            this._state = 4;
                        }
                        if (this._state != 4 || this._persistent == null || this._persistent.booleanValue() || this._status == 100 || this._method != null) break;
                        this._endp.shutdownOutput();
                        break;
                    }
                    this.prepareBuffers();
                }
            }
            if (len > 0) {
                total += len;
            }
            return total;
        }
        catch (IOException e) {
            Log.ignore((Throwable)e);
            throw e instanceof EofException ? e : new EofException((Throwable)e);
        }
    }

    private void prepareBuffers() {
        if (!this._bufferChunked) {
            if (this._content != null && this._content.length() > 0 && this._buffer != null && this._buffer.space() > 0) {
                int len = this._buffer.put(this._content);
                this._content.skip(len);
                if (this._content.length() == 0) {
                    this._content = null;
                }
            }
            if (this._contentLength == -2L) {
                int size;
                int n = size = this._buffer == null ? 0 : this._buffer.length();
                if (size > 0) {
                    this._bufferChunked = true;
                    if (this._buffer.getIndex() == 12) {
                        this._buffer.poke(this._buffer.getIndex() - 2, HttpTokens.CRLF, 0, 2);
                        this._buffer.setGetIndex(this._buffer.getIndex() - 2);
                        BufferUtil.prependHexInt((Buffer)this._buffer, (int)size);
                        if (this._needCRLF) {
                            this._buffer.poke(this._buffer.getIndex() - 2, HttpTokens.CRLF, 0, 2);
                            this._buffer.setGetIndex(this._buffer.getIndex() - 2);
                            this._needCRLF = false;
                        }
                    } else {
                        if (this._needCRLF) {
                            if (this._header.length() > 0) {
                                throw new IllegalStateException("EOC");
                            }
                            this._header.put(HttpTokens.CRLF);
                            this._needCRLF = false;
                        }
                        BufferUtil.putHexInt((Buffer)this._header, (int)size);
                        this._header.put(HttpTokens.CRLF);
                    }
                    if (this._buffer.space() >= 2) {
                        this._buffer.put(HttpTokens.CRLF);
                    } else {
                        this._needCRLF = true;
                    }
                }
                if (this._needEOC && (this._content == null || this._content.length() == 0)) {
                    if (this._needCRLF) {
                        if (this._buffer == null && this._header.space() >= 2) {
                            this._header.put(HttpTokens.CRLF);
                            this._needCRLF = false;
                        } else if (this._buffer != null && this._buffer.space() >= 2) {
                            this._buffer.put(HttpTokens.CRLF);
                            this._needCRLF = false;
                        }
                    }
                    if (!this._needCRLF && this._needEOC) {
                        if (this._buffer == null && this._header.space() >= LAST_CHUNK.length) {
                            if (!this._head) {
                                this._header.put(LAST_CHUNK);
                                this._bufferChunked = true;
                            }
                            this._needEOC = false;
                        } else if (this._buffer != null && this._buffer.space() >= LAST_CHUNK.length) {
                            if (!this._head) {
                                this._buffer.put(LAST_CHUNK);
                                this._bufferChunked = true;
                            }
                            this._needEOC = false;
                        }
                    }
                }
            }
        }
        if (this._content != null && this._content.length() == 0) {
            this._content = null;
        }
    }

    public int getBytesBuffered() {
        return (this._header == null ? 0 : this._header.length()) + (this._buffer == null ? 0 : this._buffer.length()) + (this._content == null ? 0 : this._content.length());
    }

    public boolean isEmpty() {
        return !(this._header != null && this._header.length() != 0 || this._buffer != null && this._buffer.length() != 0 || this._content != null && this._content.length() != 0);
    }

    public String toString() {
        return "HttpGenerator s=" + this._state + " h=" + (this._header == null ? "null" : Integer.valueOf(this._header.length())) + " b=" + (this._buffer == null ? "null" : Integer.valueOf(this._buffer.length())) + " c=" + (this._content == null ? "null" : Integer.valueOf(this._content.length()));
    }

    static {
        int versionLength = HttpVersions.HTTP_1_1_BUFFER.length();
        for (int i = 0; i < __status.length; ++i) {
            HttpStatus.Code code = HttpStatus.getCode(i);
            if (code == null) continue;
            String reason = code.getMessage();
            byte[] bytes = new byte[versionLength + 5 + reason.length() + 2];
            HttpVersions.HTTP_1_1_BUFFER.peek(0, bytes, 0, versionLength);
            bytes[versionLength + 0] = 32;
            bytes[versionLength + 1] = (byte)(48 + i / 100);
            bytes[versionLength + 2] = (byte)(48 + i % 100 / 10);
            bytes[versionLength + 3] = (byte)(48 + i % 10);
            bytes[versionLength + 4] = 32;
            for (int j = 0; j < reason.length(); ++j) {
                bytes[versionLength + 5 + j] = (byte)reason.charAt(j);
            }
            bytes[versionLength + 5 + reason.length()] = 13;
            bytes[versionLength + 6 + reason.length()] = 10;
            HttpGenerator.__status[i] = new Status();
            HttpGenerator.__status[i]._reason = new ByteArrayBuffer(bytes, versionLength + 5, bytes.length - versionLength - 7, 0);
            HttpGenerator.__status[i]._schemeCode = new ByteArrayBuffer(bytes, 0, versionLength + 5, 0);
            HttpGenerator.__status[i]._responseLine = new ByteArrayBuffer(bytes, 0, bytes.length, 0);
        }
        LAST_CHUNK = new byte[]{48, 13, 10, 13, 10};
        CONTENT_LENGTH_0 = StringUtil.getBytes((String)"Content-Length: 0\r\n");
        CONNECTION_KEEP_ALIVE = StringUtil.getBytes((String)"Connection: keep-alive\r\n");
        CONNECTION_CLOSE = StringUtil.getBytes((String)"Connection: close\r\n");
        CONNECTION_ = StringUtil.getBytes((String)"Connection: ");
        CRLF = StringUtil.getBytes((String)"\r\n");
        TRANSFER_ENCODING_CHUNKED = StringUtil.getBytes((String)"Transfer-Encoding: chunked\r\n");
        SERVER = StringUtil.getBytes((String)"Server: Jetty(7.0.x)\r\n");
    }

    private static class Status {
        Buffer _reason;
        Buffer _schemeCode;
        Buffer _responseLine;

        private Status() {
        }
    }
}

