/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionIdListener;
import javax.servlet.http.HttpSessionListener;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.session.AbstractSession;
import org.eclipse.jetty.server.session.HashSessionIdManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.statistic.CounterStatistic;
import org.eclipse.jetty.util.statistic.SampleStatistic;

@ManagedObject(value="Abstract Session Manager")
public abstract class AbstractSessionManager
extends ContainerLifeCycle
implements SessionManager {
    static final Logger __log = SessionHandler.LOG;
    public Set<SessionTrackingMode> __defaultSessionTrackingModes = Collections.unmodifiableSet(new HashSet<SessionTrackingMode>(Arrays.asList(SessionTrackingMode.COOKIE, SessionTrackingMode.URL)));
    public static final int __distantFuture = 628992000;
    static final HttpSessionContext __nullSessionContext = new HttpSessionContext(){

        public HttpSession getSession(String sessionId) {
            return null;
        }

        public Enumeration getIds() {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }
    };
    private boolean _usingCookies = true;
    protected int _dftMaxIdleSecs = -1;
    protected SessionHandler _sessionHandler;
    protected boolean _httpOnly = false;
    protected SessionIdManager _sessionIdManager;
    protected boolean _secureCookies = false;
    protected boolean _secureRequestOnly = true;
    protected final List<HttpSessionAttributeListener> _sessionAttributeListeners = new CopyOnWriteArrayList<HttpSessionAttributeListener>();
    protected final List<HttpSessionListener> _sessionListeners = new CopyOnWriteArrayList<HttpSessionListener>();
    protected final List<HttpSessionIdListener> _sessionIdListeners = new CopyOnWriteArrayList<HttpSessionIdListener>();
    protected ClassLoader _loader;
    protected ContextHandler.Context _context;
    protected String _sessionCookie = "JSESSIONID";
    protected String _sessionIdPathParameterName = "jsessionid";
    protected String _sessionIdPathParameterNamePrefix = ";" + this._sessionIdPathParameterName + "=";
    protected String _sessionDomain;
    protected String _sessionPath;
    protected int _maxCookieAge = -1;
    protected int _refreshCookieAge;
    protected boolean _nodeIdInSessionId;
    protected boolean _checkingRemoteSessionIdEncoding;
    protected String _sessionComment;
    public Set<SessionTrackingMode> _sessionTrackingModes;
    private boolean _usingURLs;
    protected final CounterStatistic _sessionsStats = new CounterStatistic();
    protected final SampleStatistic _sessionTimeStats = new SampleStatistic();
    private SessionCookieConfig _cookieConfig = new CookieConfig();

    public AbstractSessionManager() {
        this.setSessionTrackingModes(this.__defaultSessionTrackingModes);
    }

    public ContextHandler.Context getContext() {
        return this._context;
    }

    public ContextHandler getContextHandler() {
        return this._context.getContextHandler();
    }

    @ManagedAttribute(value="path of the session cookie, or null for default")
    public String getSessionPath() {
        return this._sessionPath;
    }

    @ManagedAttribute(value="if greater the zero, the time in seconds a session cookie will last for")
    public int getMaxCookieAge() {
        return this._maxCookieAge;
    }

    @Override
    public HttpCookie access(HttpSession session, boolean secure) {
        long now = System.currentTimeMillis();
        AbstractSession s = ((SessionIf)session).getSession();
        if (s.access(now) && this.isUsingCookies() && (s.isIdChanged() || this.getSessionCookieConfig().getMaxAge() > 0 && this.getRefreshCookieAge() > 0 && (now - s.getCookieSetTime()) / 1000L > (long)this.getRefreshCookieAge())) {
            HttpCookie cookie = this.getSessionCookie(session, this._context == null ? "/" : this._context.getContextPath(), secure);
            s.cookieSet();
            s.setIdChanged(false);
            return cookie;
        }
        return null;
    }

    @Override
    public void addEventListener(EventListener listener) {
        if (listener instanceof HttpSessionAttributeListener) {
            this._sessionAttributeListeners.add((HttpSessionAttributeListener)listener);
        }
        if (listener instanceof HttpSessionListener) {
            this._sessionListeners.add((HttpSessionListener)listener);
        }
        if (listener instanceof HttpSessionIdListener) {
            this._sessionIdListeners.add((HttpSessionIdListener)listener);
        }
        this.addBean(listener, false);
    }

    @Override
    public void clearEventListeners() {
        for (EventListener e : this.getBeans(EventListener.class)) {
            this.removeBean(e);
        }
        this._sessionAttributeListeners.clear();
        this._sessionListeners.clear();
        this._sessionIdListeners.clear();
    }

    @Override
    public void complete(HttpSession session) {
        AbstractSession s = ((SessionIf)session).getSession();
        s.complete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStart() throws Exception {
        Server server;
        this._context = ContextHandler.getCurrentContext();
        this._loader = Thread.currentThread().getContextClassLoader();
        Server server2 = server = this.getSessionHandler().getServer();
        synchronized (server2) {
            if (this._sessionIdManager == null) {
                this._sessionIdManager = server.getSessionIdManager();
                if (this._sessionIdManager == null) {
                    ClassLoader serverLoader = server.getClass().getClassLoader();
                    try {
                        Thread.currentThread().setContextClassLoader(serverLoader);
                        this._sessionIdManager = new HashSessionIdManager();
                        server.setSessionIdManager(this._sessionIdManager);
                        server.manage(this._sessionIdManager);
                        this._sessionIdManager.start();
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(this._loader);
                    }
                }
                this.addBean(this._sessionIdManager, false);
            }
        }
        if (this._context != null) {
            String tmp = this._context.getInitParameter("org.eclipse.jetty.servlet.SessionCookie");
            if (tmp != null) {
                this._sessionCookie = tmp;
            }
            if ((tmp = this._context.getInitParameter("org.eclipse.jetty.servlet.SessionIdPathParameterName")) != null) {
                this.setSessionIdPathParameterName(tmp);
            }
            if (this._maxCookieAge == -1 && (tmp = this._context.getInitParameter("org.eclipse.jetty.servlet.MaxAge")) != null) {
                this._maxCookieAge = Integer.parseInt(tmp.trim());
            }
            if (this._sessionDomain == null) {
                this._sessionDomain = this._context.getInitParameter("org.eclipse.jetty.servlet.SessionDomain");
            }
            if (this._sessionPath == null) {
                this._sessionPath = this._context.getInitParameter("org.eclipse.jetty.servlet.SessionPath");
            }
            if ((tmp = this._context.getInitParameter("org.eclipse.jetty.servlet.CheckingRemoteSessionIdEncoding")) != null) {
                this._checkingRemoteSessionIdEncoding = Boolean.parseBoolean(tmp);
            }
        }
        super.doStart();
    }

    public void doStop() throws Exception {
        super.doStop();
        this.shutdownSessions();
        this._loader = null;
    }

    @Override
    @ManagedAttribute(value="true if cookies use the http only flag")
    public boolean getHttpOnly() {
        return this._httpOnly;
    }

    @Override
    public HttpSession getHttpSession(String nodeId) {
        String cluster_id = this.getSessionIdManager().getClusterId(nodeId);
        AbstractSession session = this.getSession(cluster_id);
        if (session != null && !session.getNodeId().equals(nodeId)) {
            session.setIdChanged(true);
        }
        return session;
    }

    @Override
    @ManagedAttribute(value="Session ID Manager")
    public SessionIdManager getSessionIdManager() {
        return this._sessionIdManager;
    }

    @Override
    @ManagedAttribute(value="defailt maximum time a session may be idle for (in s)")
    public int getMaxInactiveInterval() {
        return this._dftMaxIdleSecs;
    }

    @ManagedAttribute(value="maximum number of simultaneous sessions")
    public int getSessionsMax() {
        return (int)this._sessionsStats.getMax();
    }

    @ManagedAttribute(value="total number of sessions")
    public int getSessionsTotal() {
        return (int)this._sessionsStats.getTotal();
    }

    @ManagedAttribute(value="time before a session cookie is re-set (in s)")
    public int getRefreshCookieAge() {
        return this._refreshCookieAge;
    }

    @ManagedAttribute(value="if true, secure cookie flag is set on session cookies")
    public boolean getSecureCookies() {
        return this._secureCookies;
    }

    public boolean isSecureRequestOnly() {
        return this._secureRequestOnly;
    }

    public void setSecureRequestOnly(boolean secureRequestOnly) {
        this._secureRequestOnly = secureRequestOnly;
    }

    @ManagedAttribute(value="the set session cookie")
    public String getSessionCookie() {
        return this._sessionCookie;
    }

    @Override
    public HttpCookie getSessionCookie(HttpSession session, String contextPath, boolean requestIsSecure) {
        if (this.isUsingCookies()) {
            String sessionPath = this._cookieConfig.getPath() == null ? contextPath : this._cookieConfig.getPath();
            sessionPath = sessionPath == null || sessionPath.length() == 0 ? "/" : sessionPath;
            String id = this.getNodeId(session);
            HttpCookie cookie = null;
            cookie = this._sessionComment == null ? new HttpCookie(this._cookieConfig.getName(), id, this._cookieConfig.getDomain(), sessionPath, (long)this._cookieConfig.getMaxAge(), this._cookieConfig.isHttpOnly(), this._cookieConfig.isSecure() || this.isSecureRequestOnly() && requestIsSecure) : new HttpCookie(this._cookieConfig.getName(), id, this._cookieConfig.getDomain(), sessionPath, (long)this._cookieConfig.getMaxAge(), this._cookieConfig.isHttpOnly(), this._cookieConfig.isSecure() || this.isSecureRequestOnly() && requestIsSecure, this._sessionComment, 1);
            return cookie;
        }
        return null;
    }

    @ManagedAttribute(value="domain of the session cookie, or null for the default")
    public String getSessionDomain() {
        return this._sessionDomain;
    }

    public SessionHandler getSessionHandler() {
        return this._sessionHandler;
    }

    @ManagedAttribute(value="number of currently active sessions")
    public int getSessions() {
        return (int)this._sessionsStats.getCurrent();
    }

    @Override
    @ManagedAttribute(value="name of use for URL session tracking")
    public String getSessionIdPathParameterName() {
        return this._sessionIdPathParameterName;
    }

    @Override
    public String getSessionIdPathParameterNamePrefix() {
        return this._sessionIdPathParameterNamePrefix;
    }

    @Override
    public boolean isUsingCookies() {
        return this._usingCookies;
    }

    @Override
    public boolean isValid(HttpSession session) {
        AbstractSession s = ((SessionIf)session).getSession();
        return s.isValid();
    }

    @Override
    public String getClusterId(HttpSession session) {
        AbstractSession s = ((SessionIf)session).getSession();
        return s.getClusterId();
    }

    @Override
    public String getNodeId(HttpSession session) {
        AbstractSession s = ((SessionIf)session).getSession();
        return s.getNodeId();
    }

    @Override
    public HttpSession newHttpSession(HttpServletRequest request) {
        AbstractSession session = this.newSession(request);
        session.setMaxInactiveInterval(this._dftMaxIdleSecs);
        this.addSession(session, true);
        return session;
    }

    @Override
    public void removeEventListener(EventListener listener) {
        if (listener instanceof HttpSessionAttributeListener) {
            this._sessionAttributeListeners.remove(listener);
        }
        if (listener instanceof HttpSessionListener) {
            this._sessionListeners.remove(listener);
        }
        if (listener instanceof HttpSessionIdListener) {
            this._sessionIdListeners.remove(listener);
        }
        this.removeBean(listener);
    }

    @ManagedOperation(value="reset statistics", impact="ACTION")
    public void statsReset() {
        this._sessionsStats.reset((long)this.getSessions());
        this._sessionTimeStats.reset();
    }

    public void setHttpOnly(boolean httpOnly) {
        this._httpOnly = httpOnly;
    }

    @Override
    public void setSessionIdManager(SessionIdManager metaManager) {
        this.updateBean(this._sessionIdManager, metaManager);
        this._sessionIdManager = metaManager;
    }

    @Override
    public void setMaxInactiveInterval(int seconds) {
        this._dftMaxIdleSecs = seconds;
    }

    public void setRefreshCookieAge(int ageInSeconds) {
        this._refreshCookieAge = ageInSeconds;
    }

    public void setSessionCookie(String cookieName) {
        this._sessionCookie = cookieName;
    }

    @Override
    public void setSessionHandler(SessionHandler sessionHandler) {
        this._sessionHandler = sessionHandler;
    }

    @Override
    public void setSessionIdPathParameterName(String param) {
        this._sessionIdPathParameterName = param == null || "none".equals(param) ? null : param;
        this._sessionIdPathParameterNamePrefix = param == null || "none".equals(param) ? null : ";" + this._sessionIdPathParameterName + "=";
    }

    public void setUsingCookies(boolean usingCookies) {
        this._usingCookies = usingCookies;
    }

    protected abstract void addSession(AbstractSession var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSession(AbstractSession session, boolean created) {
        SessionIdManager sessionIdManager = this._sessionIdManager;
        synchronized (sessionIdManager) {
            this._sessionIdManager.addSession(session);
            this.addSession(session);
        }
        if (created) {
            this._sessionsStats.increment();
            if (this._sessionListeners != null) {
                HttpSessionEvent event = new HttpSessionEvent((HttpSession)session);
                for (HttpSessionListener listener : this._sessionListeners) {
                    listener.sessionCreated(event);
                }
            }
        }
    }

    public abstract AbstractSession getSession(String var1);

    protected abstract void shutdownSessions() throws Exception;

    protected abstract AbstractSession newSession(HttpServletRequest var1);

    public boolean isNodeIdInSessionId() {
        return this._nodeIdInSessionId;
    }

    public void setNodeIdInSessionId(boolean nodeIdInSessionId) {
        this._nodeIdInSessionId = nodeIdInSessionId;
    }

    public void removeSession(HttpSession session, boolean invalidate) {
        AbstractSession s = ((SessionIf)session).getSession();
        this.removeSession(s, invalidate);
    }

    public boolean removeSession(AbstractSession session, boolean invalidate) {
        boolean removed = this.removeSession(session.getClusterId());
        if (removed) {
            this._sessionsStats.decrement();
            this._sessionTimeStats.set(Math.round((double)(System.currentTimeMillis() - session.getCreationTime()) / 1000.0));
            this._sessionIdManager.removeSession(session);
            if (invalidate) {
                this._sessionIdManager.invalidateAll(session.getClusterId());
            }
            if (invalidate && this._sessionListeners != null) {
                HttpSessionEvent event = new HttpSessionEvent((HttpSession)session);
                for (int i = this._sessionListeners.size() - 1; i >= 0; --i) {
                    this._sessionListeners.get(i).sessionDestroyed(event);
                }
            }
        }
        return removed;
    }

    protected abstract boolean removeSession(String var1);

    @ManagedAttribute(value="maximum amount of time sessions have remained active (in s)")
    public long getSessionTimeMax() {
        return this._sessionTimeStats.getMax();
    }

    @Override
    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return this.__defaultSessionTrackingModes;
    }

    @Override
    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return Collections.unmodifiableSet(this._sessionTrackingModes);
    }

    @Override
    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        this._sessionTrackingModes = new HashSet<SessionTrackingMode>(sessionTrackingModes);
        this._usingCookies = this._sessionTrackingModes.contains(SessionTrackingMode.COOKIE);
        this._usingURLs = this._sessionTrackingModes.contains(SessionTrackingMode.URL);
    }

    @Override
    public boolean isUsingURLs() {
        return this._usingURLs;
    }

    @Override
    public SessionCookieConfig getSessionCookieConfig() {
        return this._cookieConfig;
    }

    @ManagedAttribute(value="total time sessions have remained valid")
    public long getSessionTimeTotal() {
        return this._sessionTimeStats.getTotal();
    }

    @ManagedAttribute(value="mean time sessions remain valid (in s)")
    public double getSessionTimeMean() {
        return this._sessionTimeStats.getMean();
    }

    @ManagedAttribute(value="standard deviation a session remained valid (in s)")
    public double getSessionTimeStdDev() {
        return this._sessionTimeStats.getStdDev();
    }

    @Override
    @ManagedAttribute(value="check remote session id encoding")
    public boolean isCheckingRemoteSessionIdEncoding() {
        return this._checkingRemoteSessionIdEncoding;
    }

    @Override
    public void setCheckingRemoteSessionIdEncoding(boolean remote) {
        this._checkingRemoteSessionIdEncoding = remote;
    }

    @Override
    public void renewSessionId(String oldClusterId, String oldNodeId, String newClusterId, String newNodeId) {
        if (!this._sessionIdListeners.isEmpty()) {
            AbstractSession session = this.getSession(newClusterId);
            HttpSessionEvent event = new HttpSessionEvent((HttpSession)session);
            for (HttpSessionIdListener l : this._sessionIdListeners) {
                l.sessionIdChanged(event, oldClusterId);
            }
        }
    }

    public void doSessionAttributeListeners(AbstractSession session, String name, Object old, Object value) {
        if (!this._sessionAttributeListeners.isEmpty()) {
            HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)session, name, old == null ? value : old);
            for (HttpSessionAttributeListener l : this._sessionAttributeListeners) {
                if (old == null) {
                    l.attributeAdded(event);
                    continue;
                }
                if (value == null) {
                    l.attributeRemoved(event);
                    continue;
                }
                l.attributeReplaced(event);
            }
        }
    }

    @Override
    @Deprecated
    public SessionIdManager getMetaManager() {
        throw new UnsupportedOperationException();
    }

    public static interface SessionIf
    extends HttpSession {
        public AbstractSession getSession();
    }

    public final class CookieConfig
    implements SessionCookieConfig {
        public String getComment() {
            return AbstractSessionManager.this._sessionComment;
        }

        public String getDomain() {
            return AbstractSessionManager.this._sessionDomain;
        }

        public int getMaxAge() {
            return AbstractSessionManager.this._maxCookieAge;
        }

        public String getName() {
            return AbstractSessionManager.this._sessionCookie;
        }

        public String getPath() {
            return AbstractSessionManager.this._sessionPath;
        }

        public boolean isHttpOnly() {
            return AbstractSessionManager.this._httpOnly;
        }

        public boolean isSecure() {
            return AbstractSessionManager.this._secureCookies;
        }

        public void setComment(String comment) {
            if (AbstractSessionManager.this._context != null && AbstractSessionManager.this._context.getContextHandler().isAvailable()) {
                throw new IllegalStateException("CookieConfig cannot be set after ServletContext is started");
            }
            AbstractSessionManager.this._sessionComment = comment;
        }

        public void setDomain(String domain) {
            if (AbstractSessionManager.this._context != null && AbstractSessionManager.this._context.getContextHandler().isAvailable()) {
                throw new IllegalStateException("CookieConfig cannot be set after ServletContext is started");
            }
            AbstractSessionManager.this._sessionDomain = domain;
        }

        public void setHttpOnly(boolean httpOnly) {
            if (AbstractSessionManager.this._context != null && AbstractSessionManager.this._context.getContextHandler().isAvailable()) {
                throw new IllegalStateException("CookieConfig cannot be set after ServletContext is started");
            }
            AbstractSessionManager.this._httpOnly = httpOnly;
        }

        public void setMaxAge(int maxAge) {
            if (AbstractSessionManager.this._context != null && AbstractSessionManager.this._context.getContextHandler().isAvailable()) {
                throw new IllegalStateException("CookieConfig cannot be set after ServletContext is started");
            }
            AbstractSessionManager.this._maxCookieAge = maxAge;
        }

        public void setName(String name) {
            if (AbstractSessionManager.this._context != null && AbstractSessionManager.this._context.getContextHandler().isAvailable()) {
                throw new IllegalStateException("CookieConfig cannot be set after ServletContext is started");
            }
            AbstractSessionManager.this._sessionCookie = name;
        }

        public void setPath(String path) {
            if (AbstractSessionManager.this._context != null && AbstractSessionManager.this._context.getContextHandler().isAvailable()) {
                throw new IllegalStateException("CookieConfig cannot be set after ServletContext is started");
            }
            AbstractSessionManager.this._sessionPath = path;
        }

        public void setSecure(boolean secure) {
            if (AbstractSessionManager.this._context != null && AbstractSessionManager.this._context.getContextHandler().isAvailable()) {
                throw new IllegalStateException("CookieConfig cannot be set after ServletContext is started");
            }
            AbstractSessionManager.this._secureCookies = secure;
        }
    }
}

