/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jetty.start.BaseHome;
import org.eclipse.jetty.start.Classpath;
import org.eclipse.jetty.start.CommandLineBuilder;
import org.eclipse.jetty.start.FS;
import org.eclipse.jetty.start.FileArg;
import org.eclipse.jetty.start.JarVersion;
import org.eclipse.jetty.start.Module;
import org.eclipse.jetty.start.ModuleGraphWriter;
import org.eclipse.jetty.start.Modules;
import org.eclipse.jetty.start.NaturalSort;
import org.eclipse.jetty.start.StartArgs;
import org.eclipse.jetty.start.StartIni;
import org.eclipse.jetty.start.StartLog;
import org.eclipse.jetty.start.UsageException;

public class Main {
    private static final int EXIT_USAGE = 1;
    private final BaseHome baseHome = new BaseHome();

    public static String join(Collection<?> objs, String delim) {
        StringBuilder str = new StringBuilder();
        boolean needDelim = false;
        for (Object obj : objs) {
            if (needDelim) {
                str.append(delim);
            }
            str.append(obj);
            needDelim = true;
        }
        return str.toString();
    }

    public static void main(String[] args) {
        try {
            Main main = new Main();
            StartArgs startArgs = main.processCommandLine(args);
            main.start(startArgs);
        }
        catch (UsageException e) {
            System.err.println(e.getMessage());
            Main.usageExit(e.getCause(), e.getExitCode());
        }
        catch (Throwable e) {
            Main.usageExit(e, -5);
        }
    }

    static void usageExit(int exit) {
        Main.usageExit(null, exit);
    }

    static void usageExit(Throwable t, int exit) {
        if (t != null) {
            t.printStackTrace(System.err);
        }
        System.err.println();
        System.err.println("Usage: java -jar start.jar [options] [properties] [configs]");
        System.err.println("       java -jar start.jar --help  # for more information");
        System.exit(exit);
    }

    Main() throws IOException {
    }

    private void copyInThread(final InputStream in, final OutputStream out) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    byte[] buf = new byte[1024];
                    int len = in.read(buf);
                    while (len > 0) {
                        out.write(buf, 0, len);
                        len = in.read(buf);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }).start();
    }

    private void initFile(FileArg arg) {
        block31: {
            try {
                File file = this.baseHome.getBaseFile(arg.location);
                StartLog.debug("Module file %s %s", file.getAbsolutePath(), file.exists() ? "[Exists!]" : "");
                if (file.exists()) {
                    return;
                }
                if (arg.uri != null) {
                    URL url = new URL(arg.uri);
                    System.err.println("DOWNLOAD: " + url + " to " + arg.location);
                    FS.ensureDirectoryExists(file.getParentFile());
                    byte[] buf = new byte[8192];
                    try (InputStream in = url.openStream();
                         FileOutputStream out = new FileOutputStream(file);){
                        int len;
                        do {
                            if ((len = in.read(buf)) <= 0) continue;
                            ((OutputStream)out).write(buf, 0, len);
                        } while (len >= 0);
                        break block31;
                    }
                }
                if (arg.location.endsWith("/")) {
                    System.err.println("MKDIR: " + this.baseHome.toShortForm(file));
                    file.mkdirs();
                } else {
                    StartLog.warn("MISSING: required file " + this.baseHome.toShortForm(file), new Object[0]);
                }
            }
            catch (Exception e) {
                StartLog.warn("ERROR: processing %s%n%s", arg, e);
                StartLog.warn(e);
                Main.usageExit(1);
            }
        }
    }

    private void dumpClasspathWithVersions(Classpath classpath) {
        System.out.println();
        System.out.println("Jetty Server Classpath:");
        System.out.println("-----------------------");
        if (classpath.count() == 0) {
            System.out.println("No classpath entries and/or version information available show.");
            return;
        }
        System.out.println("Version Information on " + classpath.count() + " entr" + (classpath.count() > 1 ? "ies" : "y") + " in the classpath.");
        System.out.println("Note: order presented here is how they would appear on the classpath.");
        System.out.println("      changes to the --module=name command line options will be reflected here.");
        int i = 0;
        for (File element : classpath.getElements()) {
            System.out.printf("%2d: %24s | %s\n", i++, this.getVersion(element), this.baseHome.toShortForm(element));
        }
    }

    public BaseHome getBaseHome() {
        return this.baseHome;
    }

    private String getVersion(File element) {
        String name;
        if (element.isDirectory()) {
            return "(dir)";
        }
        if (element.isFile() && (name = element.getName().toLowerCase(Locale.ENGLISH)).endsWith(".jar")) {
            return JarVersion.getVersion(element);
        }
        return "";
    }

    public void invokeMain(StartArgs args) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException, IOException {
        Class<?> invoked_class = null;
        ClassLoader classloader = args.getClasspath().getClassLoader();
        String mainclass = args.getMainClassname();
        try {
            invoked_class = classloader.loadClass(mainclass);
        }
        catch (ClassNotFoundException e) {
            System.out.println("WARNING: Nothing to start, exiting ...");
            StartLog.debug(e);
            Main.usageExit(-2);
            return;
        }
        StartLog.debug("%s - %s", invoked_class, invoked_class.getPackage().getImplementationVersion());
        CommandLineBuilder cmd = args.getMainArgs(this.baseHome, false);
        String[] argArray = cmd.getArgs().toArray(new String[0]);
        StartLog.debug("Command Line Args: %s", cmd.toString());
        Class[] method_param_types = new Class[]{argArray.getClass()};
        Method main = invoked_class.getDeclaredMethod("main", method_param_types);
        Object[] method_params = new Object[]{argArray};
        main.invoke(null, method_params);
    }

    public void listConfig(StartArgs args) {
        args.dumpEnvironment();
        args.dumpJvmArgs();
        args.dumpSystemProperties();
        args.dumpProperties();
        this.dumpClasspathWithVersions(args.getClasspath());
        args.dumpActiveXmls(this.baseHome);
    }

    private void listModules(StartArgs args) {
        System.out.println();
        System.out.println("Jetty All Available Modules:");
        System.out.println("----------------------------");
        args.getAllModules().dump();
        System.out.println();
        System.out.println("Jetty Active Module Tree:");
        System.out.println("-------------------------");
        Modules modules = args.getAllModules();
        modules.dumpEnabledTree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moduleIni(StartArgs args, String name, boolean topLevel, boolean appendStartIni) throws IOException {
        boolean has_ini_lines;
        File start_d = this.baseHome.getBaseFile("start.d");
        Modules modules = args.getAllModules();
        Module module = modules.get(name);
        if (module == null) {
            StartLog.warn("ERROR: No known module for %s", name);
            return;
        }
        File start_ini = this.baseHome.getBaseFile("start.ini");
        String short_start_ini = this.baseHome.toShortForm(start_ini);
        File ini = new File(start_d, name + ".ini");
        String short_ini = this.baseHome.toShortForm(ini);
        StartIni module_ini = null;
        if (ini.exists() && (module_ini = new StartIni(ini)).getLineMatches(Pattern.compile("--module=(.*, *)*" + name)).size() == 0) {
            StartLog.warn("ERROR: %s is not enabled in %s!", name, short_ini);
            return;
        }
        boolean transitive = module.isEnabled() && module.getSources().size() == 0;
        boolean bl = has_ini_lines = module.getInitialise().size() > 0;
        if (!module.isEnabled() || transitive && has_ini_lines || topLevel && !ini.exists() && !appendStartIni) {
            String source = null;
            try (PrintWriter out = null;){
                if (appendStartIni) {
                    if (!start_ini.exists() && !start_ini.createNewFile() || !start_ini.canWrite()) {
                        StartLog.warn("ERROR: Bad %s! ", start_ini);
                        return;
                    }
                    source = short_start_ini;
                    StartLog.info("%-15s initialised in %s (appended)", name, source);
                    out = new PrintWriter(new FileWriter(start_ini, true));
                } else {
                    FS.ensureDirectoryExists(start_d);
                    FS.ensureDirectoryWritable(start_d);
                    try {
                        if (!ini.createNewFile()) {
                            StartLog.warn("ERROR: %s cannot be initialised in %s! ", name, short_ini);
                            return;
                        }
                    }
                    catch (IOException e) {
                        StartLog.warn("ERROR: Unable to create %s!", ini);
                        StartLog.warn(e);
                        return;
                    }
                    source = short_ini;
                    StartLog.info("%-15s initialised in %s (created)", name, source);
                    out = new PrintWriter(ini);
                }
                if (appendStartIni) {
                    out.println();
                }
                out.println("#");
                out.println("# Initialize module " + name);
                out.println("#");
                Pattern p = Pattern.compile("--module=([^,]+)(,([^,]+))*");
                out.println("--module=" + name);
                args.parse("--module=" + name, source);
                modules.enable(name, Collections.singletonList(source));
                for (String line : module.getInitialise()) {
                    out.println(line);
                    args.parse(line, source);
                    Matcher m = p.matcher(line);
                    if (!m.matches()) continue;
                    for (int i = 1; i <= m.groupCount(); ++i) {
                        String n = m.group(i);
                        if (n == null || (n = n.trim()).length() == 0 || n.startsWith(",")) continue;
                        modules.enable(n, Collections.singletonList(source));
                    }
                }
            }
        }
        if (ini.exists()) {
            StartLog.info("%-15s initialised in %s", name, short_ini);
        }
        for (String source : module.getSources()) {
            if (short_ini.equals(source)) continue;
            StartLog.info("%-15s enabled in     %s", name, this.baseHome.toShortForm(source));
        }
        for (String file : module.getFiles()) {
            this.initFile(new FileArg(file));
        }
        if (topLevel) {
            ArrayList<Module> parents = new ArrayList<Module>();
            for (String parent : modules.resolveParentModulesOf(name)) {
                if (name.equals(parent)) continue;
                Module m = modules.get(parent);
                m.setEnabled(true);
                parents.add(m);
            }
            Collections.sort(parents, Collections.reverseOrder(new Module.DepthComparator()));
            for (Module m : parents) {
                this.moduleIni(args, m.getName(), false, appendStartIni);
            }
        }
    }

    public StartArgs processCommandLine(List<String> cmdLine) throws Exception {
        return this.processCommandLine(cmdLine.toArray(new String[cmdLine.size()]));
    }

    public StartArgs processCommandLine(String[] cmdLine) throws Exception {
        File start_d;
        StartArgs args = new StartArgs(cmdLine);
        this.baseHome.initialize(args);
        StartLog.getInstance().initialize(this.baseHome, args);
        StartLog.debug("jetty.home=%s", this.baseHome.getHome());
        StartLog.debug("jetty.base=%s", this.baseHome.getBase());
        File start_ini = this.baseHome.getBaseFile("start.ini");
        if (FS.canReadFile(start_ini)) {
            StartLog.debug("Reading ${jetty.base}/start.ini - %s", start_ini);
            args.parse(this.baseHome, new StartIni(start_ini));
        }
        if (FS.canReadDirectory(start_d = this.baseHome.getBaseFile("start.d"))) {
            ArrayList<File> files = new ArrayList<File>();
            for (File file : start_d.listFiles(new FS.IniFilter())) {
                files.add(file);
            }
            Collections.sort(files, new NaturalSort.Files());
            for (File file : files) {
                StartLog.debug("Reading ${jetty.base}/start.d/%s - %s", file.getName(), file);
                args.parse(this.baseHome, new StartIni(file));
            }
        }
        StartLog.debug("Parsing collected arguments", new Object[0]);
        args.parseCommandLine();
        Modules modules = new Modules();
        StartLog.debug("Registering all modules", new Object[0]);
        modules.registerAll(this.baseHome, args);
        for (String enabledModule : args.getEnabledModules()) {
            List<String> sources = args.getSources(enabledModule);
            modules.enable(enabledModule, sources);
        }
        StartLog.debug("Building Module Graph", new Object[0]);
        modules.buildGraph();
        args.setAllModules(modules);
        List<Module> activeModules = modules.resolveEnabled();
        args.expandModules(this.baseHome, activeModules);
        args.resolveExtraXmls(this.baseHome);
        return args;
    }

    public void start(StartArgs args) throws IOException, InterruptedException {
        StartLog.debug("StartArgs: %s", args);
        Classpath classpath = args.getClasspath();
        System.setProperty("java.class.path", classpath.toString());
        if (args.isHelp()) {
            this.usage(true);
        }
        if (args.isListClasspath()) {
            this.dumpClasspathWithVersions(classpath);
        }
        if (args.isListConfig()) {
            this.listConfig(args);
        }
        if (args.isListModules()) {
            this.listModules(args);
        }
        if (args.getModuleGraphFilename() != null) {
            File outputFile = this.baseHome.getBaseFile(args.getModuleGraphFilename());
            System.out.printf("Generating GraphViz Graph of Jetty Modules at %s%n", this.baseHome.toShortForm(outputFile));
            ModuleGraphWriter writer = new ModuleGraphWriter();
            writer.config(args.getProperties());
            writer.write(args.getAllModules(), outputFile);
        }
        if (args.isDryRun()) {
            CommandLineBuilder cmd = args.getMainArgs(this.baseHome, true);
            System.out.println(cmd.toString());
        }
        if (args.isStopCommand()) {
            int stopPort = Integer.parseInt(args.getProperties().getString("STOP.PORT"));
            String stopKey = args.getProperties().getString("STOP.KEY");
            if (args.getProperties().getString("STOP.WAIT") != null) {
                int stopWait = Integer.parseInt(args.getProperties().getString("STOP.PORT"));
                this.stop(stopPort, stopKey, stopWait);
            } else {
                this.stop(stopPort, stopKey);
            }
        }
        for (String module : args.getModuleStartIni()) {
            this.moduleIni(args, module, true, true);
        }
        for (String module : args.getModuleStartdIni()) {
            this.moduleIni(args, module, true, false);
        }
        for (FileArg arg : args.getFiles()) {
            String type;
            File file = this.baseHome.getBaseFile(arg.location);
            if (!file.exists() && args.isDownload()) {
                this.initFile(arg);
            }
            if (file.exists()) continue;
            args.setRun(false);
            String string = type = arg.location.endsWith("/") ? "directory" : "file";
            if (arg.uri == null) {
                StartLog.warn("Required %s '%s' does not exist. Run with --create-files to create", type, this.baseHome.toShortForm(file));
                continue;
            }
            StartLog.warn("Required %s '%s' not downloaded from %s.  Run with --create-files to download", type, this.baseHome.toShortForm(file), arg.uri);
        }
        if (!args.isRun()) {
            return;
        }
        if (args.isExec()) {
            CommandLineBuilder cmd = args.getMainArgs(this.baseHome, true);
            ProcessBuilder pbuilder = new ProcessBuilder(cmd.getArgs());
            final Process process = pbuilder.start();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    StartLog.debug("Destroying " + process, new Object[0]);
                    process.destroy();
                }
            });
            this.copyInThread(process.getErrorStream(), System.err);
            this.copyInThread(process.getInputStream(), System.out);
            this.copyInThread(System.in, process.getOutputStream());
            process.waitFor();
            System.exit(0);
            return;
        }
        if (args.hasJvmArgs() || args.hasSystemProperties()) {
            System.err.println("WARNING: System properties and/or JVM args set.  Consider using --dry-run or --exec");
        }
        ClassLoader cl = classpath.getClassLoader();
        Thread.currentThread().setContextClassLoader(cl);
        try {
            this.invokeMain(args);
        }
        catch (Exception e) {
            Main.usageExit(e, -2);
        }
    }

    public void stop(int port, String key) {
        this.stop(port, key, 0);
    }

    public void stop(int port, String key, int timeout) {
        int _port = port;
        String _key = key;
        try {
            if (_port <= 0) {
                System.err.println("STOP.PORT system property must be specified");
            }
            if (_key == null) {
                _key = "";
                System.err.println("STOP.KEY system property must be specified");
                System.err.println("Using empty key");
            }
            try (Socket s = new Socket(InetAddress.getByName("127.0.0.1"), _port);){
                if (timeout > 0) {
                    s.setSoTimeout(timeout * 1000);
                }
                try (OutputStream out = s.getOutputStream();){
                    out.write((_key + "\r\nstop\r\n").getBytes());
                    out.flush();
                    if (timeout > 0) {
                        String response;
                        System.err.printf("Waiting %,d seconds for jetty to stop%n", timeout);
                        LineNumberReader lin = new LineNumberReader(new InputStreamReader(s.getInputStream()));
                        while ((response = lin.readLine()) != null) {
                            StartLog.debug("Received \"%s\"", response);
                            if (!"Stopped".equals(response)) continue;
                            StartLog.warn("Server reports itself as Stopped", new Object[0]);
                        }
                    }
                }
            }
        }
        catch (SocketTimeoutException e) {
            System.err.println("Timed out waiting for stop confirmation");
            System.exit(-5);
        }
        catch (ConnectException e) {
            Main.usageExit(e, -4);
        }
        catch (Exception e) {
            Main.usageExit(e, -5);
        }
    }

    public void usage(boolean exit) {
        boolean usagePresented;
        block42: {
            String usageResource = "org/eclipse/jetty/start/usage.txt";
            usagePresented = false;
            try (InputStream usageStream = this.getClass().getClassLoader().getResourceAsStream(usageResource);){
                if (usageStream != null) {
                    try (InputStreamReader reader = new InputStreamReader(usageStream);
                         BufferedReader buf = new BufferedReader(reader);){
                        String line;
                        usagePresented = true;
                        while ((line = buf.readLine()) != null) {
                            System.out.println(line);
                        }
                        break block42;
                    }
                }
                System.out.println("No usage.txt ??");
            }
            catch (IOException e) {
                StartLog.warn(e);
            }
        }
        if (!usagePresented) {
            System.err.println("ERROR: detailed usage resource unavailable");
        }
        if (exit) {
            System.exit(1);
        }
    }
}

