/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packager.rpm;

public enum HashAlgorithm {
    SHA1(2, "sha"),
    SHA256(8, "sha256"),
    SHA512(10, "sha512");

    private int value;
    private String id;

    private HashAlgorithm(int value, String id) {
        this.value = value;
        this.id = id;
    }

    public int getValue() {
        return this.value;
    }

    public String getId() {
        return this.id;
    }

    public static HashAlgorithm from(String name) {
        if (name == null || name.isEmpty()) {
            return SHA1;
        }
        return HashAlgorithm.valueOf(name);
    }
}

