/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.commons;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.WKTReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.text.commons.BuildResultStack;
import org.geotools.filter.text.commons.IToken;
import org.geotools.filter.text.commons.PeriodNode;
import org.geotools.filter.text.commons.Result;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.BinaryExpression;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.DistanceBufferOperator;
import org.opengis.filter.temporal.After;
import org.opengis.filter.temporal.Before;
import org.opengis.filter.temporal.During;
import org.opengis.filter.temporal.TEquals;
import org.opengis.temporal.Period;

public abstract class AbstractFilterBuilder {
    static Pattern DATETIME_PATTERN = Pattern.compile("(\\d{4}-\\d{1,2}-\\d{1,2})?(?:T?(\\d{2}:\\d{2}:\\d{2}(?:\\.\\d+)?))?(Z|(?:[+-]\\d{2}(?:\\:?\\d{2})?))?", 2);
    static Pattern TZOFFSET_PATTERN = Pattern.compile("[+-]\\d{2}(?:\\d{2})");
    private final FilterFactory filterFactory;
    private final BuildResultStack resultStack;
    protected final String cqlSource;

    public AbstractFilterBuilder(String cqlSource, FilterFactory filterFactory) {
        assert (cqlSource != null) : "illegal argument";
        assert (filterFactory != null) : "illegal argument";
        this.cqlSource = cqlSource;
        this.filterFactory = filterFactory;
        this.resultStack = new BuildResultStack(cqlSource);
    }

    protected FilterFactory getFilterFactory() {
        return this.filterFactory;
    }

    protected final BuildResultStack getResultStack() {
        return this.resultStack;
    }

    protected final String getStatement() {
        return this.cqlSource;
    }

    public void pushResult(Result result) {
        this.resultStack.push(result);
    }

    public Result peekResult() {
        return this.resultStack.peek();
    }

    public Filter getFilter() throws CQLException {
        return this.resultStack.popFilter();
    }

    public Expression getExpression() throws CQLException {
        return this.resultStack.popExpression();
    }

    public List<Filter> getFilterList() throws CQLException {
        int size = this.resultStack.size();
        ArrayList<Filter> results = new ArrayList<Filter>(size);
        for (int i = 0; i < size; ++i) {
            Result item = this.resultStack.popResult();
            Filter result = (Filter)item.getBuilt();
            results.add(0, result);
        }
        return results;
    }

    public BinaryExpression buildAddExpression() throws CQLException {
        Expression right = this.resultStack.popExpression();
        Expression left = this.resultStack.popExpression();
        return this.filterFactory.add(left, right);
    }

    public BinaryExpression buildSubtractExression() throws CQLException {
        Expression right = this.resultStack.popExpression();
        Expression left = this.resultStack.popExpression();
        return this.filterFactory.subtract(left, right);
    }

    public BinaryExpression buildMultiplyExpression() throws CQLException {
        Expression right = this.resultStack.popExpression();
        Expression left = this.resultStack.popExpression();
        return this.filterFactory.multiply(left, right);
    }

    public BinaryExpression buildDivideExpression() throws CQLException {
        Expression right = this.resultStack.popExpression();
        Expression left = this.resultStack.popExpression();
        return this.filterFactory.divide(left, right);
    }

    public Filter buildAndFilter() throws CQLException {
        Filter right = this.resultStack.popFilter();
        Filter left = this.resultStack.popFilter();
        Object logicFilter = null;
        logicFilter = Filter.INCLUDE.equals(right) ? left : (Filter.INCLUDE.equals(left) ? right : (Filter.EXCLUDE.equals(right) || Filter.EXCLUDE.equals(left) ? Filter.EXCLUDE : this.filterFactory.and(left, right)));
        return logicFilter;
    }

    public Filter buildOrFilter() throws CQLException {
        Filter right = this.resultStack.popFilter();
        Filter left = this.resultStack.popFilter();
        Object logicFilter = null;
        logicFilter = Filter.INCLUDE.equals(right) || Filter.INCLUDE.equals(left) ? Filter.INCLUDE : (Filter.EXCLUDE.equals(left) ? right : (Filter.EXCLUDE.equals(right) ? left : this.filterFactory.or(left, right)));
        return logicFilter;
    }

    public Filter buildNotFilter() throws CQLException {
        Filter right = this.resultStack.popFilter();
        Object logicFilter = null;
        logicFilter = Filter.INCLUDE.equals(right) ? Filter.EXCLUDE : (Filter.EXCLUDE.equals(right) ? Filter.INCLUDE : this.filterFactory.not(right));
        return logicFilter;
    }

    public PropertyIsLike buildLikeFilter(boolean matchCase) throws CQLException {
        String WC_MULTI = "%";
        String WC_SINGLE = "_";
        String ESCAPE = "\\";
        try {
            Expression pattern = this.resultStack.popExpression();
            Expression expr = this.resultStack.popExpression();
            PropertyIsLike f = this.filterFactory.like(expr, pattern.toString(), "%", "_", "\\", matchCase);
            return f;
        }
        catch (IllegalFilterException ife) {
            throw new CQLException("Exception building LikeFilter: " + ife.getMessage(), this.cqlSource);
        }
    }

    public PropertyIsNull buildPropertyIsNull() throws CQLException {
        try {
            Expression property = this.resultStack.popExpression();
            PropertyIsNull filter = this.filterFactory.isNull(property);
            return filter;
        }
        catch (CQLException e) {
            throw new CQLException("Exception building Null Predicate", this.cqlSource);
        }
    }

    public Not buildPorpertyNotIsNull() throws CQLException {
        return this.filterFactory.not((Filter)this.buildPropertyIsNull());
    }

    public PropertyIsBetween buildBetween() throws CQLException {
        try {
            Expression sup = this.resultStack.popExpression();
            Expression inf = this.resultStack.popExpression();
            Expression expr = this.resultStack.popExpression();
            PropertyIsBetween filter = this.filterFactory.between(expr, inf, sup);
            return filter;
        }
        catch (IllegalFilterException ife) {
            throw new CQLException("Exception building CompareFilter: " + ife.getMessage(), this.cqlSource);
        }
    }

    public Not buildNotBetween() throws CQLException {
        return this.filterFactory.not((Filter)this.buildBetween());
    }

    public Not buildNotLikeFilter(boolean matchCase) throws CQLException {
        Not filter = this.filterFactory.not((Filter)this.buildLikeFilter(matchCase));
        return filter;
    }

    public PropertyIsEqualTo buildPropertyExists() throws CQLException {
        PropertyName property = this.resultStack.popPropertyName();
        Expression[] args = new Expression[]{this.filterFactory.literal((Object)property)};
        Function function = this.filterFactory.function("PropertyExists", args);
        Literal literalTrue = this.filterFactory.literal((Object)Boolean.TRUE);
        PropertyIsEqualTo propExistsFilter = this.filterFactory.equals((Expression)function, (Expression)literalTrue);
        return propExistsFilter;
    }

    public Literal buildDateExpression(IToken token) throws CQLException {
        return this.asLiteralDate(((Object)token).toString());
    }

    public Literal buildDateTimeExpression(IToken token) throws CQLException {
        return this.asLiteralDateTime(((Object)token).toString());
    }

    private Literal asLiteralDate(String cqlDate) throws CQLException {
        try {
            String strDate = this.extractDate(cqlDate);
            String strTimeZone = this.extractTimeZone(cqlDate);
            return this.asLiteralTemporal(strDate, null, strTimeZone);
        }
        catch (ParseException e) {
            throw new CQLException("Unsupported date time format: " + e.getMessage(), this.cqlSource);
        }
    }

    private Literal asLiteralDateTime(String cqlDateTime) throws CQLException {
        try {
            String strDate = this.extractDate(cqlDateTime);
            String strTime = this.extractTime(cqlDateTime);
            String timeZoneOffset = this.extractTimeZone(cqlDateTime);
            return this.asLiteralTemporal(strDate, strTime, timeZoneOffset);
        }
        catch (ParseException e) {
            throw new CQLException("Unsupported date time format: " + e.getMessage(), this.cqlSource);
        }
    }

    private Literal asLiteralTemporal(String strDate, String strTime, String timeZoneOffset) throws ParseException {
        StringBuilder format = new StringBuilder("yyyy-MM-dd");
        if (strTime != null && !"".equals(strTime)) {
            format.append(" HH:mm:ss");
            if (strTime.contains(".")) {
                format.append(".SSS");
            }
        }
        TimeZone tz = null;
        if (timeZoneOffset != null && !"".equals(timeZoneOffset)) {
            timeZoneOffset = "Z".equals(timeZoneOffset) ? "GMT+00:00" : "GMT" + timeZoneOffset;
            tz = TimeZone.getTimeZone(timeZoneOffset);
        } else {
            tz = TimeZone.getDefault();
        }
        SimpleDateFormat formatter = new SimpleDateFormat(format.toString());
        formatter.setTimeZone(tz);
        Date date = !"".equals(strTime) ? formatter.parse(strDate + " " + strTime) : formatter.parse(strDate);
        Literal literalDate = this.filterFactory.literal((Object)date);
        return literalDate;
    }

    private String extractTimeZone(String cqlDateTime) throws CQLException {
        Matcher m = DATETIME_PATTERN.matcher(cqlDateTime);
        if (m.matches()) {
            return m.group(3) != null ? m.group(3).toUpperCase() : "";
        }
        return "";
    }

    private String toTimeZone(String cqlTimeZone) {
        String[] str = cqlTimeZone.split(":");
        assert (str.length == 2);
        return str[0].concat(str[1]);
    }

    private String extractTime(String cqlDateTime) {
        Matcher m = DATETIME_PATTERN.matcher(cqlDateTime);
        if (m.matches()) {
            assert (m.group(2) != null);
            return m.group(2);
        }
        assert (false);
        return null;
    }

    private String extractDate(String cqlDateTime) {
        Matcher m = DATETIME_PATTERN.matcher(cqlDateTime);
        if (m.matches()) {
            assert (m.group(1) != null);
            return m.group(1);
        }
        assert (false);
        return null;
    }

    public Not buildNotFilter(Filter eq) {
        return this.filterFactory.not(eq);
    }

    public Literal buildTrueLiteral() {
        return this.filterFactory.literal((Object)Boolean.TRUE);
    }

    public Literal buildFalseLiteral() {
        return this.filterFactory.literal((Object)Boolean.FALSE);
    }

    public Literal buildLiteralInteger(String tokenImage) {
        return this.filterFactory.literal(Long.parseLong(tokenImage));
    }

    public Literal buildLiteralDouble(String tokenImage) {
        return this.filterFactory.literal(Double.parseDouble(tokenImage));
    }

    public Literal buildLiteralString(String tokenImage) {
        String strLiteral = this.removeQuotes(tokenImage);
        return this.filterFactory.literal((Object)strLiteral);
    }

    protected String removeQuotes(String source) {
        String quote = "'";
        if (!source.startsWith("'") || !source.endsWith("'")) {
            return source;
        }
        int length = source.length();
        String result = source.substring(1, length - 1);
        result = result.replaceAll("''", "'");
        return result;
    }

    public String buildIdentifier(int nodeIdentifier) throws CQLException {
        try {
            String part;
            Result r;
            ArrayList<String> arrayParts = new ArrayList<String>();
            while (this.resultStack.size() > 0 && (r = this.resultStack.peek()).getNodeType() == nodeIdentifier) {
                part = this.resultStack.popIdentifierPart();
                part = this.removeFirstAndLastDoubleQuote(part);
                arrayParts.add(part);
            }
            assert (arrayParts.size() >= 1) : "postcondition: the list of identifier part must have one or more elements ";
            StringBuffer identifier = new StringBuffer(100);
            int i = 0;
            for (i = arrayParts.size() - 1; i > 0; --i) {
                part = (String)arrayParts.get(i);
                identifier.append(part).append(":");
            }
            assert (i == 0);
            part = (String)arrayParts.get(i);
            identifier.append(part);
            return identifier.toString();
        }
        catch (CQLException e) {
            throw new CQLException("Fail builing identifier: " + e.getMessage(), this.cqlSource);
        }
    }

    public String buildIdentifierPart(IToken token) {
        String part = ((Object)token).toString();
        return part;
    }

    private String removeFirstAndLastDoubleQuote(String source) {
        String doubleQuote = "\"";
        if (!source.startsWith("\"") || !source.endsWith("\"")) {
            return source;
        }
        String result = source.substring(1, source.length() - 1);
        return result;
    }

    public PropertyName buildSimpleAttribute() throws CQLException {
        String identifier = this.resultStack.popIdentifier();
        PropertyName property = this.filterFactory.property(identifier);
        return property;
    }

    public PropertyName buildCompoundAttribute(int nodeSimpleAttr, String nodeAttrSeparator) throws CQLException {
        Result r;
        ArrayList<String> arrayIdentifiers = new ArrayList<String>();
        while (this.resultStack.size() > 0 && (r = this.resultStack.peek()).getNodeType() == nodeSimpleAttr) {
            PropertyName simpleAttribute = this.resultStack.popPropertyName();
            arrayIdentifiers.add(simpleAttribute.getPropertyName());
        }
        StringBuffer attribute = new StringBuffer(100);
        int i = 0;
        for (i = arrayIdentifiers.size() - 1; i > 0; --i) {
            attribute.append((String)arrayIdentifiers.get(i));
            attribute.append(nodeAttrSeparator);
        }
        attribute.append((String)arrayIdentifiers.get(i));
        PropertyName property = this.filterFactory.property(attribute.toString());
        return property;
    }

    public Literal buildDistanceUnit(IToken token) throws CQLException {
        Literal unit = null;
        unit = this.filterFactory.literal((Object)((Object)token).toString());
        return unit;
    }

    public Literal buildTolerance() throws CQLException {
        Literal tolerance = null;
        try {
            tolerance = this.resultStack.popLiteral();
            return tolerance;
        }
        catch (NumberFormatException e) {
            throw new CQLException("Unsupported number format", this.cqlSource);
        }
    }

    public BinarySpatialOperator buildSpatialEqualFilter() throws CQLException {
        Literal geom = this.resultStack.popLiteral();
        Expression property = this.resultStack.popExpression();
        FilterFactory2 ff = (FilterFactory2)this.filterFactory;
        return ff.equal(property, (Expression)geom);
    }

    public BinarySpatialOperator buildSpatialDisjointFilter() throws CQLException {
        Literal geom = this.resultStack.popLiteral();
        Expression property = this.resultStack.popExpression();
        FilterFactory2 ff = (FilterFactory2)this.filterFactory;
        return ff.disjoint(property, (Expression)geom);
    }

    public BinarySpatialOperator buildSpatialIntersectsFilter() throws CQLException {
        Literal geom = this.resultStack.popLiteral();
        Expression property = this.resultStack.popExpression();
        FilterFactory2 ff = (FilterFactory2)this.filterFactory;
        return ff.intersects(property, (Expression)geom);
    }

    public PropertyIsEqualTo buildSpatialRelateFilter() throws CQLException {
        Literal pattern = this.resultStack.popLiteral();
        Literal geometry = this.resultStack.popLiteral();
        PropertyName property = this.resultStack.popPropertyName();
        FilterFactory2 ff = (FilterFactory2)this.filterFactory;
        Expression[] args = new Expression[]{property, geometry, pattern};
        Function function = this.filterFactory.function("relatePattern", args);
        assert (function != null) : "a relatePattern function is expected";
        PropertyIsEqualTo filter = ff.equals((Expression)function, (Expression)ff.literal(true));
        return filter;
    }

    public Literal buildDE9IM(String tokenImage) {
        Literal literal = this.filterFactory.literal((Object)tokenImage);
        return literal;
    }

    public BinarySpatialOperator buildSpatialTouchesFilter() throws CQLException {
        Literal geom = this.resultStack.popLiteral();
        Expression property = this.resultStack.popExpression();
        FilterFactory2 ff = (FilterFactory2)this.filterFactory;
        return ff.touches(property, (Expression)geom);
    }

    public BinarySpatialOperator buildSpatialCrossesFilter() throws CQLException {
        Literal geom = this.resultStack.popLiteral();
        Expression property = this.resultStack.popExpression();
        FilterFactory2 ff = (FilterFactory2)this.filterFactory;
        return ff.crosses(property, (Expression)geom);
    }

    public BinarySpatialOperator buildSpatialWithinFilter() throws CQLException {
        Literal geom = this.resultStack.popLiteral();
        Expression property = this.resultStack.popExpression();
        FilterFactory2 ff = (FilterFactory2)this.filterFactory;
        return ff.within(property, (Expression)geom);
    }

    public BinarySpatialOperator buildSpatialContainsFilter() throws CQLException {
        Literal geom = this.resultStack.popLiteral();
        Expression property = this.resultStack.popExpression();
        FilterFactory2 ff = (FilterFactory2)this.filterFactory;
        return ff.contains(property, (Expression)geom);
    }

    public BinarySpatialOperator buildSpatialOverlapsFilter() throws CQLException {
        Literal geom = this.resultStack.popLiteral();
        Expression property = this.resultStack.popExpression();
        FilterFactory2 ff = (FilterFactory2)this.filterFactory;
        return ff.overlaps(property, (Expression)geom);
    }

    public BBOX buildBBox() throws CQLException {
        return this.buildBbox(null);
    }

    public BBOX buildBBoxWithCRS() throws CQLException {
        String crs = this.resultStack.popStringValue();
        assert (crs != null);
        return this.buildBbox(crs);
    }

    private BBOX buildBbox(String crs) throws CQLException {
        double maxY = this.resultStack.popDoubleValue();
        double maxX = this.resultStack.popDoubleValue();
        double minY = this.resultStack.popDoubleValue();
        double minX = this.resultStack.popDoubleValue();
        PropertyName property = this.resultStack.popPropertyName();
        String strProperty = property.getPropertyName();
        BBOX bbox = this.filterFactory.bbox(strProperty, minX, minY, maxX, maxY, crs);
        return bbox;
    }

    public DistanceBufferOperator buildSpatialDWithinFilter() throws CQLException {
        String unit = this.resultStack.popStringValue();
        double tolerance = this.resultStack.popDoubleValue();
        Expression geom = this.resultStack.popExpression();
        Expression property = this.resultStack.popExpression();
        FilterFactory2 ff = (FilterFactory2)this.filterFactory;
        return ff.dwithin(property, geom, tolerance, unit);
    }

    public DistanceBufferOperator buildSpatialBeyondFilter() throws CQLException {
        String unit = this.resultStack.popStringValue();
        double tolerance = this.resultStack.popDoubleValue();
        Expression geom = this.resultStack.popExpression();
        Expression property = this.resultStack.popExpression();
        FilterFactory2 ff = (FilterFactory2)this.filterFactory;
        return ff.beyond(property, geom, tolerance, unit);
    }

    public PeriodNode buildPeriodBetweenDates() throws CQLException {
        Literal end = this.resultStack.popLiteral();
        Literal begin = this.resultStack.popLiteral();
        PeriodNode period = PeriodNode.createPeriodDateAndDate(begin, end);
        return period;
    }

    public PeriodNode buildPeriodDurationAndDate() throws CQLException {
        Literal date = this.resultStack.popLiteral();
        Literal duration = this.resultStack.popLiteral();
        PeriodNode period = PeriodNode.createPeriodDurationAndDate(duration, date, this.filterFactory);
        return period;
    }

    public PeriodNode buildPeriodDateAndDuration() throws CQLException {
        Literal duration = this.resultStack.popLiteral();
        Literal date = this.resultStack.popLiteral();
        PeriodNode period = PeriodNode.createPeriodDateAndDuration(date, duration, this.filterFactory);
        return period;
    }

    public Literal buildDurationExpression(IToken token) {
        String duration = ((Object)token).toString();
        Literal literalDuration = this.filterFactory.literal((Object)duration);
        return literalDuration;
    }

    public And buildPropertyBetweenDates() throws CQLException {
        Result node = this.resultStack.popResult();
        PeriodNode period = (PeriodNode)node.getBuilt();
        Literal begin = period.getBeginning();
        Literal end = period.getEnding();
        Expression property = this.resultStack.popExpression();
        And filter = this.filterFactory.and((Filter)this.filterFactory.lessOrEqual((Expression)begin, property), (Filter)this.filterFactory.lessOrEqual(property, (Expression)end));
        return filter;
    }

    public PropertyIsGreaterThanOrEqualTo buildPropertyIsGTEFirstDate() throws CQLException {
        Result node = this.resultStack.popResult();
        PeriodNode period = (PeriodNode)node.getBuilt();
        Literal begin = period.getBeginning();
        Expression property = this.resultStack.popExpression();
        PropertyIsGreaterThanOrEqualTo filter = this.filterFactory.greaterOrEqual(property, (Expression)begin);
        return filter;
    }

    public PropertyIsGreaterThan buildPropertyIsGTLastDate() throws CQLException {
        Result node = this.resultStack.popResult();
        PeriodNode period = (PeriodNode)node.getBuilt();
        Literal date = period.getEnding();
        Expression property = this.resultStack.popExpression();
        PropertyIsGreaterThan filter = this.filterFactory.greater(property, (Expression)date);
        return filter;
    }

    public PropertyIsLessThan buildPropertyIsLTFirsDate() throws CQLException {
        PeriodNode period = this.resultStack.popPeriodNode();
        Literal date = period.getBeginning();
        Expression property = this.resultStack.popExpression();
        PropertyIsLessThan filter = this.filterFactory.less(property, (Expression)date);
        return filter;
    }

    public PropertyIsLessThanOrEqualTo buildPropertyIsLTELastDate() throws CQLException {
        PeriodNode period = this.resultStack.popPeriodNode();
        Literal date = period.getEnding();
        Expression property = this.resultStack.popExpression();
        PropertyIsLessThanOrEqualTo filter = this.filterFactory.lessOrEqual(property, (Expression)date);
        return filter;
    }

    public PropertyIsEqualTo buildEquals() throws CQLException {
        Expression right = this.resultStack.popExpression();
        Expression left = this.resultStack.popExpression();
        return this.filterFactory.equals(left, right);
    }

    public PropertyIsGreaterThan buildGreater() throws CQLException {
        Expression right = this.resultStack.popExpression();
        Expression left = this.resultStack.popExpression();
        return this.filterFactory.greater(left, right);
    }

    public PropertyIsLessThan buildLess() throws CQLException {
        Expression right = this.resultStack.popExpression();
        Expression left = this.resultStack.popExpression();
        return this.filterFactory.less(left, right);
    }

    public PropertyIsGreaterThanOrEqualTo buildGreaterOrEqual() throws CQLException {
        Expression right = this.resultStack.popExpression();
        Expression left = this.resultStack.popExpression();
        return this.filterFactory.greaterOrEqual(left, right);
    }

    public PropertyIsLessThanOrEqualTo buildLessOrEqual() throws CQLException {
        Expression right = this.resultStack.popExpression();
        Expression left = this.resultStack.popExpression();
        return this.filterFactory.lessOrEqual(left, right);
    }

    public Literal buildGeometry(IToken geometry) throws CQLException {
        try {
            String wktGeom = this.scanExpression(geometry);
            String vividGeom = this.transformWKTGeometry(wktGeom);
            WKTReader reader = new WKTReader();
            Geometry g = reader.read(vividGeom);
            Literal literal = this.filterFactory.literal((Object)g);
            return literal;
        }
        catch (com.vividsolutions.jts.io.ParseException e) {
            throw new CQLException(e.getMessage(), geometry, e, this.cqlSource);
        }
        catch (Exception e) {
            throw new CQLException("Error building WKT Geometry: " + e.getMessage(), geometry, e, this.cqlSource);
        }
    }

    protected String scanExpression(IToken initialToken) {
        IToken end = initialToken;
        while (end.hasNext()) {
            end = end.next();
        }
        String expr = this.cqlSource.substring(initialToken.beginColumn() - 1, end.endColumn());
        return expr;
    }

    protected String transformWKTGeometry(String wktGeom) {
        String MULTIPOINT_TYPE = "MULTIPOINT";
        StringBuffer transformed = new StringBuffer(30);
        StringBuffer source = new StringBuffer(wktGeom.toUpperCase());
        int cur = -1;
        cur = source.indexOf("MULTIPOINT");
        if (cur != -1) {
            String argument = source.substring(cur + "MULTIPOINT".length() + 1, source.length() - 1);
            argument = argument.replace('(', ' ');
            argument = argument.replace(')', ' ');
            transformed.append("MULTIPOINT").append("(").append(argument).append(")");
            return transformed.toString();
        }
        return wktGeom;
    }

    public Literal buildEnvelop(IToken token) {
        String source = this.scanExpression(token);
        String ENVELOPE_TYPE = "ENVELOPE";
        int cur = source.indexOf("ENVELOPE");
        cur = cur + "ENVELOPE".length() + 1;
        String argument = source.substring(cur, source.length() - 1);
        String comma = ",";
        cur = 0;
        int end = argument.indexOf(",", cur);
        String west = argument.substring(cur, end);
        double minX = Double.parseDouble(west);
        cur = end + 1;
        end = argument.indexOf(",", cur);
        String east = argument.substring(cur, end);
        double maxX = Double.parseDouble(east);
        cur = end + 1;
        end = argument.indexOf(",", cur);
        String north = argument.substring(cur, end);
        double maxY = Double.parseDouble(north);
        cur = end + 1;
        String south = argument.substring(cur);
        double minY = Double.parseDouble(south);
        GeometryFactory gf = new GeometryFactory();
        Coordinate[] coords = new Coordinate[]{new Coordinate(minX, minY), new Coordinate(minX, maxY), new Coordinate(maxX, maxY), new Coordinate(maxX, minY), new Coordinate(minX, minY)};
        LinearRing shell = gf.createLinearRing(coords);
        Polygon bbox = gf.createPolygon(shell, null);
        bbox.setUserData((Object)DefaultGeographicCRS.WGS84);
        Literal literal = this.filterFactory.literal((Object)bbox);
        return literal;
    }

    public Function buildFunction(int functionNode) throws CQLException {
        String functionName = null;
        LinkedList<Expression> argList = new LinkedList<Expression>();
        while (!this.resultStack.empty()) {
            Result node = this.resultStack.peek();
            if (node.getNodeType() == functionNode) {
                Result funcNameNode = this.resultStack.popResult();
                functionName = ((Object)funcNameNode.getToken()).toString();
                break;
            }
            this.resultStack.popResult();
            Expression arg = this.resultStack.popExpression();
            argList.add(arg);
        }
        Collections.reverse(argList);
        Expression[] args = argList.toArray(new Expression[argList.size()]);
        Function function = null;
        try {
            function = this.filterFactory.function(functionName, args);
            if (function == null) {
                throw new CQLException("Function not found.", this.cqlSource);
            }
        }
        catch (Exception ex) {
            throw new CQLException("Function not found.", this.cqlSource);
        }
        return function;
    }

    public TEquals buildTEquals() throws CQLException {
        Expression right = this.resultStack.popExpression();
        Expression left = this.resultStack.popExpression();
        return this.filterFactory.tequals(left, right);
    }

    public After buildAfterDate() throws CQLException {
        Expression right = this.resultStack.popExpression();
        Expression left = this.resultStack.popExpression();
        After filter = this.filterFactory.after(left, right);
        return filter;
    }

    public After buildAfterPeriod() throws CQLException {
        Result node = this.resultStack.popResult();
        PeriodNode period = (PeriodNode)node.getBuilt();
        Literal date = period.getEnding();
        Expression property = this.resultStack.popExpression();
        After filter = this.filterFactory.after(property, (Expression)date);
        return filter;
    }

    public Before buildBeforeDate() throws CQLException {
        Expression right = this.resultStack.popExpression();
        Expression left = this.resultStack.popExpression();
        Before filter = this.filterFactory.before(left, right);
        return filter;
    }

    public Before buildBeforePeriod() throws CQLException {
        Result node = this.resultStack.popResult();
        PeriodNode period = (PeriodNode)node.getBuilt();
        Literal date = period.getEnding();
        Expression property = this.resultStack.popExpression();
        Before filter = this.filterFactory.before(property, (Expression)date);
        return filter;
    }

    public During buildDuringPeriod() throws CQLException {
        Period period = this.resultStack.popPeriod();
        Expression property = this.resultStack.popExpression();
        During filter = this.filterFactory.during(property, (Expression)this.filterFactory.literal((Object)period));
        return filter;
    }

    public Or buildDuringOrAfter() throws CQLException {
        Period period = this.resultStack.popPeriod();
        PropertyName property = this.resultStack.popPropertyName();
        After right = this.filterFactory.after((Expression)property, (Expression)this.filterFactory.literal((Object)period.getEnding()));
        During left = this.filterFactory.during((Expression)property, (Expression)this.filterFactory.literal((Object)period));
        Or filter = this.filterFactory.or((Filter)left, (Filter)right);
        return filter;
    }

    public Or buildBeforeOrDuring() throws CQLException {
        Period period = this.resultStack.popPeriod();
        PropertyName property = this.resultStack.popPropertyName();
        Before right = this.filterFactory.before((Expression)property, (Expression)this.filterFactory.literal((Object)period.getBeginning()));
        During left = this.filterFactory.during((Expression)property, (Expression)this.filterFactory.literal((Object)period));
        Or filter = this.filterFactory.or((Filter)right, (Filter)left);
        return filter;
    }
}

