/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Point;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.Join;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.data.store.ContentFeatureStore;
import org.geotools.data.store.ContentState;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.SortBy;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.filter.Filter;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.ProgressListener;

public class ContentFeatureCollection
implements SimpleFeatureCollection {
    protected static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.store");
    protected ContentFeatureSource featureSource;
    protected Query query;
    protected SimpleFeatureType featureType;
    protected ContentState state;

    protected ContentFeatureCollection(ContentFeatureSource featureSource, Query query) {
        this.featureSource = featureSource;
        this.query = query;
        this.featureType = featureSource.getSchema();
        if (query.getPropertyNames() != Query.ALL_NAMES) {
            this.featureType = SimpleFeatureTypeBuilder.retype((SimpleFeatureType)this.featureType, (String[])query.getPropertyNames());
        }
        try {
            if (query.getCoordinateSystemReproject() != null) {
                this.featureType = FeatureTypes.transform((SimpleFeatureType)this.featureType, (CoordinateReferenceSystem)query.getCoordinateSystemReproject());
            } else if (query.getCoordinateSystem() != null) {
                this.featureType = FeatureTypes.transform((SimpleFeatureType)this.featureType, (CoordinateReferenceSystem)query.getCoordinateSystem());
            }
        }
        catch (SchemaException e) {
            LOGGER.log(Level.FINER, "Problem handling Query change of CoordinateReferenceSystem:" + (Object)((Object)e), e);
        }
        if (!query.getJoins().isEmpty()) {
            SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
            tb.init(this.featureType);
            for (Join join : query.getJoins()) {
                tb.add(join.attributeName(), SimpleFeature.class);
            }
            this.featureType = tb.buildFeatureType();
        }
    }

    public SimpleFeatureType getSchema() {
        return this.featureType;
    }

    public void accepts(FeatureVisitor visitor, ProgressListener progress) throws IOException {
        this.featureSource.accepts(this.query, visitor, progress);
    }

    public SimpleFeatureIterator features() {
        try {
            return new WrappingFeatureIterator(this.featureSource.getReader(this.query));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ReferencedEnvelope getBounds() {
        FeatureReader<SimpleFeatureType, SimpleFeature> reader = null;
        try {
            ReferencedEnvelope referencedEnvelope;
            ReferencedEnvelope result = this.featureSource.getBounds(this.query);
            if (result != null) {
                ReferencedEnvelope referencedEnvelope2 = result;
                return referencedEnvelope2;
            }
            Query q = new Query(this.query);
            ArrayList<String> geometries = new ArrayList<String>();
            for (AttributeDescriptor ad : this.getSchema().getAttributeDescriptors()) {
                if (!(ad instanceof GeometryDescriptor)) continue;
                geometries.add(ad.getLocalName());
            }
            if (geometries.size() == 0) {
                ReferencedEnvelope i$ = new ReferencedEnvelope();
                return i$;
            }
            q.setPropertyNames(geometries);
            reader = this.featureSource.getReader(q);
            while (reader.hasNext()) {
                SimpleFeature f = (SimpleFeature)reader.next();
                ReferencedEnvelope featureBounds = ReferencedEnvelope.reference((BoundingBox)f.getBounds());
                if (result == null) {
                    result = featureBounds;
                    continue;
                }
                if (featureBounds == null) continue;
                result.expandToInclude((Envelope)featureBounds);
            }
            if (result != null) {
                referencedEnvelope = result;
                return referencedEnvelope;
            }
            referencedEnvelope = new ReferencedEnvelope(this.getSchema().getCoordinateReferenceSystem());
            return referencedEnvelope;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    public int size() {
        FeatureReader<SimpleFeatureType, SimpleFeature> fr = null;
        try {
            int size = this.featureSource.getCount(this.query);
            if (size >= 0) {
                int n = size;
                return n;
            }
            AttributeDescriptor chosen = this.getSmallAttributeInSchema();
            Query q = new Query(this.query);
            if (chosen != null) {
                q.setPropertyNames(Collections.singletonList(chosen.getLocalName()));
            }
            fr = this.featureSource.getReader(q);
            int count = 0;
            while (fr.hasNext()) {
                fr.next();
                ++count;
            }
            int n = count;
            return n;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private AttributeDescriptor getSmallAttributeInSchema() {
        AttributeDescriptor chosen = null;
        for (AttributeDescriptor ad : this.getSchema().getAttributeDescriptors()) {
            if (chosen != null && this.size(ad) >= this.size(chosen)) continue;
            chosen = ad;
        }
        return chosen;
    }

    int size(AttributeDescriptor ad) {
        Class binding = ad.getType().getBinding();
        if (binding.isPrimitive() || Number.class.isAssignableFrom(binding) || Date.class.isAssignableFrom(binding)) {
            return 4;
        }
        if (binding.equals(String.class)) {
            int fieldLen = FeatureTypes.getFieldLength((PropertyDescriptor)ad);
            if (fieldLen > 0) {
                return fieldLen * 2;
            }
            return Integer.MAX_VALUE;
        }
        if (Point.class.isAssignableFrom(binding)) {
            return 12;
        }
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        boolean bl;
        Query notEmptyQuery = new Query(this.query);
        notEmptyQuery.setMaxFeatures(1);
        AttributeDescriptor smallAttribute = this.getSmallAttributeInSchema();
        if (smallAttribute != null) {
            notEmptyQuery.setPropertyNames(Collections.singletonList(smallAttribute.getLocalName()));
        }
        FeatureReader<SimpleFeatureType, SimpleFeature> fr = this.featureSource.getReader(notEmptyQuery);
        try {
            bl = !fr.hasNext();
        }
        catch (Throwable throwable) {
            try {
                fr.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        fr.close();
        return bl;
    }

    ContentFeatureStore ensureFeatureStore() {
        if (this.featureSource instanceof ContentFeatureStore) {
            return (ContentFeatureStore)this.featureSource;
        }
        throw new UnsupportedOperationException("read only");
    }

    public SimpleFeatureCollection sort(SortBy order) {
        return this.sort((org.opengis.filter.sort.SortBy)order);
    }

    public SimpleFeatureCollection sort(org.opengis.filter.sort.SortBy sort) {
        Query query = new Query();
        query.setSortBy(new org.opengis.filter.sort.SortBy[]{sort});
        query = DataUtilities.mixQueries((Query)this.query, (Query)query, null);
        return new ContentFeatureCollection(this.featureSource, query);
    }

    public SimpleFeatureCollection subCollection(Filter filter) {
        Query query = new Query();
        query.setFilter(filter);
        query = DataUtilities.mixQueries((Query)this.query, (Query)query, null);
        return new ContentFeatureCollection(this.featureSource, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object o) {
        SimpleFeatureIterator e = null;
        try {
            e = this.features();
            if (o == null) {
                while (e.hasNext()) {
                    if (e.next() != null) continue;
                    boolean bl = true;
                    return bl;
                }
            } else {
                while (e.hasNext()) {
                    if (!o.equals(e.next())) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (e != null) {
                e.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(Collection<?> c) {
        Iterator<?> e = c.iterator();
        try {
            while (e.hasNext()) {
                if (this.contains(e.next())) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (e instanceof FeatureIterator) {
                ((FeatureIterator)e).close();
            }
        }
    }

    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Content is not writable; FeatureStore not available");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray() {
        ArrayList<Feature> array = new ArrayList<Feature>();
        SimpleFeatureIterator e = null;
        try {
            e = this.features();
            while (e.hasNext()) {
                array.add(e.next());
            }
            Object[] objectArray = array.toArray(new SimpleFeature[array.size()]);
            return objectArray;
        }
        finally {
            if (e != null) {
                e.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T[] toArray(T[] array) {
        int size = this.size();
        if (array.length < size) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), size);
        }
        SimpleFeatureIterator it = this.features();
        try {
            T[] result = array;
            for (int i = 0; it.hasNext() && i < size; ++i) {
                result[i] = it.next();
            }
            if (array.length > size) {
                array[size] = null;
            }
            Object[] objectArray = array;
            return objectArray;
        }
        finally {
            if (it != null) {
                it.close();
            }
        }
    }

    public String getID() {
        throw new UnsupportedOperationException();
    }

    public static class WrappingFeatureIterator
    implements SimpleFeatureIterator {
        FeatureReader<SimpleFeatureType, SimpleFeature> delegate;

        public WrappingFeatureIterator(FeatureReader<SimpleFeatureType, SimpleFeature> delegate) {
            this.delegate = delegate;
        }

        public boolean hasNext() {
            try {
                return this.delegate.hasNext();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public SimpleFeature next() throws NoSuchElementException {
            try {
                return (SimpleFeature)this.delegate.next();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void close() {
            try {
                this.delegate.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

