/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.geotools.feature.NameImpl;
import org.geotools.filter.DefaultExpression;
import org.geotools.filter.Expression;
import org.geotools.filter.FunctionExpression;
import org.geotools.filter.FunctionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.opengis.feature.type.Name;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.parameter.Parameter;

public abstract class FunctionExpressionImpl
extends DefaultExpression
implements FunctionExpression {
    protected String name;
    protected List<org.opengis.filter.expression.Expression> params;
    protected Literal fallback;
    protected FunctionName functionName;

    protected FunctionExpressionImpl(FunctionName functionName) {
        this(functionName.getName(), null);
        this.functionName = functionName;
    }

    protected FunctionExpressionImpl(String name) {
        this((Name)new NameImpl(name));
    }

    protected FunctionExpressionImpl(Name name) {
        this(name, null);
    }

    protected FunctionExpressionImpl(String name, Literal fallback) {
        this((Name)new NameImpl(name), fallback);
    }

    protected FunctionExpressionImpl(Name name, Literal fallback) {
        this.functionName = new FunctionNameImpl(name, (Class)null, new Parameter[0]);
        this.name = name.getLocalPart();
        this.fallback = fallback;
        this.params = new ArrayList<org.opengis.filter.expression.Expression>();
    }

    @Override
    public short getType() {
        return 114;
    }

    public String getName() {
        return this.name;
    }

    public synchronized FunctionName getFunctionName() {
        if (this.functionName == null) {
            this.functionName = new FunctionNameImpl(this.getName(), this.getArgCount());
        }
        return this.functionName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Literal getFallbackValue() {
        return this.fallback;
    }

    public void setFallbackValue(Literal fallback) {
        this.fallback = fallback;
    }

    public List<org.opengis.filter.expression.Expression> getParameters() {
        return this.params;
    }

    public void setParameters(List params) {
        if (params == null) {
            throw new NullPointerException("Function parameters required");
        }
        int argCount = this.getArgCount();
        int paramsSize = params.size();
        if (argCount > 0 && argCount != paramsSize) {
            throw new IllegalArgumentException("Function " + this.name + " expected " + argCount + " arguments, got " + paramsSize);
        }
        this.params = new ArrayList<org.opengis.filter.expression.Expression>(params);
    }

    public Expression[] getArgs() {
        List<org.opengis.filter.expression.Expression> params = this.getParameters();
        return params.toArray(new Expression[params.size()]);
    }

    public void setArgs(Expression[] args) {
        this.setParameters(Arrays.asList(args));
    }

    public int getArgCount() {
        if (this.functionName != null && this.functionName.getArguments() != null) {
            int count = 0;
            for (Parameter argument : this.functionName.getArguments()) {
                if (argument.getMinOccurs() != argument.getMaxOccurs()) {
                    return -1;
                }
                count += argument.getMinOccurs();
            }
            return count;
        }
        return 0;
    }

    public Object accept(ExpressionVisitor visitor, Object extraData) {
        return visitor.visit((Function)this, extraData);
    }

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return Collections.emptyMap();
    }

    protected static FunctionName functionName(String name, String ret, String ... args) {
        return FunctionImpl.functionName(name, ret, args);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        sb.append("(");
        List<org.opengis.filter.expression.Expression> params = this.getParameters();
        if (params != null) {
            Iterator<org.opengis.filter.expression.Expression> it = params.iterator();
            while (it.hasNext()) {
                org.opengis.filter.expression.Expression exp = it.next();
                sb.append("[");
                sb.append(exp);
                sb.append("]");
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
        }
        sb.append(")");
        return sb.toString();
    }

    protected org.opengis.filter.expression.Expression getExpression(int index) {
        org.opengis.filter.expression.Expression exp = this.getParameters().get(index);
        return exp;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Function)) {
            return false;
        }
        Function other = (Function)obj;
        if (this.getName() == null && other.getName() != null || this.getName() != null && !this.getName().equalsIgnoreCase(other.getName())) {
            return false;
        }
        if (this.getParameters() == null && other.getClass() != null) {
            return false;
        }
        return this.getParameters() != null && ((Object)this.getParameters()).equals(other.getParameters());
    }
}

