/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.spatial;

import com.vividsolutions.jts.geom.Geometry;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.spatial.BBOX;
import org.opengis.geometry.BoundingBox;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DefaultCRSFilterVisitor
extends DuplicatingFilterVisitor {
    private CoordinateReferenceSystem defaultCrs;

    public DefaultCRSFilterVisitor(FilterFactory2 factory, CoordinateReferenceSystem defaultCrs) {
        super(factory);
        this.defaultCrs = defaultCrs;
    }

    @Override
    public Object visit(BBOX filter, Object extraData) {
        String srs = filter.getSRS();
        if (srs != null && !"".equals(srs.trim())) {
            return super.visit(filter, extraData);
        }
        try {
            return this.getFactory(extraData).bbox(filter.getExpression1(), (BoundingBox)ReferencedEnvelope.create((Envelope)filter.getBounds(), (CoordinateReferenceSystem)this.defaultCrs));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not decode srs '" + srs + "'", e);
        }
    }

    @Override
    public Object visit(Literal expression, Object extraData) {
        if (!(expression.getValue() instanceof Geometry)) {
            return super.visit(expression, extraData);
        }
        Geometry geom = (Geometry)expression.getValue();
        if (geom.getUserData() != null && geom.getUserData() instanceof CoordinateReferenceSystem) {
            return super.visit(expression, extraData);
        }
        Geometry clone = geom.getFactory().createGeometry(geom);
        clone.setUserData((Object)this.defaultCrs);
        return this.ff.literal((Object)clone);
    }
}

