/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Loggings;
import org.geotools.util.GrowableInternationalString;
import org.geotools.util.LocalName;
import org.geotools.util.ScopedName;
import org.geotools.util.Utilities;
import org.geotools.util.WeakValueHashMap;
import org.geotools.util.logging.Logging;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.NameSpace;

public class NamedIdentifier
implements ReferenceIdentifier,
GenericName,
Comparable<GenericName>,
Serializable {
    private static final long serialVersionUID = 8474731565582774497L;
    private static Map<CharSequence, GenericName> SCOPES;
    private final String code;
    private final String codespace;
    private final Citation authority;
    private final String version;
    private final InternationalString remarks;
    private GenericName name;

    public NamedIdentifier(Map<String, ?> properties) throws IllegalArgumentException {
        this(properties, true);
    }

    public NamedIdentifier(Citation authority, InternationalString code) {
        this(authority, code.toString(null));
        this.name = this.getName(authority, (CharSequence)code);
    }

    public NamedIdentifier(Citation authority, String code) {
        this(authority, code, null);
    }

    public NamedIdentifier(Citation authority, String code, String version) {
        this(NamedIdentifier.toMap(authority, code, version));
    }

    private static Map<String, ?> toMap(Citation authority, String code, String version) {
        HashMap<String, Object> properties = new HashMap<String, Object>(4);
        if (authority != null) {
            properties.put("authority", authority);
        }
        if (code != null) {
            properties.put("code", code);
        }
        if (version != null) {
            properties.put("version", version);
        }
        return properties;
    }

    NamedIdentifier(Map<String, ?> properties, boolean standalone) throws IllegalArgumentException {
        NamedIdentifier.ensureNonNull("properties", properties);
        Object code = null;
        String codespace = null;
        Object version = null;
        Object authority = null;
        Object remarks = null;
        Object growable = null;
        String key = null;
        Object value = null;
        block10: for (Map.Entry<String, ?> entry : properties.entrySet()) {
            key = entry.getKey().trim().toLowerCase();
            value = entry.getValue();
            switch (key.hashCode()) {
                case 3373707: {
                    if (standalone || !key.equals("name")) break;
                    code = value;
                    continue block10;
                }
                case 3059181: {
                    if (!key.equals("code")) break;
                    code = value;
                    continue block10;
                }
                case -1108676807: {
                    if (!key.equals("codespace")) break;
                    codespace = value;
                    continue block10;
                }
                case 351608024: {
                    if (!key.equals("version")) break;
                    version = value;
                    continue block10;
                }
                case 1475610435: {
                    if (!key.equals("authority")) break;
                    if (value instanceof String) {
                        value = Citations.fromName((String)value.toString());
                    }
                    authority = value;
                    continue block10;
                }
                case 1091415283: {
                    if (!standalone || !key.equals("remarks") || !(value instanceof InternationalString)) break;
                    remarks = value;
                    continue block10;
                }
            }
            if (!standalone || !(value instanceof String)) continue;
            if (growable == null) {
                growable = remarks instanceof GrowableInternationalString ? (GrowableInternationalString)remarks : new GrowableInternationalString();
            }
            growable.add("remarks", key, value.toString());
        }
        if (growable != null && !growable.getLocales().isEmpty()) {
            if (remarks == null) {
                remarks = growable;
            } else {
                Logger logger = Logging.getLogger(NamedIdentifier.class);
                LogRecord record = Loggings.format((Level)Level.WARNING, (int)28);
                record.setLoggerName(logger.getName());
                logger.log(record);
            }
        }
        if (codespace == null && authority instanceof Citation) {
            codespace = NamedIdentifier.getCodeSpace((Citation)authority);
        }
        try {
            key = "code";
            value = code;
            this.code = (String)value;
            key = "version";
            value = version;
            this.version = (String)value;
            key = "codespace";
            value = codespace;
            this.codespace = value;
            key = "authority";
            value = authority;
            this.authority = (Citation)value;
            key = "remarks";
            value = remarks;
            this.remarks = (InternationalString)value;
        }
        catch (ClassCastException exception) {
            InvalidParameterValueException e = new InvalidParameterValueException(Errors.format((int)58, (Object)key, value), key, value);
            e.initCause((Throwable)exception);
            throw e;
        }
        NamedIdentifier.ensureNonNull("code", code);
    }

    private static void ensureNonNull(String name, Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new InvalidParameterValueException(Errors.format((int)143, (Object)name), name, object);
        }
    }

    public String getCode() {
        return this.code;
    }

    public String getCodeSpace() {
        return this.codespace;
    }

    public Citation getAuthority() {
        return this.authority;
    }

    public String getVersion() {
        return this.version;
    }

    public InternationalString getRemarks() {
        return this.remarks;
    }

    private synchronized GenericName getName() {
        if (this.name == null) {
            this.name = this.getName(this.authority, this.code);
        }
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GenericName getName(Citation authority, CharSequence code) {
        if (authority == null) {
            return new LocalName(code);
        }
        String title = this.codespace != null ? this.codespace : NamedIdentifier.getShortestTitle(authority);
        Class<NamedIdentifier> clazz = NamedIdentifier.class;
        synchronized (NamedIdentifier.class) {
            GenericName scope;
            if (SCOPES == null) {
                SCOPES = new WeakValueHashMap();
            }
            if ((scope = SCOPES.get(title)) == null) {
                scope = new LocalName((CharSequence)title);
                SCOPES.put(title, scope);
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return new ScopedName(scope, code);
        }
    }

    private static InternationalString getShortestTitle(Citation authority) {
        InternationalString title = authority.getTitle();
        int length = title.length();
        Collection alt = authority.getAlternateTitles();
        if (alt != null) {
            for (InternationalString candidate : alt) {
                int candidateLength = candidate.length();
                if (candidateLength <= 0 || candidateLength >= length) continue;
                title = candidate;
                length = candidateLength;
            }
        }
        return title;
    }

    private static String getCodeSpace(Citation authority) {
        String title;
        Collection identifiers = authority.getIdentifiers();
        if (identifiers != null) {
            for (Identifier id : identifiers) {
                String identifier = id.getCode();
                if (!NamedIdentifier.isValidCodeSpace(identifier)) continue;
                return identifier;
            }
        }
        if (NamedIdentifier.isValidCodeSpace(title = NamedIdentifier.getShortestTitle(authority).toString(null))) {
            return title;
        }
        return null;
    }

    private static boolean isValidCodeSpace(String codespace) {
        if (codespace == null) {
            return false;
        }
        int i = codespace.length();
        while (--i >= 0) {
            if (Character.isJavaIdentifierPart(codespace.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public org.opengis.util.LocalName head() {
        return this.getName().head();
    }

    public org.opengis.util.LocalName tip() {
        return this.getName().tip();
    }

    @Deprecated
    public org.opengis.util.LocalName name() {
        return this.tip();
    }

    @Deprecated
    public org.opengis.util.LocalName asLocalName() {
        return this.tip();
    }

    public NameSpace scope() {
        return this.getName().scope();
    }

    public GenericName getScope() {
        return this.getName().scope().name();
    }

    public int depth() {
        return this.getName().depth();
    }

    public List<org.opengis.util.LocalName> getParsedNames() {
        return this.getName().getParsedNames();
    }

    public org.opengis.util.ScopedName push(GenericName scope) {
        return this.getName().push(scope);
    }

    public GenericName toFullyQualifiedName() {
        return this.getName().toFullyQualifiedName();
    }

    @Deprecated
    public org.opengis.util.ScopedName asScopedName() {
        GenericName name = this.toFullyQualifiedName();
        return name instanceof org.opengis.util.ScopedName ? (org.opengis.util.ScopedName)name : null;
    }

    public InternationalString toInternationalString() {
        return this.getName().toInternationalString();
    }

    public String toString() {
        return this.getName().toString();
    }

    @Override
    public int compareTo(GenericName object) {
        return this.getName().compareTo((Object)object);
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            NamedIdentifier that = (NamedIdentifier)object;
            return Utilities.equals((Object)this.code, (Object)that.code) && Utilities.equals((Object)this.codespace, (Object)that.codespace) && Utilities.equals((Object)this.version, (Object)that.version) && Utilities.equals((Object)this.authority, (Object)that.authority) && Utilities.equals((Object)this.remarks, (Object)that.remarks);
        }
        return false;
    }

    public int hashCode() {
        int hash = 895086817;
        if (this.code != null) {
            hash ^= this.code.hashCode();
        }
        if (this.version != null) {
            hash = hash * 37 + this.version.hashCode();
        }
        return hash;
    }
}

