/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.handlers;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.xml.SchemaFactory;
import org.geotools.xml.XMLElementHandler;
import org.geotools.xml.handlers.ComplexElementHandler;
import org.geotools.xml.handlers.IgnoreHandler;
import org.geotools.xml.handlers.SimpleElementHandler;
import org.geotools.xml.schema.ComplexType;
import org.geotools.xml.schema.Element;
import org.geotools.xml.schema.Schema;
import org.geotools.xml.schema.SimpleType;
import org.geotools.xml.schema.Type;
import org.xml.sax.SAXException;

public class ElementHandlerFactory {
    public static final String KEY = "org.geotools.xml.handlers.ElementHandlerFactory_KEY";
    private Logger logger;
    private Map targSchemas = new HashMap();
    private Map prefixURIs = new HashMap();
    protected URI defaultNS = null;

    public ElementHandlerFactory(Logger l) {
        this.logger = l;
    }

    public void endPrefixMapping(String prefix) {
        URI s = (URI)this.prefixURIs.remove(prefix);
        if (s != null) {
            this.targSchemas.remove(s);
        }
    }

    public void startPrefixMapping(String prefix, String targ, URI uri) throws SAXException {
        this.logger.finest("Target == '" + targ + "'");
        this.logger.finest("URI == '" + uri + "'");
        try {
            URI tns = new URI(targ);
            Schema s = SchemaFactory.getInstance(tns, uri, this.logger.getLevel());
            if (s != null) {
                if (prefix == null || "".equalsIgnoreCase(prefix)) {
                    this.defaultNS = s.getTargetNamespace();
                }
                this.targSchemas.put(s.getTargetNamespace(), s);
                this.prefixURIs.put(prefix, tns);
            } else {
                this.prefixURIs.put(prefix, tns);
            }
        }
        catch (URISyntaxException e) {
            this.logger.warning(e.toString());
            throw new SAXException(e);
        }
    }

    public void startPrefixMapping(String prefix, String targ) throws SAXException {
        this.logger.finest("Target == '" + targ + "'");
        try {
            URI tns = new URI(targ);
            Schema s = SchemaFactory.getInstance(tns);
            if (s == null) {
                this.prefixURIs.put(prefix, tns);
                return;
            }
            if (prefix == null || "".equalsIgnoreCase(prefix)) {
                this.defaultNS = s.getTargetNamespace();
            }
            this.targSchemas.put(s.getTargetNamespace(), s);
            this.prefixURIs.put(prefix, tns);
        }
        catch (URISyntaxException e) {
            this.logger.warning(e.toString());
            throw new SAXException(e);
        }
    }

    protected void startPrefixMapping(String prefix, Schema targ) {
        this.logger.finest("Target == '" + targ + "'");
        if (prefix == null || "".equalsIgnoreCase(prefix)) {
            this.defaultNS = targ.getTargetNamespace();
        }
        this.targSchemas.put(targ.getTargetNamespace(), targ);
        this.prefixURIs.put(prefix, targ.getTargetNamespace());
    }

    public XMLElementHandler createElementHandler(URI namespaceURI, String localName) throws SAXException {
        if (localName == null) {
            return null;
        }
        if (namespaceURI == null || "".equals(namespaceURI.toString())) {
            namespaceURI = this.defaultNS;
        }
        this.logger.finest("Trying to create an element handler for " + localName + " :: " + namespaceURI);
        Schema s = (Schema)this.targSchemas.get(namespaceURI);
        if (s == null) {
            this.logger.finest("Could not find Schema " + namespaceURI);
            return null;
        }
        this.logger.finest("Found Schema " + s.getTargetNamespace());
        Element[] eth = s.getElements();
        if (eth == null) {
            return null;
        }
        for (int i = 0; i < eth.length; ++i) {
            String name = eth[i].getName();
            if (!localName.equalsIgnoreCase(name) && !name.equals("IGNORE_HANDLER")) continue;
            return this.createElementHandler(eth[i]);
        }
        return null;
    }

    public XMLElementHandler createElementHandler(Element eth) throws SAXException {
        Type type = eth.getType();
        if (type instanceof SimpleType) {
            return new SimpleElementHandler(eth);
        }
        if (type instanceof ComplexType) {
            return new ComplexElementHandler(this, eth);
        }
        return new IgnoreHandler(eth);
    }

    public URI getNamespace(String prefix) {
        URI s = (URI)this.prefixURIs.get(prefix);
        return s;
    }
}

