/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.generator;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.graphstream.algorithm.generator.BaseGenerator;
import org.graphstream.graph.implementations.DefaultGraph;
import org.graphstream.stream.Sink;

public class PointsOfInterestGenerator
extends BaseGenerator {
    protected int initialPeopleCount;
    protected float addPeopleProbability;
    protected float delPeopleProbability;
    protected float haveInterestProbability;
    protected float lostInterestProbability;
    protected int initialPointOfInterestCount;
    protected float addPointOfInterestProbability;
    protected float delPointOfInterestProbability;
    protected float averagePointsOfInterestCount;
    protected int linksNeededToCreateEdge;
    protected float linkProbability;
    protected LinkedList<Addict> addicts;
    protected LinkedList<PointOfInterest> pointsOfInterest;
    private long currentId;
    private long currentStep;

    protected static String getEdgeId(String nodeA, String nodeB) {
        return nodeA.compareTo(nodeB) < 0 ? String.format("%s---%s", nodeA, nodeB) : String.format("%s---%s", nodeB, nodeA);
    }

    public PointsOfInterestGenerator() {
        this.setUseInternalGraph(false);
        this.initialPeopleCount = 500;
        this.delPeopleProbability = 0.001f;
        this.addPeopleProbability = 0.001f;
        this.haveInterestProbability = 0.001f;
        this.lostInterestProbability = 0.005f;
        this.initialPointOfInterestCount = 15;
        this.delPointOfInterestProbability = 0.001f;
        this.addPointOfInterestProbability = 0.001f;
        this.linkProbability = 0.3f;
        this.averagePointsOfInterestCount = 3.0f;
        this.linksNeededToCreateEdge = 2;
        this.addicts = new LinkedList();
        this.pointsOfInterest = new LinkedList();
        this.currentStep = 0L;
    }

    public void setParameter(Parameter p, Object value) {
        switch (p) {
            case INITIAL_PEOPLE_COUNT: {
                this.initialPeopleCount = (Integer)value;
                break;
            }
            case ADD_PEOPLE_PROBABILITY: {
                this.addPeopleProbability = ((Float)value).floatValue();
                break;
            }
            case DEL_PEOPLE_PROBABILITY: {
                this.delPeopleProbability = ((Float)value).floatValue();
                break;
            }
            case INITIAL_POINT_OF_INTEREST_COUNT: {
                this.initialPointOfInterestCount = (Integer)value;
                break;
            }
            case AVERAGE_POINTS_OF_INTEREST_COUNT: {
                this.averagePointsOfInterestCount = ((Float)value).floatValue();
                break;
            }
            case ADD_POINT_OF_INTEREST_PROBABILITY: {
                this.addPointOfInterestProbability = ((Float)value).floatValue();
                break;
            }
            case DEL_POINT_OF_INTEREST_PROBABILITY: {
                this.delPointOfInterestProbability = ((Float)value).floatValue();
                break;
            }
            case HAVE_INTEREST_PROBABILITY: {
                this.haveInterestProbability = ((Float)value).floatValue();
                break;
            }
            case LOST_INTEREST_PROBABILITY: {
                this.lostInterestProbability = ((Float)value).floatValue();
                break;
            }
            case LINKS_NEEDED_TO_CREATE_EDGE: {
                this.linksNeededToCreateEdge = (Integer)value;
                break;
            }
            case LINK_PROBABILITY: {
                this.linkProbability = ((Number)value).floatValue();
            }
        }
    }

    @Override
    public void begin() {
        int i;
        this.pointsOfInterest.clear();
        for (i = 0; i < this.initialPointOfInterestCount; ++i) {
            this.addPointOfInterest();
        }
        for (i = 0; i < this.initialPeopleCount; ++i) {
            this.addAddict();
        }
    }

    @Override
    public boolean nextEvents() {
        this.sendStepBegins(this.sourceId, this.currentStep++);
        if (this.random.nextDouble() < (double)this.delPeopleProbability) {
            this.killSomeone();
        }
        if (this.random.nextDouble() < (double)this.addPeopleProbability) {
            this.addAddict();
        }
        if (this.random.nextDouble() < (double)this.delPointOfInterestProbability) {
            this.removeRandomPointOfInterest();
        }
        if (this.random.nextDouble() < (double)this.addPointOfInterestProbability) {
            this.addPointOfInterest();
        }
        for (Addict a : this.addicts) {
            a.step();
        }
        return true;
    }

    @Override
    public void end() {
        super.end();
    }

    protected void addPointOfInterest() {
        this.pointsOfInterest.add(new PointOfInterest());
    }

    protected void removePointOfInterest(PointOfInterest poi) {
        this.pointsOfInterest.remove(poi);
        for (Addict a : poi.addict) {
            poi.delAddict(a);
        }
    }

    protected void removeRandomPointOfInterest() {
        this.pointsOfInterest.remove(this.random.nextInt(this.pointsOfInterest.size()));
    }

    protected void addAddict() {
        Addict a = new Addict(String.format("%08x", this.currentId++));
        this.addicts.add(a);
        this.addNode(a.id);
    }

    protected void killAddict(Addict a) {
        while (a.pointsOfInterest.size() > 0) {
            a.pointsOfInterest.peek().delAddict(a);
        }
        a.fullUnlink();
        this.addicts.remove(a);
        this.delNode(a.id);
        a.id = null;
        a.pointsOfInterest.clear();
        a.pointsOfInterest = null;
    }

    protected void killSomeone() {
        this.killAddict(this.addicts.get(this.random.nextInt(this.addicts.size())));
    }

    public static void main(String ... args) {
        PointsOfInterestGenerator gen = new PointsOfInterestGenerator();
        gen.setParameter(Parameter.INITIAL_PEOPLE_COUNT, 300);
        gen.setParameter(Parameter.ADD_PEOPLE_PROBABILITY, Float.valueOf(0.01f));
        gen.setParameter(Parameter.DEL_PEOPLE_PROBABILITY, Float.valueOf(0.01f));
        gen.setParameter(Parameter.INITIAL_POINT_OF_INTEREST_COUNT, 30);
        gen.setParameter(Parameter.AVERAGE_POINTS_OF_INTEREST_COUNT, Float.valueOf(5.0f));
        gen.setParameter(Parameter.ADD_POINT_OF_INTEREST_PROBABILITY, Float.valueOf(0.0f));
        gen.setParameter(Parameter.DEL_POINT_OF_INTEREST_PROBABILITY, Float.valueOf(0.0f));
        gen.setParameter(Parameter.HAVE_INTEREST_PROBABILITY, Float.valueOf(0.1f));
        gen.setParameter(Parameter.LOST_INTEREST_PROBABILITY, Float.valueOf(0.001f));
        gen.setParameter(Parameter.LINKS_NEEDED_TO_CREATE_EDGE, 2);
        gen.setParameter(Parameter.LINK_PROBABILITY, Float.valueOf(0.05f));
        DefaultGraph g = new DefaultGraph("theGraph");
        gen.addSink((Sink)g);
        String stylesheet = "graph {   fill-color: white;  padding: 50px;}node {   fill-color: black;}edge {  fill-color: black;}";
        g.addAttribute("ui.stylesheet", new Object[]{stylesheet});
        g.addAttribute("ui.quality", new Object[0]);
        g.display();
        gen.begin();
        while (true) {
            gen.nextEvents();
            try {
                Thread.sleep(60L);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public static enum Parameter {
        INITIAL_PEOPLE_COUNT,
        ADD_PEOPLE_PROBABILITY,
        DEL_PEOPLE_PROBABILITY,
        INITIAL_POINT_OF_INTEREST_COUNT,
        AVERAGE_POINTS_OF_INTEREST_COUNT,
        ADD_POINT_OF_INTEREST_PROBABILITY,
        DEL_POINT_OF_INTEREST_PROBABILITY,
        HAVE_INTEREST_PROBABILITY,
        LOST_INTEREST_PROBABILITY,
        LINKS_NEEDED_TO_CREATE_EDGE,
        LINK_PROBABILITY;

    }

    protected class Addict {
        String id;
        LinkedList<PointOfInterest> pointsOfInterest;
        Map<Addict, AddictNeighbor> neighbor;

        Addict(String id) {
            this.id = id;
            this.pointsOfInterest = new LinkedList();
            this.neighbor = new HashMap<Addict, AddictNeighbor>();
        }

        void step() {
            Collections.shuffle(PointsOfInterestGenerator.this.pointsOfInterest, PointsOfInterestGenerator.this.random);
            for (PointOfInterest poi : PointsOfInterestGenerator.this.pointsOfInterest) {
                if (this.pointsOfInterest.contains(poi)) {
                    if (!(PointsOfInterestGenerator.this.random.nextFloat() < PointsOfInterestGenerator.this.lostInterestProbability)) continue;
                    poi.delAddict(this);
                    continue;
                }
                double p = Math.atan(20.0 * (double)Math.min((float)this.pointsOfInterest.size(), PointsOfInterestGenerator.this.averagePointsOfInterestCount) / (double)PointsOfInterestGenerator.this.averagePointsOfInterestCount - 10.0);
                p = (p - Math.atan(-10.0)) / (Math.atan(10.0) - Math.atan(-10.0));
                if (!((double)PointsOfInterestGenerator.this.random.nextFloat() < (double)PointsOfInterestGenerator.this.haveInterestProbability * (1.0 - p))) continue;
                poi.newAddict(this);
            }
        }

        void link(Addict a) {
            AddictNeighbor an;
            if (!this.neighbor.containsKey(a)) {
                an = new AddictNeighbor();
                this.neighbor.put(a, an);
                a.neighbor.put(this, an);
            }
            if ((an = this.neighbor.get(a)).incrementAndGet() >= PointsOfInterestGenerator.this.linksNeededToCreateEdge && !an.connected && PointsOfInterestGenerator.this.random.nextDouble() < Math.pow(PointsOfInterestGenerator.this.linkProbability, 1.0 / (double)(an.counter.get() - PointsOfInterestGenerator.this.linksNeededToCreateEdge + 1))) {
                an.connected = true;
                PointsOfInterestGenerator.this.addEdge(PointsOfInterestGenerator.getEdgeId(this.id, a.id), this.id, a.id);
            }
        }

        void unlink(Addict a) {
            if (this.neighbor.containsKey(a) && this.neighbor.get(a).decrementAndGet() < PointsOfInterestGenerator.this.linksNeededToCreateEdge) {
                this.neighbor.remove(a);
                a.neighbor.remove(this);
                PointsOfInterestGenerator.this.delEdge(PointsOfInterestGenerator.getEdgeId(this.id, a.id));
            }
        }

        void fullUnlink() {
            for (Addict a : this.neighbor.keySet()) {
                a.neighbor.remove(this);
                PointsOfInterestGenerator.this.delEdge(PointsOfInterestGenerator.getEdgeId(this.id, a.id));
            }
            this.neighbor.clear();
        }
    }

    protected static class AddictNeighbor {
        AtomicInteger counter;
        boolean connected;

        public AddictNeighbor() {
            this.counter = new AtomicInteger(0);
            this.connected = false;
        }

        public AddictNeighbor(AtomicInteger i) {
            this.counter = i;
            this.connected = false;
        }

        int incrementAndGet() {
            return this.counter.incrementAndGet();
        }

        int decrementAndGet() {
            return this.counter.decrementAndGet();
        }

        boolean isConnected() {
            return this.connected;
        }
    }

    protected class PointOfInterest {
        Set<Addict> addict = new HashSet<Addict>();

        PointOfInterest() {
        }

        void newAddict(Addict addictA) {
            if (!this.addict.contains(addictA)) {
                for (Addict addictB : this.addict) {
                    addictA.link(addictB);
                }
                this.addict.add(addictA);
                addictA.pointsOfInterest.add(this);
            }
        }

        void delAddict(Addict addictA) {
            if (this.addict.contains(addictA)) {
                this.addict.remove(addictA);
                addictA.pointsOfInterest.remove(this);
                for (Addict addictB : this.addict) {
                    addictA.unlink(addictB);
                }
            }
        }

        boolean isAddict(Addict a) {
            return this.addict.contains(a);
        }
    }
}

