/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.frame;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.frame.SuppressFBWarnings;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.graalvm.collections.EconomicMap;

public final class FrameDescriptor
implements Cloneable {
    private final Object defaultValue;
    private final ArrayList<FrameSlot> slots;
    private final EconomicMap<Object, FrameSlot> identifierToSlotMap;
    @CompilerDirectives.CompilationFinal
    private volatile Assumption version;
    private EconomicMap<Object, Assumption> identifierToNotInFrameAssumptionMap;
    @CompilerDirectives.CompilationFinal
    private volatile int size;
    private final Object lock;
    boolean materializeCalled;
    private static final String NEVER_PART_OF_COMPILATION_MESSAGE = "interpreter-only. includes hashmap operations.";

    public FrameDescriptor() {
        this(null);
    }

    public FrameDescriptor(Object defaultValue) {
        this(defaultValue, null);
    }

    private FrameDescriptor(Object defaultValue, Object lock) {
        CompilerAsserts.neverPartOfCompilation("do not create a FrameDescriptor from compiled code");
        this.defaultValue = defaultValue;
        this.slots = new ArrayList();
        this.identifierToSlotMap = EconomicMap.create();
        this.lock = lock == null ? this : lock;
        FrameDescriptor.newVersion(this);
    }

    public FrameSlot addFrameSlot(Object identifier) {
        return this.addFrameSlot(identifier, null, FrameSlotKind.Illegal);
    }

    public FrameSlot addFrameSlot(Object identifier, FrameSlotKind kind) {
        return this.addFrameSlot(identifier, null, kind);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="All increments and decrements are synchronized.")
    public FrameSlot addFrameSlot(Object identifier, Object info, FrameSlotKind kind) {
        CompilerAsserts.neverPartOfCompilation(NEVER_PART_OF_COMPILATION_MESSAGE);
        Objects.requireNonNull(identifier, "identifier");
        Objects.requireNonNull(kind, "kind");
        Object object = this.lock;
        synchronized (object) {
            if (this.identifierToSlotMap.containsKey(identifier)) {
                throw new IllegalArgumentException("duplicate frame slot: " + identifier);
            }
            FrameSlot slot = new FrameSlot(this, identifier, info, kind, this.size);
            ++this.size;
            this.slots.add(slot);
            this.identifierToSlotMap.put(identifier, slot);
            this.updateVersion();
            this.invalidateNotInFrameAssumption(identifier);
            return slot;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FrameSlot findFrameSlot(Object identifier) {
        CompilerAsserts.neverPartOfCompilation(NEVER_PART_OF_COMPILATION_MESSAGE);
        Object object = this.lock;
        synchronized (object) {
            return (FrameSlot)this.identifierToSlotMap.get(identifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FrameSlot findOrAddFrameSlot(Object identifier) {
        CompilerAsserts.neverPartOfCompilation(NEVER_PART_OF_COMPILATION_MESSAGE);
        Object object = this.lock;
        synchronized (object) {
            FrameSlot result = this.findFrameSlot(identifier);
            if (result != null) {
                return result;
            }
            return this.addFrameSlot(identifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FrameSlot findOrAddFrameSlot(Object identifier, FrameSlotKind kind) {
        CompilerAsserts.neverPartOfCompilation(NEVER_PART_OF_COMPILATION_MESSAGE);
        Object object = this.lock;
        synchronized (object) {
            FrameSlot result = this.findFrameSlot(identifier);
            if (result != null) {
                return result;
            }
            return this.addFrameSlot(identifier, kind);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FrameSlot findOrAddFrameSlot(Object identifier, Object info, FrameSlotKind kind) {
        CompilerAsserts.neverPartOfCompilation(NEVER_PART_OF_COMPILATION_MESSAGE);
        Object object = this.lock;
        synchronized (object) {
            FrameSlot result = this.findFrameSlot(identifier);
            if (result != null) {
                return result;
            }
            return this.addFrameSlot(identifier, info, kind);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFrameSlot(Object identifier) {
        CompilerAsserts.neverPartOfCompilation(NEVER_PART_OF_COMPILATION_MESSAGE);
        Object object = this.lock;
        synchronized (object) {
            FrameSlot slot = (FrameSlot)this.identifierToSlotMap.get(identifier);
            if (slot == null) {
                throw new IllegalArgumentException("no such frame slot: " + identifier);
            }
            this.slots.remove(slot);
            this.identifierToSlotMap.removeKey(identifier);
            this.updateVersion();
            this.getNotInFrameAssumption(identifier);
        }
    }

    public FrameSlotKind getFrameSlotKind(FrameSlot frameSlot) {
        assert (this.checkFrameSlotOwnership(frameSlot));
        return frameSlot.kind;
    }

    public void setFrameSlotKind(FrameSlot frameSlot, FrameSlotKind kind) {
        if (frameSlot.kind != kind) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.setFrameSlotKindSlow(frameSlot, kind);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFrameSlotKindSlow(FrameSlot frameSlot, FrameSlotKind kind) {
        CompilerAsserts.neverPartOfCompilation(NEVER_PART_OF_COMPILATION_MESSAGE);
        Object object = this.lock;
        synchronized (object) {
            assert (this.checkFrameSlotOwnershipUnsafe(frameSlot));
            if (frameSlot.kind != kind) {
                FrameDescriptor.invalidateVersion(this);
                frameSlot.kind = kind;
                FrameDescriptor.newVersion(this);
            }
        }
    }

    private boolean checkFrameSlotOwnershipUnsafe(FrameSlot frameSlot) {
        return frameSlot.descriptor == this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkFrameSlotOwnership(FrameSlot frameSlot) {
        CompilerAsserts.neverPartOfCompilation(NEVER_PART_OF_COMPILATION_MESSAGE);
        Object object = this.lock;
        synchronized (object) {
            return this.checkFrameSlotOwnershipUnsafe(frameSlot);
        }
    }

    public int getSize() {
        if (CompilerDirectives.inCompiledCode() && !this.version.isValid()) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
        }
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<? extends FrameSlot> getSlots() {
        CompilerAsserts.neverPartOfCompilation(NEVER_PART_OF_COMPILATION_MESSAGE);
        Object object = this.lock;
        synchronized (object) {
            return Collections.unmodifiableList(new ArrayList<FrameSlot>(this.slots));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Object> getIdentifiers() {
        CompilerAsserts.neverPartOfCompilation(NEVER_PART_OF_COMPILATION_MESSAGE);
        Object object = this.lock;
        synchronized (object) {
            return FrameDescriptor.unmodifiableSetFromEconomicMap(EconomicMap.create(this.identifierToSlotMap));
        }
    }

    private static <K> Set<K> unmodifiableSetFromEconomicMap(final EconomicMap<K, ?> map) {
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                return new Iterator<K>(){
                    private final Iterator<K> it;
                    {
                        this.it = map.getKeys().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public K next() {
                        return this.it.next();
                    }
                };
            }

            @Override
            public int size() {
                return map.size();
            }

            @Override
            public boolean contains(Object o) {
                return map.containsKey(o);
            }

            @Override
            public boolean add(K e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends K> coll) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> coll) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> coll) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeIf(Predicate<? super K> filter) {
                throw new UnsupportedOperationException();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FrameDescriptor copy() {
        CompilerAsserts.neverPartOfCompilation(NEVER_PART_OF_COMPILATION_MESSAGE);
        Object object = this.lock;
        synchronized (object) {
            FrameDescriptor clonedFrameDescriptor = new FrameDescriptor(this.defaultValue);
            for (int i = 0; i < this.slots.size(); ++i) {
                FrameSlot slot = this.slots.get(i);
                clonedFrameDescriptor.addFrameSlot(slot.getIdentifier(), slot.getInfo(), FrameSlotKind.Illegal);
            }
            return clonedFrameDescriptor;
        }
    }

    private void updateVersion() {
        FrameDescriptor.invalidateVersion(this);
        FrameDescriptor.newVersion(this);
    }

    private static void newVersion(FrameDescriptor descriptor) {
        descriptor.version = Truffle.getRuntime().createAssumption("frame version");
    }

    private static void invalidateVersion(FrameDescriptor descriptor) {
        descriptor.version.invalidate();
    }

    public Assumption getVersion() {
        return this.version;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Assumption getNotInFrameAssumption(Object identifier) {
        CompilerAsserts.neverPartOfCompilation(NEVER_PART_OF_COMPILATION_MESSAGE);
        Object object = this.lock;
        synchronized (object) {
            Assumption assumption;
            if (this.identifierToSlotMap.containsKey(identifier)) {
                throw new IllegalArgumentException("Cannot get not-in-frame assumption for existing frame slot!");
            }
            if (this.identifierToNotInFrameAssumptionMap == null) {
                this.identifierToNotInFrameAssumptionMap = EconomicMap.create();
            } else {
                assumption = (Assumption)this.identifierToNotInFrameAssumptionMap.get(identifier);
                if (assumption != null) {
                    return assumption;
                }
            }
            assumption = Truffle.getRuntime().createAssumption("identifier not in frame");
            this.identifierToNotInFrameAssumptionMap.put(identifier, assumption);
            return assumption;
        }
    }

    private void invalidateNotInFrameAssumption(Object identifier) {
        Assumption assumption;
        if (this.identifierToNotInFrameAssumptionMap != null && (assumption = (Assumption)this.identifierToNotInFrameAssumptionMap.get(identifier)) != null) {
            assumption.invalidate();
            this.identifierToNotInFrameAssumptionMap.removeKey(identifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        CompilerAsserts.neverPartOfCompilation(NEVER_PART_OF_COMPILATION_MESSAGE);
        Object object = this.lock;
        synchronized (object) {
            StringBuilder sb = new StringBuilder();
            sb.append("FrameDescriptor@").append(Integer.toHexString(this.hashCode()));
            sb.append("{");
            boolean comma = false;
            for (FrameSlot slot : this.slots) {
                if (comma) {
                    sb.append(", ");
                } else {
                    comma = true;
                }
                sb.append(slot.index).append(":").append(slot.getIdentifier());
            }
            sb.append("}");
            return sb.toString();
        }
    }
}

