/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.builtins.ArrayBufferPrototypeBuiltins;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.JSContext;

@GeneratedBy(value=ArrayBufferPrototypeBuiltins.class)
public final class ArrayBufferPrototypeBuiltinsFactory {

    @GeneratedBy(value=ArrayBufferPrototypeBuiltins.JSArrayBufferSliceNode.class)
    public static final class JSArrayBufferSliceNodeGen
    extends ArrayBufferPrototypeBuiltins.JSArrayBufferSliceNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private JSArrayBufferSliceNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0x1A) == 0 && state_0 != 0) {
                return this.execute_int_int0(state_0, frameValue);
            }
            return this.execute_generic1(state_0, frameValue);
        }

        private Object execute_int_int0(int state_0, VirtualFrame frameValue) {
            int arguments2Value_;
            int arguments1Value_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            try {
                arguments1Value_ = this.arguments1_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object arguments2Value = this.arguments2_.execute(frameValue);
                return this.executeAndSpecialize(arguments0Value_, ex.getResult(), arguments2Value);
            }
            try {
                arguments2Value_ = this.arguments2_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(arguments0Value_, arguments1Value_, ex.getResult());
            }
            if ((state_0 & 5) != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                if ((state_0 & 1) != 0 && JSGuards.isJSHeapArrayBuffer(arguments0Value__)) {
                    return this.slice(arguments0Value__, arguments1Value_, arguments2Value_);
                }
                if ((state_0 & 4) != 0 && JSGuards.isJSDirectArrayBuffer(arguments0Value__)) {
                    return this.sliceDirect(arguments0Value__, arguments1Value_, arguments2Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        private Object execute_generic1(int state_0, VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if ((state_0 & 0xF) != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                int arguments2Value__;
                int arguments1Value__;
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                if ((state_0 & 1) != 0 && arguments1Value_ instanceof Integer) {
                    arguments1Value__ = (Integer)arguments1Value_;
                    if (arguments2Value_ instanceof Integer) {
                        arguments2Value__ = (Integer)arguments2Value_;
                        if (JSGuards.isJSHeapArrayBuffer(arguments0Value__)) {
                            return this.slice(arguments0Value__, arguments1Value__, arguments2Value__);
                        }
                    }
                }
                if ((state_0 & 2) != 0 && JSGuards.isJSHeapArrayBuffer(arguments0Value__)) {
                    return this.slice(arguments0Value__, arguments1Value_, arguments2Value_);
                }
                if ((state_0 & 4) != 0 && arguments1Value_ instanceof Integer) {
                    arguments1Value__ = (Integer)arguments1Value_;
                    if (arguments2Value_ instanceof Integer) {
                        arguments2Value__ = (Integer)arguments2Value_;
                        if (JSGuards.isJSDirectArrayBuffer(arguments0Value__)) {
                            return this.sliceDirect(arguments0Value__, arguments1Value__, arguments2Value__);
                        }
                    }
                }
                if ((state_0 & 8) != 0 && JSGuards.isJSDirectArrayBuffer(arguments0Value__)) {
                    return this.sliceDirect(arguments0Value__, arguments1Value_, arguments2Value_);
                }
            }
            if ((state_0 & 0x10) != 0 && !JSGuards.isJSHeapArrayBuffer(arguments0Value_) && !JSGuards.isJSDirectArrayBuffer(arguments0Value_)) {
                return ArrayBufferPrototypeBuiltins.JSArrayBufferSliceNode.error(arguments0Value_, arguments1Value_, arguments2Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private DynamicObject executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            int state_0 = this.state_0_;
            if (JSTypes.isDynamicObject(arguments0Value)) {
                int arguments2Value_;
                int arguments1Value_;
                DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                if (arguments1Value instanceof Integer) {
                    arguments1Value_ = (Integer)arguments1Value;
                    if (arguments2Value instanceof Integer) {
                        arguments2Value_ = (Integer)arguments2Value;
                        if (JSGuards.isJSHeapArrayBuffer(arguments0Value_)) {
                            this.state_0_ = state_0 |= 1;
                            return this.slice(arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                }
                if (JSGuards.isJSHeapArrayBuffer(arguments0Value_)) {
                    this.state_0_ = state_0 |= 2;
                    return this.slice(arguments0Value_, arguments1Value, arguments2Value);
                }
                if (arguments1Value instanceof Integer) {
                    arguments1Value_ = (Integer)arguments1Value;
                    if (arguments2Value instanceof Integer) {
                        arguments2Value_ = (Integer)arguments2Value;
                        if (JSGuards.isJSDirectArrayBuffer(arguments0Value_)) {
                            this.state_0_ = state_0 |= 4;
                            return this.sliceDirect(arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                }
                if (JSGuards.isJSDirectArrayBuffer(arguments0Value_)) {
                    this.state_0_ = state_0 |= 8;
                    return this.sliceDirect(arguments0Value_, arguments1Value, arguments2Value);
                }
            }
            if (!JSGuards.isJSHeapArrayBuffer(arguments0Value) && !JSGuards.isJSDirectArrayBuffer(arguments0Value)) {
                this.state_0_ = state_0 |= 0x10;
                return ArrayBufferPrototypeBuiltins.JSArrayBufferSliceNode.error(arguments0Value, arguments1Value, arguments2Value);
            }
            throw new UnsupportedSpecializationException(this, new Node[]{this.arguments0_, this.arguments1_, this.arguments2_}, arguments0Value, arguments1Value, arguments2Value);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[6];
            data[0] = 0;
            int state_0 = this.state_0_;
            Object[] s2 = new Object[3];
            s2[0] = "slice";
            s2[1] = (state_0 & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s2;
            s2 = new Object[3];
            s2[0] = "slice";
            s2[1] = (state_0 & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s2;
            s2 = new Object[3];
            s2[0] = "sliceDirect";
            s2[1] = (state_0 & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s2;
            s2 = new Object[3];
            s2[0] = "sliceDirect";
            s2[1] = (state_0 & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[4] = s2;
            s2 = new Object[3];
            s2[0] = "error";
            s2[1] = (state_0 & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[5] = s2;
            return Introspection.Provider.create(data);
        }

        public static ArrayBufferPrototypeBuiltins.JSArrayBufferSliceNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSArrayBufferSliceNodeGen(context, builtin, arguments);
        }
    }
}

