/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.RealmFunctionBuiltinsFactory;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.objects.Undefined;

public final class RealmFunctionBuiltins
extends JSBuiltinsContainer.SwitchEnum<RealmFunction> {
    public static final JSBuiltinsContainer BUILTINS = new RealmFunctionBuiltins();

    protected RealmFunctionBuiltins() {
        super("Realm", RealmFunction.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, RealmFunction builtinEnum) {
        switch (builtinEnum) {
            case create: 
            case createAllowCrossRealmAccess: {
                return RealmFunctionBuiltinsFactory.RealmCreateNodeGen.create(context, builtin, RealmFunctionBuiltins.args().fixedArgs(0).createArgumentNodes(context));
            }
            case global: {
                return RealmFunctionBuiltinsFactory.RealmGlobalNodeGen.create(context, builtin, RealmFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case dispose: {
                return RealmFunctionBuiltinsFactory.RealmDisposeNodeGen.create(context, builtin, RealmFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case current: {
                return RealmFunctionBuiltinsFactory.RealmCurrentNodeGen.create(context, builtin, RealmFunctionBuiltins.args().fixedArgs(0).createArgumentNodes(context));
            }
            case eval: {
                return RealmFunctionBuiltinsFactory.RealmEvalNodeGen.create(context, builtin, RealmFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
        }
        return null;
    }

    protected static JSRealm topLevelRealm(JSContext context) {
        JSRealm realm = context.getRealm();
        while (realm.getParent() != null) {
            realm = realm.getParent();
        }
        return realm;
    }

    protected static int toRealmIndexOrThrow(JSRealm topLevelRealm, Object index) {
        int realmIdx = JSRuntime.intValue(JSRuntime.toNumber(index));
        if (realmIdx < 0) {
            throw Errors.createTypeError("Invalid realm index");
        }
        JSRealm jsrealm = topLevelRealm.getFromRealmList(realmIdx);
        if (jsrealm == null) {
            throw Errors.createTypeError("Invalid realm index");
        }
        return realmIdx;
    }

    public static abstract class RealmEvalNode
    extends JSBuiltinNode {
        public RealmEvalNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected Object eval(Object index, Object code) {
            JSRealm topLevelRealm = RealmFunctionBuiltins.topLevelRealm(this.getContext());
            int realmIndex = RealmFunctionBuiltins.toRealmIndexOrThrow(topLevelRealm, index);
            JSRealm jsrealm = topLevelRealm.getFromRealmList(realmIndex);
            String sourceText = JSRuntime.toString(code);
            Source source = Source.newBuilder("js", sourceText, "<eval>").build();
            JSRealm currentV8Realm = topLevelRealm.getCurrentV8Realm();
            try {
                topLevelRealm.setCurrentV8Realm(jsrealm);
                Object object = jsrealm.getContext().getEvaluator().evaluate(jsrealm, this, source);
                return object;
            }
            finally {
                topLevelRealm.setCurrentV8Realm(currentV8Realm);
            }
        }
    }

    public static abstract class RealmCurrentNode
    extends JSBuiltinNode {
        public RealmCurrentNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected Object current() {
            JSRealm topLevelRealm = RealmFunctionBuiltins.topLevelRealm(this.getContext());
            return topLevelRealm.getIndexFromRealmList(topLevelRealm.getCurrentV8Realm());
        }
    }

    public static abstract class RealmGlobalNode
    extends JSBuiltinNode {
        public RealmGlobalNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected Object global(Object index) {
            JSRealm topLevelRealm = RealmFunctionBuiltins.topLevelRealm(this.getContext());
            int realmIndex = RealmFunctionBuiltins.toRealmIndexOrThrow(topLevelRealm, index);
            JSRealm jsrealm = topLevelRealm.getFromRealmList(realmIndex);
            return jsrealm.getGlobalObject();
        }
    }

    public static abstract class RealmDisposeNode
    extends JSBuiltinNode {
        public RealmDisposeNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected Object dispose(Object index) {
            JSRealm topLevelRealm = RealmFunctionBuiltins.topLevelRealm(this.getContext());
            int realmIndex = RealmFunctionBuiltins.toRealmIndexOrThrow(topLevelRealm, index);
            topLevelRealm.removeFromRealmList(realmIndex);
            return Undefined.instance;
        }
    }

    public static abstract class RealmCreateNode
    extends JSBuiltinNode {
        public RealmCreateNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected Object createRealm() {
            JSRealm newRealm = this.getContext().getRealm().createChildRealm();
            return RealmFunctionBuiltins.topLevelRealm(this.getContext()).getIndexFromRealmList(newRealm);
        }
    }

    public static enum RealmFunction implements BuiltinEnum<RealmFunction>
    {
        create(0),
        createAllowCrossRealmAccess(0),
        global(1),
        dispose(1),
        current(0),
        eval(2);

        private final int length;

        private RealmFunction(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }
}

