/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.builtins.StringPrototypeBuiltins;
import com.oracle.truffle.js.builtins.helper.ReplaceStringParser;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.IsRegExpNode;
import com.oracle.truffle.js.nodes.access.RequireObjectCoercibleNode;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToRegExpNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.cast.JSTrimWhitespaceNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.objects.JSLazyString;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=StringPrototypeBuiltins.class)
public final class StringPrototypeBuiltinsFactory {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringAtNode.class)
    public static final class JSStringAtNodeGen
    extends StringPrototypeBuiltins.JSStringAtNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;

        private JSStringAtNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            return this.at(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s2 = new Object[3];
            s2[0] = "at";
            s2[1] = (byte)1;
            data[1] = s2;
            return Introspection.Provider.create(data);
        }

        public static StringPrototypeBuiltins.JSStringAtNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringAtNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.CreateHTMLNode.class)
    static final class CreateHTMLNodeGen
    extends StringPrototypeBuiltins.CreateHTMLNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @Node.Child
        private RequireObjectCoercibleNode requireObjectCoercibleNode_;
        @Node.Child
        private JSToStringNode toStringNode_;

        private CreateHTMLNodeGen(JSContext context, JSBuiltin builtin, String tag, String attribute, JavaScriptNode[] arguments) {
            super(context, builtin, tag, attribute);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state_0 != 0) {
                return this.createHTML(arguments0Value_, arguments1Value_, this.requireObjectCoercibleNode_, this.toStringNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            try {
                this.requireObjectCoercibleNode_ = super.insert(RequireObjectCoercibleNode.create());
                this.toStringNode_ = super.insert(JSToStringNode.create());
                this.state_0_ = state_0 |= 1;
                lock.unlock();
                hasLock = false;
                String string = this.createHTML(arguments0Value, arguments1Value, this.requireObjectCoercibleNode_, this.toStringNode_);
                return string;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            int state_0 = this.state_0_;
            Object[] s2 = new Object[3];
            s2[0] = "createHTML";
            if (state_0 != 0) {
                s2[1] = (byte)1;
                ArrayList<List<JavaScriptBaseNode>> cached = new ArrayList<List<JavaScriptBaseNode>>();
                cached.add(Arrays.asList(this.requireObjectCoercibleNode_, this.toStringNode_));
                s2[2] = cached;
            } else {
                s2[1] = (byte)0;
            }
            data[1] = s2;
            return Introspection.Provider.create(data);
        }

        public static StringPrototypeBuiltins.CreateHTMLNode create(JSContext context, JSBuiltin builtin, String tag, String attribute, JavaScriptNode[] arguments) {
            return new CreateHTMLNodeGen(context, builtin, tag, attribute, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.CreateStringIteratorNode.class)
    public static final class CreateStringIteratorNodeGen
    extends StringPrototypeBuiltins.CreateStringIteratorNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @Node.Child
        private RequireObjectCoercibleNode coerce_requireObjectCoercibleNode_;
        @Node.Child
        private JSToStringNode coerce_toStringNode_;

        private CreateStringIteratorNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state_0 & 1) != 0 && JSTypesGen.isImplicitString((state_0 & 0x1C) >>> 2, arguments0Value_)) {
                String arguments0Value__ = JSTypesGen.asImplicitString((state_0 & 0x1C) >>> 2, arguments0Value_);
                return this.doString(frameValue, arguments0Value__);
            }
            if ((state_0 & 2) != 0 && !JSGuards.isString(arguments0Value_)) {
                return this.doCoerce(frameValue, arguments0Value_, this.coerce_requireObjectCoercibleNode_, this.coerce_toStringNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private DynamicObject executeAndSpecialize(VirtualFrame frameValue, Object arguments0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            try {
                int stringCast0 = JSTypesGen.specializeImplicitString(arguments0Value);
                if (stringCast0 != 0) {
                    String arguments0Value_ = JSTypesGen.asImplicitString(stringCast0, arguments0Value);
                    state_0 |= stringCast0 << 2;
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.doString(frameValue, arguments0Value_);
                    return dynamicObject;
                }
                if (!JSGuards.isString(arguments0Value)) {
                    this.coerce_requireObjectCoercibleNode_ = super.insert(RequireObjectCoercibleNode.create());
                    this.coerce_toStringNode_ = super.insert(JSToStringNode.create());
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.doCoerce(frameValue, arguments0Value, this.coerce_requireObjectCoercibleNode_, this.coerce_toStringNode_);
                    return dynamicObject;
                }
                throw new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 3) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 3 & (state_0 & 3) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[3];
            data[0] = 0;
            int state_0 = this.state_0_;
            Object[] s2 = new Object[3];
            s2[0] = "doString";
            s2[1] = (state_0 & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s2;
            s2 = new Object[3];
            s2[0] = "doCoerce";
            if ((state_0 & 2) != 0) {
                s2[1] = (byte)1;
                ArrayList<List<JavaScriptBaseNode>> cached = new ArrayList<List<JavaScriptBaseNode>>();
                cached.add(Arrays.asList(this.coerce_requireObjectCoercibleNode_, this.coerce_toStringNode_));
                s2[2] = cached;
            } else {
                s2[1] = (byte)0;
            }
            data[2] = s2;
            return Introspection.Provider.create(data);
        }

        public static StringPrototypeBuiltins.CreateStringIteratorNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new CreateStringIteratorNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringPadNode.class)
    public static final class JSStringPadNodeGen
    extends StringPrototypeBuiltins.JSStringPadNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @Node.Child
        private JSToStringNode toString2Node_;

        private JSStringPadNodeGen(JSContext context, JSBuiltin builtin, boolean atStart, JavaScriptNode[] arguments) {
            super(context, builtin, atStart);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state_0 != 0 && arguments1Value_ instanceof Object[]) {
                Object[] arguments1Value__ = (Object[])arguments1Value_;
                return this.pad(arguments0Value_, arguments1Value__, this.toString2Node_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private String executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            try {
                if (arguments1Value instanceof Object[]) {
                    Object[] arguments1Value_ = (Object[])arguments1Value;
                    this.toString2Node_ = super.insert(JSToStringNode.create());
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    String string = this.pad(arguments0Value, arguments1Value_, this.toString2Node_);
                    return string;
                }
                throw new UnsupportedSpecializationException(this, new Node[]{this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            int state_0 = this.state_0_;
            Object[] s2 = new Object[3];
            s2[0] = "pad";
            if (state_0 != 0) {
                s2[1] = (byte)1;
                ArrayList<List<JSToStringNode>> cached = new ArrayList<List<JSToStringNode>>();
                cached.add(Arrays.asList(this.toString2Node_));
                s2[2] = cached;
            } else {
                s2[1] = (byte)0;
            }
            data[1] = s2;
            return Introspection.Provider.create(data);
        }

        public static StringPrototypeBuiltins.JSStringPadNode create(JSContext context, JSBuiltin builtin, boolean atStart, JavaScriptNode[] arguments) {
            return new JSStringPadNodeGen(context, builtin, atStart, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringNormalizeNode.class)
    public static final class JSStringNormalizeNodeGen
    extends StringPrototypeBuiltins.JSStringNormalizeNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;

        private JSStringNormalizeNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            return this.normalize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s2 = new Object[3];
            s2[0] = "normalize";
            s2[1] = (byte)1;
            data[1] = s2;
            return Introspection.Provider.create(data);
        }

        public static StringPrototypeBuiltins.JSStringNormalizeNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringNormalizeNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringCodePointAtNode.class)
    public static final class JSStringCodePointAtNodeGen
    extends StringPrototypeBuiltins.JSStringCodePointAtNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;

        private JSStringCodePointAtNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            return this.codePointAt(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s2 = new Object[3];
            s2[0] = "codePointAt";
            s2[1] = (byte)1;
            data[1] = s2;
            return Introspection.Provider.create(data);
        }

        public static StringPrototypeBuiltins.JSStringCodePointAtNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringCodePointAtNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringRepeatNode.class)
    public static final class JSStringRepeatNodeGen
    extends StringPrototypeBuiltins.JSStringRepeatNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @Node.Child
        private JSToNumberNode toNumberNode_;

        private JSStringRepeatNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state_0 != 0) {
                return this.repeat(arguments0Value_, arguments1Value_, this.toNumberNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            try {
                this.toNumberNode_ = super.insert(JSToNumberNode.create());
                this.state_0_ = state_0 |= 1;
                lock.unlock();
                hasLock = false;
                String string = this.repeat(arguments0Value, arguments1Value, this.toNumberNode_);
                return string;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            int state_0 = this.state_0_;
            Object[] s2 = new Object[3];
            s2[0] = "repeat";
            if (state_0 != 0) {
                s2[1] = (byte)1;
                ArrayList<List<JSToNumberNode>> cached = new ArrayList<List<JSToNumberNode>>();
                cached.add(Arrays.asList(this.toNumberNode_));
                s2[2] = cached;
            } else {
                s2[1] = (byte)0;
            }
            data[1] = s2;
            return Introspection.Provider.create(data);
        }

        public static StringPrototypeBuiltins.JSStringRepeatNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringRepeatNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringIncludesNode.class)
    public static final class JSStringIncludesNodeGen
    extends StringPrototypeBuiltins.JSStringIncludesNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @Node.Child
        private JSToStringNode includesGeneric_toString2Node_;
        @Node.Child
        private IsRegExpNode includesGeneric_isRegExpNode_;

        private JSStringIncludesNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if ((state_0 & 3) != 0) {
                if ((state_0 & 1) != 0 && JSTypesGen.isImplicitString((state_0 & 0x1C) >>> 2, arguments0Value_)) {
                    String arguments0Value__ = JSTypesGen.asImplicitString((state_0 & 0x1C) >>> 2, arguments0Value_);
                    if (JSTypesGen.isImplicitString((state_0 & 0xE0) >>> 5, arguments1Value_)) {
                        String arguments1Value__ = JSTypesGen.asImplicitString((state_0 & 0xE0) >>> 5, arguments1Value_);
                        if (JSGuards.isUndefined(arguments2Value_)) {
                            return this.includesString(arguments0Value__, arguments1Value__, arguments2Value_);
                        }
                    }
                }
                if ((state_0 & 2) != 0) {
                    return this.includesGeneric(arguments0Value_, arguments1Value_, arguments2Value_, this.includesGeneric_toString2Node_, this.includesGeneric_isRegExpNode_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if ((state_0 & 3) != 0) {
                if ((state_0 & 1) != 0 && JSTypesGen.isImplicitString((state_0 & 0x1C) >>> 2, arguments0Value_)) {
                    String arguments0Value__ = JSTypesGen.asImplicitString((state_0 & 0x1C) >>> 2, arguments0Value_);
                    if (JSTypesGen.isImplicitString((state_0 & 0xE0) >>> 5, arguments1Value_)) {
                        String arguments1Value__ = JSTypesGen.asImplicitString((state_0 & 0xE0) >>> 5, arguments1Value_);
                        if (JSGuards.isUndefined(arguments2Value_)) {
                            return this.includesString(arguments0Value__, arguments1Value__, arguments2Value_);
                        }
                    }
                }
                if ((state_0 & 2) != 0) {
                    return this.includesGeneric(arguments0Value_, arguments1Value_, arguments2Value_, this.includesGeneric_toString2Node_, this.includesGeneric_isRegExpNode_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.executeBoolean(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            try {
                int stringCast0 = JSTypesGen.specializeImplicitString(arguments0Value);
                if (stringCast0 != 0) {
                    String arguments0Value_ = JSTypesGen.asImplicitString(stringCast0, arguments0Value);
                    int stringCast1 = JSTypesGen.specializeImplicitString(arguments1Value);
                    if (stringCast1 != 0) {
                        String arguments1Value_ = JSTypesGen.asImplicitString(stringCast1, arguments1Value);
                        if (JSGuards.isUndefined(arguments2Value)) {
                            state_0 |= stringCast0 << 2;
                            state_0 |= stringCast1 << 5;
                            this.state_0_ = state_0 |= 1;
                            lock.unlock();
                            hasLock = false;
                            boolean bl = this.includesString(arguments0Value_, arguments1Value_, arguments2Value);
                            return bl;
                        }
                    }
                }
                this.includesGeneric_toString2Node_ = super.insert(JSToStringNode.create());
                this.includesGeneric_isRegExpNode_ = super.insert(IsRegExpNode.create(this.getContext()));
                this.state_0_ = state_0 |= 2;
                lock.unlock();
                hasLock = false;
                boolean bl = this.includesGeneric(arguments0Value, arguments1Value, arguments2Value, this.includesGeneric_toString2Node_, this.includesGeneric_isRegExpNode_);
                return bl;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 3) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 3 & (state_0 & 3) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[3];
            data[0] = 0;
            int state_0 = this.state_0_;
            Object[] s2 = new Object[3];
            s2[0] = "includesString";
            s2[1] = (state_0 & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s2;
            s2 = new Object[3];
            s2[0] = "includesGeneric";
            if ((state_0 & 2) != 0) {
                s2[1] = (byte)1;
                ArrayList<List<JavaScriptBaseNode>> cached = new ArrayList<List<JavaScriptBaseNode>>();
                cached.add(Arrays.asList(this.includesGeneric_toString2Node_, this.includesGeneric_isRegExpNode_));
                s2[2] = cached;
            } else {
                s2[1] = (byte)0;
            }
            data[2] = s2;
            return Introspection.Provider.create(data);
        }

        public static StringPrototypeBuiltins.JSStringIncludesNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringIncludesNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringEndsWithNode.class)
    public static final class JSStringEndsWithNodeGen
    extends StringPrototypeBuiltins.JSStringEndsWithNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @Node.Child
        private JSToStringNode endsWithGeneric_toString2Node_;
        @Node.Child
        private IsRegExpNode endsWithGeneric_isRegExpNode_;

        private JSStringEndsWithNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if ((state_0 & 3) != 0) {
                if ((state_0 & 1) != 0 && JSTypesGen.isImplicitString((state_0 & 0x1C) >>> 2, arguments0Value_)) {
                    String arguments0Value__ = JSTypesGen.asImplicitString((state_0 & 0x1C) >>> 2, arguments0Value_);
                    if (JSTypesGen.isImplicitString((state_0 & 0xE0) >>> 5, arguments1Value_)) {
                        String arguments1Value__ = JSTypesGen.asImplicitString((state_0 & 0xE0) >>> 5, arguments1Value_);
                        if (JSGuards.isUndefined(arguments2Value_)) {
                            return this.endsWithStringUndefined(arguments0Value__, arguments1Value__, arguments2Value_);
                        }
                    }
                }
                if ((state_0 & 2) != 0) {
                    return this.endsWithGeneric(arguments0Value_, arguments1Value_, arguments2Value_, this.endsWithGeneric_toString2Node_, this.endsWithGeneric_isRegExpNode_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if ((state_0 & 3) != 0) {
                if ((state_0 & 1) != 0 && JSTypesGen.isImplicitString((state_0 & 0x1C) >>> 2, arguments0Value_)) {
                    String arguments0Value__ = JSTypesGen.asImplicitString((state_0 & 0x1C) >>> 2, arguments0Value_);
                    if (JSTypesGen.isImplicitString((state_0 & 0xE0) >>> 5, arguments1Value_)) {
                        String arguments1Value__ = JSTypesGen.asImplicitString((state_0 & 0xE0) >>> 5, arguments1Value_);
                        if (JSGuards.isUndefined(arguments2Value_)) {
                            return this.endsWithStringUndefined(arguments0Value__, arguments1Value__, arguments2Value_);
                        }
                    }
                }
                if ((state_0 & 2) != 0) {
                    return this.endsWithGeneric(arguments0Value_, arguments1Value_, arguments2Value_, this.endsWithGeneric_toString2Node_, this.endsWithGeneric_isRegExpNode_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.executeBoolean(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            try {
                int stringCast0 = JSTypesGen.specializeImplicitString(arguments0Value);
                if (stringCast0 != 0) {
                    String arguments0Value_ = JSTypesGen.asImplicitString(stringCast0, arguments0Value);
                    int stringCast1 = JSTypesGen.specializeImplicitString(arguments1Value);
                    if (stringCast1 != 0) {
                        String arguments1Value_ = JSTypesGen.asImplicitString(stringCast1, arguments1Value);
                        if (JSGuards.isUndefined(arguments2Value)) {
                            state_0 |= stringCast0 << 2;
                            state_0 |= stringCast1 << 5;
                            this.state_0_ = state_0 |= 1;
                            lock.unlock();
                            hasLock = false;
                            boolean bl = this.endsWithStringUndefined(arguments0Value_, arguments1Value_, arguments2Value);
                            return bl;
                        }
                    }
                }
                this.endsWithGeneric_toString2Node_ = super.insert(JSToStringNode.create());
                this.endsWithGeneric_isRegExpNode_ = super.insert(IsRegExpNode.create(this.getContext()));
                this.state_0_ = state_0 |= 2;
                lock.unlock();
                hasLock = false;
                boolean bl = this.endsWithGeneric(arguments0Value, arguments1Value, arguments2Value, this.endsWithGeneric_toString2Node_, this.endsWithGeneric_isRegExpNode_);
                return bl;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 3) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 3 & (state_0 & 3) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[3];
            data[0] = 0;
            int state_0 = this.state_0_;
            Object[] s2 = new Object[3];
            s2[0] = "endsWithStringUndefined";
            s2[1] = (state_0 & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s2;
            s2 = new Object[3];
            s2[0] = "endsWithGeneric";
            if ((state_0 & 2) != 0) {
                s2[1] = (byte)1;
                ArrayList<List<JavaScriptBaseNode>> cached = new ArrayList<List<JavaScriptBaseNode>>();
                cached.add(Arrays.asList(this.endsWithGeneric_toString2Node_, this.endsWithGeneric_isRegExpNode_));
                s2[2] = cached;
            } else {
                s2[1] = (byte)0;
            }
            data[2] = s2;
            return Introspection.Provider.create(data);
        }

        public static StringPrototypeBuiltins.JSStringEndsWithNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringEndsWithNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringStartsWithNode.class)
    public static final class JSStringStartsWithNodeGen
    extends StringPrototypeBuiltins.JSStringStartsWithNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @Node.Child
        private JSToStringNode startsWithGeneric_toString2Node_;
        @Node.Child
        private IsRegExpNode startsWithGeneric_isRegExpNode_;

        private JSStringStartsWithNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if ((state_0 & 1) != 0 && JSTypesGen.isImplicitString((state_0 & 0x1C) >>> 2, arguments0Value_)) {
                String arguments0Value__ = JSTypesGen.asImplicitString((state_0 & 0x1C) >>> 2, arguments0Value_);
                if (JSTypesGen.isImplicitString((state_0 & 0xE0) >>> 5, arguments1Value_)) {
                    DynamicObject arguments2Value__;
                    String arguments1Value__ = JSTypesGen.asImplicitString((state_0 & 0xE0) >>> 5, arguments1Value_);
                    if (JSTypes.isDynamicObject(arguments2Value_) && JSGuards.isUndefined(arguments2Value__ = (DynamicObject)arguments2Value_)) {
                        return this.startsWithString(arguments0Value__, arguments1Value__, arguments2Value__);
                    }
                }
            }
            if ((state_0 & 2) != 0) {
                return this.startsWithGeneric(arguments0Value_, arguments1Value_, arguments2Value_, this.startsWithGeneric_toString2Node_, this.startsWithGeneric_isRegExpNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if ((state_0 & 1) != 0 && JSTypesGen.isImplicitString((state_0 & 0x1C) >>> 2, arguments0Value_)) {
                String arguments0Value__ = JSTypesGen.asImplicitString((state_0 & 0x1C) >>> 2, arguments0Value_);
                if (JSTypesGen.isImplicitString((state_0 & 0xE0) >>> 5, arguments1Value_)) {
                    DynamicObject arguments2Value__;
                    String arguments1Value__ = JSTypesGen.asImplicitString((state_0 & 0xE0) >>> 5, arguments1Value_);
                    if (JSTypes.isDynamicObject(arguments2Value_) && JSGuards.isUndefined(arguments2Value__ = (DynamicObject)arguments2Value_)) {
                        return this.startsWithString(arguments0Value__, arguments1Value__, arguments2Value__);
                    }
                }
            }
            if ((state_0 & 2) != 0) {
                return this.startsWithGeneric(arguments0Value_, arguments1Value_, arguments2Value_, this.startsWithGeneric_toString2Node_, this.startsWithGeneric_isRegExpNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.executeBoolean(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            try {
                int stringCast0 = JSTypesGen.specializeImplicitString(arguments0Value);
                if (stringCast0 != 0) {
                    String arguments0Value_ = JSTypesGen.asImplicitString(stringCast0, arguments0Value);
                    int stringCast1 = JSTypesGen.specializeImplicitString(arguments1Value);
                    if (stringCast1 != 0) {
                        DynamicObject arguments2Value_;
                        String arguments1Value_ = JSTypesGen.asImplicitString(stringCast1, arguments1Value);
                        if (JSTypes.isDynamicObject(arguments2Value) && JSGuards.isUndefined(arguments2Value_ = (DynamicObject)arguments2Value)) {
                            state_0 |= stringCast0 << 2;
                            state_0 |= stringCast1 << 5;
                            this.state_0_ = state_0 |= 1;
                            lock.unlock();
                            hasLock = false;
                            boolean bl = this.startsWithString(arguments0Value_, arguments1Value_, arguments2Value_);
                            return bl;
                        }
                    }
                }
                this.startsWithGeneric_toString2Node_ = super.insert(JSToStringNode.create());
                this.startsWithGeneric_isRegExpNode_ = super.insert(IsRegExpNode.create(this.getContext()));
                this.state_0_ = state_0 |= 2;
                lock.unlock();
                hasLock = false;
                boolean bl = this.startsWithGeneric(arguments0Value, arguments1Value, arguments2Value, this.startsWithGeneric_toString2Node_, this.startsWithGeneric_isRegExpNode_);
                return bl;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 3) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 3 & (state_0 & 3) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[3];
            data[0] = 0;
            int state_0 = this.state_0_;
            Object[] s2 = new Object[3];
            s2[0] = "startsWithString";
            s2[1] = (state_0 & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s2;
            s2 = new Object[3];
            s2[0] = "startsWithGeneric";
            if ((state_0 & 2) != 0) {
                s2[1] = (byte)1;
                ArrayList<List<JavaScriptBaseNode>> cached = new ArrayList<List<JavaScriptBaseNode>>();
                cached.add(Arrays.asList(this.startsWithGeneric_toString2Node_, this.startsWithGeneric_isRegExpNode_));
                s2[2] = cached;
            } else {
                s2[1] = (byte)0;
            }
            data[2] = s2;
            return Introspection.Provider.create(data);
        }

        public static StringPrototypeBuiltins.JSStringStartsWithNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringStartsWithNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringSliceNode.class)
    public static final class JSStringSliceNodeGen
    extends StringPrototypeBuiltins.JSStringSliceNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @CompilerDirectives.CompilationFinal
        private ConditionProfile sliceGeneric_isUndefined_;

        private JSStringSliceNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0xC) == 0 && (state_0 & 0xF) != 0) {
                return this.execute_int_int0(state_0, frameValue);
            }
            if ((state_0 & 0xB) == 0 && (state_0 & 0xF) != 0) {
                return this.execute_int1(state_0, frameValue);
            }
            return this.execute_generic2(state_0, frameValue);
        }

        private Object execute_int_int0(int state_0, VirtualFrame frameValue) {
            int arguments2Value_;
            int arguments1Value_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            try {
                arguments1Value_ = this.arguments1_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object arguments2Value = this.arguments2_.execute(frameValue);
                return this.executeAndSpecialize(arguments0Value_, ex.getResult(), arguments2Value);
            }
            try {
                arguments2Value_ = this.arguments2_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(arguments0Value_, arguments1Value_, ex.getResult());
            }
            if ((state_0 & 1) != 0 && JSTypesGen.isImplicitString((state_0 & 0x70) >>> 4, arguments0Value_)) {
                String arguments0Value__ = JSTypesGen.asImplicitString((state_0 & 0x70) >>> 4, arguments0Value_);
                return this.sliceStringIntInt(arguments0Value__, arguments1Value_, arguments2Value_);
            }
            if ((state_0 & 2) != 0) {
                return this.sliceObjectIntInt(arguments0Value_, arguments1Value_, arguments2Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        private Object execute_int1(int state_0, VirtualFrame frameValue) {
            int arguments1Value_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            try {
                arguments1Value_ = this.arguments1_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object arguments2Value = this.arguments2_.execute(frameValue);
                return this.executeAndSpecialize(arguments0Value_, ex.getResult(), arguments2Value);
            }
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            assert ((state_0 & 4) != 0);
            if (JSTypesGen.isImplicitString((state_0 & 0x70) >>> 4, arguments0Value_)) {
                String arguments0Value__ = JSTypesGen.asImplicitString((state_0 & 0x70) >>> 4, arguments0Value_);
                if (JSGuards.isUndefined(arguments2Value_)) {
                    return this.sliceStringIntUndefined(arguments0Value__, arguments1Value_, arguments2Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        private Object execute_generic2(int state_0, VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if ((state_0 & 7) != 0 && arguments1Value_ instanceof Integer) {
                int arguments1Value__ = (Integer)arguments1Value_;
                if ((state_0 & 3) != 0 && arguments2Value_ instanceof Integer) {
                    int arguments2Value__ = (Integer)arguments2Value_;
                    if ((state_0 & 1) != 0 && JSTypesGen.isImplicitString((state_0 & 0x70) >>> 4, arguments0Value_)) {
                        String arguments0Value__ = JSTypesGen.asImplicitString((state_0 & 0x70) >>> 4, arguments0Value_);
                        return this.sliceStringIntInt(arguments0Value__, arguments1Value__, arguments2Value__);
                    }
                    if ((state_0 & 2) != 0) {
                        return this.sliceObjectIntInt(arguments0Value_, arguments1Value__, arguments2Value__);
                    }
                }
                if ((state_0 & 4) != 0 && JSTypesGen.isImplicitString((state_0 & 0x70) >>> 4, arguments0Value_)) {
                    String arguments0Value__ = JSTypesGen.asImplicitString((state_0 & 0x70) >>> 4, arguments0Value_);
                    if (JSGuards.isUndefined(arguments2Value_)) {
                        return this.sliceStringIntUndefined(arguments0Value__, arguments1Value__, arguments2Value_);
                    }
                }
            }
            if ((state_0 & 8) != 0) {
                return this.sliceGeneric(arguments0Value_, arguments1Value_, arguments2Value_, this.sliceGeneric_isUndefined_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            try {
                if (arguments1Value instanceof Integer) {
                    int stringCast0;
                    int arguments1Value_ = (Integer)arguments1Value;
                    if (arguments2Value instanceof Integer) {
                        int stringCast022;
                        int arguments2Value_ = (Integer)arguments2Value;
                        if ((exclude & 1) == 0 && (stringCast022 = JSTypesGen.specializeImplicitString(arguments0Value)) != 0) {
                            String arguments0Value_ = JSTypesGen.asImplicitString(stringCast022, arguments0Value);
                            state_0 |= stringCast022 << 4;
                            this.state_0_ = state_0 |= 1;
                            lock.unlock();
                            hasLock = false;
                            String string = this.sliceStringIntInt(arguments0Value_, arguments1Value_, arguments2Value_);
                            return string;
                        }
                        if ((exclude & 2) == 0) {
                            this.exclude_ = exclude |= 1;
                            state_0 &= 0xFFFFFFFE;
                            this.state_0_ = state_0 |= 2;
                            lock.unlock();
                            hasLock = false;
                            String stringCast022 = this.sliceObjectIntInt(arguments0Value, arguments1Value_, arguments2Value_);
                            return stringCast022;
                        }
                    }
                    if ((exclude & 4) == 0 && (stringCast0 = JSTypesGen.specializeImplicitString(arguments0Value)) != 0) {
                        String arguments0Value_ = JSTypesGen.asImplicitString(stringCast0, arguments0Value);
                        if (JSGuards.isUndefined(arguments2Value)) {
                            state_0 |= stringCast0 << 4;
                            this.state_0_ = state_0 |= 4;
                            lock.unlock();
                            hasLock = false;
                            String string = this.sliceStringIntUndefined(arguments0Value_, arguments1Value_, arguments2Value);
                            return string;
                        }
                    }
                }
                this.sliceGeneric_isUndefined_ = ConditionProfile.createBinaryProfile();
                this.exclude_ = exclude |= 7;
                state_0 &= 0xFFFFFFF8;
                this.state_0_ = state_0 |= 8;
                lock.unlock();
                hasLock = false;
                String string = this.sliceGeneric(arguments0Value, arguments1Value, arguments2Value, this.sliceGeneric_isUndefined_);
                return string;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0xF) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 0xF & (state_0 & 0xF) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[5];
            data[0] = 0;
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            Object[] s2 = new Object[3];
            s2[0] = "sliceStringIntInt";
            s2[1] = (state_0 & 1) != 0 ? Byte.valueOf((byte)1) : ((exclude & 1) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
            data[1] = s2;
            s2 = new Object[3];
            s2[0] = "sliceObjectIntInt";
            s2[1] = (state_0 & 2) != 0 ? Byte.valueOf((byte)1) : ((exclude & 2) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
            data[2] = s2;
            s2 = new Object[3];
            s2[0] = "sliceStringIntUndefined";
            s2[1] = (state_0 & 4) != 0 ? Byte.valueOf((byte)1) : ((exclude & 4) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
            data[3] = s2;
            s2 = new Object[3];
            s2[0] = "sliceGeneric";
            if ((state_0 & 8) != 0) {
                s2[1] = (byte)1;
                ArrayList<List<ConditionProfile>> cached = new ArrayList<List<ConditionProfile>>();
                cached.add(Arrays.asList(this.sliceGeneric_isUndefined_));
                s2[2] = cached;
            } else {
                s2[1] = (byte)0;
            }
            data[4] = s2;
            return Introspection.Provider.create(data);
        }

        public static StringPrototypeBuiltins.JSStringSliceNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringSliceNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringLocaleCompareIntlNode.class)
    public static final class JSStringLocaleCompareIntlNodeGen
    extends StringPrototypeBuiltins.JSStringLocaleCompareIntlNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @Node.Child
        private JavaScriptNode arguments3_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @Node.Child
        private JSToStringNode toString2Node_;

        private JSStringLocaleCompareIntlNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
            this.arguments3_ = arguments != null && 3 < arguments.length ? arguments[3] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_, this.arguments3_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            Object arguments3Value_ = this.arguments3_.execute(frameValue);
            if (state_0 != 0) {
                return this.localeCompare(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_, this.toString2Node_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
        }

        @Override
        public int executeInt(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            Object arguments3Value_ = this.arguments3_.execute(frameValue);
            if (state_0 != 0) {
                return this.localeCompare(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_, this.toString2Node_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.executeInt(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            try {
                this.toString2Node_ = super.insert(JSToStringNode.create());
                this.state_0_ = state_0 |= 1;
                lock.unlock();
                hasLock = false;
                int n = this.localeCompare(arguments0Value, arguments1Value, arguments2Value, arguments3Value, this.toString2Node_);
                return n;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            int state_0 = this.state_0_;
            Object[] s2 = new Object[3];
            s2[0] = "localeCompare";
            if (state_0 != 0) {
                s2[1] = (byte)1;
                ArrayList<List<JSToStringNode>> cached = new ArrayList<List<JSToStringNode>>();
                cached.add(Arrays.asList(this.toString2Node_));
                s2[2] = cached;
            } else {
                s2[1] = (byte)0;
            }
            data[1] = s2;
            return Introspection.Provider.create(data);
        }

        public static StringPrototypeBuiltins.JSStringLocaleCompareIntlNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringLocaleCompareIntlNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringLocaleCompareNode.class)
    public static final class JSStringLocaleCompareNodeGen
    extends StringPrototypeBuiltins.JSStringLocaleCompareNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @Node.Child
        private JSToStringNode toString2Node_;

        private JSStringLocaleCompareNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state_0 != 0) {
                return this.localeCompare(arguments0Value_, arguments1Value_, this.toString2Node_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public int executeInt(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state_0 != 0) {
                return this.localeCompare(arguments0Value_, arguments1Value_, this.toString2Node_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.executeInt(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            try {
                this.toString2Node_ = super.insert(JSToStringNode.create());
                this.state_0_ = state_0 |= 1;
                lock.unlock();
                hasLock = false;
                int n = this.localeCompare(arguments0Value, arguments1Value, this.toString2Node_);
                return n;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            int state_0 = this.state_0_;
            Object[] s2 = new Object[3];
            s2[0] = "localeCompare";
            if (state_0 != 0) {
                s2[1] = (byte)1;
                ArrayList<List<JSToStringNode>> cached = new ArrayList<List<JSToStringNode>>();
                cached.add(Arrays.asList(this.toString2Node_));
                s2[2] = cached;
            } else {
                s2[1] = (byte)0;
            }
            data[1] = s2;
            return Introspection.Provider.create(data);
        }

        public static StringPrototypeBuiltins.JSStringLocaleCompareNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringLocaleCompareNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringTrimRightNode.class)
    public static final class JSStringTrimRightNodeGen
    extends StringPrototypeBuiltins.JSStringTrimRightNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;

        private JSStringTrimRightNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            return this.trimRight(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s2 = new Object[3];
            s2[0] = "trimRight";
            s2[1] = (byte)1;
            data[1] = s2;
            return Introspection.Provider.create(data);
        }

        public static StringPrototypeBuiltins.JSStringTrimRightNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringTrimRightNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringTrimLeftNode.class)
    public static final class JSStringTrimLeftNodeGen
    extends StringPrototypeBuiltins.JSStringTrimLeftNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;

        private JSStringTrimLeftNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            return this.trimLeft(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s2 = new Object[3];
            s2[0] = "trimLeft";
            s2[1] = (byte)1;
            data[1] = s2;
            return Introspection.Provider.create(data);
        }

        public static StringPrototypeBuiltins.JSStringTrimLeftNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringTrimLeftNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringTrimNode.class)
    public static final class JSStringTrimNodeGen
    extends StringPrototypeBuiltins.JSStringTrimNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @Node.Child
        private JSTrimWhitespaceNode trimWhitespace;

        private JSStringTrimNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state_0 & 1) != 0 && JSTypesGen.isImplicitString((state_0 & 0x1C) >>> 2, arguments0Value_)) {
                String arguments0Value__ = JSTypesGen.asImplicitString((state_0 & 0x1C) >>> 2, arguments0Value_);
                return this.trimString(arguments0Value__, this.trimWhitespace);
            }
            if ((state_0 & 2) != 0) {
                return this.trimObject(arguments0Value_, this.trimWhitespace);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String executeAndSpecialize(Object arguments0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            try {
                int stringCast0 = JSTypesGen.specializeImplicitString(arguments0Value);
                if (stringCast0 != 0) {
                    String arguments0Value_ = JSTypesGen.asImplicitString(stringCast0, arguments0Value);
                    if (this.trimWhitespace == null) {
                        this.trimWhitespace = super.insert(JSTrimWhitespaceNode.create());
                    }
                    state_0 |= stringCast0 << 2;
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    String string = this.trimString(arguments0Value_, this.trimWhitespace);
                    return string;
                }
                if (this.trimWhitespace == null) {
                    this.trimWhitespace = super.insert(JSTrimWhitespaceNode.create());
                }
                this.state_0_ = state_0 |= 2;
                lock.unlock();
                hasLock = false;
                String string = this.trimObject(arguments0Value, this.trimWhitespace);
                return string;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 3) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 3 & (state_0 & 3) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            ArrayList<List<JSTrimWhitespaceNode>> cached;
            Object[] data = new Object[3];
            data[0] = 0;
            int state_0 = this.state_0_;
            Object[] s2 = new Object[3];
            s2[0] = "trimString";
            if ((state_0 & 1) != 0) {
                s2[1] = (byte)1;
                cached = new ArrayList<List<JSTrimWhitespaceNode>>();
                cached.add(Arrays.asList(this.trimWhitespace));
                s2[2] = cached;
            } else {
                s2[1] = (byte)0;
            }
            data[1] = s2;
            s2 = new Object[3];
            s2[0] = "trimObject";
            if ((state_0 & 2) != 0) {
                s2[1] = (byte)1;
                cached = new ArrayList();
                cached.add(Arrays.asList(this.trimWhitespace));
                s2[2] = cached;
            } else {
                s2[1] = (byte)0;
            }
            data[2] = s2;
            return Introspection.Provider.create(data);
        }

        public static StringPrototypeBuiltins.JSStringTrimNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringTrimNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringMatchES5Node.class)
    public static final class JSStringMatchES5NodeGen
    extends StringPrototypeBuiltins.JSStringMatchES5Node
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;

        private JSStringMatchES5NodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            return this.matchRegExpNotGlobal(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s2 = new Object[3];
            s2[0] = "matchRegExpNotGlobal";
            s2[1] = (byte)1;
            data[1] = s2;
            return Introspection.Provider.create(data);
        }

        public static StringPrototypeBuiltins.JSStringMatchES5Node create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringMatchES5NodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringMatchNode.class)
    public static final class JSStringMatchNodeGen
    extends StringPrototypeBuiltins.JSStringMatchNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;

        private JSStringMatchNodeGen(JSContext context, JSBuiltin builtin, boolean matchAll, JavaScriptNode[] arguments) {
            super(context, builtin, matchAll);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            return this.match(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s2 = new Object[3];
            s2[0] = "match";
            s2[1] = (byte)1;
            data[1] = s2;
            return Introspection.Provider.create(data);
        }

        public static StringPrototypeBuiltins.JSStringMatchNode create(JSContext context, JSBuiltin builtin, boolean matchAll, JavaScriptNode[] arguments) {
            return new JSStringMatchNodeGen(context, builtin, matchAll, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringSubstrNode.class)
    public static final class JSStringSubstrNodeGen
    extends StringPrototypeBuiltins.JSStringSubstrNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;

        private JSStringSubstrNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 6) == 0 && (state_0 & 7) != 0) {
                return this.execute_int_int0(state_0, frameValue);
            }
            if ((state_0 & 5) == 0 && (state_0 & 7) != 0) {
                return this.execute_int1(state_0, frameValue);
            }
            return this.execute_generic2(state_0, frameValue);
        }

        private Object execute_int_int0(int state_0, VirtualFrame frameValue) {
            int arguments2Value_;
            int arguments1Value_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            try {
                arguments1Value_ = this.arguments1_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object arguments2Value = this.arguments2_.execute(frameValue);
                return this.executeAndSpecialize(arguments0Value_, ex.getResult(), arguments2Value);
            }
            try {
                arguments2Value_ = this.arguments2_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(arguments0Value_, arguments1Value_, ex.getResult());
            }
            assert ((state_0 & 1) != 0);
            if (JSTypesGen.isImplicitString((state_0 & 0x38) >>> 3, arguments0Value_)) {
                String arguments0Value__ = JSTypesGen.asImplicitString((state_0 & 0x38) >>> 3, arguments0Value_);
                return this.substrInt(arguments0Value__, arguments1Value_, arguments2Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        private Object execute_int1(int state_0, VirtualFrame frameValue) {
            int arguments1Value_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            try {
                arguments1Value_ = this.arguments1_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object arguments2Value = this.arguments2_.execute(frameValue);
                return this.executeAndSpecialize(arguments0Value_, ex.getResult(), arguments2Value);
            }
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            assert ((state_0 & 2) != 0);
            if (JSTypesGen.isImplicitString((state_0 & 0x38) >>> 3, arguments0Value_)) {
                String arguments0Value__ = JSTypesGen.asImplicitString((state_0 & 0x38) >>> 3, arguments0Value_);
                if (JSGuards.isUndefined(arguments2Value_)) {
                    return this.substrLenUndef(arguments0Value__, arguments1Value_, arguments2Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        private Object execute_generic2(int state_0, VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if ((state_0 & 3) != 0 && JSTypesGen.isImplicitString((state_0 & 0x38) >>> 3, arguments0Value_)) {
                String arguments0Value__ = JSTypesGen.asImplicitString((state_0 & 0x38) >>> 3, arguments0Value_);
                if (arguments1Value_ instanceof Integer) {
                    int arguments1Value__ = (Integer)arguments1Value_;
                    if ((state_0 & 1) != 0 && arguments2Value_ instanceof Integer) {
                        int arguments2Value__ = (Integer)arguments2Value_;
                        return this.substrInt(arguments0Value__, arguments1Value__, arguments2Value__);
                    }
                    if ((state_0 & 2) != 0 && JSGuards.isUndefined(arguments2Value_)) {
                        return this.substrLenUndef(arguments0Value__, arguments1Value__, arguments2Value_);
                    }
                }
            }
            if ((state_0 & 4) != 0) {
                return this.substrGeneric(arguments0Value_, arguments1Value_, arguments2Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            try {
                int stringCast0 = JSTypesGen.specializeImplicitString(arguments0Value);
                if (stringCast0 != 0) {
                    String arguments0Value_ = JSTypesGen.asImplicitString(stringCast0, arguments0Value);
                    if (arguments1Value instanceof Integer) {
                        int arguments1Value_ = (Integer)arguments1Value;
                        if ((exclude & 1) == 0 && arguments2Value instanceof Integer) {
                            int arguments2Value_ = (Integer)arguments2Value;
                            state_0 |= stringCast0 << 3;
                            this.state_0_ = state_0 |= 1;
                            lock.unlock();
                            hasLock = false;
                            String string = this.substrInt(arguments0Value_, arguments1Value_, arguments2Value_);
                            return string;
                        }
                        if ((exclude & 2) == 0 && JSGuards.isUndefined(arguments2Value)) {
                            state_0 |= stringCast0 << 3;
                            this.state_0_ = state_0 |= 2;
                            lock.unlock();
                            hasLock = false;
                            String string = this.substrLenUndef(arguments0Value_, arguments1Value_, arguments2Value);
                            return string;
                        }
                    }
                }
                this.exclude_ = exclude |= 3;
                state_0 &= 0xFFFFFFFC;
                this.state_0_ = state_0 |= 4;
                lock.unlock();
                hasLock = false;
                String string = this.substrGeneric(arguments0Value, arguments1Value, arguments2Value);
                return string;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 7) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 7 & (state_0 & 7) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[4];
            data[0] = 0;
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            Object[] s2 = new Object[3];
            s2[0] = "substrInt";
            s2[1] = (state_0 & 1) != 0 ? Byte.valueOf((byte)1) : ((exclude & 1) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
            data[1] = s2;
            s2 = new Object[3];
            s2[0] = "substrLenUndef";
            s2[1] = (state_0 & 2) != 0 ? Byte.valueOf((byte)1) : ((exclude & 2) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
            data[2] = s2;
            s2 = new Object[3];
            s2[0] = "substrGeneric";
            s2[1] = (state_0 & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s2;
            return Introspection.Provider.create(data);
        }

        public static StringPrototypeBuiltins.JSStringSubstrNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringSubstrNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringSearchES5Node.class)
    public static final class JSStringSearchES5NodeGen
    extends StringPrototypeBuiltins.JSStringSearchES5Node
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @Node.Child
        private JSToRegExpNode toRegExpNode_;

        private JSStringSearchES5NodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state_0 != 0 && arguments1Value_ instanceof Object[]) {
                Object[] arguments1Value__ = (Object[])arguments1Value_;
                return this.search(arguments0Value_, arguments1Value__, this.toRegExpNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public int executeInt(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state_0 != 0 && arguments1Value_ instanceof Object[]) {
                Object[] arguments1Value__ = (Object[])arguments1Value_;
                return this.search(arguments0Value_, arguments1Value__, this.toRegExpNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.executeInt(frameValue);
        }

        private int executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            try {
                if (arguments1Value instanceof Object[]) {
                    Object[] arguments1Value_ = (Object[])arguments1Value;
                    this.toRegExpNode_ = super.insert(JSToRegExpNode.create(this.getContext()));
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    int n = this.search(arguments0Value, arguments1Value_, this.toRegExpNode_);
                    return n;
                }
                throw new UnsupportedSpecializationException(this, new Node[]{this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            int state_0 = this.state_0_;
            Object[] s2 = new Object[3];
            s2[0] = "search";
            if (state_0 != 0) {
                s2[1] = (byte)1;
                ArrayList<List<JSToRegExpNode>> cached = new ArrayList<List<JSToRegExpNode>>();
                cached.add(Arrays.asList(this.toRegExpNode_));
                s2[2] = cached;
            } else {
                s2[1] = (byte)0;
            }
            data[1] = s2;
            return Introspection.Provider.create(data);
        }

        public static StringPrototypeBuiltins.JSStringSearchES5Node create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringSearchES5NodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringSearchNode.class)
    public static final class JSStringSearchNodeGen
    extends StringPrototypeBuiltins.JSStringSearchNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;

        private JSStringSearchNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            return this.search(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s2 = new Object[3];
            s2[0] = "search";
            s2[1] = (byte)1;
            data[1] = s2;
            return Introspection.Provider.create(data);
        }

        public static StringPrototypeBuiltins.JSStringSearchNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringSearchNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringToUpperCaseNode.class)
    public static final class JSStringToUpperCaseNodeGen
    extends StringPrototypeBuiltins.JSStringToUpperCaseNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;

        private JSStringToUpperCaseNodeGen(JSContext context, JSBuiltin builtin, boolean locale, JavaScriptNode[] arguments) {
            super(context, builtin, locale);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state_0 & 1) != 0 && JSTypesGen.isImplicitString((state_0 & 0x1C) >>> 2, arguments0Value_)) {
                String arguments0Value__ = JSTypesGen.asImplicitString((state_0 & 0x1C) >>> 2, arguments0Value_);
                return this.toUpperCaseString(arguments0Value__);
            }
            if ((state_0 & 2) != 0) {
                return this.toUpperCaseGeneric(arguments0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String executeAndSpecialize(Object arguments0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            try {
                int stringCast0;
                if (exclude == 0 && (stringCast0 = JSTypesGen.specializeImplicitString(arguments0Value)) != 0) {
                    String arguments0Value_ = JSTypesGen.asImplicitString(stringCast0, arguments0Value);
                    state_0 |= stringCast0 << 2;
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    String string = this.toUpperCaseString(arguments0Value_);
                    return string;
                }
                this.exclude_ = exclude |= 1;
                state_0 &= 0xFFFFFFFE;
                this.state_0_ = state_0 |= 2;
                lock.unlock();
                hasLock = false;
                String string = this.toUpperCaseGeneric(arguments0Value);
                return string;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 3) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 3 & (state_0 & 3) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[3];
            data[0] = 0;
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            Object[] s2 = new Object[3];
            s2[0] = "toUpperCaseString";
            s2[1] = (state_0 & 1) != 0 ? Byte.valueOf((byte)1) : (exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
            data[1] = s2;
            s2 = new Object[3];
            s2[0] = "toUpperCaseGeneric";
            s2[1] = (state_0 & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s2;
            return Introspection.Provider.create(data);
        }

        public static StringPrototypeBuiltins.JSStringToUpperCaseNode create(JSContext context, JSBuiltin builtin, boolean locale, JavaScriptNode[] arguments) {
            return new JSStringToUpperCaseNodeGen(context, builtin, locale, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringToLocaleUpperCaseIntlNode.class)
    public static final class JSStringToLocaleUpperCaseIntlNodeGen
    extends StringPrototypeBuiltins.JSStringToLocaleUpperCaseIntlNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;

        private JSStringToLocaleUpperCaseIntlNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            return this.toDesiredCase(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s2 = new Object[3];
            s2[0] = "toDesiredCase";
            s2[1] = (byte)1;
            data[1] = s2;
            return Introspection.Provider.create(data);
        }

        public static StringPrototypeBuiltins.JSStringToLocaleUpperCaseIntlNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringToLocaleUpperCaseIntlNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringToLocaleLowerCaseIntlNode.class)
    public static final class JSStringToLocaleLowerCaseIntlNodeGen
    extends StringPrototypeBuiltins.JSStringToLocaleLowerCaseIntlNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;

        private JSStringToLocaleLowerCaseIntlNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            return this.toDesiredCase(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s2 = new Object[3];
            s2[0] = "toDesiredCase";
            s2[1] = (byte)1;
            data[1] = s2;
            return Introspection.Provider.create(data);
        }

        public static StringPrototypeBuiltins.JSStringToLocaleLowerCaseIntlNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringToLocaleLowerCaseIntlNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringToLocaleXCaseIntl.class)
    public static final class JSStringToLocaleXCaseIntlNodeGen
    extends StringPrototypeBuiltins.JSStringToLocaleXCaseIntl
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;

        private JSStringToLocaleXCaseIntlNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            return this.toDesiredCase(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s2 = new Object[3];
            s2[0] = "toDesiredCase";
            s2[1] = (byte)1;
            data[1] = s2;
            return Introspection.Provider.create(data);
        }

        public static StringPrototypeBuiltins.JSStringToLocaleXCaseIntl create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringToLocaleXCaseIntlNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringToLowerCaseNode.class)
    public static final class JSStringToLowerCaseNodeGen
    extends StringPrototypeBuiltins.JSStringToLowerCaseNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;

        private JSStringToLowerCaseNodeGen(JSContext context, JSBuiltin builtin, boolean locale, JavaScriptNode[] arguments) {
            super(context, builtin, locale);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state_0 & 1) != 0 && JSTypesGen.isImplicitString((state_0 & 0x1C) >>> 2, arguments0Value_)) {
                String arguments0Value__ = JSTypesGen.asImplicitString((state_0 & 0x1C) >>> 2, arguments0Value_);
                return this.toLowerCaseString(arguments0Value__);
            }
            if ((state_0 & 2) != 0) {
                return this.toLowerCase(arguments0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String executeAndSpecialize(Object arguments0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            try {
                int stringCast0;
                if (exclude == 0 && (stringCast0 = JSTypesGen.specializeImplicitString(arguments0Value)) != 0) {
                    String arguments0Value_ = JSTypesGen.asImplicitString(stringCast0, arguments0Value);
                    state_0 |= stringCast0 << 2;
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    String string = this.toLowerCaseString(arguments0Value_);
                    return string;
                }
                this.exclude_ = exclude |= 1;
                state_0 &= 0xFFFFFFFE;
                this.state_0_ = state_0 |= 2;
                lock.unlock();
                hasLock = false;
                String string = this.toLowerCase(arguments0Value);
                return string;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 3) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 3 & (state_0 & 3) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[3];
            data[0] = 0;
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            Object[] s2 = new Object[3];
            s2[0] = "toLowerCaseString";
            s2[1] = (state_0 & 1) != 0 ? Byte.valueOf((byte)1) : (exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
            data[1] = s2;
            s2 = new Object[3];
            s2[0] = "toLowerCase";
            s2[1] = (state_0 & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s2;
            return Introspection.Provider.create(data);
        }

        public static StringPrototypeBuiltins.JSStringToLowerCaseNode create(JSContext context, JSBuiltin builtin, boolean locale, JavaScriptNode[] arguments) {
            return new JSStringToLowerCaseNodeGen(context, builtin, locale, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringToStringNode.class)
    public static final class JSStringToStringNodeGen
    extends StringPrototypeBuiltins.JSStringToStringNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @Node.Child
        private StringPrototypeBuiltins.JSStringToStringNode toStringString_nestedToString_;
        @Node.Child
        private ToStringForeignObject0Data toStringForeignObject0_cache;

        private JSStringToStringNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        @ExplodeLoop
        protected String executeString(Object arguments0Value) {
            Object arguments0Value_;
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0 && JSTypes.isDynamicObject(arguments0Value) && JSGuards.isJSString(arguments0Value_ = (DynamicObject)arguments0Value)) {
                return this.toStringString((DynamicObject)arguments0Value_, this.toStringString_nestedToString_);
            }
            if ((state_0 & 2) != 0 && JSTypesGen.isImplicitCharSequence((state_0 & 0xE0) >>> 5, arguments0Value)) {
                arguments0Value_ = JSTypesGen.asImplicitCharSequence((state_0 & 0xE0) >>> 5, arguments0Value);
                return this.toStringCharseq((CharSequence)arguments0Value_);
            }
            if ((state_0 & 0x1C) != 0) {
                if ((state_0 & 4) != 0) {
                    ToStringForeignObject0Data s3_ = this.toStringForeignObject0_cache;
                    while (s3_ != null) {
                        if (s3_.interop_.accepts(arguments0Value) && JSGuards.isForeignObject(arguments0Value)) {
                            return this.toStringForeignObject(arguments0Value, s3_.interop_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state_0 & 8) != 0 && JSGuards.isForeignObject(arguments0Value)) {
                    return this.toStringForeignObject1Boundary(state_0, arguments0Value);
                }
                if ((state_0 & 0x10) != 0 && JSStringToStringNodeGen.fallbackGuard_(state_0, arguments0Value)) {
                    return this.toStringOther(arguments0Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private String toStringForeignObject1Boundary(int state_0, Object arguments0Value) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                InteropLibrary toStringForeignObject1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arguments0Value);
                String string = this.toStringForeignObject(arguments0Value, toStringForeignObject1_interop__);
                return string;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        @ExplodeLoop
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value__;
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state_0 & 1) != 0 && JSTypes.isDynamicObject(arguments0Value_) && JSGuards.isJSString(arguments0Value__ = (DynamicObject)arguments0Value_)) {
                return this.toStringString((DynamicObject)arguments0Value__, this.toStringString_nestedToString_);
            }
            if ((state_0 & 2) != 0 && JSTypesGen.isImplicitCharSequence((state_0 & 0xE0) >>> 5, arguments0Value_)) {
                arguments0Value__ = JSTypesGen.asImplicitCharSequence((state_0 & 0xE0) >>> 5, arguments0Value_);
                return this.toStringCharseq((CharSequence)arguments0Value__);
            }
            if ((state_0 & 0x1C) != 0) {
                if ((state_0 & 4) != 0) {
                    ToStringForeignObject0Data s3_ = this.toStringForeignObject0_cache;
                    while (s3_ != null) {
                        if (s3_.interop_.accepts(arguments0Value_) && JSGuards.isForeignObject(arguments0Value_)) {
                            return this.toStringForeignObject(arguments0Value_, s3_.interop_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state_0 & 8) != 0 && JSGuards.isForeignObject(arguments0Value_)) {
                    return this.toStringForeignObject1Boundary0(state_0, arguments0Value_);
                }
                if ((state_0 & 0x10) != 0 && JSStringToStringNodeGen.fallbackGuard_(state_0, arguments0Value_)) {
                    return this.toStringOther(arguments0Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        private Object toStringForeignObject1Boundary0(int state_0, Object arguments0Value_) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                InteropLibrary toStringForeignObject1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arguments0Value_);
                String string = this.toStringForeignObject(arguments0Value_, toStringForeignObject1_interop__);
                return string;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String executeAndSpecialize(Object arguments0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            try {
                DynamicObject arguments0Value_;
                if (JSTypes.isDynamicObject(arguments0Value) && JSGuards.isJSString(arguments0Value_ = (DynamicObject)arguments0Value)) {
                    this.toStringString_nestedToString_ = super.insert(StringPrototypeBuiltins.JSStringToStringNode.createStringToString(this.getContext()));
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    String string = this.toStringString(arguments0Value_, this.toStringString_nestedToString_);
                    return string;
                }
                int charSequenceCast0 = JSTypesGen.specializeImplicitCharSequence(arguments0Value);
                if (charSequenceCast0 != 0) {
                    CharSequence arguments0Value_2 = JSTypesGen.asImplicitCharSequence(charSequenceCast0, arguments0Value);
                    state_0 |= charSequenceCast0 << 5;
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    String string = this.toStringCharseq(arguments0Value_2);
                    return string;
                }
                if (exclude == 0) {
                    int count3_ = 0;
                    ToStringForeignObject0Data s3_ = this.toStringForeignObject0_cache;
                    if ((state_0 & 4) != 0) {
                        while (!(s3_ == null || s3_.interop_.accepts(arguments0Value) && JSGuards.isForeignObject(arguments0Value))) {
                            s3_ = s3_.next_;
                            ++count3_;
                        }
                    }
                    if (s3_ == null && JSGuards.isForeignObject(arguments0Value) && count3_ < 5) {
                        s3_ = super.insert(new ToStringForeignObject0Data(this.toStringForeignObject0_cache));
                        s3_.interop_ = (InteropLibrary)s3_.insertAccessor(INTEROP_LIBRARY_.create(arguments0Value));
                        this.toStringForeignObject0_cache = s3_;
                        this.state_0_ = state_0 |= 4;
                    }
                    if (s3_ != null) {
                        lock.unlock();
                        hasLock = false;
                        String string = this.toStringForeignObject(arguments0Value, s3_.interop_);
                        return string;
                    }
                }
                InteropLibrary toStringForeignObject1_interop__ = null;
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set(this);
                try {
                    if (JSGuards.isForeignObject(arguments0Value)) {
                        toStringForeignObject1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arguments0Value);
                        this.exclude_ = exclude |= 1;
                        this.toStringForeignObject0_cache = null;
                        state_0 &= 0xFFFFFFFB;
                        this.state_0_ = state_0 |= 8;
                        lock.unlock();
                        hasLock = false;
                        String string = this.toStringForeignObject(arguments0Value, toStringForeignObject1_interop__);
                        return string;
                    }
                }
                finally {
                    encapsulating_.set(prev_);
                }
                this.state_0_ = state_0 |= 0x10;
                lock.unlock();
                hasLock = false;
                String string = this.toStringOther(arguments0Value);
                return string;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            ToStringForeignObject0Data s3_;
            int state_0 = this.state_0_;
            if ((state_0 & 0x1F) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 0x1F & (state_0 & 0x1F) - 1) == 0 && ((s3_ = this.toStringForeignObject0_cache) == null || s3_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            ArrayList<List<Object>> cached;
            Object[] data = new Object[6];
            data[0] = 0;
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            Object[] s2 = new Object[3];
            s2[0] = "toStringString";
            if ((state_0 & 1) != 0) {
                s2[1] = (byte)1;
                cached = new ArrayList<List<Object>>();
                cached.add(Arrays.asList(this.toStringString_nestedToString_));
                s2[2] = cached;
            } else {
                s2[1] = (byte)0;
            }
            data[1] = s2;
            s2 = new Object[3];
            s2[0] = "toStringCharseq";
            s2[1] = (state_0 & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s2;
            s2 = new Object[3];
            s2[0] = "toStringForeignObject";
            if ((state_0 & 4) != 0) {
                s2[1] = (byte)1;
                cached = new ArrayList();
                ToStringForeignObject0Data s3_ = this.toStringForeignObject0_cache;
                while (s3_ != null) {
                    cached.add(Arrays.asList(s3_.interop_));
                    s3_ = s3_.next_;
                }
                s2[2] = cached;
            } else {
                s2[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
            }
            data[3] = s2;
            s2 = new Object[3];
            s2[0] = "toStringForeignObject";
            if ((state_0 & 8) != 0) {
                s2[1] = (byte)1;
                cached = new ArrayList();
                cached.add(Arrays.asList(new Object[0]));
                s2[2] = cached;
            } else {
                s2[1] = (byte)0;
            }
            data[4] = s2;
            s2 = new Object[3];
            s2[0] = "toStringOther";
            s2[1] = (state_0 & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[5] = s2;
            return Introspection.Provider.create(data);
        }

        private static boolean fallbackGuard_(int state_0, Object arguments0Value) {
            DynamicObject arguments0Value_;
            if (JSTypes.isDynamicObject(arguments0Value) && JSGuards.isJSString(arguments0Value_ = (DynamicObject)arguments0Value)) {
                return false;
            }
            if (JSTypesGen.isImplicitCharSequence(arguments0Value)) {
                return false;
            }
            return (state_0 & 8) != 0 || !JSGuards.isForeignObject(arguments0Value);
        }

        public static StringPrototypeBuiltins.JSStringToStringNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringToStringNodeGen(context, builtin, arguments);
        }

        @GeneratedBy(value=StringPrototypeBuiltins.JSStringToStringNode.class)
        private static final class ToStringForeignObject0Data
        extends Node {
            @Node.Child
            ToStringForeignObject0Data next_;
            @Node.Child
            InteropLibrary interop_;

            ToStringForeignObject0Data(ToStringForeignObject0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringReplaceES5Node.class)
    public static final class JSStringReplaceES5NodeGen
    extends StringPrototypeBuiltins.JSStringReplaceES5Node
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;

        private JSStringReplaceES5NodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            return this.replace(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s2 = new Object[3];
            s2[0] = "replace";
            s2[1] = (byte)1;
            data[1] = s2;
            return Introspection.Provider.create(data);
        }

        public static StringPrototypeBuiltins.JSStringReplaceES5Node create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringReplaceES5NodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringReplaceAllNode.class)
    public static final class JSStringReplaceAllNodeGen
    extends StringPrototypeBuiltins.JSStringReplaceAllNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @CompilerDirectives.CompilationFinal
        private ReplaceStringCachedData replaceStringCached_cache;

        private JSStringReplaceAllNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        @ExplodeLoop
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if ((state_0 & 7) != 0) {
                if ((state_0 & 3) != 0 && JSTypesGen.isImplicitString((state_0 & 0x38) >>> 3, arguments1Value_)) {
                    String arguments1Value__ = JSTypesGen.asImplicitString((state_0 & 0x38) >>> 3, arguments1Value_);
                    if (JSTypesGen.isImplicitString((state_0 & 0x1C0) >>> 6, arguments2Value_)) {
                        String arguments2Value__ = JSTypesGen.asImplicitString((state_0 & 0x1C0) >>> 6, arguments2Value_);
                        if ((state_0 & 1) != 0) {
                            ReplaceStringCachedData s1_ = this.replaceStringCached_cache;
                            while (s1_ != null) {
                                if (s1_.cachedReplaceValue_.equals(arguments2Value__)) {
                                    return this.replaceStringCached(arguments0Value_, arguments1Value__, arguments2Value__, s1_.cachedReplaceValue_, s1_.cachedParsedReplaceValue_);
                                }
                                s1_ = s1_.next_;
                            }
                        }
                        if ((state_0 & 2) != 0) {
                            return this.replaceString(arguments0Value_, arguments1Value__, arguments2Value__);
                        }
                    }
                }
                if ((state_0 & 4) != 0) {
                    return this.replaceGeneric(arguments0Value_, arguments1Value_, arguments2Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            try {
                int stringCast1 = JSTypesGen.specializeImplicitString(arguments1Value);
                if (stringCast1 != 0) {
                    String arguments1Value_ = JSTypesGen.asImplicitString(stringCast1, arguments1Value);
                    int stringCast2 = JSTypesGen.specializeImplicitString(arguments2Value);
                    if (stringCast2 != 0) {
                        String arguments2Value_ = JSTypesGen.asImplicitString(stringCast2, arguments2Value);
                        if ((exclude & 1) == 0) {
                            int count1_ = 0;
                            ReplaceStringCachedData s1_ = this.replaceStringCached_cache;
                            if ((state_0 & 1) != 0) {
                                while (s1_ != null && !s1_.cachedReplaceValue_.equals(arguments2Value_)) {
                                    s1_ = s1_.next_;
                                    ++count1_;
                                }
                            }
                            if (s1_ == null) {
                                if (count1_ < 3) {
                                    s1_ = new ReplaceStringCachedData(this.replaceStringCached_cache);
                                    s1_.cachedReplaceValue_ = arguments2Value_;
                                    s1_.cachedParsedReplaceValue_ = StringPrototypeBuiltins.JSStringReplaceBaseNode.parseReplaceValue(arguments2Value_);
                                    this.replaceStringCached_cache = s1_;
                                    state_0 |= stringCast1 << 3;
                                    state_0 |= stringCast2 << 6;
                                    this.state_0_ = state_0 |= 1;
                                }
                            } else {
                                state_0 |= stringCast1 << 3;
                                state_0 |= stringCast2 << 6;
                                this.state_0_ = state_0 |= 1;
                            }
                            if (s1_ != null) {
                                lock.unlock();
                                hasLock = false;
                                Object object = this.replaceStringCached(arguments0Value, arguments1Value_, arguments2Value_, s1_.cachedReplaceValue_, s1_.cachedParsedReplaceValue_);
                                return object;
                            }
                        }
                        if ((exclude & 2) == 0) {
                            this.exclude_ = exclude |= 1;
                            this.replaceStringCached_cache = null;
                            state_0 &= 0xFFFFFFFE;
                            state_0 |= stringCast1 << 3;
                            state_0 |= stringCast2 << 6;
                            this.state_0_ = state_0 |= 2;
                            lock.unlock();
                            hasLock = false;
                            Object object = this.replaceString(arguments0Value, arguments1Value_, arguments2Value_);
                            return object;
                        }
                    }
                }
                this.exclude_ = exclude |= 3;
                this.replaceStringCached_cache = null;
                state_0 &= 0xFFFFFFFC;
                this.state_0_ = state_0 |= 4;
                lock.unlock();
                hasLock = false;
                Object object = this.replaceGeneric(arguments0Value, arguments1Value, arguments2Value);
                return object;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            ReplaceStringCachedData s1_;
            int state_0 = this.state_0_;
            if ((state_0 & 7) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 7 & (state_0 & 7) - 1) == 0 && ((s1_ = this.replaceStringCached_cache) == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[4];
            data[0] = 0;
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            Object[] s2 = new Object[3];
            s2[0] = "replaceStringCached";
            if ((state_0 & 1) != 0) {
                s2[1] = (byte)1;
                ArrayList<List<Serializable>> cached = new ArrayList<List<Serializable>>();
                ReplaceStringCachedData s1_ = this.replaceStringCached_cache;
                while (s1_ != null) {
                    cached.add(Arrays.asList(s1_.cachedReplaceValue_, s1_.cachedParsedReplaceValue_));
                    s1_ = s1_.next_;
                }
                s2[2] = cached;
            } else {
                s2[1] = (exclude & 1) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
            }
            data[1] = s2;
            s2 = new Object[3];
            s2[0] = "replaceString";
            s2[1] = (state_0 & 2) != 0 ? Byte.valueOf((byte)1) : ((exclude & 2) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
            data[2] = s2;
            s2 = new Object[3];
            s2[0] = "replaceGeneric";
            s2[1] = (state_0 & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s2;
            return Introspection.Provider.create(data);
        }

        public static StringPrototypeBuiltins.JSStringReplaceAllNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringReplaceAllNodeGen(context, builtin, arguments);
        }

        @GeneratedBy(value=StringPrototypeBuiltins.JSStringReplaceAllNode.class)
        private static final class ReplaceStringCachedData {
            @CompilerDirectives.CompilationFinal
            ReplaceStringCachedData next_;
            @CompilerDirectives.CompilationFinal
            String cachedReplaceValue_;
            @CompilerDirectives.CompilationFinal(dimensions=1)
            ReplaceStringParser.Token[] cachedParsedReplaceValue_;

            ReplaceStringCachedData(ReplaceStringCachedData next_) {
                this.next_ = next_;
            }
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringReplaceNode.class)
    public static final class JSStringReplaceNodeGen
    extends StringPrototypeBuiltins.JSStringReplaceNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @CompilerDirectives.CompilationFinal
        private ReplaceStringCachedData replaceStringCached_cache;

        private JSStringReplaceNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        @ExplodeLoop
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if ((state_0 & 7) != 0) {
                if ((state_0 & 3) != 0 && JSTypesGen.isImplicitString((state_0 & 0x38) >>> 3, arguments1Value_)) {
                    String arguments1Value__ = JSTypesGen.asImplicitString((state_0 & 0x38) >>> 3, arguments1Value_);
                    if (JSTypesGen.isImplicitString((state_0 & 0x1C0) >>> 6, arguments2Value_)) {
                        String arguments2Value__ = JSTypesGen.asImplicitString((state_0 & 0x1C0) >>> 6, arguments2Value_);
                        if ((state_0 & 1) != 0) {
                            ReplaceStringCachedData s1_ = this.replaceStringCached_cache;
                            while (s1_ != null) {
                                if (s1_.cachedReplaceValue_.equals(arguments2Value__)) {
                                    return this.replaceStringCached(arguments0Value_, arguments1Value__, arguments2Value__, s1_.cachedReplaceValue_, s1_.cachedParsedReplaceValue_);
                                }
                                s1_ = s1_.next_;
                            }
                        }
                        if ((state_0 & 2) != 0) {
                            return this.replaceString(arguments0Value_, arguments1Value__, arguments2Value__);
                        }
                    }
                }
                if ((state_0 & 4) != 0 && !this.isStringString(arguments1Value_, arguments2Value_)) {
                    return this.replaceGeneric(arguments0Value_, arguments1Value_, arguments2Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            try {
                int stringCast1 = JSTypesGen.specializeImplicitString(arguments1Value);
                if (stringCast1 != 0) {
                    String arguments1Value_ = JSTypesGen.asImplicitString(stringCast1, arguments1Value);
                    int stringCast2 = JSTypesGen.specializeImplicitString(arguments2Value);
                    if (stringCast2 != 0) {
                        String arguments2Value_ = JSTypesGen.asImplicitString(stringCast2, arguments2Value);
                        if (exclude == 0) {
                            int count1_ = 0;
                            ReplaceStringCachedData s1_ = this.replaceStringCached_cache;
                            if ((state_0 & 1) != 0) {
                                while (s1_ != null && !s1_.cachedReplaceValue_.equals(arguments2Value_)) {
                                    s1_ = s1_.next_;
                                    ++count1_;
                                }
                            }
                            if (s1_ == null) {
                                if (count1_ < 3) {
                                    s1_ = new ReplaceStringCachedData(this.replaceStringCached_cache);
                                    s1_.cachedReplaceValue_ = arguments2Value_;
                                    s1_.cachedParsedReplaceValue_ = StringPrototypeBuiltins.JSStringReplaceBaseNode.parseReplaceValue(arguments2Value_);
                                    this.replaceStringCached_cache = s1_;
                                    state_0 |= stringCast1 << 3;
                                    state_0 |= stringCast2 << 6;
                                    this.state_0_ = state_0 |= 1;
                                }
                            } else {
                                state_0 |= stringCast1 << 3;
                                state_0 |= stringCast2 << 6;
                                this.state_0_ = state_0 |= 1;
                            }
                            if (s1_ != null) {
                                lock.unlock();
                                hasLock = false;
                                Object object = this.replaceStringCached(arguments0Value, arguments1Value_, arguments2Value_, s1_.cachedReplaceValue_, s1_.cachedParsedReplaceValue_);
                                return object;
                            }
                        }
                        this.exclude_ = exclude |= 1;
                        this.replaceStringCached_cache = null;
                        state_0 &= 0xFFFFFFFE;
                        state_0 |= stringCast1 << 3;
                        state_0 |= stringCast2 << 6;
                        this.state_0_ = state_0 |= 2;
                        lock.unlock();
                        hasLock = false;
                        Object object = this.replaceString(arguments0Value, arguments1Value_, arguments2Value_);
                        return object;
                    }
                }
                if (!this.isStringString(arguments1Value, arguments2Value)) {
                    this.state_0_ = state_0 |= 4;
                    lock.unlock();
                    hasLock = false;
                    Object object = this.replaceGeneric(arguments0Value, arguments1Value, arguments2Value);
                    return object;
                }
                throw new UnsupportedSpecializationException(this, new Node[]{this.arguments0_, this.arguments1_, this.arguments2_}, arguments0Value, arguments1Value, arguments2Value);
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            ReplaceStringCachedData s1_;
            int state_0 = this.state_0_;
            if ((state_0 & 7) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 7 & (state_0 & 7) - 1) == 0 && ((s1_ = this.replaceStringCached_cache) == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[4];
            data[0] = 0;
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            Object[] s2 = new Object[3];
            s2[0] = "replaceStringCached";
            if ((state_0 & 1) != 0) {
                s2[1] = (byte)1;
                ArrayList<List<Serializable>> cached = new ArrayList<List<Serializable>>();
                ReplaceStringCachedData s1_ = this.replaceStringCached_cache;
                while (s1_ != null) {
                    cached.add(Arrays.asList(s1_.cachedReplaceValue_, s1_.cachedParsedReplaceValue_));
                    s1_ = s1_.next_;
                }
                s2[2] = cached;
            } else {
                s2[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
            }
            data[1] = s2;
            s2 = new Object[3];
            s2[0] = "replaceString";
            s2[1] = (state_0 & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s2;
            s2 = new Object[3];
            s2[0] = "replaceGeneric";
            s2[1] = (state_0 & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s2;
            return Introspection.Provider.create(data);
        }

        public static StringPrototypeBuiltins.JSStringReplaceNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringReplaceNodeGen(context, builtin, arguments);
        }

        @GeneratedBy(value=StringPrototypeBuiltins.JSStringReplaceNode.class)
        private static final class ReplaceStringCachedData {
            @CompilerDirectives.CompilationFinal
            ReplaceStringCachedData next_;
            @CompilerDirectives.CompilationFinal
            String cachedReplaceValue_;
            @CompilerDirectives.CompilationFinal(dimensions=1)
            ReplaceStringParser.Token[] cachedParsedReplaceValue_;

            ReplaceStringCachedData(ReplaceStringCachedData next_) {
                this.next_ = next_;
            }
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringConcatNode.class)
    public static final class JSStringConcatNodeGen
    extends StringPrototypeBuiltins.JSStringConcatNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @Node.Child
        private JSToStringNode toString2Node_;

        private JSStringConcatNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state_0 != 0 && arguments1Value_ instanceof Object[]) {
                Object[] arguments1Value__ = (Object[])arguments1Value_;
                return this.concat(arguments0Value_, arguments1Value__, this.toString2Node_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private String executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            try {
                if (arguments1Value instanceof Object[]) {
                    Object[] arguments1Value_ = (Object[])arguments1Value;
                    this.toString2Node_ = super.insert(JSToStringNode.create());
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    String string = this.concat(arguments0Value, arguments1Value_, this.toString2Node_);
                    return string;
                }
                throw new UnsupportedSpecializationException(this, new Node[]{this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            int state_0 = this.state_0_;
            Object[] s2 = new Object[3];
            s2[0] = "concat";
            if (state_0 != 0) {
                s2[1] = (byte)1;
                ArrayList<List<JSToStringNode>> cached = new ArrayList<List<JSToStringNode>>();
                cached.add(Arrays.asList(this.toString2Node_));
                s2[2] = cached;
            } else {
                s2[1] = (byte)0;
            }
            data[1] = s2;
            return Introspection.Provider.create(data);
        }

        public static StringPrototypeBuiltins.JSStringConcatNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringConcatNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringSplitNode.class)
    public static final class JSStringSplitNodeGen
    extends StringPrototypeBuiltins.JSStringSplitNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private JSStringSplitNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if ((state_0 & 1) != 0) {
                assert (!this.isES6OrNewer());
                return this.splitES5(arguments0Value_, arguments1Value_, arguments2Value_);
            }
            if ((state_0 & 2) != 0 && JSTypesGen.isImplicitString((state_0 & 0x38) >>> 3, arguments0Value_)) {
                String arguments0Value__ = JSTypesGen.asImplicitString((state_0 & 0x38) >>> 3, arguments0Value_);
                if (JSTypesGen.isImplicitString((state_0 & 0x1C0) >>> 6, arguments1Value_)) {
                    String arguments1Value__ = JSTypesGen.asImplicitString((state_0 & 0x1C0) >>> 6, arguments1Value_);
                    if (JSTypes.isDynamicObject(arguments2Value_)) {
                        DynamicObject arguments2Value__ = (DynamicObject)arguments2Value_;
                        assert (this.isES6OrNewer());
                        if (this.isFastPath(arguments0Value__, arguments1Value__, arguments2Value__)) {
                            return this.splitES6StrStrUndefined(arguments0Value__, arguments1Value__, arguments2Value__);
                        }
                    }
                }
            }
            if ((state_0 & 4) != 0) {
                assert (this.isES6OrNewer());
                if (!this.isFastPath(arguments0Value_, arguments1Value_, arguments2Value_)) {
                    return this.splitES6Generic(arguments0Value_, arguments1Value_, arguments2Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            int state_0 = this.state_0_;
            if (!this.isES6OrNewer()) {
                this.state_0_ = state_0 |= 1;
                return this.splitES5(arguments0Value, arguments1Value, arguments2Value);
            }
            int stringCast0 = JSTypesGen.specializeImplicitString(arguments0Value);
            if (stringCast0 != 0) {
                String arguments0Value_ = JSTypesGen.asImplicitString(stringCast0, arguments0Value);
                int stringCast1 = JSTypesGen.specializeImplicitString(arguments1Value);
                if (stringCast1 != 0) {
                    String arguments1Value_ = JSTypesGen.asImplicitString(stringCast1, arguments1Value);
                    if (JSTypes.isDynamicObject(arguments2Value)) {
                        DynamicObject arguments2Value_ = (DynamicObject)arguments2Value;
                        if (this.isES6OrNewer() && this.isFastPath(arguments0Value_, arguments1Value_, arguments2Value_)) {
                            state_0 |= stringCast0 << 3;
                            state_0 |= stringCast1 << 6;
                            this.state_0_ = state_0 |= 2;
                            return this.splitES6StrStrUndefined(arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                }
            }
            if (this.isES6OrNewer() && !this.isFastPath(arguments0Value, arguments1Value, arguments2Value)) {
                this.state_0_ = state_0 |= 4;
                return this.splitES6Generic(arguments0Value, arguments1Value, arguments2Value);
            }
            throw new UnsupportedSpecializationException(this, new Node[]{this.arguments0_, this.arguments1_, this.arguments2_}, arguments0Value, arguments1Value, arguments2Value);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 7) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 7 & (state_0 & 7) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[4];
            data[0] = 0;
            int state_0 = this.state_0_;
            Object[] s2 = new Object[3];
            s2[0] = "splitES5";
            s2[1] = (state_0 & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s2;
            s2 = new Object[3];
            s2[0] = "splitES6StrStrUndefined";
            s2[1] = (state_0 & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s2;
            s2 = new Object[3];
            s2[0] = "splitES6Generic";
            s2[1] = (state_0 & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s2;
            return Introspection.Provider.create(data);
        }

        public static StringPrototypeBuiltins.JSStringSplitNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringSplitNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringLastIndexOfNode.class)
    public static final class JSStringLastIndexOfNodeGen
    extends StringPrototypeBuiltins.JSStringLastIndexOfNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @CompilerDirectives.CompilationFinal
        private ConditionProfile searchStrZero;
        @CompilerDirectives.CompilationFinal
        private ConditionProfile searchStrOne;
        @Node.Child
        private JSToStringNode lastIndexOf_toString2Node_;
        @Node.Child
        private JSToNumberNode lastIndexOf_toNumberNode_;
        @CompilerDirectives.CompilationFinal
        private ConditionProfile lastIndexOf_posNaN_;

        private JSStringLastIndexOfNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0xB) == 0 && (state_0 & 0xF) != 0) {
                return this.execute_int0(state_0, frameValue);
            }
            return this.execute_generic1(state_0, frameValue);
        }

        private Object execute_int0(int state_0, VirtualFrame frameValue) {
            int arguments2Value_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            try {
                arguments2Value_ = this.arguments2_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(arguments0Value_, arguments1Value_, ex.getResult());
            }
            assert ((state_0 & 4) != 0);
            if (JSTypesGen.isImplicitString((state_0 & 0x70) >>> 4, arguments0Value_)) {
                String arguments0Value__ = JSTypesGen.asImplicitString((state_0 & 0x70) >>> 4, arguments0Value_);
                if (JSTypesGen.isImplicitString((state_0 & 0x380) >>> 7, arguments1Value_)) {
                    String arguments1Value__ = JSTypesGen.asImplicitString((state_0 & 0x380) >>> 7, arguments1Value_);
                    return this.lastIndexOfString(arguments0Value__, arguments1Value__, arguments2Value_, this.searchStrZero, this.searchStrOne);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        private Object execute_generic1(int state_0, VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if ((state_0 & 7) != 0 && JSTypesGen.isImplicitString((state_0 & 0x70) >>> 4, arguments0Value_)) {
                String arguments0Value__ = JSTypesGen.asImplicitString((state_0 & 0x70) >>> 4, arguments0Value_);
                if (JSTypesGen.isImplicitString((state_0 & 0x380) >>> 7, arguments1Value_)) {
                    String arguments1Value__ = JSTypesGen.asImplicitString((state_0 & 0x380) >>> 7, arguments1Value_);
                    if ((state_0 & 3) != 0) {
                        if ((state_0 & 1) != 0 && this.isStringLength1(arguments1Value__) && JSGuards.isUndefined(arguments2Value_)) {
                            return this.lastIndexOfChar(arguments0Value__, arguments1Value__, arguments2Value_);
                        }
                        if ((state_0 & 2) != 0 && JSGuards.isUndefined(arguments2Value_)) {
                            return this.lastIndexOfString(arguments0Value__, arguments1Value__, arguments2Value_, this.searchStrZero, this.searchStrOne);
                        }
                    }
                    if ((state_0 & 4) != 0 && arguments2Value_ instanceof Integer) {
                        int arguments2Value__ = (Integer)arguments2Value_;
                        return this.lastIndexOfString(arguments0Value__, arguments1Value__, arguments2Value__, this.searchStrZero, this.searchStrOne);
                    }
                }
            }
            if ((state_0 & 8) != 0) {
                return this.lastIndexOf(arguments0Value_, arguments1Value_, arguments2Value_, this.lastIndexOf_toString2Node_, this.lastIndexOf_toNumberNode_, this.lastIndexOf_posNaN_, this.searchStrZero, this.searchStrOne);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public int executeInt(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0xB) == 0 && (state_0 & 0xF) != 0) {
                return this.executeInt_int2(state_0, frameValue);
            }
            return this.executeInt_generic3(state_0, frameValue);
        }

        private int executeInt_int2(int state_0, VirtualFrame frameValue) {
            int arguments2Value_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            try {
                arguments2Value_ = this.arguments2_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(arguments0Value_, arguments1Value_, ex.getResult());
            }
            assert ((state_0 & 4) != 0);
            if (JSTypesGen.isImplicitString((state_0 & 0x70) >>> 4, arguments0Value_)) {
                String arguments0Value__ = JSTypesGen.asImplicitString((state_0 & 0x70) >>> 4, arguments0Value_);
                if (JSTypesGen.isImplicitString((state_0 & 0x380) >>> 7, arguments1Value_)) {
                    String arguments1Value__ = JSTypesGen.asImplicitString((state_0 & 0x380) >>> 7, arguments1Value_);
                    return this.lastIndexOfString(arguments0Value__, arguments1Value__, arguments2Value_, this.searchStrZero, this.searchStrOne);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        private int executeInt_generic3(int state_0, VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if ((state_0 & 7) != 0 && JSTypesGen.isImplicitString((state_0 & 0x70) >>> 4, arguments0Value_)) {
                String arguments0Value__ = JSTypesGen.asImplicitString((state_0 & 0x70) >>> 4, arguments0Value_);
                if (JSTypesGen.isImplicitString((state_0 & 0x380) >>> 7, arguments1Value_)) {
                    String arguments1Value__ = JSTypesGen.asImplicitString((state_0 & 0x380) >>> 7, arguments1Value_);
                    if ((state_0 & 3) != 0) {
                        if ((state_0 & 1) != 0 && this.isStringLength1(arguments1Value__) && JSGuards.isUndefined(arguments2Value_)) {
                            return this.lastIndexOfChar(arguments0Value__, arguments1Value__, arguments2Value_);
                        }
                        if ((state_0 & 2) != 0 && JSGuards.isUndefined(arguments2Value_)) {
                            return this.lastIndexOfString(arguments0Value__, arguments1Value__, arguments2Value_, this.searchStrZero, this.searchStrOne);
                        }
                    }
                    if ((state_0 & 4) != 0 && arguments2Value_ instanceof Integer) {
                        int arguments2Value__ = (Integer)arguments2Value_;
                        return this.lastIndexOfString(arguments0Value__, arguments1Value__, arguments2Value__, this.searchStrZero, this.searchStrOne);
                    }
                }
            }
            if ((state_0 & 8) != 0) {
                return this.lastIndexOf(arguments0Value_, arguments1Value_, arguments2Value_, this.lastIndexOf_toString2Node_, this.lastIndexOf_toNumberNode_, this.lastIndexOf_posNaN_, this.searchStrZero, this.searchStrOne);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.executeInt(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            try {
                int stringCast0 = JSTypesGen.specializeImplicitString(arguments0Value);
                if (stringCast0 != 0) {
                    String arguments0Value_ = JSTypesGen.asImplicitString(stringCast0, arguments0Value);
                    int stringCast1 = JSTypesGen.specializeImplicitString(arguments1Value);
                    if (stringCast1 != 0) {
                        String arguments1Value_ = JSTypesGen.asImplicitString(stringCast1, arguments1Value);
                        if ((exclude & 1) == 0 && this.isStringLength1(arguments1Value_) && JSGuards.isUndefined(arguments2Value)) {
                            state_0 |= stringCast0 << 4;
                            state_0 |= stringCast1 << 7;
                            this.state_0_ = state_0 |= 1;
                            lock.unlock();
                            hasLock = false;
                            int n = this.lastIndexOfChar(arguments0Value_, arguments1Value_, arguments2Value);
                            return n;
                        }
                        if ((exclude & 2) == 0 && JSGuards.isUndefined(arguments2Value)) {
                            if (this.searchStrZero == null) {
                                this.searchStrZero = ConditionProfile.createBinaryProfile();
                            }
                            if (this.searchStrOne == null) {
                                this.searchStrOne = ConditionProfile.createBinaryProfile();
                            }
                            state_0 |= stringCast0 << 4;
                            state_0 |= stringCast1 << 7;
                            this.state_0_ = state_0 |= 2;
                            lock.unlock();
                            hasLock = false;
                            int n = this.lastIndexOfString(arguments0Value_, arguments1Value_, arguments2Value, this.searchStrZero, this.searchStrOne);
                            return n;
                        }
                        if ((exclude & 4) == 0 && arguments2Value instanceof Integer) {
                            int arguments2Value_ = (Integer)arguments2Value;
                            if (this.searchStrZero == null) {
                                this.searchStrZero = ConditionProfile.createBinaryProfile();
                            }
                            if (this.searchStrOne == null) {
                                this.searchStrOne = ConditionProfile.createBinaryProfile();
                            }
                            state_0 |= stringCast0 << 4;
                            state_0 |= stringCast1 << 7;
                            this.state_0_ = state_0 |= 4;
                            lock.unlock();
                            hasLock = false;
                            int n = this.lastIndexOfString(arguments0Value_, arguments1Value_, arguments2Value_, this.searchStrZero, this.searchStrOne);
                            return n;
                        }
                    }
                }
                this.lastIndexOf_toString2Node_ = super.insert(JSToStringNode.create());
                this.lastIndexOf_toNumberNode_ = super.insert(JSToNumberNode.create());
                this.lastIndexOf_posNaN_ = ConditionProfile.createBinaryProfile();
                if (this.searchStrZero == null) {
                    this.searchStrZero = ConditionProfile.createBinaryProfile();
                }
                if (this.searchStrOne == null) {
                    this.searchStrOne = ConditionProfile.createBinaryProfile();
                }
                this.exclude_ = exclude |= 7;
                state_0 &= 0xFFFFFFF8;
                this.state_0_ = state_0 |= 8;
                lock.unlock();
                hasLock = false;
                int n = this.lastIndexOf(arguments0Value, arguments1Value, arguments2Value, this.lastIndexOf_toString2Node_, this.lastIndexOf_toNumberNode_, this.lastIndexOf_posNaN_, this.searchStrZero, this.searchStrOne);
                return n;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0xF) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 0xF & (state_0 & 0xF) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            ArrayList<List<Cloneable>> cached;
            Object[] data = new Object[5];
            data[0] = 0;
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            Object[] s2 = new Object[3];
            s2[0] = "lastIndexOfChar";
            s2[1] = (state_0 & 1) != 0 ? Byte.valueOf((byte)1) : ((exclude & 1) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
            data[1] = s2;
            s2 = new Object[3];
            s2[0] = "lastIndexOfString";
            if ((state_0 & 2) != 0) {
                s2[1] = (byte)1;
                cached = new ArrayList<List<Cloneable>>();
                cached.add(Arrays.asList(this.searchStrZero, this.searchStrOne));
                s2[2] = cached;
            } else {
                s2[1] = (exclude & 2) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
            }
            data[2] = s2;
            s2 = new Object[3];
            s2[0] = "lastIndexOfString";
            if ((state_0 & 4) != 0) {
                s2[1] = (byte)1;
                cached = new ArrayList();
                cached.add(Arrays.asList(this.searchStrZero, this.searchStrOne));
                s2[2] = cached;
            } else {
                s2[1] = (exclude & 4) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
            }
            data[3] = s2;
            s2 = new Object[3];
            s2[0] = "lastIndexOf";
            if ((state_0 & 8) != 0) {
                s2[1] = (byte)1;
                cached = new ArrayList();
                cached.add(Arrays.asList(this.lastIndexOf_toString2Node_, this.lastIndexOf_toNumberNode_, this.lastIndexOf_posNaN_, this.searchStrZero, this.searchStrOne));
                s2[2] = cached;
            } else {
                s2[1] = (byte)0;
            }
            data[4] = s2;
            return Introspection.Provider.create(data);
        }

        public static StringPrototypeBuiltins.JSStringLastIndexOfNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringLastIndexOfNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringIndexOfNode.class)
    public static final class JSStringIndexOfNodeGen
    extends StringPrototypeBuiltins.JSStringIndexOfNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @Node.Child
        private JSToStringNode indexOfGeneric_toString2Node_;

        private JSStringIndexOfNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 5) == 0 && (state_0 & 7) != 0) {
                return this.execute_int0(state_0, frameValue);
            }
            return this.execute_generic1(state_0, frameValue);
        }

        private Object execute_int0(int state_0, VirtualFrame frameValue) {
            int arguments2Value_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            try {
                arguments2Value_ = this.arguments2_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(arguments0Value_, arguments1Value_, ex.getResult());
            }
            assert ((state_0 & 2) != 0);
            if (JSTypesGen.isImplicitString((state_0 & 0x38) >>> 3, arguments0Value_)) {
                String arguments0Value__ = JSTypesGen.asImplicitString((state_0 & 0x38) >>> 3, arguments0Value_);
                if (JSTypesGen.isImplicitString((state_0 & 0x1C0) >>> 6, arguments1Value_)) {
                    String arguments1Value__ = JSTypesGen.asImplicitString((state_0 & 0x1C0) >>> 6, arguments1Value_);
                    return this.indexOfStringInt(arguments0Value__, arguments1Value__, arguments2Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        private Object execute_generic1(int state_0, VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if ((state_0 & 3) != 0 && JSTypesGen.isImplicitString((state_0 & 0x38) >>> 3, arguments0Value_)) {
                String arguments0Value__ = JSTypesGen.asImplicitString((state_0 & 0x38) >>> 3, arguments0Value_);
                if (JSTypesGen.isImplicitString((state_0 & 0x1C0) >>> 6, arguments1Value_)) {
                    String arguments1Value__ = JSTypesGen.asImplicitString((state_0 & 0x1C0) >>> 6, arguments1Value_);
                    if ((state_0 & 1) != 0 && JSGuards.isUndefined(arguments2Value_)) {
                        return this.indexOfStringUndefined(arguments0Value__, arguments1Value__, arguments2Value_);
                    }
                    if ((state_0 & 2) != 0 && arguments2Value_ instanceof Integer) {
                        int arguments2Value__ = (Integer)arguments2Value_;
                        return this.indexOfStringInt(arguments0Value__, arguments1Value__, arguments2Value__);
                    }
                }
            }
            if ((state_0 & 4) != 0) {
                return this.indexOfGeneric(arguments0Value_, arguments1Value_, arguments2Value_, this.indexOfGeneric_toString2Node_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public int executeInt(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 5) == 0 && (state_0 & 7) != 0) {
                return this.executeInt_int2(state_0, frameValue);
            }
            return this.executeInt_generic3(state_0, frameValue);
        }

        private int executeInt_int2(int state_0, VirtualFrame frameValue) {
            int arguments2Value_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            try {
                arguments2Value_ = this.arguments2_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(arguments0Value_, arguments1Value_, ex.getResult());
            }
            assert ((state_0 & 2) != 0);
            if (JSTypesGen.isImplicitString((state_0 & 0x38) >>> 3, arguments0Value_)) {
                String arguments0Value__ = JSTypesGen.asImplicitString((state_0 & 0x38) >>> 3, arguments0Value_);
                if (JSTypesGen.isImplicitString((state_0 & 0x1C0) >>> 6, arguments1Value_)) {
                    String arguments1Value__ = JSTypesGen.asImplicitString((state_0 & 0x1C0) >>> 6, arguments1Value_);
                    return this.indexOfStringInt(arguments0Value__, arguments1Value__, arguments2Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        private int executeInt_generic3(int state_0, VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if ((state_0 & 3) != 0 && JSTypesGen.isImplicitString((state_0 & 0x38) >>> 3, arguments0Value_)) {
                String arguments0Value__ = JSTypesGen.asImplicitString((state_0 & 0x38) >>> 3, arguments0Value_);
                if (JSTypesGen.isImplicitString((state_0 & 0x1C0) >>> 6, arguments1Value_)) {
                    String arguments1Value__ = JSTypesGen.asImplicitString((state_0 & 0x1C0) >>> 6, arguments1Value_);
                    if ((state_0 & 1) != 0 && JSGuards.isUndefined(arguments2Value_)) {
                        return this.indexOfStringUndefined(arguments0Value__, arguments1Value__, arguments2Value_);
                    }
                    if ((state_0 & 2) != 0 && arguments2Value_ instanceof Integer) {
                        int arguments2Value__ = (Integer)arguments2Value_;
                        return this.indexOfStringInt(arguments0Value__, arguments1Value__, arguments2Value__);
                    }
                }
            }
            if ((state_0 & 4) != 0) {
                return this.indexOfGeneric(arguments0Value_, arguments1Value_, arguments2Value_, this.indexOfGeneric_toString2Node_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.executeInt(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            try {
                int stringCast0 = JSTypesGen.specializeImplicitString(arguments0Value);
                if (stringCast0 != 0) {
                    String arguments0Value_ = JSTypesGen.asImplicitString(stringCast0, arguments0Value);
                    int stringCast1 = JSTypesGen.specializeImplicitString(arguments1Value);
                    if (stringCast1 != 0) {
                        String arguments1Value_ = JSTypesGen.asImplicitString(stringCast1, arguments1Value);
                        if (JSGuards.isUndefined(arguments2Value)) {
                            state_0 |= stringCast0 << 3;
                            state_0 |= stringCast1 << 6;
                            this.state_0_ = state_0 |= 1;
                            lock.unlock();
                            hasLock = false;
                            int n = this.indexOfStringUndefined(arguments0Value_, arguments1Value_, arguments2Value);
                            return n;
                        }
                        if (exclude == 0 && arguments2Value instanceof Integer) {
                            int arguments2Value_ = (Integer)arguments2Value;
                            state_0 |= stringCast0 << 3;
                            state_0 |= stringCast1 << 6;
                            this.state_0_ = state_0 |= 2;
                            lock.unlock();
                            hasLock = false;
                            int n = this.indexOfStringInt(arguments0Value_, arguments1Value_, arguments2Value_);
                            return n;
                        }
                    }
                }
                this.indexOfGeneric_toString2Node_ = super.insert(JSToStringNode.create());
                this.exclude_ = exclude |= 1;
                state_0 &= 0xFFFFFFFD;
                this.state_0_ = state_0 |= 4;
                lock.unlock();
                hasLock = false;
                int n = this.indexOfGeneric(arguments0Value, arguments1Value, arguments2Value, this.indexOfGeneric_toString2Node_);
                return n;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 7) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 7 & (state_0 & 7) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[4];
            data[0] = 0;
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            Object[] s2 = new Object[3];
            s2[0] = "indexOfStringUndefined";
            s2[1] = (state_0 & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s2;
            s2 = new Object[3];
            s2[0] = "indexOfStringInt";
            s2[1] = (state_0 & 2) != 0 ? Byte.valueOf((byte)1) : (exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
            data[2] = s2;
            s2 = new Object[3];
            s2[0] = "indexOfGeneric";
            if ((state_0 & 4) != 0) {
                s2[1] = (byte)1;
                ArrayList<List<JSToStringNode>> cached = new ArrayList<List<JSToStringNode>>();
                cached.add(Arrays.asList(this.indexOfGeneric_toString2Node_));
                s2[2] = cached;
            } else {
                s2[1] = (byte)0;
            }
            data[3] = s2;
            return Introspection.Provider.create(data);
        }

        public static StringPrototypeBuiltins.JSStringIndexOfNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringIndexOfNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringSubstringNode.class)
    public static final class JSStringSubstringNodeGen
    extends StringPrototypeBuiltins.JSStringSubstringNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @Node.Child
        private SubstringGenericData substringGeneric_cache;

        private JSStringSubstringNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 6) == 0 && (state_0 & 7) != 0) {
                return this.execute_int_int0(state_0, frameValue);
            }
            if ((state_0 & 5) == 0 && (state_0 & 7) != 0) {
                return this.execute_int1(state_0, frameValue);
            }
            return this.execute_generic2(state_0, frameValue);
        }

        private Object execute_int_int0(int state_0, VirtualFrame frameValue) {
            int arguments2Value_;
            int arguments1Value_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            try {
                arguments1Value_ = this.arguments1_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object arguments2Value = this.arguments2_.execute(frameValue);
                return this.executeAndSpecialize(arguments0Value_, ex.getResult(), arguments2Value);
            }
            try {
                arguments2Value_ = this.arguments2_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(arguments0Value_, arguments1Value_, ex.getResult());
            }
            assert ((state_0 & 1) != 0);
            if (JSTypesGen.isImplicitString((state_0 & 0x38) >>> 3, arguments0Value_)) {
                String arguments0Value__ = JSTypesGen.asImplicitString((state_0 & 0x38) >>> 3, arguments0Value_);
                return this.substring(arguments0Value__, arguments1Value_, arguments2Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        private Object execute_int1(int state_0, VirtualFrame frameValue) {
            int arguments1Value_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            try {
                arguments1Value_ = this.arguments1_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object arguments2Value = this.arguments2_.execute(frameValue);
                return this.executeAndSpecialize(arguments0Value_, ex.getResult(), arguments2Value);
            }
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            assert ((state_0 & 2) != 0);
            if (JSTypesGen.isImplicitString((state_0 & 0x38) >>> 3, arguments0Value_)) {
                String arguments0Value__ = JSTypesGen.asImplicitString((state_0 & 0x38) >>> 3, arguments0Value_);
                if (JSGuards.isUndefined(arguments2Value_)) {
                    return this.substringStart(arguments0Value__, arguments1Value_, arguments2Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        private Object execute_generic2(int state_0, VirtualFrame frameValue) {
            SubstringGenericData s3_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if ((state_0 & 3) != 0 && JSTypesGen.isImplicitString((state_0 & 0x38) >>> 3, arguments0Value_)) {
                String arguments0Value__ = JSTypesGen.asImplicitString((state_0 & 0x38) >>> 3, arguments0Value_);
                if (arguments1Value_ instanceof Integer) {
                    int arguments1Value__ = (Integer)arguments1Value_;
                    if ((state_0 & 1) != 0 && arguments2Value_ instanceof Integer) {
                        int arguments2Value__ = (Integer)arguments2Value_;
                        return this.substring(arguments0Value__, arguments1Value__, arguments2Value__);
                    }
                    if ((state_0 & 2) != 0 && JSGuards.isUndefined(arguments2Value_)) {
                        return this.substringStart(arguments0Value__, arguments1Value__, arguments2Value_);
                    }
                }
            }
            if ((state_0 & 4) != 0 && (s3_ = this.substringGeneric_cache) != null) {
                return this.substringGeneric(arguments0Value_, arguments1Value_, arguments2Value_, s3_.toNumberNode_, s3_.toNumber2Node_, s3_.startUndefined_, s3_.endUndefined_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            try {
                int stringCast0 = JSTypesGen.specializeImplicitString(arguments0Value);
                if (stringCast0 != 0) {
                    String arguments0Value_ = JSTypesGen.asImplicitString(stringCast0, arguments0Value);
                    if (arguments1Value instanceof Integer) {
                        int arguments1Value_ = (Integer)arguments1Value;
                        if ((exclude & 1) == 0 && arguments2Value instanceof Integer) {
                            int arguments2Value_ = (Integer)arguments2Value;
                            state_0 |= stringCast0 << 3;
                            this.state_0_ = state_0 |= 1;
                            lock.unlock();
                            hasLock = false;
                            String string = this.substring(arguments0Value_, arguments1Value_, arguments2Value_);
                            return string;
                        }
                        if ((exclude & 2) == 0 && JSGuards.isUndefined(arguments2Value)) {
                            state_0 |= stringCast0 << 3;
                            this.state_0_ = state_0 |= 2;
                            lock.unlock();
                            hasLock = false;
                            String string = this.substringStart(arguments0Value_, arguments1Value_, arguments2Value);
                            return string;
                        }
                    }
                }
                SubstringGenericData s3_ = super.insert(new SubstringGenericData());
                s3_.toNumberNode_ = s3_.insertAccessor(JSToNumberNode.create());
                s3_.toNumber2Node_ = s3_.insertAccessor(JSToNumberNode.create());
                s3_.startUndefined_ = ConditionProfile.createBinaryProfile();
                s3_.endUndefined_ = ConditionProfile.createBinaryProfile();
                this.substringGeneric_cache = s3_;
                this.exclude_ = exclude |= 3;
                state_0 &= 0xFFFFFFFC;
                this.state_0_ = state_0 |= 4;
                lock.unlock();
                hasLock = false;
                String string = this.substringGeneric(arguments0Value, arguments1Value, arguments2Value, s3_.toNumberNode_, s3_.toNumber2Node_, s3_.startUndefined_, s3_.endUndefined_);
                return string;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 7) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 7 & (state_0 & 7) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[4];
            data[0] = 0;
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            Object[] s2 = new Object[3];
            s2[0] = "substring";
            s2[1] = (state_0 & 1) != 0 ? Byte.valueOf((byte)1) : ((exclude & 1) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
            data[1] = s2;
            s2 = new Object[3];
            s2[0] = "substringStart";
            s2[1] = (state_0 & 2) != 0 ? Byte.valueOf((byte)1) : ((exclude & 2) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
            data[2] = s2;
            s2 = new Object[3];
            s2[0] = "substringGeneric";
            if ((state_0 & 4) != 0) {
                s2[1] = (byte)1;
                ArrayList<List<Cloneable>> cached = new ArrayList<List<Cloneable>>();
                SubstringGenericData s3_ = this.substringGeneric_cache;
                if (s3_ != null) {
                    cached.add(Arrays.asList(s3_.toNumberNode_, s3_.toNumber2Node_, s3_.startUndefined_, s3_.endUndefined_));
                }
                s2[2] = cached;
            } else {
                s2[1] = (byte)0;
            }
            data[3] = s2;
            return Introspection.Provider.create(data);
        }

        public static StringPrototypeBuiltins.JSStringSubstringNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringSubstringNodeGen(context, builtin, arguments);
        }

        @GeneratedBy(value=StringPrototypeBuiltins.JSStringSubstringNode.Inlined.class)
        public static final class InlinedNodeGen
        extends StringPrototypeBuiltins.JSStringSubstringNode.Inlined
        implements Introspection.Provider {
            @Node.Child
            private JavaScriptNode arguments0_;
            @Node.Child
            private JavaScriptNode arguments1_;
            @Node.Child
            private JavaScriptNode arguments2_;
            @CompilerDirectives.CompilationFinal
            private volatile int state_0_;
            @Node.Child
            private SubstringGenericData substringGeneric_cache;

            private InlinedNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
                super(context, builtin);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
            }

            @Override
            public JavaScriptNode[] getArguments() {
                return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
            }

            @Override
            protected Object executeWithArguments(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                SubstringGenericData s3_;
                int state_0 = this.state_0_;
                if ((state_0 & 3) != 0 && JSTypesGen.isImplicitString((state_0 & 0x38) >>> 3, arguments0Value)) {
                    String arguments0Value_ = JSTypesGen.asImplicitString((state_0 & 0x38) >>> 3, arguments0Value);
                    if (arguments1Value instanceof Integer) {
                        int arguments1Value_ = (Integer)arguments1Value;
                        if ((state_0 & 1) != 0 && arguments2Value instanceof Integer) {
                            int arguments2Value_ = (Integer)arguments2Value;
                            return this.substring(arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                        if ((state_0 & 2) != 0 && JSGuards.isUndefined(arguments2Value)) {
                            return this.substringStart(arguments0Value_, arguments1Value_, arguments2Value);
                        }
                    }
                }
                if ((state_0 & 4) != 0 && (s3_ = this.substringGeneric_cache) != null) {
                    return this.substringGeneric(arguments0Value, arguments1Value, arguments2Value, s3_.toNumberNode_, s3_.toNumber2Node_, s3_.startUndefined_, s3_.endUndefined_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                if ((state_0 & 6) == 0 && (state_0 & 7) != 0) {
                    return this.execute_int_int0(state_0, frameValue);
                }
                if ((state_0 & 5) == 0 && (state_0 & 7) != 0) {
                    return this.execute_int1(state_0, frameValue);
                }
                return this.execute_generic2(state_0, frameValue);
            }

            private Object execute_int_int0(int state_0, VirtualFrame frameValue) {
                int arguments2Value_;
                int arguments1Value_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                try {
                    arguments1Value_ = this.arguments1_.executeInt(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value = this.arguments2_.execute(frameValue);
                    return this.executeAndSpecialize(arguments0Value_, ex.getResult(), arguments2Value);
                }
                try {
                    arguments2Value_ = this.arguments2_.executeInt(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.executeAndSpecialize(arguments0Value_, arguments1Value_, ex.getResult());
                }
                assert ((state_0 & 1) != 0);
                if (JSTypesGen.isImplicitString((state_0 & 0x38) >>> 3, arguments0Value_)) {
                    String arguments0Value__ = JSTypesGen.asImplicitString((state_0 & 0x38) >>> 3, arguments0Value_);
                    return this.substring(arguments0Value__, arguments1Value_, arguments2Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
            }

            private Object execute_int1(int state_0, VirtualFrame frameValue) {
                int arguments1Value_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                try {
                    arguments1Value_ = this.arguments1_.executeInt(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value = this.arguments2_.execute(frameValue);
                    return this.executeAndSpecialize(arguments0Value_, ex.getResult(), arguments2Value);
                }
                Object arguments2Value_ = this.arguments2_.execute(frameValue);
                assert ((state_0 & 2) != 0);
                if (JSTypesGen.isImplicitString((state_0 & 0x38) >>> 3, arguments0Value_)) {
                    String arguments0Value__ = JSTypesGen.asImplicitString((state_0 & 0x38) >>> 3, arguments0Value_);
                    if (JSGuards.isUndefined(arguments2Value_)) {
                        return this.substringStart(arguments0Value__, arguments1Value_, arguments2Value_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
            }

            private Object execute_generic2(int state_0, VirtualFrame frameValue) {
                SubstringGenericData s3_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                Object arguments2Value_ = this.arguments2_.execute(frameValue);
                if ((state_0 & 3) != 0 && JSTypesGen.isImplicitString((state_0 & 0x38) >>> 3, arguments0Value_)) {
                    String arguments0Value__ = JSTypesGen.asImplicitString((state_0 & 0x38) >>> 3, arguments0Value_);
                    if (arguments1Value_ instanceof Integer) {
                        int arguments1Value__ = (Integer)arguments1Value_;
                        if ((state_0 & 1) != 0 && arguments2Value_ instanceof Integer) {
                            int arguments2Value__ = (Integer)arguments2Value_;
                            return this.substring(arguments0Value__, arguments1Value__, arguments2Value__);
                        }
                        if ((state_0 & 2) != 0 && JSGuards.isUndefined(arguments2Value_)) {
                            return this.substringStart(arguments0Value__, arguments1Value__, arguments2Value_);
                        }
                    }
                }
                if ((state_0 & 4) != 0 && (s3_ = this.substringGeneric_cache) != null) {
                    return this.substringGeneric(arguments0Value_, arguments1Value_, arguments2Value_, s3_.toNumberNode_, s3_.toNumber2Node_, s3_.startUndefined_, s3_.endUndefined_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private String executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    int stringCast0 = JSTypesGen.specializeImplicitString(arguments0Value);
                    if (stringCast0 != 0) {
                        String arguments0Value_ = JSTypesGen.asImplicitString(stringCast0, arguments0Value);
                        if (arguments1Value instanceof Integer) {
                            int arguments1Value_ = (Integer)arguments1Value;
                            if (arguments2Value instanceof Integer) {
                                int arguments2Value_ = (Integer)arguments2Value;
                                state_0 |= stringCast0 << 3;
                                this.state_0_ = state_0 |= 1;
                                lock.unlock();
                                hasLock = false;
                                String string = this.substring(arguments0Value_, arguments1Value_, arguments2Value_);
                                return string;
                            }
                            if (JSGuards.isUndefined(arguments2Value)) {
                                state_0 |= stringCast0 << 3;
                                this.state_0_ = state_0 |= 2;
                                lock.unlock();
                                hasLock = false;
                                String string = this.substringStart(arguments0Value_, arguments1Value_, arguments2Value);
                                return string;
                            }
                        }
                    }
                    SubstringGenericData s3_ = super.insert(new SubstringGenericData());
                    s3_.toNumberNode_ = s3_.insertAccessor(JSToNumberNode.create());
                    s3_.toNumber2Node_ = s3_.insertAccessor(JSToNumberNode.create());
                    s3_.startUndefined_ = ConditionProfile.createBinaryProfile();
                    s3_.endUndefined_ = ConditionProfile.createBinaryProfile();
                    this.substringGeneric_cache = s3_;
                    this.state_0_ = state_0 |= 4;
                    lock.unlock();
                    hasLock = false;
                    String string = this.substringGeneric(arguments0Value, arguments1Value, arguments2Value, s3_.toNumberNode_, s3_.toNumber2Node_, s3_.startUndefined_, s3_.endUndefined_);
                    return string;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 7) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 7 & (state_0 & 7) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @Override
            public Introspection getIntrospectionData() {
                Object[] data = new Object[4];
                data[0] = 0;
                int state_0 = this.state_0_;
                Object[] s2 = new Object[3];
                s2[0] = "substring";
                s2[1] = (state_0 & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
                data[1] = s2;
                s2 = new Object[3];
                s2[0] = "substringStart";
                s2[1] = (state_0 & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
                data[2] = s2;
                s2 = new Object[3];
                s2[0] = "substringGeneric";
                if ((state_0 & 4) != 0) {
                    s2[1] = (byte)1;
                    ArrayList<List<Cloneable>> cached = new ArrayList<List<Cloneable>>();
                    SubstringGenericData s3_ = this.substringGeneric_cache;
                    if (s3_ != null) {
                        cached.add(Arrays.asList(s3_.toNumberNode_, s3_.toNumber2Node_, s3_.startUndefined_, s3_.endUndefined_));
                    }
                    s2[2] = cached;
                } else {
                    s2[1] = (byte)0;
                }
                data[3] = s2;
                return Introspection.Provider.create(data);
            }

            public static StringPrototypeBuiltins.JSStringSubstringNode.Inlined create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
                return new InlinedNodeGen(context, builtin, arguments);
            }

            @GeneratedBy(value=StringPrototypeBuiltins.JSStringSubstringNode.Inlined.class)
            private static final class SubstringGenericData
            extends Node {
                @Node.Child
                JSToNumberNode toNumberNode_;
                @Node.Child
                JSToNumberNode toNumber2Node_;
                @CompilerDirectives.CompilationFinal
                ConditionProfile startUndefined_;
                @CompilerDirectives.CompilationFinal
                ConditionProfile endUndefined_;

                SubstringGenericData() {
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                <T extends Node> T insertAccessor(T node) {
                    return super.insert(node);
                }
            }
        }

        @GeneratedBy(value=StringPrototypeBuiltins.JSStringSubstringNode.class)
        private static final class SubstringGenericData
        extends Node {
            @Node.Child
            JSToNumberNode toNumberNode_;
            @Node.Child
            JSToNumberNode toNumber2Node_;
            @CompilerDirectives.CompilationFinal
            ConditionProfile startUndefined_;
            @CompilerDirectives.CompilationFinal
            ConditionProfile endUndefined_;

            SubstringGenericData() {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringCharCodeAtNode.class)
    public static final class JSStringCharCodeAtNodeGen
    extends StringPrototypeBuiltins.JSStringCharCodeAtNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @CompilerDirectives.CompilationFinal
        private ConditionProfile charCodeAtLazyString_flatten_;
        @Node.Child
        private JSToNumberNode charCodeAtGeneric_toNumberNode_;

        private JSStringCharCodeAtNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 8) == 0 && (state_0 & 0xF) != 0) {
                return this.execute_int0(state_0, frameValue);
            }
            return this.execute_generic1(state_0, frameValue);
        }

        private Object execute_int0(int state_0, VirtualFrame frameValue) {
            int arguments1Value_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            try {
                arguments1Value_ = this.arguments1_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(arguments0Value_, ex.getResult());
            }
            if ((state_0 & 1) != 0 && arguments0Value_ instanceof JSLazyString) {
                JSLazyString arguments0Value__ = (JSLazyString)arguments0Value_;
                return this.charCodeAtLazyString(arguments0Value__, arguments1Value_, this.charCodeAtLazyString_flatten_);
            }
            if ((state_0 & 6) != 0 && JSTypesGen.isImplicitString((state_0 & 0x70) >>> 4, arguments0Value_)) {
                String arguments0Value__ = JSTypesGen.asImplicitString((state_0 & 0x70) >>> 4, arguments0Value_);
                if ((state_0 & 2) != 0 && StringPrototypeBuiltins.JSStringCharCodeAtNode.posInBounds(arguments0Value__, arguments1Value_)) {
                    return this.charCodeAtInBounds(arguments0Value__, arguments1Value_);
                }
                if ((state_0 & 4) != 0 && !StringPrototypeBuiltins.JSStringCharCodeAtNode.posInBounds(arguments0Value__, arguments1Value_)) {
                    return this.charCodeAtOutOfBounds(arguments0Value__, arguments1Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        private Object execute_generic1(int state_0, VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if ((state_0 & 7) != 0 && arguments1Value_ instanceof Integer) {
                int arguments1Value__ = (Integer)arguments1Value_;
                if ((state_0 & 1) != 0 && arguments0Value_ instanceof JSLazyString) {
                    JSLazyString arguments0Value__ = (JSLazyString)arguments0Value_;
                    return this.charCodeAtLazyString(arguments0Value__, arguments1Value__, this.charCodeAtLazyString_flatten_);
                }
                if ((state_0 & 6) != 0 && JSTypesGen.isImplicitString((state_0 & 0x70) >>> 4, arguments0Value_)) {
                    String arguments0Value__ = JSTypesGen.asImplicitString((state_0 & 0x70) >>> 4, arguments0Value_);
                    if ((state_0 & 2) != 0 && StringPrototypeBuiltins.JSStringCharCodeAtNode.posInBounds(arguments0Value__, arguments1Value__)) {
                        return this.charCodeAtInBounds(arguments0Value__, arguments1Value__);
                    }
                    if ((state_0 & 4) != 0 && !StringPrototypeBuiltins.JSStringCharCodeAtNode.posInBounds(arguments0Value__, arguments1Value__)) {
                        return this.charCodeAtOutOfBounds(arguments0Value__, arguments1Value__);
                    }
                }
            }
            if ((state_0 & 8) != 0) {
                return this.charCodeAtGeneric(arguments0Value_, arguments1Value_, this.charCodeAtGeneric_toNumberNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
            String arguments0Value__;
            int arguments1Value_;
            int state_0 = this.state_0_;
            if ((state_0 & 9) != 0) {
                return JSTypesGen.expectDouble(this.execute(frameValue));
            }
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            try {
                arguments1Value_ = this.arguments1_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return JSTypesGen.expectDouble(this.executeAndSpecialize(arguments0Value_, ex.getResult()));
            }
            if ((state_0 & 4) != 0 && JSTypesGen.isImplicitString((state_0 & 0x70) >>> 4, arguments0Value_) && !StringPrototypeBuiltins.JSStringCharCodeAtNode.posInBounds(arguments0Value__ = JSTypesGen.asImplicitString((state_0 & 0x70) >>> 4, arguments0Value_), arguments1Value_)) {
                return this.charCodeAtOutOfBounds(arguments0Value__, arguments1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectDouble(this.executeAndSpecialize(arguments0Value_, arguments1Value_));
        }

        @Override
        public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
            String arguments0Value__;
            int arguments1Value_;
            int state_0 = this.state_0_;
            if ((state_0 & 9) != 0) {
                return JSTypesGen.expectInteger(this.execute(frameValue));
            }
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            try {
                arguments1Value_ = this.arguments1_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return JSTypesGen.expectInteger(this.executeAndSpecialize(arguments0Value_, ex.getResult()));
            }
            if ((state_0 & 2) != 0 && JSTypesGen.isImplicitString((state_0 & 0x70) >>> 4, arguments0Value_) && StringPrototypeBuiltins.JSStringCharCodeAtNode.posInBounds(arguments0Value__ = JSTypesGen.asImplicitString((state_0 & 0x70) >>> 4, arguments0Value_), arguments1Value_)) {
                return this.charCodeAtInBounds(arguments0Value__, arguments1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectInteger(this.executeAndSpecialize(arguments0Value_, arguments1Value_));
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            try {
                if ((state_0 & 0xD) == 0 && (state_0 & 0xF) != 0) {
                    this.executeInt(frameValue);
                    return;
                }
                if ((state_0 & 0xB) == 0 && (state_0 & 0xF) != 0) {
                    this.executeDouble(frameValue);
                    return;
                }
                this.execute(frameValue);
                return;
            }
            catch (UnexpectedResultException ex) {
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            try {
                if (arguments1Value instanceof Integer) {
                    int arguments1Value_ = (Integer)arguments1Value;
                    if ((exclude & 1) == 0 && arguments0Value instanceof JSLazyString) {
                        JSLazyString arguments0Value_ = (JSLazyString)arguments0Value;
                        this.charCodeAtLazyString_flatten_ = ConditionProfile.createBinaryProfile();
                        this.state_0_ = state_0 |= 1;
                        lock.unlock();
                        hasLock = false;
                        Object object = this.charCodeAtLazyString(arguments0Value_, arguments1Value_, this.charCodeAtLazyString_flatten_);
                        return object;
                    }
                    int stringCast0 = JSTypesGen.specializeImplicitString(arguments0Value);
                    if (stringCast0 != 0) {
                        String arguments0Value_ = JSTypesGen.asImplicitString(stringCast0, arguments0Value);
                        if ((exclude & 2) == 0 && StringPrototypeBuiltins.JSStringCharCodeAtNode.posInBounds(arguments0Value_, arguments1Value_)) {
                            state_0 |= stringCast0 << 4;
                            this.state_0_ = state_0 |= 2;
                            lock.unlock();
                            hasLock = false;
                            Integer n = this.charCodeAtInBounds(arguments0Value_, arguments1Value_);
                            return n;
                        }
                        if ((exclude & 4) == 0 && !StringPrototypeBuiltins.JSStringCharCodeAtNode.posInBounds(arguments0Value_, arguments1Value_)) {
                            state_0 |= stringCast0 << 4;
                            this.state_0_ = state_0 |= 4;
                            lock.unlock();
                            hasLock = false;
                            Double d = this.charCodeAtOutOfBounds(arguments0Value_, arguments1Value_);
                            return d;
                        }
                    }
                }
                this.charCodeAtGeneric_toNumberNode_ = super.insert(JSToNumberNode.create());
                this.exclude_ = exclude |= 7;
                state_0 &= 0xFFFFFFF8;
                this.state_0_ = state_0 |= 8;
                lock.unlock();
                hasLock = false;
                Object object = this.charCodeAtGeneric(arguments0Value, arguments1Value, this.charCodeAtGeneric_toNumberNode_);
                return object;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0xF) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 0xF & (state_0 & 0xF) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            ArrayList<List<Cloneable>> cached;
            Object[] data = new Object[5];
            data[0] = 0;
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            Object[] s2 = new Object[3];
            s2[0] = "charCodeAtLazyString";
            if ((state_0 & 1) != 0) {
                s2[1] = (byte)1;
                cached = new ArrayList<List<Cloneable>>();
                cached.add(Arrays.asList(this.charCodeAtLazyString_flatten_));
                s2[2] = cached;
            } else {
                s2[1] = (exclude & 1) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
            }
            data[1] = s2;
            s2 = new Object[3];
            s2[0] = "charCodeAtInBounds";
            s2[1] = (state_0 & 2) != 0 ? Byte.valueOf((byte)1) : ((exclude & 2) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
            data[2] = s2;
            s2 = new Object[3];
            s2[0] = "charCodeAtOutOfBounds";
            s2[1] = (state_0 & 4) != 0 ? Byte.valueOf((byte)1) : ((exclude & 4) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
            data[3] = s2;
            s2 = new Object[3];
            s2[0] = "charCodeAtGeneric";
            if ((state_0 & 8) != 0) {
                s2[1] = (byte)1;
                cached = new ArrayList();
                cached.add(Arrays.asList(this.charCodeAtGeneric_toNumberNode_));
                s2[2] = cached;
            } else {
                s2[1] = (byte)0;
            }
            data[4] = s2;
            return Introspection.Provider.create(data);
        }

        public static StringPrototypeBuiltins.JSStringCharCodeAtNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringCharCodeAtNodeGen(context, builtin, arguments);
        }

        @GeneratedBy(value=StringPrototypeBuiltins.JSStringCharCodeAtNode.Inlined.class)
        public static final class InlinedNodeGen
        extends StringPrototypeBuiltins.JSStringCharCodeAtNode.Inlined
        implements Introspection.Provider {
            @Node.Child
            private JavaScriptNode arguments0_;
            @Node.Child
            private JavaScriptNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private volatile int state_0_;
            @CompilerDirectives.CompilationFinal
            private ConditionProfile charCodeAtLazyString_flatten_;
            @Node.Child
            private JSToNumberNode charCodeAtGeneric_toNumberNode_;

            private InlinedNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
                super(context, builtin);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public JavaScriptNode[] getArguments() {
                return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
            }

            @Override
            protected Object executeWithArguments(Object arguments0Value, Object arguments1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 7) != 0 && arguments1Value instanceof Integer) {
                    int arguments1Value_ = (Integer)arguments1Value;
                    if ((state_0 & 1) != 0 && arguments0Value instanceof JSLazyString) {
                        JSLazyString arguments0Value_ = (JSLazyString)arguments0Value;
                        return this.charCodeAtLazyString(arguments0Value_, arguments1Value_, this.charCodeAtLazyString_flatten_);
                    }
                    if ((state_0 & 6) != 0 && JSTypesGen.isImplicitString((state_0 & 0x70) >>> 4, arguments0Value)) {
                        String arguments0Value_ = JSTypesGen.asImplicitString((state_0 & 0x70) >>> 4, arguments0Value);
                        if ((state_0 & 2) != 0 && StringPrototypeBuiltins.JSStringCharCodeAtNode.posInBounds(arguments0Value_, arguments1Value_)) {
                            return this.charCodeAtInBounds(arguments0Value_, arguments1Value_);
                        }
                        if ((state_0 & 4) != 0 && !StringPrototypeBuiltins.JSStringCharCodeAtNode.posInBounds(arguments0Value_, arguments1Value_)) {
                            return this.charCodeAtOutOfBounds(arguments0Value_, arguments1Value_);
                        }
                    }
                }
                if ((state_0 & 8) != 0) {
                    return this.charCodeAtGeneric(arguments0Value, arguments1Value, this.charCodeAtGeneric_toNumberNode_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arguments0Value, arguments1Value);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                if ((state_0 & 8) == 0 && (state_0 & 0xF) != 0) {
                    return this.execute_int0(state_0, frameValue);
                }
                return this.execute_generic1(state_0, frameValue);
            }

            private Object execute_int0(int state_0, VirtualFrame frameValue) {
                int arguments1Value_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                try {
                    arguments1Value_ = this.arguments1_.executeInt(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.executeAndSpecialize(arguments0Value_, ex.getResult());
                }
                if ((state_0 & 1) != 0 && arguments0Value_ instanceof JSLazyString) {
                    JSLazyString arguments0Value__ = (JSLazyString)arguments0Value_;
                    return this.charCodeAtLazyString(arguments0Value__, arguments1Value_, this.charCodeAtLazyString_flatten_);
                }
                if ((state_0 & 6) != 0 && JSTypesGen.isImplicitString((state_0 & 0x70) >>> 4, arguments0Value_)) {
                    String arguments0Value__ = JSTypesGen.asImplicitString((state_0 & 0x70) >>> 4, arguments0Value_);
                    if ((state_0 & 2) != 0 && StringPrototypeBuiltins.JSStringCharCodeAtNode.posInBounds(arguments0Value__, arguments1Value_)) {
                        return this.charCodeAtInBounds(arguments0Value__, arguments1Value_);
                    }
                    if ((state_0 & 4) != 0 && !StringPrototypeBuiltins.JSStringCharCodeAtNode.posInBounds(arguments0Value__, arguments1Value_)) {
                        return this.charCodeAtOutOfBounds(arguments0Value__, arguments1Value_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
            }

            private Object execute_generic1(int state_0, VirtualFrame frameValue) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                if ((state_0 & 7) != 0 && arguments1Value_ instanceof Integer) {
                    int arguments1Value__ = (Integer)arguments1Value_;
                    if ((state_0 & 1) != 0 && arguments0Value_ instanceof JSLazyString) {
                        JSLazyString arguments0Value__ = (JSLazyString)arguments0Value_;
                        return this.charCodeAtLazyString(arguments0Value__, arguments1Value__, this.charCodeAtLazyString_flatten_);
                    }
                    if ((state_0 & 6) != 0 && JSTypesGen.isImplicitString((state_0 & 0x70) >>> 4, arguments0Value_)) {
                        String arguments0Value__ = JSTypesGen.asImplicitString((state_0 & 0x70) >>> 4, arguments0Value_);
                        if ((state_0 & 2) != 0 && StringPrototypeBuiltins.JSStringCharCodeAtNode.posInBounds(arguments0Value__, arguments1Value__)) {
                            return this.charCodeAtInBounds(arguments0Value__, arguments1Value__);
                        }
                        if ((state_0 & 4) != 0 && !StringPrototypeBuiltins.JSStringCharCodeAtNode.posInBounds(arguments0Value__, arguments1Value__)) {
                            return this.charCodeAtOutOfBounds(arguments0Value__, arguments1Value__);
                        }
                    }
                }
                if ((state_0 & 8) != 0) {
                    return this.charCodeAtGeneric(arguments0Value_, arguments1Value_, this.charCodeAtGeneric_toNumberNode_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                String arguments0Value__;
                int arguments1Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 9) != 0) {
                    return JSTypesGen.expectDouble(this.execute(frameValue));
                }
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                try {
                    arguments1Value_ = this.arguments1_.executeInt(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return JSTypesGen.expectDouble(this.executeAndSpecialize(arguments0Value_, ex.getResult()));
                }
                if ((state_0 & 4) != 0 && JSTypesGen.isImplicitString((state_0 & 0x70) >>> 4, arguments0Value_) && !StringPrototypeBuiltins.JSStringCharCodeAtNode.posInBounds(arguments0Value__ = JSTypesGen.asImplicitString((state_0 & 0x70) >>> 4, arguments0Value_), arguments1Value_)) {
                    return this.charCodeAtOutOfBounds(arguments0Value__, arguments1Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return JSTypesGen.expectDouble(this.executeAndSpecialize(arguments0Value_, arguments1Value_));
            }

            @Override
            public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                String arguments0Value__;
                int arguments1Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 9) != 0) {
                    return JSTypesGen.expectInteger(this.execute(frameValue));
                }
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                try {
                    arguments1Value_ = this.arguments1_.executeInt(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return JSTypesGen.expectInteger(this.executeAndSpecialize(arguments0Value_, ex.getResult()));
                }
                if ((state_0 & 2) != 0 && JSTypesGen.isImplicitString((state_0 & 0x70) >>> 4, arguments0Value_) && StringPrototypeBuiltins.JSStringCharCodeAtNode.posInBounds(arguments0Value__ = JSTypesGen.asImplicitString((state_0 & 0x70) >>> 4, arguments0Value_), arguments1Value_)) {
                    return this.charCodeAtInBounds(arguments0Value__, arguments1Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return JSTypesGen.expectInteger(this.executeAndSpecialize(arguments0Value_, arguments1Value_));
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                try {
                    if ((state_0 & 0xD) == 0 && (state_0 & 0xF) != 0) {
                        this.executeInt(frameValue);
                        return;
                    }
                    if ((state_0 & 0xB) == 0 && (state_0 & 0xF) != 0) {
                        this.executeDouble(frameValue);
                        return;
                    }
                    this.execute(frameValue);
                    return;
                }
                catch (UnexpectedResultException ex) {
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    if (arguments1Value instanceof Integer) {
                        int arguments1Value_ = (Integer)arguments1Value;
                        if (arguments0Value instanceof JSLazyString) {
                            JSLazyString arguments0Value_ = (JSLazyString)arguments0Value;
                            this.charCodeAtLazyString_flatten_ = ConditionProfile.createBinaryProfile();
                            this.state_0_ = state_0 |= 1;
                            lock.unlock();
                            hasLock = false;
                            Object object = this.charCodeAtLazyString(arguments0Value_, arguments1Value_, this.charCodeAtLazyString_flatten_);
                            return object;
                        }
                        int stringCast0 = JSTypesGen.specializeImplicitString(arguments0Value);
                        if (stringCast0 != 0) {
                            String arguments0Value_ = JSTypesGen.asImplicitString(stringCast0, arguments0Value);
                            if (StringPrototypeBuiltins.JSStringCharCodeAtNode.posInBounds(arguments0Value_, arguments1Value_)) {
                                state_0 |= stringCast0 << 4;
                                this.state_0_ = state_0 |= 2;
                                lock.unlock();
                                hasLock = false;
                                Integer n = this.charCodeAtInBounds(arguments0Value_, arguments1Value_);
                                return n;
                            }
                            if (!StringPrototypeBuiltins.JSStringCharCodeAtNode.posInBounds(arguments0Value_, arguments1Value_)) {
                                state_0 |= stringCast0 << 4;
                                this.state_0_ = state_0 |= 4;
                                lock.unlock();
                                hasLock = false;
                                Double d = this.charCodeAtOutOfBounds(arguments0Value_, arguments1Value_);
                                return d;
                            }
                        }
                    }
                    this.charCodeAtGeneric_toNumberNode_ = super.insert(JSToNumberNode.create());
                    this.state_0_ = state_0 |= 8;
                    lock.unlock();
                    hasLock = false;
                    Object object = this.charCodeAtGeneric(arguments0Value, arguments1Value, this.charCodeAtGeneric_toNumberNode_);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0xF) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 0xF & (state_0 & 0xF) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @Override
            public Introspection getIntrospectionData() {
                ArrayList<List<Cloneable>> cached;
                Object[] data = new Object[5];
                data[0] = 0;
                int state_0 = this.state_0_;
                Object[] s2 = new Object[3];
                s2[0] = "charCodeAtLazyString";
                if ((state_0 & 1) != 0) {
                    s2[1] = (byte)1;
                    cached = new ArrayList<List<Cloneable>>();
                    cached.add(Arrays.asList(this.charCodeAtLazyString_flatten_));
                    s2[2] = cached;
                } else {
                    s2[1] = (byte)0;
                }
                data[1] = s2;
                s2 = new Object[3];
                s2[0] = "charCodeAtInBounds";
                s2[1] = (state_0 & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
                data[2] = s2;
                s2 = new Object[3];
                s2[0] = "charCodeAtOutOfBounds";
                s2[1] = (state_0 & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
                data[3] = s2;
                s2 = new Object[3];
                s2[0] = "charCodeAtGeneric";
                if ((state_0 & 8) != 0) {
                    s2[1] = (byte)1;
                    cached = new ArrayList();
                    cached.add(Arrays.asList(this.charCodeAtGeneric_toNumberNode_));
                    s2[2] = cached;
                } else {
                    s2[1] = (byte)0;
                }
                data[4] = s2;
                return Introspection.Provider.create(data);
            }

            public static StringPrototypeBuiltins.JSStringCharCodeAtNode.Inlined create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
                return new InlinedNodeGen(context, builtin, arguments);
            }
        }
    }

    @GeneratedBy(value=StringPrototypeBuiltins.JSStringCharAtNode.class)
    public static final class JSStringCharAtNodeGen
    extends StringPrototypeBuiltins.JSStringCharAtNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private JSStringCharAtNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0 && (state_0 & 3) != 0) {
                return this.execute_int0(state_0, frameValue);
            }
            return this.execute_generic1(state_0, frameValue);
        }

        private Object execute_int0(int state_0, VirtualFrame frameValue) {
            int arguments1Value_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            try {
                arguments1Value_ = this.arguments1_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(arguments0Value_, ex.getResult());
            }
            assert ((state_0 & 1) != 0);
            if (JSTypesGen.isImplicitString((state_0 & 0x1C) >>> 2, arguments0Value_)) {
                String arguments0Value__ = JSTypesGen.asImplicitString((state_0 & 0x1C) >>> 2, arguments0Value_);
                return this.stringCharAt(arguments0Value__, arguments1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        private Object execute_generic1(int state_0, VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if ((state_0 & 1) != 0 && JSTypesGen.isImplicitString((state_0 & 0x1C) >>> 2, arguments0Value_)) {
                String arguments0Value__ = JSTypesGen.asImplicitString((state_0 & 0x1C) >>> 2, arguments0Value_);
                if (arguments1Value_ instanceof Integer) {
                    int arguments1Value__ = (Integer)arguments1Value_;
                    return this.stringCharAt(arguments0Value__, arguments1Value__);
                }
            }
            if ((state_0 & 2) != 0) {
                return this.charAt(arguments0Value_, arguments1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private String executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            int state_0 = this.state_0_;
            int stringCast0 = JSTypesGen.specializeImplicitString(arguments0Value);
            if (stringCast0 != 0) {
                String arguments0Value_ = JSTypesGen.asImplicitString(stringCast0, arguments0Value);
                if (arguments1Value instanceof Integer) {
                    int arguments1Value_ = (Integer)arguments1Value;
                    state_0 |= stringCast0 << 2;
                    this.state_0_ = state_0 |= 1;
                    return this.stringCharAt(arguments0Value_, arguments1Value_);
                }
            }
            this.state_0_ = state_0 |= 2;
            return this.charAt(arguments0Value, arguments1Value);
        }

        @Override
        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 3) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 3 & (state_0 & 3) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            Object[] data = new Object[3];
            data[0] = 0;
            int state_0 = this.state_0_;
            Object[] s2 = new Object[3];
            s2[0] = "stringCharAt";
            s2[1] = (state_0 & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s2;
            s2 = new Object[3];
            s2[0] = "charAt";
            s2[1] = (state_0 & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s2;
            return Introspection.Provider.create(data);
        }

        public static StringPrototypeBuiltins.JSStringCharAtNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new JSStringCharAtNodeGen(context, builtin, arguments);
        }

        @GeneratedBy(value=StringPrototypeBuiltins.JSStringCharAtNode.Inlined.class)
        public static final class InlinedNodeGen
        extends StringPrototypeBuiltins.JSStringCharAtNode.Inlined
        implements Introspection.Provider {
            @Node.Child
            private JavaScriptNode arguments0_;
            @Node.Child
            private JavaScriptNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private InlinedNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
                super(context, builtin);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public JavaScriptNode[] getArguments() {
                return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
            }

            @Override
            protected Object executeWithArguments(Object arguments0Value, Object arguments1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0 && JSTypesGen.isImplicitString((state_0 & 0x1C) >>> 2, arguments0Value)) {
                    String arguments0Value_ = JSTypesGen.asImplicitString((state_0 & 0x1C) >>> 2, arguments0Value);
                    if (arguments1Value instanceof Integer) {
                        int arguments1Value_ = (Integer)arguments1Value;
                        return this.stringCharAt(arguments0Value_, arguments1Value_);
                    }
                }
                if ((state_0 & 2) != 0) {
                    return this.charAt(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arguments0Value, arguments1Value);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                if ((state_0 & 2) == 0 && (state_0 & 3) != 0) {
                    return this.execute_int0(state_0, frameValue);
                }
                return this.execute_generic1(state_0, frameValue);
            }

            private Object execute_int0(int state_0, VirtualFrame frameValue) {
                int arguments1Value_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                try {
                    arguments1Value_ = this.arguments1_.executeInt(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.executeAndSpecialize(arguments0Value_, ex.getResult());
                }
                assert ((state_0 & 1) != 0);
                if (JSTypesGen.isImplicitString((state_0 & 0x1C) >>> 2, arguments0Value_)) {
                    String arguments0Value__ = JSTypesGen.asImplicitString((state_0 & 0x1C) >>> 2, arguments0Value_);
                    return this.stringCharAt(arguments0Value__, arguments1Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
            }

            private Object execute_generic1(int state_0, VirtualFrame frameValue) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                if ((state_0 & 1) != 0 && JSTypesGen.isImplicitString((state_0 & 0x1C) >>> 2, arguments0Value_)) {
                    String arguments0Value__ = JSTypesGen.asImplicitString((state_0 & 0x1C) >>> 2, arguments0Value_);
                    if (arguments1Value_ instanceof Integer) {
                        int arguments1Value__ = (Integer)arguments1Value_;
                        return this.stringCharAt(arguments0Value__, arguments1Value__);
                    }
                }
                if ((state_0 & 2) != 0) {
                    return this.charAt(arguments0Value_, arguments1Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private String executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
                int state_0 = this.state_0_;
                int stringCast0 = JSTypesGen.specializeImplicitString(arguments0Value);
                if (stringCast0 != 0) {
                    String arguments0Value_ = JSTypesGen.asImplicitString(stringCast0, arguments0Value);
                    if (arguments1Value instanceof Integer) {
                        int arguments1Value_ = (Integer)arguments1Value;
                        state_0 |= stringCast0 << 2;
                        this.state_0_ = state_0 |= 1;
                        return this.stringCharAt(arguments0Value_, arguments1Value_);
                    }
                }
                this.state_0_ = state_0 |= 2;
                return this.charAt(arguments0Value, arguments1Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 3) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & 3 & (state_0 & 3) - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @Override
            public Introspection getIntrospectionData() {
                Object[] data = new Object[3];
                data[0] = 0;
                int state_0 = this.state_0_;
                Object[] s2 = new Object[3];
                s2[0] = "stringCharAt";
                s2[1] = (state_0 & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
                data[1] = s2;
                s2 = new Object[3];
                s2[0] = "charAt";
                s2[1] = (state_0 & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
                data[2] = s2;
                return Introspection.Provider.create(data);
            }

            public static StringPrototypeBuiltins.JSStringCharAtNode.Inlined create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
                return new InlinedNodeGen(context, builtin, arguments);
            }
        }
    }
}

