/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.helper;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.js.builtins.helper.IsPristineObjectNode;
import com.oracle.truffle.js.builtins.helper.JSRegExpExecIntlNodeGen;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.IsJSClassNode;
import com.oracle.truffle.js.nodes.access.IsJSObjectNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.cast.JSToLengthNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.JSRegExp;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.TRegexUtil;

public abstract class JSRegExpExecIntlNode
extends JavaScriptBaseNode {
    private final JSContext context;
    @Node.Child
    private JSRegExpExecBuiltinNode regExpBuiltinNode;
    @Node.Child
    private PropertyGetNode getExecNode;
    @Node.Child
    private IsJSClassNode isJSRegExpNode;
    @Node.Child
    private IsJSObjectNode isJSObjectNode;
    @Node.Child
    private IsPristineObjectNode isPristineObjectNode;
    @Node.Child
    private IsCallableNode isCallableNode = IsCallableNode.create();
    @Node.Child
    private JSFunctionCallNode specialCallNode;
    private final ConditionProfile isPristineProfile = ConditionProfile.createBinaryProfile();
    private final ConditionProfile isCallableProfile = ConditionProfile.createBinaryProfile();
    private final ConditionProfile validResultProfile = ConditionProfile.createBinaryProfile();
    private final ConditionProfile isRegExpProfile = ConditionProfile.createBinaryProfile();

    JSRegExpExecIntlNode(JSContext context) {
        this.context = context;
    }

    public static JSRegExpExecIntlNode create(JSContext context) {
        return JSRegExpExecIntlNodeGen.create(context);
    }

    public abstract Object execute(DynamicObject var1, String var2);

    @Specialization
    Object doGeneric(DynamicObject regExp, String input) {
        if (this.context.getEcmaScriptVersion() >= 6) {
            if (this.isPristineProfile.profile(this.isPristine(regExp))) {
                return this.executeBuiltIn(regExp, input);
            }
            Object exec = this.getExecProperty(regExp);
            if (this.isCallableProfile.profile(this.isCallable(exec))) {
                return this.callJSFunction(regExp, input, exec);
            }
        }
        if (!this.isRegExpProfile.profile(this.isJSRegExp(regExp))) {
            throw Errors.createTypeError("RegExp expected");
        }
        return this.executeBuiltIn(regExp, input);
    }

    private Object callJSFunction(DynamicObject regExp, String input, Object exec) {
        Object result = this.doCallJSFunction(exec, regExp, input);
        if (this.validResultProfile.profile(result == Null.instance || this.isJSObject(result) && result != Undefined.instance)) {
            return result;
        }
        throw Errors.createTypeError("object or null expected");
    }

    private boolean isPristine(DynamicObject regExp) {
        if (this.isPristineObjectNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.isPristineObjectNode = this.insert(IsPristineObjectNode.createRegExpExecAndMatch(this.context));
        }
        return this.isPristineObjectNode.execute(regExp);
    }

    private Object getExecProperty(DynamicObject regExp) {
        if (this.getExecNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getExecNode = this.insert(PropertyGetNode.create("exec", false, this.context));
        }
        return this.getExecNode.getValue(regExp);
    }

    private boolean isCallable(Object obj) {
        if (this.isCallableNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.isCallableNode = this.insert(IsCallableNode.create());
        }
        return this.isCallableNode.executeBoolean(obj);
    }

    private Object executeBuiltIn(DynamicObject regExp, String input) {
        if (this.regExpBuiltinNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.regExpBuiltinNode = this.insert(JSRegExpExecBuiltinNode.create(this.context));
        }
        return this.regExpBuiltinNode.execute(regExp, input);
    }

    private boolean isJSRegExp(DynamicObject regExp) {
        if (this.isJSRegExpNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.isJSRegExpNode = this.insert(IsJSClassNode.create(JSRegExp.INSTANCE));
        }
        return this.isJSRegExpNode.executeBoolean(regExp);
    }

    private boolean isJSObject(Object obj) {
        if (this.isJSObjectNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.isJSObjectNode = this.insert(IsJSObjectNode.create());
        }
        return this.isJSObjectNode.executeBoolean(obj);
    }

    private Object doCallJSFunction(Object exec, DynamicObject regExp, String input) {
        if (this.specialCallNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.specialCallNode = this.insert(JSFunctionCallNode.createCall());
        }
        return this.specialCallNode.executeCall(JSArguments.createOneArg(regExp, exec, input));
    }

    public static IsJSClassNode createIsJSRegExpNode() {
        return IsJSClassNode.create(JSRegExp.INSTANCE);
    }

    private static Object executeCompiledRegex(Object compiledRegex, String input, long fromIndex, TRegexUtil.TRegexCompiledRegexAccessor compiledRegexAccessor) {
        try {
            return compiledRegexAccessor.exec(compiledRegex, input, fromIndex);
        }
        catch (RuntimeException e) {
            CompilerDirectives.transferToInterpreter();
            throw Errors.createError(e.getMessage());
        }
    }

    @ImportStatic(value={JSRegExp.class, JSRegExpExecIntlNode.class})
    public static abstract class JSRegExpExecBuiltinNode
    extends JavaScriptBaseNode {
        private final JSContext context;
        @Node.Child
        private PropertySetNode setRegexResultNode;
        @Node.Child
        private PropertySetNode setRegexOriginalInputNode;
        @Node.Child
        private DynamicObjectLibrary setInputNode;
        @Node.Child
        private DynamicObjectLibrary setIndexNode;
        @Node.Child
        private DynamicObjectLibrary setGroupsNode;
        @Node.Child
        private DynamicObjectLibrary setIndicesNode;
        @Node.Child
        private DynamicObjectLibrary setIndicesRegexResultNode;
        @Node.Child
        private DynamicObjectLibrary setIndicesGroupsNode;
        private final ConditionProfile invalidLastIndex = ConditionProfile.createBinaryProfile();
        private final ConditionProfile match = ConditionProfile.createCountingProfile();
        private final ConditionProfile stickyProfile = ConditionProfile.createBinaryProfile();
        private final int ecmaScriptVersion;
        @Node.Child
        protected IsJSClassNode isJSRegExpNode;
        @Node.Child
        private JSToLengthNode toLengthNode;
        @Node.Child
        private PropertyGetNode getLastIndexNode;
        @Node.Child
        private PropertySetNode setLastIndexNode;
        @Node.Child
        private TRegexUtil.TRegexCompiledRegexAccessor compiledRegexAccessor = TRegexUtil.TRegexCompiledRegexAccessor.create();
        @Node.Child
        private TRegexUtil.TRegexFlagsAccessor flagsAccessor = TRegexUtil.TRegexFlagsAccessor.create();
        @Node.Child
        private TRegexUtil.TRegexResultAccessor regexResultAccessor = TRegexUtil.TRegexResultAccessor.create();
        @Node.Child
        private BuildGroupsObjectNode groupsBuilder;

        JSRegExpExecBuiltinNode(JSContext context) {
            this.context = context;
            this.ecmaScriptVersion = context.getEcmaScriptVersion();
            this.setRegexResultNode = PropertySetNode.createSetHidden(JSArray.LAZY_REGEX_RESULT_ID, context);
            this.setRegexOriginalInputNode = PropertySetNode.createSetHidden(JSArray.LAZY_REGEX_ORIGINAL_INPUT_ID, context);
            this.setInputNode = JSObjectUtil.createDispatched("input");
            this.setIndexNode = JSObjectUtil.createDispatched("index");
            this.setGroupsNode = JSObjectUtil.createDispatched("groups");
            this.setIndicesNode = JSObjectUtil.createDispatched("indices");
            this.setIndicesRegexResultNode = JSObjectUtil.createDispatched(JSArray.LAZY_REGEX_RESULT_ID);
            this.setIndicesGroupsNode = JSObjectUtil.createDispatched("groups");
        }

        public static JSRegExpExecBuiltinNode create(JSContext context) {
            return JSRegExpExecIntlNodeGen.JSRegExpExecBuiltinNodeGen.create(context);
        }

        private Object getEmptyResult() {
            return this.ecmaScriptVersion >= 6 ? Null.instance : this.context.getTRegexEmptyResult();
        }

        public abstract Object execute(DynamicObject var1, String var2);

        @Specialization(guards={"getCompiledRegex(regExp) == cachedCompiledRegex"})
        Object doCached(DynamicObject regExp, String input, @Cached(value="getCompiledRegex(regExp)") Object cachedCompiledRegex) {
            return this.doExec(regExp, cachedCompiledRegex, input);
        }

        @Specialization(replaces={"doCached"})
        Object doDynamic(DynamicObject regExp, String input) {
            return this.doExec(regExp, JSRegExp.getCompiledRegex(regExp), input);
        }

        private Object doExec(DynamicObject regExp, Object compiledRegex, String input) {
            JSRealm thisRealm;
            Object flags = this.compiledRegexAccessor.flags(compiledRegex);
            boolean global = this.flagsAccessor.global(flags);
            boolean sticky = this.ecmaScriptVersion >= 6 && this.flagsAccessor.sticky(flags);
            long lastIndex = this.getLastIndex(regExp);
            if (global || sticky) {
                if (this.invalidLastIndex.profile(lastIndex < 0L || lastIndex > (long)input.length())) {
                    this.setLastIndex(regExp, 0);
                    return this.getEmptyResult();
                }
            } else {
                lastIndex = 0L;
            }
            Object result = JSRegExpExecIntlNode.executeCompiledRegex(compiledRegex, input, lastIndex, this.compiledRegexAccessor);
            if (this.context.isOptionRegexpStaticResult() && this.regexResultAccessor.isMatch(result) && (thisRealm = this.context.getRealm()) == JSRegExp.getRealm(regExp)) {
                if (JSRegExp.getLegacyFeaturesEnabled(regExp)) {
                    thisRealm.setStaticRegexResult(this.context, compiledRegex, input, lastIndex, result);
                } else {
                    thisRealm.invalidateStaticRegexResult();
                }
            }
            if (this.match.profile(this.regexResultAccessor.isMatch(result))) {
                if (this.stickyProfile.profile(sticky && (long)this.regexResultAccessor.captureGroupStart(result, 0) != lastIndex)) {
                    this.setLastIndex(regExp, 0);
                    return this.getEmptyResult();
                }
                if (global || sticky) {
                    this.setLastIndex(regExp, this.regexResultAccessor.captureGroupEnd(result, 0));
                }
                if (this.ecmaScriptVersion < 6) {
                    return result;
                }
                int groupCount = this.compiledRegexAccessor.groupCount(compiledRegex);
                DynamicObject groups = this.getGroupsObject(regExp, result, input, false);
                DynamicObject indicesGroups = this.getGroupsObject(regExp, result, input, true);
                return this.getMatchResult(result, groupCount, input, groups, indicesGroups);
            }
            if (this.ecmaScriptVersion < 8 || global || sticky) {
                this.setLastIndex(regExp, 0);
            }
            return this.getEmptyResult();
        }

        private DynamicObject getMatchResult(Object regexResult, int groupCount, String inputStr, DynamicObject groups, DynamicObject indicesGroups) {
            DynamicObject resultArray = JSArray.createLazyRegexArray(this.context, groupCount);
            this.setRegexResultNode.setValue(resultArray, regexResult);
            this.setRegexOriginalInputNode.setValue(resultArray, inputStr);
            this.setIndexNode.putConstant(resultArray, "index", JSRegExp.LAZY_INDEX_PROXY, JSAttributes.getDefault() | 0x10);
            this.setInputNode.put(resultArray, "input", inputStr);
            this.setGroupsNode.put(resultArray, "groups", groups);
            if (this.context.isOptionRegexpMatchIndices()) {
                DynamicObject indices = JSArray.createLazyRegexIndicesArray(this.context, groupCount);
                this.setIndicesRegexResultNode.put(indices, JSRegExp.GROUPS_RESULT_ID, regexResult);
                this.setIndicesGroupsNode.put(indices, "groups", indicesGroups);
                this.setIndicesNode.put(resultArray, "indices", indices);
            }
            return resultArray;
        }

        private DynamicObject getGroupsObject(DynamicObject regExp, Object result, String input, boolean isIndices) {
            if (this.groupsBuilder == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.groupsBuilder = this.insert(BuildGroupsObjectNode.create());
            }
            return this.groupsBuilder.execute(this.context, regExp, result, input, isIndices);
        }

        private long getLastIndex(DynamicObject regExp) {
            if (this.getLastIndexNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getLastIndexNode = this.insert(PropertyGetNode.create("lastIndex", false, this.context));
            }
            Object lastIndex = this.getLastIndexNode.getValue(regExp);
            if (this.ecmaScriptVersion < 6) {
                return JSRuntime.toInteger(lastIndex);
            }
            if (this.toLengthNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toLengthNode = this.insert(JSToLengthNode.create());
            }
            return this.toLengthNode.executeLong(lastIndex);
        }

        private void setLastIndex(DynamicObject regExp, int value) {
            if (this.setLastIndexNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.setLastIndexNode = this.insert(PropertySetNode.create("lastIndex", false, this.context, true));
            }
            this.setLastIndexNode.setValueInt(regExp, value);
        }

        protected boolean isJSRegExp(DynamicObject regExp) {
            if (this.isJSRegExpNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.isJSRegExpNode = JSRegExpExecIntlNode.createIsJSRegExpNode();
            }
            return this.isJSRegExpNode.executeBoolean(regExp);
        }
    }

    @ImportStatic(value={JSRegExp.class, JSRegExpExecIntlNode.class})
    public static abstract class BuildGroupsObjectNode
    extends JavaScriptBaseNode {
        public static BuildGroupsObjectNode create() {
            return JSRegExpExecIntlNodeGen.BuildGroupsObjectNodeGen.create();
        }

        public abstract DynamicObject execute(JSContext var1, DynamicObject var2, Object var3, String var4, boolean var5);

        @Specialization(guards={"getGroupsFactory(regExp) == cachedGroupsFactory || getCompiledRegex(regExp) == cachedCompiledRegex"})
        static DynamicObject doCachedGroupsFactory(JSContext context, DynamicObject regExp, Object regexResult, String input, boolean isIndices, @Cached(value="getCompiledRegex(regExp)") Object cachedCompiledRegex, @Cached(value="getGroupsFactory(regExp)") JSObjectFactory cachedGroupsFactory, @Cached(value="createIsJSRegExpNode()") IsJSClassNode isJSRegExpNode) {
            return BuildGroupsObjectNode.doIt(context, cachedGroupsFactory, regexResult, input, isIndices);
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static DynamicObject doVaryingGroupsFactory(JSContext context, DynamicObject regExp, Object regexResult, String input, boolean isIndices) {
            return BuildGroupsObjectNode.doIt(context, JSRegExp.getGroupsFactory(regExp), regexResult, input, isIndices);
        }

        private static DynamicObject doIt(JSContext context, JSObjectFactory groupsFactory, Object regexResult, String input, boolean isIndices) {
            if (groupsFactory == null) {
                return Undefined.instance;
            }
            return JSRegExp.createGroupsObject(context, groupsFactory, regexResult, input, isIndices);
        }
    }

    @ImportStatic(value={JSRegExpExecIntlNode.class})
    public static abstract class JSRegExpExecIntlIgnoreLastIndexNode
    extends JavaScriptBaseNode {
        private final JSContext context;
        private final boolean doStaticResultUpdate;
        private final ValueProfile compiledRegexProfile = ValueProfile.createIdentityProfile();

        JSRegExpExecIntlIgnoreLastIndexNode(JSContext context, boolean doStaticResultUpdate) {
            this.context = context;
            this.doStaticResultUpdate = doStaticResultUpdate;
        }

        public static JSRegExpExecIntlIgnoreLastIndexNode create(JSContext context, boolean doStaticResultUpdate) {
            return JSRegExpExecIntlNodeGen.JSRegExpExecIntlIgnoreLastIndexNodeGen.create(context, doStaticResultUpdate);
        }

        public abstract Object execute(DynamicObject var1, String var2, long var3);

        @Specialization
        Object doGeneric(DynamicObject regExp, String input, long lastIndex, @Cached(value="create()") TRegexUtil.TRegexCompiledRegexAccessor compiledRegexAccessor, @Cached(value="create()") TRegexUtil.TRegexResultAccessor regexResultAccessor) {
            assert (JSRegExp.isJSRegExp(regExp));
            Object compiledRegex = this.compiledRegexProfile.profile(JSRegExp.getCompiledRegex(regExp));
            Object result = JSRegExpExecIntlNode.executeCompiledRegex(compiledRegex, input, lastIndex, compiledRegexAccessor);
            if (this.doStaticResultUpdate && this.context.isOptionRegexpStaticResult() && regexResultAccessor.isMatch(result)) {
                this.context.getRealm().setStaticRegexResult(this.context, compiledRegex, input, lastIndex, result);
            }
            return result;
        }
    }
}

