/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.helper;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSAgentWaiterList;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.array.TypedArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import com.oracle.truffle.js.runtime.builtins.JSSharedArrayBuffer;
import com.oracle.truffle.js.runtime.util.Fences;

public final class SharedMemorySync {
    private SharedMemorySync() {
    }

    @CompilerDirectives.TruffleBoundary
    public static int doVolatileGet(DynamicObject target, int intArrayOffset) {
        Fences.acquireFence();
        TypedArray array = JSArrayBufferView.typedArrayGetArrayType(target);
        TypedArray.TypedIntArray typedArray = (TypedArray.TypedIntArray)array;
        return typedArray.getInt(target, intArrayOffset);
    }

    @CompilerDirectives.TruffleBoundary
    public static BigInt doVolatileGetBigInt(DynamicObject target, int intArrayOffset) {
        Fences.acquireFence();
        TypedArray array = JSArrayBufferView.typedArrayGetArrayType(target);
        TypedArray.TypedBigIntArray typedArray = (TypedArray.TypedBigIntArray)array;
        return typedArray.getBigInt(target, intArrayOffset);
    }

    @CompilerDirectives.TruffleBoundary
    public static void doVolatilePut(DynamicObject target, int index, int value) {
        TypedArray array = JSArrayBufferView.typedArrayGetArrayType(target);
        TypedArray.TypedIntArray typedArray = (TypedArray.TypedIntArray)array;
        typedArray.setInt(target, index, value);
        Fences.releaseFence();
    }

    @CompilerDirectives.TruffleBoundary
    public static void doVolatilePutBigInt(DynamicObject target, int index, BigInt value) {
        TypedArray array = JSArrayBufferView.typedArrayGetArrayType(target);
        TypedArray.TypedBigIntArray typedArray = (TypedArray.TypedBigIntArray)array;
        typedArray.setBigInt(target, index, value);
        Fences.releaseFence();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public static boolean compareAndSwapInt(JSContext cx, DynamicObject target, int intArrayOffset, int initial, int result) {
        cx.getJSAgent().atomicSectionEnter(target);
        try {
            int value = SharedMemorySync.doVolatileGet(target, intArrayOffset);
            if (value == initial) {
                SharedMemorySync.doVolatilePut(target, intArrayOffset, result);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            cx.getJSAgent().atomicSectionLeave(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public static boolean compareAndSwapBigInt(JSContext cx, DynamicObject target, int intArrayOffset, BigInt initial, BigInt result) {
        cx.getJSAgent().atomicSectionEnter(target);
        try {
            BigInt value = SharedMemorySync.doVolatileGetBigInt(target, intArrayOffset);
            if (value.compareTo(initial) == 0) {
                SharedMemorySync.doVolatilePutBigInt(target, intArrayOffset, result);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            cx.getJSAgent().atomicSectionLeave(target);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static long atomicFetchOrGetUnsigned(JSContext cx, DynamicObject target, int intArrayOffset, Object expected, Object replacement) {
        cx.getJSAgent().atomicSectionEnter(target);
        long read = JSRuntime.toUInt32(SharedMemorySync.doVolatileGet(target, intArrayOffset));
        if (read == JSRuntime.toUInt32(expected)) {
            SharedMemorySync.doVolatilePut(target, intArrayOffset, (int)JSRuntime.toUInt32(replacement));
        }
        cx.getJSAgent().atomicSectionLeave(target);
        return read;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public static long atomicFetchOrGetLong(JSContext cx, DynamicObject target, int intArrayOffset, long expected, long replacement) {
        cx.getJSAgent().atomicSectionEnter(target);
        try {
            int read = SharedMemorySync.doVolatileGet(target, intArrayOffset);
            if ((long)read == expected) {
                SharedMemorySync.doVolatilePut(target, intArrayOffset, (int)replacement);
            }
            long l = read;
            return l;
        }
        finally {
            cx.getJSAgent().atomicSectionLeave(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public static int atomicFetchOrGetInt(JSContext cx, DynamicObject target, int intArrayOffset, int expected, int replacement) {
        cx.getJSAgent().atomicSectionEnter(target);
        try {
            int read = SharedMemorySync.doVolatileGet(target, intArrayOffset);
            if (read == expected) {
                SharedMemorySync.doVolatilePut(target, intArrayOffset, replacement);
            }
            int n = read;
            return n;
        }
        finally {
            cx.getJSAgent().atomicSectionLeave(target);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static int atomicFetchOrGetShort(JSContext cx, DynamicObject target, int intArrayOffset, int expected, int replacement, boolean sign) {
        short expectedChopped;
        cx.getJSAgent().atomicSectionEnter(target);
        int read = SharedMemorySync.doVolatileGet(target, intArrayOffset);
        read = sign ? read : read & 0xFFFF;
        short s2 = expectedChopped = sign ? (short)expected : (short)(expected & 0xFFFF);
        if (read == expectedChopped) {
            int signed = sign ? replacement : replacement & 0xFFFF;
            SharedMemorySync.doVolatilePut(target, intArrayOffset, (short)signed);
        }
        cx.getJSAgent().atomicSectionLeave(target);
        return read;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public static int atomicFetchOrGetByte(JSContext cx, DynamicObject target, int intArrayOffset, int expected, int replacement, boolean sign) {
        cx.getJSAgent().atomicSectionEnter(target);
        try {
            byte expectedChopped;
            int read = SharedMemorySync.doVolatileGet(target, intArrayOffset);
            read = sign ? read : read & 0xFF;
            byte by = expectedChopped = sign ? (byte)expected : (byte)(expected & 0xFF);
            if (read == expectedChopped) {
                int signed = sign ? replacement : replacement & 0xFF;
                SharedMemorySync.doVolatilePut(target, intArrayOffset, (byte)signed);
            }
            int n = read;
            return n;
        }
        finally {
            cx.getJSAgent().atomicSectionLeave(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public static BigInt atomicFetchOrGetBigInt(JSContext cx, DynamicObject target, int intArrayOffset, BigInt expected, BigInt replacement) {
        cx.getJSAgent().atomicSectionEnter(target);
        try {
            BigInt read = SharedMemorySync.doVolatileGetBigInt(target, intArrayOffset);
            if (read.compareTo(expected) == 0) {
                SharedMemorySync.doVolatilePutBigInt(target, intArrayOffset, replacement);
            }
            BigInt bigInt = read;
            return bigInt;
        }
        finally {
            cx.getJSAgent().atomicSectionLeave(target);
        }
    }

    public static JSAgentWaiterList.JSAgentWaiterListEntry getWaiterList(JSContext cx, DynamicObject target, int indexPos) {
        DynamicObject arrayBuffer = JSArrayBufferView.getArrayBuffer(target);
        JSAgentWaiterList waiterList = JSSharedArrayBuffer.getWaiterList(arrayBuffer);
        return waiterList.getListForIndex(indexPos);
    }

    @CompilerDirectives.TruffleBoundary
    public static void enterCriticalSection(JSContext cx, JSAgentWaiterList.JSAgentWaiterListEntry wl) {
        assert (!cx.getJSAgent().inCriticalSection());
        cx.getJSAgent().criticalSectionEnter(wl);
    }

    @CompilerDirectives.TruffleBoundary
    public static void leaveCriticalSection(JSContext cx, JSAgentWaiterList.JSAgentWaiterListEntry wl) {
        cx.getJSAgent().criticalSectionLeave(wl);
    }

    public static boolean agentCanSuspend(JSContext cx) {
        return cx.getJSAgent().canBlock();
    }

    @CompilerDirectives.TruffleBoundary
    public static void addWaiter(JSContext cx, JSAgentWaiterList.JSAgentWaiterListEntry wl, int id) {
        assert (cx.getJSAgent().inCriticalSection());
        assert (!wl.contains(id));
        wl.add(id);
    }

    @CompilerDirectives.TruffleBoundary
    public static void removeWaiter(JSContext cx, JSAgentWaiterList.JSAgentWaiterListEntry wl, int w) {
        assert (cx.getJSAgent().inCriticalSection());
        assert (wl.contains(w));
        wl.remove(w);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean suspendAgent(JSContext cx, JSAgentWaiterList.JSAgentWaiterListEntry wl, int w, int timeout) {
        assert (cx.getJSAgent().inCriticalSection());
        assert (wl.contains(w));
        assert (cx.getJSAgent().getSignifier() == w);
        assert (cx.getJSAgent().canBlock());
        cx.getJSAgent().criticalSectionLeave(wl);
        boolean interrupt = false;
        try {
            Thread.sleep(timeout);
        }
        catch (InterruptedException e) {
            interrupt = true;
        }
        cx.getJSAgent().criticalSectionEnter(wl);
        return interrupt;
    }

    @CompilerDirectives.TruffleBoundary
    public static void wakeWaiter(JSContext cx, int w) {
        assert (cx.getJSAgent().inCriticalSection());
        cx.getJSAgent().wakeAgent(w);
    }

    @CompilerDirectives.TruffleBoundary
    public static int[] removeWaiters(JSContext cx, JSAgentWaiterList.JSAgentWaiterListEntry wl, int count) {
        assert (cx.getJSAgent().inCriticalSection());
        int c = Integer.min(wl.size(), count);
        int[] removed = new int[c];
        while (c-- > 0) {
            removed[c] = (Integer)wl.poll();
        }
        return removed;
    }
}

