/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.helper;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.js.runtime.JSRuntime;
import java.util.BitSet;

public final class StringEscape {
    private static final BitSet dontEscapeSet;

    private StringEscape() {
    }

    @CompilerDirectives.TruffleBoundary
    public static String escape(String s2) {
        int len = s2.length();
        StringBuilder out = null;
        for (int i = 0; i < len; ++i) {
            char ch;
            char c = s2.charAt(i);
            if (dontEscapeSet.get(c)) {
                if (out == null) continue;
                out.append(c);
                continue;
            }
            if (out == null) {
                out = StringEscape.allocBuffer(s2, i, len + 16);
            }
            out.append('%');
            if (c < '\u0100') {
                ch = StringEscape.hexChar(c >> 4 & 0xF);
                out.append(ch);
                ch = StringEscape.hexChar(c & 0xF);
                out.append(ch);
                continue;
            }
            out.append('u');
            ch = StringEscape.hexChar(c >> 12 & 0xF);
            out.append(ch);
            ch = StringEscape.hexChar(c >> 8 & 0xF);
            out.append(ch);
            ch = StringEscape.hexChar(c >> 4 & 0xF);
            out.append(ch);
            ch = StringEscape.hexChar(c & 0xF);
            out.append(ch);
        }
        return out != null ? out.toString() : s2;
    }

    @CompilerDirectives.TruffleBoundary
    public static String unescape(String string) {
        int len = string.length();
        StringBuilder builder = null;
        int k = 0;
        while (k < len) {
            char c = string.charAt(k);
            if (c == '%') {
                if (builder == null) {
                    builder = StringEscape.allocBuffer(string, k, len);
                }
                if (k <= len - 6 && StringEscape.unescapeU0000(string, builder, k)) {
                    k += 6;
                    continue;
                }
                if (k <= len - 3 && StringEscape.unescape00(string, builder, k)) {
                    k += 3;
                    continue;
                }
            }
            if (builder != null) {
                builder.append(c);
            }
            ++k;
        }
        return builder != null ? builder.toString() : string;
    }

    private static StringBuilder allocBuffer(String s2, int i, int estimatedLength) {
        StringBuilder newBuffer = new StringBuilder(estimatedLength);
        if (i > 0) {
            newBuffer.append(s2, 0, i);
        }
        return newBuffer;
    }

    private static boolean unescapeU0000(String string, StringBuilder builder, int k) {
        char c1 = string.charAt(k + 1);
        if (c1 == 'u') {
            char c2 = string.charAt(k + 2);
            char c3 = string.charAt(k + 3);
            char c4 = string.charAt(k + 4);
            char c5 = string.charAt(k + 5);
            if (JSRuntime.isHex(c2) && JSRuntime.isHex(c3) && JSRuntime.isHex(c4) && JSRuntime.isHex(c5)) {
                char newC = (char)(StringEscape.hexVal(c2) * 16 * 16 * 16 + StringEscape.hexVal(c3) * 16 * 16 + StringEscape.hexVal(c4) * 16 + StringEscape.hexVal(c5));
                builder.append(newC);
                return true;
            }
        }
        return false;
    }

    private static boolean unescape00(String string, StringBuilder builder, int k) {
        char c1 = string.charAt(k + 1);
        char c2 = string.charAt(k + 2);
        if (JSRuntime.isHex(c1) && JSRuntime.isHex(c2)) {
            char newC = (char)(StringEscape.hexVal(c1) * 16 + StringEscape.hexVal(c2));
            builder.append(newC);
            return true;
        }
        return false;
    }

    private static char hexChar(int value) {
        if (value < 10) {
            return (char)(48 + value);
        }
        return (char)(65 + value - 10);
    }

    private static int hexVal(char c) {
        int value = JSRuntime.valueInHex(c);
        if (value < 0) {
            assert (false) : "not a hex character";
            return 0;
        }
        return value;
    }

    static {
        BitSet unescaped = new BitSet(128);
        unescaped.set(97, 123);
        unescaped.set(65, 91);
        unescaped.set(48, 58);
        unescaped.set(64);
        unescaped.set(42);
        unescaped.set(95);
        unescaped.set(43);
        unescaped.set(45);
        unescaped.set(46);
        unescaped.set(47);
        dontEscapeSet = unescaped;
    }
}

