/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.EnumerateNode;
import com.oracle.truffle.js.nodes.access.GetIteratorNode;
import com.oracle.truffle.js.nodes.access.IsJSObjectNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=GetIteratorNode.class)
public final class GetIteratorNodeGen
extends GetIteratorNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private volatile int state_0_;
    @Node.Child
    private GetIteratorData getIterator_cache;
    @Node.Child
    private EnumerateNode foreignIterable_enumerateNode_;

    private GetIteratorNodeGen(JSContext context, JavaScriptNode objectNode) {
        super(context, objectNode);
    }

    @Override
    public IteratorRecord execute(Object objectNodeValue) {
        int state_0 = this.state_0_;
        if (state_0 != 0) {
            GetIteratorData s1_;
            if ((state_0 & 1) != 0 && (s1_ = this.getIterator_cache) != null && !JSGuards.isForeignObject(objectNodeValue)) {
                return this.doGetIterator(objectNodeValue, s1_.isCallableNode_, s1_.methodCallNode_, s1_.isObjectNode_);
            }
            if ((state_0 & 2) != 0 && JSGuards.isForeignObject(objectNodeValue)) {
                return this.doForeignIterable(objectNodeValue, this.foreignIterable_enumerateNode_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(objectNodeValue);
    }

    @Override
    public IteratorRecord execute(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object objectNodeValue_ = this.objectNode.execute(frameValue);
        if (state_0 != 0) {
            GetIteratorData s1_;
            if ((state_0 & 1) != 0 && (s1_ = this.getIterator_cache) != null && !JSGuards.isForeignObject(objectNodeValue_)) {
                return this.doGetIterator(objectNodeValue_, s1_.isCallableNode_, s1_.methodCallNode_, s1_.isObjectNode_);
            }
            if ((state_0 & 2) != 0 && JSGuards.isForeignObject(objectNodeValue_)) {
                return this.doForeignIterable(objectNodeValue_, this.foreignIterable_enumerateNode_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(objectNodeValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.execute(frameValue);
    }

    private IteratorRecord executeAndSpecialize(Object objectNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state_0 = this.state_0_;
        try {
            if (!JSGuards.isForeignObject(objectNodeValue)) {
                GetIteratorData s1_ = super.insert(new GetIteratorData());
                s1_.isCallableNode_ = s1_.insertAccessor(IsCallableNode.create());
                s1_.methodCallNode_ = s1_.insertAccessor(JSFunctionCallNode.createCall());
                s1_.isObjectNode_ = s1_.insertAccessor(IsJSObjectNode.create());
                this.getIterator_cache = s1_;
                this.state_0_ = state_0 |= 1;
                lock.unlock();
                hasLock = false;
                IteratorRecord iteratorRecord = this.doGetIterator(objectNodeValue, s1_.isCallableNode_, s1_.methodCallNode_, s1_.isObjectNode_);
                return iteratorRecord;
            }
            if (JSGuards.isForeignObject(objectNodeValue)) {
                this.foreignIterable_enumerateNode_ = super.insert(this.createEnumerateValues());
                this.state_0_ = state_0 |= 2;
                lock.unlock();
                hasLock = false;
                IteratorRecord iteratorRecord = this.doForeignIterable(objectNodeValue, this.foreignIterable_enumerateNode_);
                return iteratorRecord;
            }
            throw new UnsupportedSpecializationException(this, new Node[]{this.objectNode}, objectNodeValue);
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if (state_0 == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & state_0 - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        ArrayList<List<JavaScriptBaseNode>> cached;
        Object[] data = new Object[3];
        data[0] = 0;
        int state_0 = this.state_0_;
        Object[] s2 = new Object[3];
        s2[0] = "doGetIterator";
        if ((state_0 & 1) != 0) {
            s2[1] = (byte)1;
            cached = new ArrayList<List<JavaScriptBaseNode>>();
            GetIteratorData s1_ = this.getIterator_cache;
            if (s1_ != null) {
                cached.add(Arrays.asList(s1_.isCallableNode_, s1_.methodCallNode_, s1_.isObjectNode_));
            }
            s2[2] = cached;
        } else {
            s2[1] = (byte)0;
        }
        data[1] = s2;
        s2 = new Object[3];
        s2[0] = "doForeignIterable";
        if ((state_0 & 2) != 0) {
            s2[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.foreignIterable_enumerateNode_));
            s2[2] = cached;
        } else {
            s2[1] = (byte)0;
        }
        data[2] = s2;
        return Introspection.Provider.create(data);
    }

    public static GetIteratorNode create(JSContext context, JavaScriptNode objectNode) {
        return new GetIteratorNodeGen(context, objectNode);
    }

    @GeneratedBy(value=GetIteratorNode.class)
    private static final class GetIteratorData
    extends Node {
        @Node.Child
        IsCallableNode isCallableNode_;
        @Node.Child
        JSFunctionCallNode methodCallNode_;
        @Node.Child
        IsJSObjectNode isObjectNode_;

        GetIteratorData() {
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }
    }
}

