/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.RepeatableNode;
import com.oracle.truffle.js.nodes.access.GetPrototypeNodeGen;
import com.oracle.truffle.js.runtime.builtins.JSProxy;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.util.JSClassProfile;
import java.util.Set;

@GenerateUncached
public abstract class GetPrototypeNode
extends JavaScriptBaseNode {
    static final int MAX_SHAPE_COUNT = 2;

    GetPrototypeNode() {
    }

    protected abstract DynamicObject executeDynamicObject(DynamicObject var1);

    public abstract DynamicObject executeJSObject(Object var1);

    public static GetPrototypeNode create() {
        return GetPrototypeNodeGen.create();
    }

    public static JavaScriptNode create(JavaScriptNode object) {
        assert (object instanceof RepeatableNode);
        class GetPrototypeOfNode
        extends JavaScriptNode
        implements RepeatableNode {
            @Node.Child
            private JavaScriptNode objectNode;
            @Node.Child
            private GetPrototypeNode getPrototypeNode;
            final /* synthetic */ JavaScriptNode val$object;

            GetPrototypeOfNode(JavaScriptNode javaScriptNode) {
                this.val$object = javaScriptNode;
                this.objectNode = this.val$object;
                this.getPrototypeNode = GetPrototypeNode.create();
            }

            @Override
            public DynamicObject execute(VirtualFrame frame) {
                return this.getPrototypeNode.executeJSObject(this.objectNode.execute(frame));
            }

            @Override
            protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
                return new GetPrototypeOfNode(this.val$object);
            }
        }
        return new GetPrototypeOfNode(object);
    }

    static Property getPrototypeProperty(Shape shape) {
        if (JSShape.getJSClass(shape) == JSProxy.INSTANCE) {
            return null;
        }
        return JSShape.getPrototypeProperty(shape);
    }

    @Specialization(guards={"obj.getShape() == shape", "prototypeProperty != null"}, limit="MAX_SHAPE_COUNT")
    static DynamicObject doCachedShape(DynamicObject obj, @Cached(value="obj.getShape()") Shape shape, @Cached(value="getPrototypeProperty(shape)") Property prototypeProperty) {
        assert (!JSGuards.isJSProxy(obj));
        return (DynamicObject)prototypeProperty.get(obj, shape);
    }

    @Specialization(guards={"!isJSProxy(obj)"}, replaces={"doCachedShape"})
    static DynamicObject doGeneric(DynamicObject obj) {
        return JSObjectUtil.getPrototype(obj);
    }

    @Specialization(guards={"isJSProxy(obj)"})
    static DynamicObject doProxy(DynamicObject obj, @Cached(value="create()") JSClassProfile jsclassProfile) {
        return JSObject.getPrototype(obj, jsclassProfile);
    }

    @Specialization(guards={"!isDynamicObject(obj)"})
    static DynamicObject doNotObject(Object obj) {
        return Null.instance;
    }
}

