/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.access.IsJSObjectNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=IsJSObjectNode.class)
public final class IsJSObjectNodeGen
extends IsJSObjectNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private volatile int state_0_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @CompilerDirectives.CompilationFinal
    private IsObjectCachedData isObjectCached_cache;
    @CompilerDirectives.CompilationFinal
    private ConditionProfile isObject_resultProfile_;

    private IsJSObjectNodeGen(boolean includeNullUndefined) {
        super(includeNullUndefined);
    }

    @Override
    @ExplodeLoop
    public boolean executeBoolean(Object arg0Value) {
        int state_0 = this.state_0_;
        if (state_0 != 0) {
            if ((state_0 & 1) != 0) {
                IsObjectCachedData s1_ = this.isObjectCached_cache;
                while (s1_ != null) {
                    assert (s1_.cachedClass_ != null);
                    if (s1_.cachedClass_.isInstance(arg0Value)) {
                        return IsJSObjectNode.isObjectCached(arg0Value, s1_.cachedClass_, s1_.cachedResult_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state_0 & 2) != 0) {
                return this.isObject(arg0Value, this.isObject_resultProfile_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeAndSpecialize(Object arg0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state_0 = this.state_0_;
        int exclude = this.exclude_;
        try {
            if (exclude == 0) {
                Class<?> cachedClass__;
                int count1_ = 0;
                IsObjectCachedData s1_ = this.isObjectCached_cache;
                if ((state_0 & 1) != 0) {
                    while (s1_ != null) {
                        assert (s1_.cachedClass_ != null);
                        if (s1_.cachedClass_.isInstance(arg0Value)) break;
                        s1_ = s1_.next_;
                        ++count1_;
                    }
                }
                if (s1_ == null && (cachedClass__ = JSGuards.getClassIfJSDynamicObject(arg0Value)) != null && cachedClass__.isInstance(arg0Value) && count1_ < 1) {
                    s1_ = new IsObjectCachedData(this.isObjectCached_cache);
                    s1_.cachedClass_ = cachedClass__;
                    s1_.cachedResult_ = this.guardIsJSObject(arg0Value);
                    this.isObjectCached_cache = s1_;
                    this.state_0_ = state_0 |= 1;
                }
                if (s1_ != null) {
                    lock.unlock();
                    hasLock = false;
                    boolean bl = IsJSObjectNode.isObjectCached(arg0Value, s1_.cachedClass_, s1_.cachedResult_);
                    return bl;
                }
            }
            this.isObject_resultProfile_ = ConditionProfile.createBinaryProfile();
            this.exclude_ = exclude |= 1;
            this.isObjectCached_cache = null;
            state_0 &= 0xFFFFFFFE;
            this.state_0_ = state_0 |= 2;
            lock.unlock();
            hasLock = false;
            boolean bl = this.isObject(arg0Value, this.isObject_resultProfile_);
            return bl;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        IsObjectCachedData s1_;
        int state_0 = this.state_0_;
        if (state_0 == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & state_0 - 1) == 0 && ((s1_ = this.isObjectCached_cache) == null || s1_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        ArrayList<List<Object>> cached;
        Object[] data = new Object[3];
        data[0] = 0;
        int state_0 = this.state_0_;
        int exclude = this.exclude_;
        Object[] s2 = new Object[3];
        s2[0] = "isObjectCached";
        if ((state_0 & 1) != 0) {
            s2[1] = (byte)1;
            cached = new ArrayList<List<Object>>();
            IsObjectCachedData s1_ = this.isObjectCached_cache;
            while (s1_ != null) {
                cached.add(Arrays.asList(s1_.cachedClass_, s1_.cachedResult_));
                s1_ = s1_.next_;
            }
            s2[2] = cached;
        } else {
            s2[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[1] = s2;
        s2 = new Object[3];
        s2[0] = "isObject";
        if ((state_0 & 2) != 0) {
            s2[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.isObject_resultProfile_));
            s2[2] = cached;
        } else {
            s2[1] = (byte)0;
        }
        data[2] = s2;
        return Introspection.Provider.create(data);
    }

    public static IsJSObjectNode create(boolean includeNullUndefined) {
        return new IsJSObjectNodeGen(includeNullUndefined);
    }

    @GeneratedBy(value=IsJSObjectNode.class)
    private static final class IsObjectCachedData {
        @CompilerDirectives.CompilationFinal
        IsObjectCachedData next_;
        @CompilerDirectives.CompilationFinal
        Class<?> cachedClass_;
        @CompilerDirectives.CompilationFinal
        boolean cachedResult_;

        IsObjectCachedData(IsObjectCachedData next_) {
            this.next_ = next_;
        }
    }
}

