/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameUtil;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import java.util.List;

public abstract class ScopeFrameNode
extends JavaScriptBaseNode {
    public static final Object PARENT_SCOPE_IDENTIFIER = "<parent>";
    public static final FrameSlot[] EMPTY_FRAME_SLOT_ARRAY = new FrameSlot[0];

    public static ScopeFrameNode createCurrent() {
        return CurrentFrameNode.instance();
    }

    public static ScopeFrameNode create(int frameLevel) {
        return ScopeFrameNode.create(frameLevel, 0, EMPTY_FRAME_SLOT_ARRAY);
    }

    public static ScopeFrameNode create(int frameLevel, int scopeLevel, FrameSlot[] parentSlots) {
        assert (scopeLevel == parentSlots.length);
        if (frameLevel == 0) {
            if (scopeLevel == 0) {
                return CurrentFrameNode.instance();
            }
            return new EnclosingScopeFrameNode(scopeLevel, parentSlots);
        }
        if (scopeLevel == 0) {
            assert (frameLevel > 0);
            return EnclosingFunctionFrameNode.instance(frameLevel);
        }
        return new EnclosingFunctionScopeFrameNode(frameLevel, scopeLevel, parentSlots);
    }

    public static boolean isBlockScopeFrame(Frame frame) {
        List<? extends FrameSlot> slots = frame.getFrameDescriptor().getSlots();
        return !slots.isEmpty() && slots.get(0).getIdentifier() == PARENT_SCOPE_IDENTIFIER;
    }

    public static Frame getBlockScopeParentFrame(Frame frame) {
        FrameSlot parentSlot;
        List<? extends FrameSlot> slots = frame.getFrameDescriptor().getSlots();
        if (!slots.isEmpty() && (parentSlot = slots.get(0)).getIdentifier() == PARENT_SCOPE_IDENTIFIER) {
            return (Frame)FrameUtil.getObjectSafe(frame, parentSlot);
        }
        return null;
    }

    public static Frame getNonBlockScopeParentFrame(Frame frame) {
        Frame parent = frame;
        while (ScopeFrameNode.isBlockScopeFrame(parent)) {
            parent = ScopeFrameNode.getBlockScopeParentFrame(parent);
        }
        return parent;
    }

    public abstract Frame executeFrame(Frame var1);

    @Override
    public final boolean isAdoptable() {
        return false;
    }

    private static final class EnclosingFunctionFrameNode
    extends ScopeFrameNode {
        private final int frameLevel;
        private static final ScopeFrameNode[] STATIC_INSTANCES = new ScopeFrameNode[]{CurrentFrameNode.instance(), new EnclosingFunctionFrameNode(1), new EnclosingFunctionFrameNode(2), new EnclosingFunctionFrameNode(3)};

        private EnclosingFunctionFrameNode(int frameLevel) {
            assert (frameLevel >= 1);
            this.frameLevel = frameLevel;
        }

        static ScopeFrameNode instance(int frameLevel) {
            if (frameLevel < STATIC_INSTANCES.length) {
                return STATIC_INSTANCES[frameLevel];
            }
            return new EnclosingFunctionFrameNode(frameLevel);
        }

        @Override
        @ExplodeLoop
        public Frame executeFrame(Frame frame) {
            MaterializedFrame retFrame = JSFrameUtil.castMaterializedFrame(JSArguments.getEnclosingFrame(frame.getArguments()));
            int level = this.frameLevel;
            if (level > 1) {
                for (int i = 1; i < level; ++i) {
                    retFrame = JSFrameUtil.castMaterializedFrame(JSArguments.getEnclosingFrame(retFrame.getArguments()));
                }
            }
            return retFrame;
        }
    }

    private static final class EnclosingFunctionScopeFrameNode
    extends ScopeFrameNode {
        private final int frameLevel;
        private final int scopeLevel;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final FrameSlot[] parentSlots;

        EnclosingFunctionScopeFrameNode(int frameLevel, int scopeLevel, FrameSlot[] parentSlots) {
            this.frameLevel = frameLevel;
            this.scopeLevel = scopeLevel;
            this.parentSlots = parentSlots;
        }

        @Override
        @ExplodeLoop
        public Frame executeFrame(Frame frame) {
            int i;
            Frame retFrame = frame;
            for (i = 0; i < this.frameLevel; ++i) {
                retFrame = JSFrameUtil.castMaterializedFrame(JSArguments.getEnclosingFrame(retFrame.getArguments()));
            }
            for (i = 0; i < this.scopeLevel; ++i) {
                retFrame = JSFrameUtil.castMaterializedFrame(FrameUtil.getObjectSafe(retFrame, this.parentSlots[i]));
            }
            return retFrame;
        }
    }

    private static final class EnclosingScopeFrameNode
    extends ScopeFrameNode {
        private final int scopeLevel;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final FrameSlot[] parentSlots;

        EnclosingScopeFrameNode(int scopeLevel, FrameSlot[] parentSlots) {
            assert (scopeLevel >= 1);
            this.scopeLevel = scopeLevel;
            this.parentSlots = parentSlots;
        }

        @Override
        @ExplodeLoop
        public Frame executeFrame(Frame frame) {
            Frame retFrame = frame;
            for (int i = 0; i < this.scopeLevel; ++i) {
                retFrame = JSFrameUtil.castMaterializedFrame(FrameUtil.getObjectSafe(retFrame, this.parentSlots[i]));
            }
            return retFrame;
        }
    }

    @NodeInfo(cost=NodeCost.NONE)
    private static final class CurrentFrameNode
    extends ScopeFrameNode {
        private static final ScopeFrameNode INSTANCE = new CurrentFrameNode();

        private CurrentFrameNode() {
        }

        static ScopeFrameNode instance() {
            return INSTANCE;
        }

        @Override
        public Frame executeFrame(Frame frame) {
            return frame;
        }
    }
}

