/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.binary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.binary.JSConcatStringsNodeGen;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.objects.JSLazyString;

public abstract class JSConcatStringsNode
extends JavaScriptBaseNode {
    protected final int stringLengthLimit;

    protected JSConcatStringsNode(int stringLengthLimit) {
        this.stringLengthLimit = stringLengthLimit;
    }

    public static JSConcatStringsNode create(int stringLengthLimit) {
        return JSConcatStringsNodeGen.create(stringLengthLimit);
    }

    public static JSConcatStringsNode create() {
        return JSConcatStringsNode.create(JavaScriptLanguage.getCurrentJSRealm().getContext().getStringLengthLimit());
    }

    public abstract CharSequence executeCharSequence(CharSequence var1, CharSequence var2);

    @Specialization(guards={"isEmptyString(left)"})
    protected static CharSequence doLeftEmpty(CharSequence left, CharSequence right) {
        return right;
    }

    @Specialization(guards={"isEmptyString(right)"})
    protected static CharSequence doRightEmpty(CharSequence left, CharSequence right) {
        return left;
    }

    @Specialization(guards={"!isEmptyString(left)", "!isEmptyString(right)"})
    protected final CharSequence doConcat(CharSequence left, CharSequence right, @Cached(value="createBinaryProfile()") ConditionProfile leftIsString, @Cached(value="createBinaryProfile()") ConditionProfile leftIsLazyString, @Cached(value="createBinaryProfile()") ConditionProfile leftIsFlat, @Cached(value="createBinaryProfile()") ConditionProfile rightIsString, @Cached(value="createBinaryProfile()") ConditionProfile rightIsLazyString, @Cached(value="createBinaryProfile()") ConditionProfile rightIsFlat, @Cached(value="createBinaryProfile()") ConditionProfile stringLength, @Cached(value="createBinaryProfile()") ConditionProfile shortStringAppend, @Cached BranchProfile errorBranch) {
        int leftLength = JSRuntime.length(left, leftIsString, leftIsLazyString);
        int rightLength = JSRuntime.length(right, rightIsString, rightIsLazyString);
        int resultLength = leftLength + rightLength;
        this.validateStringLength(resultLength, errorBranch);
        if (stringLength.profile(resultLength >= 20)) {
            JSLazyString result;
            if (shortStringAppend.profile(leftLength == 1 || rightLength == 1) && (result = JSLazyString.concatToLeafMaybe(left, right, resultLength)) != null) {
                return result;
            }
            return JSLazyString.createChecked(left, right, resultLength);
        }
        String leftString = JSConcatStringsNode.toString(left, leftIsString, leftIsLazyString, leftIsFlat);
        String rightString = JSConcatStringsNode.toString(right, rightIsString, rightIsLazyString, rightIsFlat);
        return Boundaries.stringConcat(leftString, rightString);
    }

    private void validateStringLength(int resultLength, BranchProfile errorBranch) {
        if (CompilerDirectives.injectBranchProbability(1.0E-4, resultLength < 0 || resultLength > this.stringLengthLimit)) {
            errorBranch.enter();
            throw Errors.createRangeErrorInvalidStringLength(this);
        }
    }

    private static String toString(CharSequence cs, ConditionProfile stringProfile, ConditionProfile lazyStringProfile, ConditionProfile flatProfile) {
        if (stringProfile.profile(cs instanceof String)) {
            return (String)cs;
        }
        if (lazyStringProfile.profile(cs instanceof JSLazyString)) {
            return ((JSLazyString)cs).toString(flatProfile);
        }
        return Boundaries.charSequenceToString(cs);
    }

    protected static boolean isEmptyString(CharSequence s2) {
        return s2 instanceof String && ((String)s2).isEmpty();
    }
}

