/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.binary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.binary.JSBinaryNode;
import com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import com.oracle.truffle.js.nodes.control.ResumableNode;
import com.oracle.truffle.js.nodes.control.YieldException;

public abstract class JSLogicalNode
extends JSBinaryNode
implements ResumableNode {
    private static final int RESUME_RIGHT = 1;
    private static final int RESUME_UNEXECUTED = 0;
    private final boolean negate;
    @Node.Child
    private JSToBooleanNode toBooleanCast;
    protected final ConditionProfile canShortCircuit = ConditionProfile.createBinaryProfile();

    public JSLogicalNode(JavaScriptNode left, JavaScriptNode right, boolean negate) {
        super(left, right);
        this.negate = negate;
    }

    protected boolean toBoolean(Object operand) {
        if (this.toBooleanCast == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toBooleanCast = this.insert(JSToBooleanNode.create());
        }
        boolean value = this.toBooleanCast.executeBoolean(operand);
        return this.negate ? !value : value;
    }

    protected boolean useLeftValue(Object leftValue) {
        return this.toBoolean(leftValue);
    }

    @Override
    public final Object execute(VirtualFrame frame) {
        Object leftValue = this.getLeft().execute(frame);
        if (this.canShortCircuit.profile(this.useLeftValue(leftValue))) {
            return leftValue;
        }
        return this.getRight().execute(frame);
    }

    @Override
    public Object resume(VirtualFrame frame) {
        int state = this.getStateAsIntAndReset(frame);
        if (state == 0) {
            Object leftValue = this.getLeft().execute(frame);
            if (this.canShortCircuit.profile(this.useLeftValue(leftValue))) {
                return leftValue;
            }
            try {
                return this.getRight().execute(frame);
            }
            catch (YieldException e) {
                this.setState(frame, 1);
                throw e;
            }
        }
        assert (state == 1);
        try {
            return this.getRight().execute(frame);
        }
        catch (YieldException e) {
            this.setState(frame, 1);
            throw e;
        }
    }
}

