/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.GetIteratorNode;
import com.oracle.truffle.js.nodes.access.IteratorCloseNode;
import com.oracle.truffle.js.nodes.access.IteratorStepNode;
import com.oracle.truffle.js.nodes.access.IteratorValueNode;
import com.oracle.truffle.js.nodes.cast.JSStringListFromIterableNode;
import com.oracle.truffle.js.runtime.JSContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSStringListFromIterableNode.class)
public final class JSStringListFromIterableNodeGen
extends JSStringListFromIterableNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private volatile int state_0_;
    @Node.Child
    private ToArrayData toArray_cache;

    private JSStringListFromIterableNodeGen(JSContext context) {
        super(context);
    }

    @Override
    public List<String> executeIterable(Object arg0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 1) != 0 && JSGuards.isString(arg0Value)) {
            return JSStringListFromIterableNode.stringToList(arg0Value);
        }
        if ((state_0 & 2) != 0 && JSTypes.isDynamicObject(arg0Value)) {
            DynamicObject arg0Value_ = (DynamicObject)arg0Value;
            ToArrayData s2_ = this.toArray_cache;
            if (s2_ != null && !JSGuards.isUndefined(arg0Value_) && !JSGuards.isString(arg0Value_)) {
                return JSStringListFromIterableNode.toArray(arg0Value_, s2_.getIteratorNode_, s2_.iteratorStepNode_, s2_.iteratorValueNode_, s2_.iteratorCloseNode_);
            }
        }
        if ((state_0 & 4) != 0 && JSGuards.isUndefined(arg0Value)) {
            return this.doUndefined(arg0Value);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    private List<String> executeAndSpecialize(Object arg0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state_0 = this.state_0_;
        try {
            DynamicObject arg0Value_;
            if (JSGuards.isString(arg0Value)) {
                this.state_0_ = state_0 |= 1;
                lock.unlock();
                hasLock = false;
                List<String> list = JSStringListFromIterableNode.stringToList(arg0Value);
                return list;
            }
            if (JSTypes.isDynamicObject(arg0Value) && !JSGuards.isUndefined(arg0Value_ = (DynamicObject)arg0Value) && !JSGuards.isString(arg0Value_)) {
                ToArrayData s2_ = super.insert(new ToArrayData());
                s2_.getIteratorNode_ = s2_.insertAccessor(GetIteratorNode.create(this.context));
                s2_.iteratorStepNode_ = s2_.insertAccessor(IteratorStepNode.create(this.context));
                s2_.iteratorValueNode_ = s2_.insertAccessor(IteratorValueNode.create(this.context));
                s2_.iteratorCloseNode_ = s2_.insertAccessor(IteratorCloseNode.create(this.context));
                this.toArray_cache = s2_;
                this.state_0_ = state_0 |= 2;
                lock.unlock();
                hasLock = false;
                List<String> list = JSStringListFromIterableNode.toArray(arg0Value_, s2_.getIteratorNode_, s2_.iteratorStepNode_, s2_.iteratorValueNode_, s2_.iteratorCloseNode_);
                return list;
            }
            if (JSGuards.isUndefined(arg0Value)) {
                this.state_0_ = state_0 |= 4;
                lock.unlock();
                hasLock = false;
                List<String> list = this.doUndefined(arg0Value);
                return list;
            }
            throw new UnsupportedSpecializationException(this, new Node[]{null}, arg0Value);
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if (state_0 == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & state_0 - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        Object[] data = new Object[4];
        data[0] = 0;
        int state_0 = this.state_0_;
        Object[] s2 = new Object[3];
        s2[0] = "stringToList";
        s2[1] = (state_0 & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s2;
        s2 = new Object[3];
        s2[0] = "toArray";
        if ((state_0 & 2) != 0) {
            s2[1] = (byte)1;
            ArrayList<List<JavaScriptBaseNode>> cached = new ArrayList<List<JavaScriptBaseNode>>();
            ToArrayData s2_ = this.toArray_cache;
            if (s2_ != null) {
                cached.add(Arrays.asList(s2_.getIteratorNode_, s2_.iteratorStepNode_, s2_.iteratorValueNode_, s2_.iteratorCloseNode_));
            }
            s2[2] = cached;
        } else {
            s2[1] = (byte)0;
        }
        data[2] = s2;
        s2 = new Object[3];
        s2[0] = "doUndefined";
        s2[1] = (state_0 & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s2;
        return Introspection.Provider.create(data);
    }

    public static JSStringListFromIterableNode create(JSContext context) {
        return new JSStringListFromIterableNodeGen(context);
    }

    @GeneratedBy(value=JSStringListFromIterableNode.class)
    private static final class ToArrayData
    extends Node {
        @Node.Child
        GetIteratorNode getIteratorNode_;
        @Node.Child
        IteratorStepNode iteratorStepNode_;
        @Node.Child
        IteratorValueNode iteratorValueNode_;
        @Node.Child
        IteratorCloseNode iteratorCloseNode_;

        ToArrayData() {
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }
    }
}

