/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.cast.JSStringToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToDoubleNode;
import com.oracle.truffle.js.nodes.cast.JSToInt32Node;
import com.oracle.truffle.js.nodes.cast.JSToPrimitiveNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.SafeInteger;
import com.oracle.truffle.js.runtime.Symbol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSToInt32Node.class)
public final class JSToInt32NodeGen
extends JSToInt32Node
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private volatile int state_0_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @Node.Child
    private JSStringToNumberNode string_stringToNumberNode_;
    @Node.Child
    private JSToDoubleNode jSObject_toDoubleNode_;
    @Node.Child
    private JSToPrimitiveNode foreignObject_toPrimitiveNode_;
    @Node.Child
    private JSToInt32Node foreignObject_toInt32Node_;

    private JSToInt32NodeGen(JavaScriptNode operand) {
        super(operand);
    }

    @Override
    public Object execute(VirtualFrame frameValue, Object operandNodeValue) {
        DynamicObject operandNodeValue_;
        long operandNodeValue_2;
        int state_0 = this.state_0_;
        if ((state_0 & 1) != 0 && operandNodeValue instanceof Integer) {
            int operandNodeValue_3 = (Integer)operandNodeValue;
            return this.doInteger(operandNodeValue_3);
        }
        if ((state_0 & 2) != 0 && operandNodeValue instanceof SafeInteger) {
            SafeInteger operandNodeValue_4 = (SafeInteger)operandNodeValue;
            return this.doSafeInteger(operandNodeValue_4);
        }
        if ((state_0 & 4) != 0 && operandNodeValue instanceof Boolean) {
            boolean operandNodeValue_5 = (Boolean)operandNodeValue;
            return this.doBoolean(operandNodeValue_5);
        }
        if ((state_0 & 8) != 0 && operandNodeValue instanceof Long && JSGuards.isLongRepresentableAsInt32(operandNodeValue_2 = ((Long)operandNodeValue).longValue())) {
            return this.doLong(operandNodeValue_2);
        }
        if ((state_0 & 0xF0) != 0 && JSTypesGen.isImplicitDouble((state_0 & 0x78000) >>> 15, operandNodeValue)) {
            double operandNodeValue_6 = JSTypesGen.asImplicitDouble((state_0 & 0x78000) >>> 15, operandNodeValue);
            if ((state_0 & 0x10) != 0 && !JSGuards.isDoubleLargerThan2e32(operandNodeValue_6)) {
                return this.doDoubleFitsInt(operandNodeValue_6);
            }
            if ((state_0 & 0x20) != 0 && JSGuards.isDoubleLargerThan2e32(operandNodeValue_6) && JSGuards.isDoubleRepresentableAsLong(operandNodeValue_6) && JSGuards.isDoubleSafeInteger(operandNodeValue_6)) {
                return this.doDoubleRepresentableAsSafeInteger(operandNodeValue_6);
            }
            if ((state_0 & 0x40) != 0 && JSGuards.isDoubleLargerThan2e32(operandNodeValue_6) && JSGuards.isDoubleRepresentableAsLong(operandNodeValue_6)) {
                return this.doDoubleRepresentableAsLong(operandNodeValue_6);
            }
            if ((state_0 & 0x80) != 0 && JSGuards.isDoubleLargerThan2e32(operandNodeValue_6) && !JSGuards.isDoubleRepresentableAsLong(operandNodeValue_6)) {
                return this.doDouble(operandNodeValue_6);
            }
        }
        if ((state_0 & 0x300) != 0) {
            if ((state_0 & 0x100) != 0 && JSGuards.isUndefined(operandNodeValue)) {
                return this.doUndefined(operandNodeValue);
            }
            if ((state_0 & 0x200) != 0 && JSGuards.isJSNull(operandNodeValue)) {
                return this.doNull(operandNodeValue);
            }
        }
        if ((state_0 & 0x400) != 0 && JSTypesGen.isImplicitString((state_0 & 0x380000) >>> 19, operandNodeValue)) {
            String operandNodeValue_7 = JSTypesGen.asImplicitString((state_0 & 0x380000) >>> 19, operandNodeValue);
            return this.doString(operandNodeValue_7, this.string_stringToNumberNode_);
        }
        if ((state_0 & 0x800) != 0 && operandNodeValue instanceof Symbol) {
            Symbol operandNodeValue_8 = (Symbol)operandNodeValue;
            return this.doSymbol(operandNodeValue_8);
        }
        if ((state_0 & 0x1000) != 0 && operandNodeValue instanceof BigInt) {
            BigInt operandNodeValue_9 = (BigInt)operandNodeValue;
            return this.doBigInt(operandNodeValue_9);
        }
        if ((state_0 & 0x2000) != 0 && JSTypes.isDynamicObject(operandNodeValue) && JSGuards.isJSObject(operandNodeValue_ = (DynamicObject)operandNodeValue)) {
            return this.doJSObject(operandNodeValue_, this.jSObject_toDoubleNode_);
        }
        if ((state_0 & 0x4000) != 0 && JSGuards.isForeignObject(operandNodeValue)) {
            return JSToInt32Node.doForeignObject(operandNodeValue, this.foreignObject_toPrimitiveNode_, this.foreignObject_toInt32Node_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(operandNodeValue);
    }

    @Override
    public int executeInt(Object operandNodeValue) {
        DynamicObject operandNodeValue_;
        long operandNodeValue_2;
        int state_0 = this.state_0_;
        if ((state_0 & 1) != 0 && operandNodeValue instanceof Integer) {
            int operandNodeValue_3 = (Integer)operandNodeValue;
            return this.doInteger(operandNodeValue_3);
        }
        if ((state_0 & 2) != 0 && operandNodeValue instanceof SafeInteger) {
            SafeInteger operandNodeValue_4 = (SafeInteger)operandNodeValue;
            return this.doSafeInteger(operandNodeValue_4);
        }
        if ((state_0 & 4) != 0 && operandNodeValue instanceof Boolean) {
            boolean operandNodeValue_5 = (Boolean)operandNodeValue;
            return this.doBoolean(operandNodeValue_5);
        }
        if ((state_0 & 8) != 0 && operandNodeValue instanceof Long && JSGuards.isLongRepresentableAsInt32(operandNodeValue_2 = ((Long)operandNodeValue).longValue())) {
            return this.doLong(operandNodeValue_2);
        }
        if ((state_0 & 0xF0) != 0 && JSTypesGen.isImplicitDouble((state_0 & 0x78000) >>> 15, operandNodeValue)) {
            double operandNodeValue_6 = JSTypesGen.asImplicitDouble((state_0 & 0x78000) >>> 15, operandNodeValue);
            if ((state_0 & 0x10) != 0 && !JSGuards.isDoubleLargerThan2e32(operandNodeValue_6)) {
                return this.doDoubleFitsInt(operandNodeValue_6);
            }
            if ((state_0 & 0x20) != 0 && JSGuards.isDoubleLargerThan2e32(operandNodeValue_6) && JSGuards.isDoubleRepresentableAsLong(operandNodeValue_6) && JSGuards.isDoubleSafeInteger(operandNodeValue_6)) {
                return this.doDoubleRepresentableAsSafeInteger(operandNodeValue_6);
            }
            if ((state_0 & 0x40) != 0 && JSGuards.isDoubleLargerThan2e32(operandNodeValue_6) && JSGuards.isDoubleRepresentableAsLong(operandNodeValue_6)) {
                return this.doDoubleRepresentableAsLong(operandNodeValue_6);
            }
            if ((state_0 & 0x80) != 0 && JSGuards.isDoubleLargerThan2e32(operandNodeValue_6) && !JSGuards.isDoubleRepresentableAsLong(operandNodeValue_6)) {
                return this.doDouble(operandNodeValue_6);
            }
        }
        if ((state_0 & 0x300) != 0) {
            if ((state_0 & 0x100) != 0 && JSGuards.isUndefined(operandNodeValue)) {
                return this.doUndefined(operandNodeValue);
            }
            if ((state_0 & 0x200) != 0 && JSGuards.isJSNull(operandNodeValue)) {
                return this.doNull(operandNodeValue);
            }
        }
        if ((state_0 & 0x400) != 0 && JSTypesGen.isImplicitString((state_0 & 0x380000) >>> 19, operandNodeValue)) {
            String operandNodeValue_7 = JSTypesGen.asImplicitString((state_0 & 0x380000) >>> 19, operandNodeValue);
            return this.doString(operandNodeValue_7, this.string_stringToNumberNode_);
        }
        if ((state_0 & 0x800) != 0 && operandNodeValue instanceof Symbol) {
            Symbol operandNodeValue_8 = (Symbol)operandNodeValue;
            return this.doSymbol(operandNodeValue_8);
        }
        if ((state_0 & 0x1000) != 0 && operandNodeValue instanceof BigInt) {
            BigInt operandNodeValue_9 = (BigInt)operandNodeValue;
            return this.doBigInt(operandNodeValue_9);
        }
        if ((state_0 & 0x2000) != 0 && JSTypes.isDynamicObject(operandNodeValue) && JSGuards.isJSObject(operandNodeValue_ = (DynamicObject)operandNodeValue)) {
            return this.doJSObject(operandNodeValue_, this.jSObject_toDoubleNode_);
        }
        if ((state_0 & 0x4000) != 0 && JSGuards.isForeignObject(operandNodeValue)) {
            return JSToInt32Node.doForeignObject(operandNodeValue, this.foreignObject_toPrimitiveNode_, this.foreignObject_toInt32Node_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(operandNodeValue);
    }

    @Override
    public int executeInt(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0x7FFE) == 0 && (state_0 & Short.MAX_VALUE) != 0) {
            return this.executeInt_int0(state_0, frameValue);
        }
        if ((state_0 & 0x7FFB) == 0 && (state_0 & Short.MAX_VALUE) != 0) {
            return this.executeInt_boolean1(state_0, frameValue);
        }
        if ((state_0 & 0x7FF7) == 0 && (state_0 & Short.MAX_VALUE) != 0) {
            return this.executeInt_long2(state_0, frameValue);
        }
        if ((state_0 & 0x7F0F) == 0 && (state_0 & Short.MAX_VALUE) != 0) {
            return this.executeInt_double3(state_0, frameValue);
        }
        return this.executeInt_generic4(state_0, frameValue);
    }

    private int executeInt_int0(int state_0, VirtualFrame frameValue) {
        int operandNodeValue_;
        try {
            operandNodeValue_ = this.operandNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state_0 & 1) != 0);
        return this.doInteger(operandNodeValue_);
    }

    private int executeInt_boolean1(int state_0, VirtualFrame frameValue) {
        boolean operandNodeValue_;
        try {
            operandNodeValue_ = this.operandNode.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state_0 & 4) != 0);
        return this.doBoolean(operandNodeValue_);
    }

    private int executeInt_long2(int state_0, VirtualFrame frameValue) {
        long operandNodeValue_;
        try {
            operandNodeValue_ = this.operandNode.executeLong(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state_0 & 8) != 0);
        if (JSGuards.isLongRepresentableAsInt32(operandNodeValue_)) {
            return this.doLong(operandNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(operandNodeValue_);
    }

    private int executeInt_double3(int state_0, VirtualFrame frameValue) {
        double operandNodeValue_;
        int operandNodeValue_int = 0;
        long operandNodeValue_long = 0L;
        try {
            if ((state_0 & 0x70000) == 0 && (state_0 & Short.MAX_VALUE) != 0) {
                operandNodeValue_long = this.operandNode.executeLong(frameValue);
                operandNodeValue_ = JSTypes.longToDouble(operandNodeValue_long);
            } else if ((state_0 & 0x68000) == 0 && (state_0 & Short.MAX_VALUE) != 0) {
                operandNodeValue_int = this.operandNode.executeInt(frameValue);
                operandNodeValue_ = JSTypes.intToDouble(operandNodeValue_int);
            } else if ((state_0 & 0x58000) == 0 && (state_0 & Short.MAX_VALUE) != 0) {
                operandNodeValue_ = this.operandNode.executeDouble(frameValue);
            } else {
                Object operandNodeValue__ = this.operandNode.execute(frameValue);
                operandNodeValue_ = JSTypesGen.expectImplicitDouble((state_0 & 0x78000) >>> 15, operandNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        if ((state_0 & 0x10) != 0 && !JSGuards.isDoubleLargerThan2e32(operandNodeValue_)) {
            return this.doDoubleFitsInt(operandNodeValue_);
        }
        if ((state_0 & 0x20) != 0 && JSGuards.isDoubleLargerThan2e32(operandNodeValue_) && JSGuards.isDoubleRepresentableAsLong(operandNodeValue_) && JSGuards.isDoubleSafeInteger(operandNodeValue_)) {
            return this.doDoubleRepresentableAsSafeInteger(operandNodeValue_);
        }
        if ((state_0 & 0x40) != 0 && JSGuards.isDoubleLargerThan2e32(operandNodeValue_) && JSGuards.isDoubleRepresentableAsLong(operandNodeValue_)) {
            return this.doDoubleRepresentableAsLong(operandNodeValue_);
        }
        if ((state_0 & 0x80) != 0 && JSGuards.isDoubleLargerThan2e32(operandNodeValue_) && !JSGuards.isDoubleRepresentableAsLong(operandNodeValue_)) {
            return this.doDouble(operandNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize((state_0 & 0x70000) == 0 && (state_0 & Short.MAX_VALUE) != 0 ? (Number)operandNodeValue_long : (Number)((state_0 & 0x68000) == 0 && (state_0 & Short.MAX_VALUE) != 0 ? (Number)operandNodeValue_int : (Number)operandNodeValue_));
    }

    private int executeInt_generic4(int state_0, VirtualFrame frameValue) {
        DynamicObject operandNodeValue__;
        long operandNodeValue__2;
        Object operandNodeValue_ = this.operandNode.execute(frameValue);
        if ((state_0 & 1) != 0 && operandNodeValue_ instanceof Integer) {
            int operandNodeValue__3 = (Integer)operandNodeValue_;
            return this.doInteger(operandNodeValue__3);
        }
        if ((state_0 & 2) != 0 && operandNodeValue_ instanceof SafeInteger) {
            SafeInteger operandNodeValue__4 = (SafeInteger)operandNodeValue_;
            return this.doSafeInteger(operandNodeValue__4);
        }
        if ((state_0 & 4) != 0 && operandNodeValue_ instanceof Boolean) {
            boolean operandNodeValue__5 = (Boolean)operandNodeValue_;
            return this.doBoolean(operandNodeValue__5);
        }
        if ((state_0 & 8) != 0 && operandNodeValue_ instanceof Long && JSGuards.isLongRepresentableAsInt32(operandNodeValue__2 = ((Long)operandNodeValue_).longValue())) {
            return this.doLong(operandNodeValue__2);
        }
        if ((state_0 & 0xF0) != 0 && JSTypesGen.isImplicitDouble((state_0 & 0x78000) >>> 15, operandNodeValue_)) {
            double operandNodeValue__6 = JSTypesGen.asImplicitDouble((state_0 & 0x78000) >>> 15, operandNodeValue_);
            if ((state_0 & 0x10) != 0 && !JSGuards.isDoubleLargerThan2e32(operandNodeValue__6)) {
                return this.doDoubleFitsInt(operandNodeValue__6);
            }
            if ((state_0 & 0x20) != 0 && JSGuards.isDoubleLargerThan2e32(operandNodeValue__6) && JSGuards.isDoubleRepresentableAsLong(operandNodeValue__6) && JSGuards.isDoubleSafeInteger(operandNodeValue__6)) {
                return this.doDoubleRepresentableAsSafeInteger(operandNodeValue__6);
            }
            if ((state_0 & 0x40) != 0 && JSGuards.isDoubleLargerThan2e32(operandNodeValue__6) && JSGuards.isDoubleRepresentableAsLong(operandNodeValue__6)) {
                return this.doDoubleRepresentableAsLong(operandNodeValue__6);
            }
            if ((state_0 & 0x80) != 0 && JSGuards.isDoubleLargerThan2e32(operandNodeValue__6) && !JSGuards.isDoubleRepresentableAsLong(operandNodeValue__6)) {
                return this.doDouble(operandNodeValue__6);
            }
        }
        if ((state_0 & 0x300) != 0) {
            if ((state_0 & 0x100) != 0 && JSGuards.isUndefined(operandNodeValue_)) {
                return this.doUndefined(operandNodeValue_);
            }
            if ((state_0 & 0x200) != 0 && JSGuards.isJSNull(operandNodeValue_)) {
                return this.doNull(operandNodeValue_);
            }
        }
        if ((state_0 & 0x400) != 0 && JSTypesGen.isImplicitString((state_0 & 0x380000) >>> 19, operandNodeValue_)) {
            String operandNodeValue__7 = JSTypesGen.asImplicitString((state_0 & 0x380000) >>> 19, operandNodeValue_);
            return this.doString(operandNodeValue__7, this.string_stringToNumberNode_);
        }
        if ((state_0 & 0x800) != 0 && operandNodeValue_ instanceof Symbol) {
            Symbol operandNodeValue__8 = (Symbol)operandNodeValue_;
            return this.doSymbol(operandNodeValue__8);
        }
        if ((state_0 & 0x1000) != 0 && operandNodeValue_ instanceof BigInt) {
            BigInt operandNodeValue__9 = (BigInt)operandNodeValue_;
            return this.doBigInt(operandNodeValue__9);
        }
        if ((state_0 & 0x2000) != 0 && JSTypes.isDynamicObject(operandNodeValue_) && JSGuards.isJSObject(operandNodeValue__ = (DynamicObject)operandNodeValue_)) {
            return this.doJSObject(operandNodeValue__, this.jSObject_toDoubleNode_);
        }
        if ((state_0 & 0x4000) != 0 && JSGuards.isForeignObject(operandNodeValue_)) {
            return JSToInt32Node.doForeignObject(operandNodeValue_, this.foreignObject_toPrimitiveNode_, this.foreignObject_toInt32Node_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(operandNodeValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.executeInt(frameValue);
    }

    private int executeAndSpecialize(Object operandNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state_0 = this.state_0_;
        int exclude = this.exclude_;
        try {
            DynamicObject operandNodeValue_;
            long operandNodeValue_2;
            if (operandNodeValue instanceof Integer) {
                int operandNodeValue_3 = (Integer)operandNodeValue;
                this.state_0_ = state_0 |= 1;
                lock.unlock();
                hasLock = false;
                int n = this.doInteger(operandNodeValue_3);
                return n;
            }
            if (operandNodeValue instanceof SafeInteger) {
                SafeInteger operandNodeValue_4 = (SafeInteger)operandNodeValue;
                this.state_0_ = state_0 |= 2;
                lock.unlock();
                hasLock = false;
                int n = this.doSafeInteger(operandNodeValue_4);
                return n;
            }
            if (operandNodeValue instanceof Boolean) {
                boolean operandNodeValue_5 = (Boolean)operandNodeValue;
                this.state_0_ = state_0 |= 4;
                lock.unlock();
                hasLock = false;
                int n = this.doBoolean(operandNodeValue_5);
                return n;
            }
            if (operandNodeValue instanceof Long && JSGuards.isLongRepresentableAsInt32(operandNodeValue_2 = ((Long)operandNodeValue).longValue())) {
                this.state_0_ = state_0 |= 8;
                lock.unlock();
                hasLock = false;
                int n = this.doLong(operandNodeValue_2);
                return n;
            }
            int doubleCast0 = JSTypesGen.specializeImplicitDouble(operandNodeValue);
            if (doubleCast0 != 0) {
                double operandNodeValue_6 = JSTypesGen.asImplicitDouble(doubleCast0, operandNodeValue);
                if (!JSGuards.isDoubleLargerThan2e32(operandNodeValue_6)) {
                    state_0 |= doubleCast0 << 15;
                    this.state_0_ = state_0 |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    int n = this.doDoubleFitsInt(operandNodeValue_6);
                    return n;
                }
                if (exclude == 0 && JSGuards.isDoubleLargerThan2e32(operandNodeValue_6) && JSGuards.isDoubleRepresentableAsLong(operandNodeValue_6) && JSGuards.isDoubleSafeInteger(operandNodeValue_6)) {
                    state_0 |= doubleCast0 << 15;
                    this.state_0_ = state_0 |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    int n = this.doDoubleRepresentableAsSafeInteger(operandNodeValue_6);
                    return n;
                }
                if (JSGuards.isDoubleLargerThan2e32(operandNodeValue_6) && JSGuards.isDoubleRepresentableAsLong(operandNodeValue_6)) {
                    this.exclude_ = exclude |= 1;
                    state_0 &= 0xFFFFFFDF;
                    state_0 |= doubleCast0 << 15;
                    this.state_0_ = state_0 |= 0x40;
                    lock.unlock();
                    hasLock = false;
                    int n = this.doDoubleRepresentableAsLong(operandNodeValue_6);
                    return n;
                }
                if (JSGuards.isDoubleLargerThan2e32(operandNodeValue_6) && !JSGuards.isDoubleRepresentableAsLong(operandNodeValue_6)) {
                    state_0 |= doubleCast0 << 15;
                    this.state_0_ = state_0 |= 0x80;
                    lock.unlock();
                    hasLock = false;
                    int n = this.doDouble(operandNodeValue_6);
                    return n;
                }
            }
            if (JSGuards.isUndefined(operandNodeValue)) {
                this.state_0_ = state_0 |= 0x100;
                lock.unlock();
                hasLock = false;
                doubleCast0 = this.doUndefined(operandNodeValue);
                return doubleCast0;
            }
            if (JSGuards.isJSNull(operandNodeValue)) {
                this.state_0_ = state_0 |= 0x200;
                lock.unlock();
                hasLock = false;
                doubleCast0 = this.doNull(operandNodeValue);
                return doubleCast0;
            }
            int stringCast0 = JSTypesGen.specializeImplicitString(operandNodeValue);
            if (stringCast0 != 0) {
                String operandNodeValue_7 = JSTypesGen.asImplicitString(stringCast0, operandNodeValue);
                this.string_stringToNumberNode_ = super.insert(JSStringToNumberNode.create());
                state_0 |= stringCast0 << 19;
                this.state_0_ = state_0 |= 0x400;
                lock.unlock();
                hasLock = false;
                int n = this.doString(operandNodeValue_7, this.string_stringToNumberNode_);
                return n;
            }
            if (operandNodeValue instanceof Symbol) {
                Symbol operandNodeValue_8 = (Symbol)operandNodeValue;
                this.state_0_ = state_0 |= 0x800;
                lock.unlock();
                hasLock = false;
                int n = this.doSymbol(operandNodeValue_8);
                return n;
            }
            if (operandNodeValue instanceof BigInt) {
                BigInt operandNodeValue_9 = (BigInt)operandNodeValue;
                this.state_0_ = state_0 |= 0x1000;
                lock.unlock();
                hasLock = false;
                int n = this.doBigInt(operandNodeValue_9);
                return n;
            }
            if (JSTypes.isDynamicObject(operandNodeValue) && JSGuards.isJSObject(operandNodeValue_ = (DynamicObject)operandNodeValue)) {
                this.jSObject_toDoubleNode_ = super.insert(JSToDoubleNode.create());
                this.state_0_ = state_0 |= 0x2000;
                lock.unlock();
                hasLock = false;
                int n = this.doJSObject(operandNodeValue_, this.jSObject_toDoubleNode_);
                return n;
            }
            if (JSGuards.isForeignObject(operandNodeValue)) {
                this.foreignObject_toPrimitiveNode_ = super.insert(JSToPrimitiveNode.createHintNumber());
                this.foreignObject_toInt32Node_ = super.insert(JSToInt32Node.create());
                this.state_0_ = state_0 |= 0x4000;
                lock.unlock();
                hasLock = false;
                int n = JSToInt32Node.doForeignObject(operandNodeValue, this.foreignObject_toPrimitiveNode_, this.foreignObject_toInt32Node_);
                return n;
            }
            throw new UnsupportedSpecializationException(this, new Node[]{this.operandNode}, operandNodeValue);
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & Short.MAX_VALUE) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & Short.MAX_VALUE & (state_0 & Short.MAX_VALUE) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        ArrayList<List<JavaScriptBaseNode>> cached;
        Object[] data = new Object[16];
        data[0] = 0;
        int state_0 = this.state_0_;
        int exclude = this.exclude_;
        Object[] s2 = new Object[3];
        s2[0] = "doInteger";
        s2[1] = (state_0 & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s2;
        s2 = new Object[3];
        s2[0] = "doSafeInteger";
        s2[1] = (state_0 & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s2;
        s2 = new Object[3];
        s2[0] = "doBoolean";
        s2[1] = (state_0 & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s2;
        s2 = new Object[3];
        s2[0] = "doLong";
        s2[1] = (state_0 & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[4] = s2;
        s2 = new Object[3];
        s2[0] = "doDoubleFitsInt";
        s2[1] = (state_0 & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[5] = s2;
        s2 = new Object[3];
        s2[0] = "doDoubleRepresentableAsSafeInteger";
        s2[1] = (state_0 & 0x20) != 0 ? Byte.valueOf((byte)1) : (exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[6] = s2;
        s2 = new Object[3];
        s2[0] = "doDoubleRepresentableAsLong";
        s2[1] = (state_0 & 0x40) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[7] = s2;
        s2 = new Object[3];
        s2[0] = "doDouble";
        s2[1] = (state_0 & 0x80) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[8] = s2;
        s2 = new Object[3];
        s2[0] = "doUndefined";
        s2[1] = (state_0 & 0x100) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[9] = s2;
        s2 = new Object[3];
        s2[0] = "doNull";
        s2[1] = (state_0 & 0x200) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[10] = s2;
        s2 = new Object[3];
        s2[0] = "doString";
        if ((state_0 & 0x400) != 0) {
            s2[1] = (byte)1;
            cached = new ArrayList<List<JavaScriptBaseNode>>();
            cached.add(Arrays.asList(this.string_stringToNumberNode_));
            s2[2] = cached;
        } else {
            s2[1] = (byte)0;
        }
        data[11] = s2;
        s2 = new Object[3];
        s2[0] = "doSymbol";
        s2[1] = (state_0 & 0x800) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[12] = s2;
        s2 = new Object[3];
        s2[0] = "doBigInt";
        s2[1] = (state_0 & 0x1000) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[13] = s2;
        s2 = new Object[3];
        s2[0] = "doJSObject";
        if ((state_0 & 0x2000) != 0) {
            s2[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.jSObject_toDoubleNode_));
            s2[2] = cached;
        } else {
            s2[1] = (byte)0;
        }
        data[14] = s2;
        s2 = new Object[3];
        s2[0] = "doForeignObject";
        if ((state_0 & 0x4000) != 0) {
            s2[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.foreignObject_toPrimitiveNode_, this.foreignObject_toInt32Node_));
            s2[2] = cached;
        } else {
            s2[1] = (byte)0;
        }
        data[15] = s2;
        return Introspection.Provider.create(data);
    }

    public static JSToInt32Node create(JavaScriptNode operand) {
        return new JSToInt32NodeGen(operand);
    }
}

