/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.cast.JSToDoubleNode;
import com.oracle.truffle.js.nodes.cast.JSToStringOrNumberNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.SafeInteger;
import com.oracle.truffle.js.runtime.Symbol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSToStringOrNumberNode.class)
public final class JSToStringOrNumberNodeGen
extends JSToStringOrNumberNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private volatile int state_0_;
    @Node.Child
    private JSToDoubleNode jSObject_toDoubleNode_;

    private JSToStringOrNumberNodeGen() {
    }

    @Override
    public Object execute(Object arg0Value) {
        TruffleObject arg0Value_;
        int state_0 = this.state_0_;
        if ((state_0 & 1) != 0 && arg0Value instanceof Integer) {
            int arg0Value_2 = (Integer)arg0Value;
            return this.doInteger(arg0Value_2);
        }
        if ((state_0 & 2) != 0 && arg0Value instanceof SafeInteger) {
            SafeInteger arg0Value_3 = (SafeInteger)arg0Value;
            return this.doSafeInteger(arg0Value_3);
        }
        if ((state_0 & 4) != 0 && arg0Value instanceof Boolean) {
            boolean arg0Value_4 = (Boolean)arg0Value;
            return this.doBoolean(arg0Value_4);
        }
        if ((state_0 & 8) != 0 && arg0Value instanceof Long) {
            long arg0Value_5 = (Long)arg0Value;
            return this.doLong(arg0Value_5);
        }
        if ((state_0 & 0x10) != 0 && JSTypesGen.isImplicitDouble((state_0 & 0x7800) >>> 11, arg0Value)) {
            double arg0Value_6 = JSTypesGen.asImplicitDouble((state_0 & 0x7800) >>> 11, arg0Value);
            return this.doDouble(arg0Value_6);
        }
        if ((state_0 & 0x20) != 0 && JSTypesGen.isImplicitString((state_0 & 0x38000) >>> 15, arg0Value)) {
            String arg0Value_7 = JSTypesGen.asImplicitString((state_0 & 0x38000) >>> 15, arg0Value);
            return this.doString(arg0Value_7);
        }
        if ((state_0 & 0x40) != 0 && JSTypes.isDynamicObject(arg0Value) && JSGuards.isJSObject(arg0Value_ = (DynamicObject)arg0Value)) {
            return this.doJSObject((DynamicObject)arg0Value_, this.jSObject_toDoubleNode_);
        }
        if ((state_0 & 0x80) != 0 && JSGuards.isJSNull(arg0Value)) {
            return this.doNull(arg0Value);
        }
        if ((state_0 & 0x100) != 0 && arg0Value instanceof Symbol) {
            arg0Value_ = (Symbol)arg0Value;
            return this.doSymbol((Symbol)arg0Value_);
        }
        if ((state_0 & 0x200) != 0 && JSGuards.isUndefined(arg0Value)) {
            return this.doUndefined(arg0Value);
        }
        if ((state_0 & 0x400) != 0 && arg0Value instanceof BigInt) {
            arg0Value_ = (BigInt)arg0Value;
            return JSToStringOrNumberNode.doBigInt((BigInt)arg0Value_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    private Object executeAndSpecialize(Object arg0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state_0 = this.state_0_;
        try {
            DynamicObject arg0Value_8;
            if (arg0Value instanceof Integer) {
                int arg0Value_2 = (Integer)arg0Value;
                this.state_0_ = state_0 |= 1;
                lock.unlock();
                hasLock = false;
                Integer n = this.doInteger(arg0Value_2);
                return n;
            }
            if (arg0Value instanceof SafeInteger) {
                SafeInteger arg0Value_3 = (SafeInteger)arg0Value;
                this.state_0_ = state_0 |= 2;
                lock.unlock();
                hasLock = false;
                SafeInteger safeInteger = this.doSafeInteger(arg0Value_3);
                return safeInteger;
            }
            if (arg0Value instanceof Boolean) {
                boolean arg0Value_4 = (Boolean)arg0Value;
                this.state_0_ = state_0 |= 4;
                lock.unlock();
                hasLock = false;
                Integer n = this.doBoolean(arg0Value_4);
                return n;
            }
            if (arg0Value instanceof Long) {
                long arg0Value_5 = (Long)arg0Value;
                this.state_0_ = state_0 |= 8;
                lock.unlock();
                hasLock = false;
                Boolean bl = this.doLong(arg0Value_5);
                return bl;
            }
            int doubleCast0 = JSTypesGen.specializeImplicitDouble(arg0Value);
            if (doubleCast0 != 0) {
                double arg0Value_6 = JSTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                state_0 |= doubleCast0 << 11;
                this.state_0_ = state_0 |= 0x10;
                lock.unlock();
                hasLock = false;
                Double d = this.doDouble(arg0Value_6);
                return d;
            }
            int stringCast0 = JSTypesGen.specializeImplicitString(arg0Value);
            if (stringCast0 != 0) {
                String arg0Value_7 = JSTypesGen.asImplicitString(stringCast0, arg0Value);
                state_0 |= stringCast0 << 15;
                this.state_0_ = state_0 |= 0x20;
                lock.unlock();
                hasLock = false;
                String string = this.doString(arg0Value_7);
                return string;
            }
            if (JSTypes.isDynamicObject(arg0Value) && JSGuards.isJSObject(arg0Value_8 = (DynamicObject)arg0Value)) {
                this.jSObject_toDoubleNode_ = super.insert(JSToDoubleNode.create());
                this.state_0_ = state_0 |= 0x40;
                lock.unlock();
                hasLock = false;
                Double d = this.doJSObject(arg0Value_8, this.jSObject_toDoubleNode_);
                return d;
            }
            if (JSGuards.isJSNull(arg0Value)) {
                this.state_0_ = state_0 |= 0x80;
                lock.unlock();
                hasLock = false;
                Integer arg0Value_8 = this.doNull(arg0Value);
                return arg0Value_8;
            }
            if (arg0Value instanceof Symbol) {
                Symbol arg0Value_9 = (Symbol)arg0Value;
                this.state_0_ = state_0 |= 0x100;
                lock.unlock();
                hasLock = false;
                Object object = this.doSymbol(arg0Value_9);
                return object;
            }
            if (JSGuards.isUndefined(arg0Value)) {
                this.state_0_ = state_0 |= 0x200;
                lock.unlock();
                hasLock = false;
                Double arg0Value_9 = this.doUndefined(arg0Value);
                return arg0Value_9;
            }
            if (arg0Value instanceof BigInt) {
                BigInt arg0Value_10 = (BigInt)arg0Value;
                this.state_0_ = state_0 |= 0x400;
                lock.unlock();
                hasLock = false;
                BigInt bigInt = JSToStringOrNumberNode.doBigInt(arg0Value_10);
                return bigInt;
            }
            throw new UnsupportedSpecializationException(this, new Node[]{null}, arg0Value);
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0x7FF) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & 0x7FF & (state_0 & 0x7FF) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        Object[] data = new Object[12];
        data[0] = 0;
        int state_0 = this.state_0_;
        Object[] s2 = new Object[3];
        s2[0] = "doInteger";
        s2[1] = (state_0 & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s2;
        s2 = new Object[3];
        s2[0] = "doSafeInteger";
        s2[1] = (state_0 & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s2;
        s2 = new Object[3];
        s2[0] = "doBoolean";
        s2[1] = (state_0 & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s2;
        s2 = new Object[3];
        s2[0] = "doLong";
        s2[1] = (state_0 & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[4] = s2;
        s2 = new Object[3];
        s2[0] = "doDouble";
        s2[1] = (state_0 & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[5] = s2;
        s2 = new Object[3];
        s2[0] = "doString";
        s2[1] = (state_0 & 0x20) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[6] = s2;
        s2 = new Object[3];
        s2[0] = "doJSObject";
        if ((state_0 & 0x40) != 0) {
            s2[1] = (byte)1;
            ArrayList<List<JSToDoubleNode>> cached = new ArrayList<List<JSToDoubleNode>>();
            cached.add(Arrays.asList(this.jSObject_toDoubleNode_));
            s2[2] = cached;
        } else {
            s2[1] = (byte)0;
        }
        data[7] = s2;
        s2 = new Object[3];
        s2[0] = "doNull";
        s2[1] = (state_0 & 0x80) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[8] = s2;
        s2 = new Object[3];
        s2[0] = "doSymbol";
        s2[1] = (state_0 & 0x100) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[9] = s2;
        s2 = new Object[3];
        s2[0] = "doUndefined";
        s2[1] = (state_0 & 0x200) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[10] = s2;
        s2 = new Object[3];
        s2[0] = "doBigInt";
        s2[1] = (state_0 & 0x400) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[11] = s2;
        return Introspection.Provider.create(data);
    }

    public static JSToStringOrNumberNode create() {
        return new JSToStringOrNumberNodeGen();
    }
}

