/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.function;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.function.AbstractFunctionArgumentsNode;
import com.oracle.truffle.js.nodes.function.EvalNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.SafeInteger;
import com.oracle.truffle.js.runtime.Symbol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=EvalNode.class)
public final class EvalNodeGen
extends EvalNode
implements Introspection.Provider {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @CompilerDirectives.CompilationFinal
    private volatile int state_0_;
    @Node.Child
    private JSFunctionCallNode evalOverridden_redirectCall_;

    private EvalNodeGen(JSContext context, JavaScriptNode function, JavaScriptNode[] args, JavaScriptNode thisObject, Object env) {
        super(context, function, args, thisObject, env);
    }

    private EvalNodeGen(JSContext context, JavaScriptNode functionNode, AbstractFunctionArgumentsNode arguments, EvalNode.DirectEvalNode directEvalNode) {
        super(context, functionNode, arguments, directEvalNode);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object functionNodeValue_ = this.functionNode.execute(frameValue);
        if (state_0 != 0) {
            if ((state_0 & 1) != 0 && !this.isEvalOverridden(functionNodeValue_)) {
                return this.evalNotOverridden(frameValue, functionNodeValue_);
            }
            if ((state_0 & 2) != 0 && this.isEvalOverridden(functionNodeValue_)) {
                return this.evalOverridden(frameValue, functionNodeValue_, this.evalOverridden_redirectCall_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(frameValue, functionNodeValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.execute(frameValue);
    }

    private Object executeAndSpecialize(VirtualFrame frameValue, Object functionNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state_0 = this.state_0_;
        try {
            if (!this.isEvalOverridden(functionNodeValue)) {
                this.state_0_ = state_0 |= 1;
                lock.unlock();
                hasLock = false;
                Object object = this.evalNotOverridden(frameValue, functionNodeValue);
                return object;
            }
            if (this.isEvalOverridden(functionNodeValue)) {
                this.evalOverridden_redirectCall_ = super.insert(JSFunctionCallNode.createCall());
                this.state_0_ = state_0 |= 2;
                lock.unlock();
                hasLock = false;
                Object object = this.evalOverridden(frameValue, functionNodeValue, this.evalOverridden_redirectCall_);
                return object;
            }
            throw new UnsupportedSpecializationException(this, new Node[]{this.functionNode}, functionNodeValue);
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if (state_0 == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & state_0 - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        Object[] data = new Object[3];
        data[0] = 0;
        int state_0 = this.state_0_;
        Object[] s2 = new Object[3];
        s2[0] = "evalNotOverridden";
        s2[1] = (state_0 & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s2;
        s2 = new Object[3];
        s2[0] = "evalOverridden";
        if ((state_0 & 2) != 0) {
            s2[1] = (byte)1;
            ArrayList<List<JSFunctionCallNode>> cached = new ArrayList<List<JSFunctionCallNode>>();
            cached.add(Arrays.asList(this.evalOverridden_redirectCall_));
            s2[2] = cached;
        } else {
            s2[1] = (byte)0;
        }
        data[2] = s2;
        return Introspection.Provider.create(data);
    }

    public static EvalNode create(JSContext context, JavaScriptNode function, JavaScriptNode[] args, JavaScriptNode thisObject, Object env) {
        return new EvalNodeGen(context, function, args, thisObject, env);
    }

    public static EvalNode create(JSContext context, JavaScriptNode functionNode, AbstractFunctionArgumentsNode arguments, EvalNode.DirectEvalNode directEvalNode) {
        return new EvalNodeGen(context, functionNode, arguments, directEvalNode);
    }

    @GeneratedBy(value=EvalNode.DirectEvalNode.class)
    protected static final class DirectEvalNodeGen
    extends EvalNode.DirectEvalNode
    implements Introspection.Provider {
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @Node.Child
        private DirectEvalForeignObject0Data directEvalForeignObject0_cache;

        private DirectEvalNodeGen(JSContext context, JavaScriptNode thisNode, Object currEnv) {
            super(context, thisNode, currEnv);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @ExplodeLoop
        public Object executeWithSource(VirtualFrame frameValue, Object arg0Value) {
            Object arg0Value_;
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0 && arg0Value instanceof Integer) {
                int arg0Value_2 = (Integer)arg0Value;
                return this.directEvalInt(arg0Value_2);
            }
            if ((state_0 & 2) != 0 && arg0Value instanceof SafeInteger) {
                SafeInteger arg0Value_3 = (SafeInteger)arg0Value;
                return this.directEvalSafeInteger(arg0Value_3);
            }
            if ((state_0 & 4) != 0 && arg0Value instanceof Long) {
                long arg0Value_4 = (Long)arg0Value;
                return this.directEvalLong(arg0Value_4);
            }
            if ((state_0 & 8) != 0 && JSTypesGen.isImplicitDouble((state_0 & 0x7800) >>> 11, arg0Value)) {
                double arg0Value_5 = JSTypesGen.asImplicitDouble((state_0 & 0x7800) >>> 11, arg0Value);
                return this.directEvalDouble(arg0Value_5);
            }
            if ((state_0 & 0x10) != 0 && arg0Value instanceof Boolean) {
                boolean arg0Value_6 = (Boolean)arg0Value;
                return this.directEvalBoolean(arg0Value_6);
            }
            if ((state_0 & 0x20) != 0 && arg0Value instanceof Symbol) {
                Symbol arg0Value_7 = (Symbol)arg0Value;
                return this.directEvalSymbol(arg0Value_7);
            }
            if ((state_0 & 0x40) != 0 && arg0Value instanceof BigInt) {
                BigInt arg0Value_8 = (BigInt)arg0Value;
                return this.directEvalBigInt(arg0Value_8);
            }
            if ((state_0 & 0x80) != 0 && JSTypes.isDynamicObject(arg0Value) && JSGuards.isJSDynamicObject(arg0Value_ = (DynamicObject)arg0Value)) {
                return this.directEvalJSType((DynamicObject)arg0Value_);
            }
            if ((state_0 & 0x100) != 0 && JSTypesGen.isImplicitCharSequence((state_0 & 0x38000) >>> 15, arg0Value)) {
                arg0Value_ = JSTypesGen.asImplicitCharSequence((state_0 & 0x38000) >>> 15, arg0Value);
                return this.directEvalCharSequence(frameValue, (CharSequence)arg0Value_);
            }
            if ((state_0 & 0x600) != 0) {
                if ((state_0 & 0x200) != 0) {
                    DirectEvalForeignObject0Data s10_ = this.directEvalForeignObject0_cache;
                    while (s10_ != null) {
                        if (s10_.interop_.accepts(arg0Value) && JSGuards.isForeignObject(arg0Value)) {
                            return this.directEvalForeignObject(frameValue, arg0Value, s10_.interop_);
                        }
                        s10_ = s10_.next_;
                    }
                }
                if ((state_0 & 0x400) != 0 && JSGuards.isForeignObject(arg0Value)) {
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set(this);
                    try {
                        InteropLibrary directEvalForeignObject1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                        Object object = this.directEvalForeignObject(frameValue, arg0Value, directEvalForeignObject1_interop__);
                        return object;
                    }
                    finally {
                        encapsulating_.set(prev_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, arg0Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            try {
                DynamicObject arg0Value_;
                if (arg0Value instanceof Integer) {
                    int arg0Value_2 = (Integer)arg0Value;
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    Integer n = this.directEvalInt(arg0Value_2);
                    return n;
                }
                if (arg0Value instanceof SafeInteger) {
                    SafeInteger arg0Value_3 = (SafeInteger)arg0Value;
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    SafeInteger safeInteger = this.directEvalSafeInteger(arg0Value_3);
                    return safeInteger;
                }
                if (arg0Value instanceof Long) {
                    long arg0Value_4 = (Long)arg0Value;
                    this.state_0_ = state_0 |= 4;
                    lock.unlock();
                    hasLock = false;
                    Long l = this.directEvalLong(arg0Value_4);
                    return l;
                }
                int doubleCast0 = JSTypesGen.specializeImplicitDouble(arg0Value);
                if (doubleCast0 != 0) {
                    double arg0Value_5 = JSTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                    state_0 |= doubleCast0 << 11;
                    this.state_0_ = state_0 |= 8;
                    lock.unlock();
                    hasLock = false;
                    Double d = this.directEvalDouble(arg0Value_5);
                    return d;
                }
                if (arg0Value instanceof Boolean) {
                    boolean arg0Value_6 = (Boolean)arg0Value;
                    this.state_0_ = state_0 |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    Boolean arg0Value_5 = this.directEvalBoolean(arg0Value_6);
                    return arg0Value_5;
                }
                if (arg0Value instanceof Symbol) {
                    Symbol arg0Value_7 = (Symbol)arg0Value;
                    this.state_0_ = state_0 |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    Symbol arg0Value_5 = this.directEvalSymbol(arg0Value_7);
                    return arg0Value_5;
                }
                if (arg0Value instanceof BigInt) {
                    BigInt arg0Value_8 = (BigInt)arg0Value;
                    this.state_0_ = state_0 |= 0x40;
                    lock.unlock();
                    hasLock = false;
                    BigInt arg0Value_5 = this.directEvalBigInt(arg0Value_8);
                    return arg0Value_5;
                }
                if (JSTypes.isDynamicObject(arg0Value) && JSGuards.isJSDynamicObject(arg0Value_ = (DynamicObject)arg0Value)) {
                    this.state_0_ = state_0 |= 0x80;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject arg0Value_5 = this.directEvalJSType(arg0Value_);
                    return arg0Value_5;
                }
                int charSequenceCast0 = JSTypesGen.specializeImplicitCharSequence(arg0Value);
                if (charSequenceCast0 != 0) {
                    CharSequence arg0Value_9 = JSTypesGen.asImplicitCharSequence(charSequenceCast0, arg0Value);
                    state_0 |= charSequenceCast0 << 15;
                    this.state_0_ = state_0 |= 0x100;
                    lock.unlock();
                    hasLock = false;
                    Object object = this.directEvalCharSequence(frameValue, arg0Value_9);
                    return object;
                }
                if (exclude == 0) {
                    int count10_ = 0;
                    DirectEvalForeignObject0Data s10_ = this.directEvalForeignObject0_cache;
                    if ((state_0 & 0x200) != 0) {
                        while (!(s10_ == null || s10_.interop_.accepts(arg0Value) && JSGuards.isForeignObject(arg0Value))) {
                            s10_ = s10_.next_;
                            ++count10_;
                        }
                    }
                    if (s10_ == null && JSGuards.isForeignObject(arg0Value) && count10_ < 3) {
                        s10_ = super.insert(new DirectEvalForeignObject0Data(this.directEvalForeignObject0_cache));
                        s10_.interop_ = (InteropLibrary)s10_.insertAccessor(INTEROP_LIBRARY_.create(arg0Value));
                        this.directEvalForeignObject0_cache = s10_;
                        this.state_0_ = state_0 |= 0x200;
                    }
                    if (s10_ != null) {
                        lock.unlock();
                        hasLock = false;
                        Object object = this.directEvalForeignObject(frameValue, arg0Value, s10_.interop_);
                        return object;
                    }
                }
                InteropLibrary directEvalForeignObject1_interop__ = null;
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set(this);
                try {
                    if (JSGuards.isForeignObject(arg0Value)) {
                        directEvalForeignObject1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached();
                        this.exclude_ = exclude |= 1;
                        this.directEvalForeignObject0_cache = null;
                        state_0 &= 0xFFFFFDFF;
                        this.state_0_ = state_0 |= 0x400;
                        lock.unlock();
                        hasLock = false;
                        Object object = this.directEvalForeignObject(frameValue, arg0Value, directEvalForeignObject1_interop__);
                        return object;
                    }
                }
                finally {
                    encapsulating_.set(prev_);
                }
                throw new UnsupportedSpecializationException(this, new Node[]{null}, arg0Value);
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            DirectEvalForeignObject0Data s10_;
            int state_0 = this.state_0_;
            if ((state_0 & 0x7FF) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 0x7FF & (state_0 & 0x7FF) - 1) == 0 && ((s10_ = this.directEvalForeignObject0_cache) == null || s10_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        @Override
        public Introspection getIntrospectionData() {
            ArrayList<List<Object>> cached;
            Object[] data = new Object[12];
            data[0] = 0;
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            Object[] s2 = new Object[3];
            s2[0] = "directEvalInt";
            s2[1] = (state_0 & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s2;
            s2 = new Object[3];
            s2[0] = "directEvalSafeInteger";
            s2[1] = (state_0 & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s2;
            s2 = new Object[3];
            s2[0] = "directEvalLong";
            s2[1] = (state_0 & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s2;
            s2 = new Object[3];
            s2[0] = "directEvalDouble";
            s2[1] = (state_0 & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[4] = s2;
            s2 = new Object[3];
            s2[0] = "directEvalBoolean";
            s2[1] = (state_0 & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[5] = s2;
            s2 = new Object[3];
            s2[0] = "directEvalSymbol";
            s2[1] = (state_0 & 0x20) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[6] = s2;
            s2 = new Object[3];
            s2[0] = "directEvalBigInt";
            s2[1] = (state_0 & 0x40) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[7] = s2;
            s2 = new Object[3];
            s2[0] = "directEvalJSType";
            s2[1] = (state_0 & 0x80) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[8] = s2;
            s2 = new Object[3];
            s2[0] = "directEvalCharSequence";
            s2[1] = (state_0 & 0x100) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[9] = s2;
            s2 = new Object[3];
            s2[0] = "directEvalForeignObject";
            if ((state_0 & 0x200) != 0) {
                s2[1] = (byte)1;
                cached = new ArrayList<List<Object>>();
                DirectEvalForeignObject0Data s10_ = this.directEvalForeignObject0_cache;
                while (s10_ != null) {
                    cached.add(Arrays.asList(s10_.interop_));
                    s10_ = s10_.next_;
                }
                s2[2] = cached;
            } else {
                s2[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
            }
            data[10] = s2;
            s2 = new Object[3];
            s2[0] = "directEvalForeignObject";
            if ((state_0 & 0x400) != 0) {
                s2[1] = (byte)1;
                cached = new ArrayList();
                cached.add(Arrays.asList(new Object[0]));
                s2[2] = cached;
            } else {
                s2[1] = (byte)0;
            }
            data[11] = s2;
            return Introspection.Provider.create(data);
        }

        public static EvalNode.DirectEvalNode create(JSContext context, JavaScriptNode thisNode, Object currEnv) {
            return new DirectEvalNodeGen(context, thisNode, currEnv);
        }

        @GeneratedBy(value=EvalNode.DirectEvalNode.class)
        private static final class DirectEvalForeignObject0Data
        extends Node {
            @Node.Child
            DirectEvalForeignObject0Data next_;
            @Node.Child
            InteropLibrary interop_;

            DirectEvalForeignObject0Data(DirectEvalForeignObject0Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return super.insert(node);
            }
        }
    }
}

